module glee;

struct __nt_context { int esp; int info; int prev; int handler; int stable; int sindex; int ebp; };
///////////////////////////////////
//
// GLee.h ;
// OpenGL Easy Extension library        
// Version : 3.0;
//
// Copyright (c)2004  Ben Woodhouse  All rights reserved.;
//
// Redistribution and use _in source and binary forms, with or without
// modification, are permitted provided that the following conditions are 
// met:
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer as
// the first lines of this file unmodified.
// 2. Redistributions _in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer _in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY BEN WOODHOUSE ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL BEN WOODHOUSE BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES LOSS OF USE,
// DATA, OR PROFITS OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// This licence includes and incorporates the SGI FREE SOFTWARE LICENSE B 
// (Version 1.1 [02/22/2000]) full details of which can be found at
// http://oss.sgi.com/projects/FreeB
//
// For the avoidance of doubt, this work falls within the definition of a 
// 'Larger Work' within that licence, since it incorporates parts of SGI's
// glExt.h, wglExt.h and glxExt.h header files, which form part of SGI's
// OpenGL Sample Implementation. 
// Web: http://elf-stone.com
//
// [This file was automatically generated by GLeeGen]
//
// Then it was ported manually by Joel Anderson to D (1\21\2004)
//
///////////////////////////////////

private import glConstants;

extern (C)
{

//#ifndef __glee_h_;
//#define __glee_h_;

//#ifdef __gl_h_;
//#endif ;

//#ifdef __glext_h_;
//#endif ;

//#ifdef __wglext_h_;
//#endif ;

//#ifdef __glxext_h_;
//#endif ;

//#ifdef WIN32;
//#define WIN32_LEAN_AND_MEAN;
//#include <windows.h>;
//#include <gl\gl.h>;
//#else;
//#endif ;

//#ifndef APIENTRY;
//#define APIENTRY;
//#endif;

//#ifndef APIENTRYP;
//alias APIENTRY* APIENTRYP
//#define APIENTRYP APIENTRY *;
//#endif;

//#define GLEE_EXTERN extern;

//#ifdef __cplusplus ;
//#endif ;

// Extension querying variables
typedef void *PVOID;
typedef PVOID HANDLE;
//#define DECLARE_HANDLE(name) typedef HANDLE name;


typedef HANDLE HDC ;
typedef HANDLE HGLRC ;
typedef HANDLE HDESK ;
typedef HANDLE HENHMETAFILE ;
typedef HANDLE HFONT ;
typedef HANDLE HICON ;
typedef HANDLE HMENU ;
typedef HANDLE HMETAFILE ;
typedef HANDLE HINSTANCE ;
typedef HINSTANCE HMODULE; ;
typedef HANDLE HPALETTE ;
typedef HANDLE HPEN ;
typedef HANDLE HRGN ;
typedef HANDLE HRSRC ;
typedef HANDLE HSTR ;
typedef HANDLE HTASK ;
typedef HANDLE HWINSTA ;
typedef HANDLE HKL ;

typedef uint       DWORD;
typedef int                 BOOLEAN;
typedef uint       BYTE;
typedef ushort      WORD;
typedef float               FLOAT;
typedef FLOAT               *PFLOAT;
typedef BOOLEAN               *PBOOL;
typedef BOOLEAN                *LPBOOL;
typedef BYTE               *PBYTE;
typedef BYTE                *LPBYTE;
typedef int                *PINT;
typedef int                 *LPINT;
typedef WORD               *PWORD;
typedef WORD                *LPWORD;
typedef int                *LPLONG;
typedef DWORD              *PDWORD;
typedef DWORD               *LPDWORD;
typedef void                *LPVOID;

typedef int                 INT;
typedef uint        UINT;
typedef uint        *PUINT;

alias void VOID;
typedef char CHAR;
typedef short SHORT;
typedef int LONG;

//typedef uint uint
typedef uint *Puint;
typedef ushort USHORT;
typedef USHORT *PUSHORT;
typedef uint UCHAR;
typedef UCHAR *PUCHAR;
typedef char *PSZ;
typedef long INT64;
typedef int INT32;

 extern   GLboolean GLEE_VERSION_1_2;
 extern   GLboolean GLEE_ARB_imaging;
 extern   GLboolean GLEE_VERSION_1_3;
 extern   GLboolean GLEE_VERSION_1_4;
 extern   GLboolean GLEE_VERSION_1_5;
 extern   GLboolean GLEE_ARB_multitexture;
 extern   GLboolean GLEE_ARB_transpose_matrix;
 extern   GLboolean GLEE_ARB_multisample;
 extern   GLboolean GLEE_ARB_texture_env_add;
 extern   GLboolean GLEE_ARB_texture_cube_map;
 extern   GLboolean GLEE_ARB_texture_compression;
 extern   GLboolean GLEE_ARB_texture_border_clamp;
 extern   GLboolean GLEE_ARB_point_parameters;
 extern   GLboolean GLEE_ARB_vertex_blend;
 extern   GLboolean GLEE_ARB_matrix_palette;
 extern   GLboolean GLEE_ARB_texture_env_combine;
 extern   GLboolean GLEE_ARB_texture_env_crossbar;
 extern   GLboolean GLEE_ARB_texture_env_dot3;
 extern   GLboolean GLEE_ARB_texture_mirrored_repeat;
 extern   GLboolean GLEE_ARB_depth_texture;
 extern   GLboolean GLEE_ARB_shadow;
 extern   GLboolean GLEE_ARB_shadow_ambient;
 extern   GLboolean GLEE_ARB_window_pos;
 extern   GLboolean GLEE_ARB_vertex_program;
 extern   GLboolean GLEE_ARB_fragment_program;
 extern   GLboolean GLEE_ARB_vertex_buffer_object;
 extern   GLboolean GLEE_ARB_occlusion_query;
 extern   GLboolean GLEE_ARB_shader_objects;
 extern   GLboolean GLEE_ARB_vertex_shader;
 extern   GLboolean GLEE_ARB_fragment_shader;
 extern   GLboolean GLEE_ARB_shading_language_100;
 extern   GLboolean GLEE_ARB_texture_non_power_of_two;
 extern   GLboolean GLEE_ARB_point_sprite;
 extern   GLboolean GLEE_EXT_abgr;
 extern   GLboolean GLEE_EXT_blend_color;
 extern   GLboolean GLEE_EXT_polygon_offset;
 extern   GLboolean GLEE_EXT_texture;
 extern   GLboolean GLEE_EXT_texture3D;
 extern   GLboolean GLEE_SGIS_texture_filter4;
 extern   GLboolean GLEE_EXT_subtexture;
 extern   GLboolean GLEE_EXT_copy_texture;
 extern   GLboolean GLEE_EXT_histogram;
 extern   GLboolean GLEE_EXT_convolution;
 extern   GLboolean GLEE_SGI_color_matrix;
 extern   GLboolean GLEE_SGI_color_table;
 extern   GLboolean GLEE_SGIS_pixel_texture;
 extern   GLboolean GLEE_SGIX_pixel_texture;
 extern   GLboolean GLEE_SGIS_texture4D;
 extern   GLboolean GLEE_SGI_texture_color_table;
 extern   GLboolean GLEE_EXT_cmyka;
 extern   GLboolean GLEE_EXT_texture_object;
 extern   GLboolean GLEE_SGIS_detail_texture;
 extern   GLboolean GLEE_SGIS_sharpen_texture;
 extern   GLboolean GLEE_EXT_packed_pixels;
 extern   GLboolean GLEE_SGIS_texture_lod;
 extern   GLboolean GLEE_SGIS_multisample;
 extern   GLboolean GLEE_EXT_rescale_normal;
 extern   GLboolean GLEE_EXT_vertex_array;
 extern   GLboolean GLEE_EXT_misc_attribute;
 extern   GLboolean GLEE_SGIS_generate_mipmap;
 extern   GLboolean GLEE_SGIX_clipmap;
 extern   GLboolean GLEE_SGIX_shadow;
 extern   GLboolean GLEE_SGIS_texture_edge_clamp;
 extern   GLboolean GLEE_EXT_blend_minmax;
 extern   GLboolean GLEE_EXT_blend_subtract;
 extern   GLboolean GLEE_EXT_blend_logic_op;
 extern   GLboolean GLEE_SGIX_interlace;
 extern   GLboolean GLEE_SGIX_pixel_tiles;
 extern   GLboolean GLEE_SGIS_texture_select;
 extern   GLboolean GLEE_SGIX_sprite;
 extern   GLboolean GLEE_SGIX_texture_multi_buffer;
 extern   GLboolean GLEE_EXT_point_parameters;
 extern   GLboolean GLEE_SGIS_point_parameters;
 extern   GLboolean GLEE_SGIX_instruments;
 extern   GLboolean GLEE_SGIX_texture_scale_bias;
 extern   GLboolean GLEE_SGIX_framezoom;
 extern   GLboolean GLEE_SGIX_tag_sample_buffer;
 extern   GLboolean GLEE_FfdMaskSGIX;
 extern   GLboolean GLEE_SGIX_polynomial_ffd;
 extern   GLboolean GLEE_SGIX_reference_plane;
 extern   GLboolean GLEE_SGIX_flush_raster;
 extern   GLboolean GLEE_SGIX_depth_texture;
 extern   GLboolean GLEE_SGIS_fog_function;
 extern   GLboolean GLEE_SGIX_fog_offset;
 extern   GLboolean GLEE_HP_image_transform;
 extern   GLboolean GLEE_HP_convolution_border_modes;
 extern   GLboolean GLEE_INGR_palette_buffer;
 extern   GLboolean GLEE_SGIX_texture_add_env;
 extern   GLboolean GLEE_EXT_color_subtable;
 extern   GLboolean GLEE_PGI_vertex_hints;
 extern   GLboolean GLEE_PGI_misc_hints;
 extern   GLboolean GLEE_EXT_paletted_texture;
 extern   GLboolean GLEE_EXT_clip_volume_hint;
 extern   GLboolean GLEE_SGIX_list_priority;
 extern   GLboolean GLEE_SGIX_ir_instrument1;
 extern   GLboolean GLEE_SGIX_calligraphic_fragment;
 extern   GLboolean GLEE_SGIX_texture_lod_bias;
 extern   GLboolean GLEE_SGIX_shadow_ambient;
 extern   GLboolean GLEE_EXT_index_texture;
 extern   GLboolean GLEE_EXT_index_material;
 extern   GLboolean GLEE_EXT_index_func;
 extern   GLboolean GLEE_EXT_index_array_formats;
 extern   GLboolean GLEE_EXT_compiled_vertex_array;
 extern   GLboolean GLEE_EXT_cull_vertex;
 extern   GLboolean GLEE_SGIX_ycrcb;
 extern   GLboolean GLEE_SGIX_fragment_lighting;
 extern   GLboolean GLEE_IBM_rasterpos_clip;
 extern   GLboolean GLEE_HP_texture_lighting;
 extern   GLboolean GLEE_EXT_draw_range_elements;
 extern   GLboolean GLEE_WIN_phong_shading;
 extern   GLboolean GLEE_WIN_specular_fog;
 extern   GLboolean GLEE_EXT_light_texture;
 extern   GLboolean GLEE_SGIX_blend_alpha_minmax;
 extern   GLboolean GLEE_SGIX_impact_pixel_texture;
 extern   GLboolean GLEE_EXT_bgra;
 extern   GLboolean GLEE_SGIX_async;
 extern   GLboolean GLEE_SGIX_async_pixel;
 extern   GLboolean GLEE_SGIX_async_histogram;
 extern   GLboolean GLEE_INTEL_texture_scissor;
 extern   GLboolean GLEE_INTEL_parallel_arrays;
 extern   GLboolean GLEE_HP_occlusion_test;
 extern   GLboolean GLEE_EXT_pixel_transform;
 extern   GLboolean GLEE_EXT_pixel_transform_color_table;
 extern   GLboolean GLEE_EXT_shared_texture_palette;
 extern   GLboolean GLEE_EXT_separate_specular_color;
 extern   GLboolean GLEE_EXT_secondary_color;
 extern   GLboolean GLEE_EXT_texture_perturb_normal;
 extern   GLboolean GLEE_EXT_multi_draw_arrays;
 extern   GLboolean GLEE_EXT_fog_coord;
 extern   GLboolean GLEE_REND_screen_coordinates;
 extern   GLboolean GLEE_EXT_coordinate_frame;
 extern   GLboolean GLEE_EXT_texture_env_combine;
 extern   GLboolean GLEE_APPLE_specular_vector;
 extern   GLboolean GLEE_APPLE_transform_hint;
 extern   GLboolean GLEE_SGIX_fog_scale;
 extern   GLboolean GLEE_SUNX_constant_data;
 extern   GLboolean GLEE_SUN_global_alpha;
 extern   GLboolean GLEE_SUN_triangle_list;
 extern   GLboolean GLEE_SUN_vertex;
 extern   GLboolean GLEE_EXT_blend_func_separate;
 extern   GLboolean GLEE_INGR_color_clamp;
 extern   GLboolean GLEE_INGR_interlace_read;
 extern   GLboolean GLEE_EXT_stencil_wrap;
 extern   GLboolean GLEE_EXT_422_pixels;
 extern   GLboolean GLEE_NV_texgen_reflection;
 extern   GLboolean GLEE_EXT_texture_cube_map;
 extern   GLboolean GLEE_SUN_convolution_border_modes;
 extern   GLboolean GLEE_EXT_texture_env_add;
 extern   GLboolean GLEE_EXT_texture_lod_bias;
 extern   GLboolean GLEE_EXT_texture_filter_anisotropic;
 extern   GLboolean GLEE_EXT_vertex_weighting;
 extern   GLboolean GLEE_NV_light_max_exponent;
 extern   GLboolean GLEE_NV_vertex_array_range;
 extern   GLboolean GLEE_NV_register_combiners;
 extern   GLboolean GLEE_NV_fog_distance;
 extern   GLboolean GLEE_NV_texgen_emboss;
 extern   GLboolean GLEE_NV_blend_square;
 extern   GLboolean GLEE_NV_texture_env_combine4;
 extern   GLboolean GLEE_MESA_resize_buffers;
 extern   GLboolean GLEE_MESA_window_pos;
 extern   GLboolean GLEE_EXT_texture_compression_s3tc;
 extern   GLboolean GLEE_IBM_cull_vertex;
 extern   GLboolean GLEE_IBM_multimode_draw_arrays;
 extern   GLboolean GLEE_IBM_vertex_array_lists;
 extern   GLboolean GLEE_SGIX_subsample;
 extern   GLboolean GLEE_SGIX_ycrcb_subsample;
 extern   GLboolean GLEE_SGIX_ycrcba;
 extern   GLboolean GLEE_SGI_depth_pass_instrument;
 extern   GLboolean GLEE_3DFX_texture_compression_FXT1;
 extern   GLboolean GLEE_3DFX_multisample;
 extern   GLboolean GLEE_3DFX_tbuffer;
 extern   GLboolean GLEE_EXT_multisample;
 extern   GLboolean GLEE_SGIX_vertex_preclip;
 extern   GLboolean GLEE_SGIX_convolution_accuracy;
 extern   GLboolean GLEE_SGIX_resample;
 extern   GLboolean GLEE_SGIS_point_line_texgen;
 extern   GLboolean GLEE_SGIS_texture_color_mask;
 extern   GLboolean GLEE_EXT_texture_env_dot3;
 extern   GLboolean GLEE_ATI_texture_mirror_once;
 extern   GLboolean GLEE_NV_fence;
 extern   GLboolean GLEE_IBM_texture_mirrored_repeat;
 extern   GLboolean GLEE_NV_evaluators;
 extern   GLboolean GLEE_NV_packed_depth_stencil;
 extern   GLboolean GLEE_NV_register_combiners2;
 extern   GLboolean GLEE_NV_texture_compression_vtc;
 extern   GLboolean GLEE_NV_texture_rectangle;
 extern   GLboolean GLEE_NV_texture_shader;
 extern   GLboolean GLEE_NV_texture_shader2;
 extern   GLboolean GLEE_NV_vertex_array_range2;
 extern   GLboolean GLEE_NV_vertex_program;
 extern   GLboolean GLEE_SGIX_texture_coordinate_clamp;
 extern   GLboolean GLEE_SGIX_scalebias_hint;
 extern   GLboolean GLEE_OML_interlace;
 extern   GLboolean GLEE_OML_subsample;
 extern   GLboolean GLEE_OML_resample;
 extern   GLboolean GLEE_NV_copy_depth_to_color;
 extern   GLboolean GLEE_ATI_envmap_bumpmap;
 extern   GLboolean GLEE_ATI_fragment_shader;
 extern   GLboolean GLEE_ATI_pn_triangles;
 extern   GLboolean GLEE_ATI_vertex_array_object;
 extern   GLboolean GLEE_EXT_vertex_shader;
 extern   GLboolean GLEE_ATI_vertex_streams;
 extern   GLboolean GLEE_ATI_element_array;
 extern   GLboolean GLEE_SUN_mesh_array;
 extern   GLboolean GLEE_SUN_slice_accum;
 extern   GLboolean GLEE_NV_multisample_filter_hint;
 extern   GLboolean GLEE_NV_depth_clamp;
 extern   GLboolean GLEE_NV_occlusion_query;
 extern   GLboolean GLEE_NV_point_sprite;
 extern   GLboolean GLEE_NV_texture_shader3;
 extern   GLboolean GLEE_NV_vertex_program1_1;
 extern   GLboolean GLEE_EXT_shadow_funcs;
 extern   GLboolean GLEE_EXT_stencil_two_side;
 extern   GLboolean GLEE_ATI_text_fragment_shader;
 extern   GLboolean GLEE_APPLE_client_storage;
 extern   GLboolean GLEE_APPLE_element_array;
 extern   GLboolean GLEE_APPLE_fence;
 extern   GLboolean GLEE_APPLE_vertex_array_object;
 extern   GLboolean GLEE_APPLE_vertex_array_range;
 extern   GLboolean GLEE_APPLE_ycbcr_422;
 extern   GLboolean GLEE_S3_s3tc;
 extern   GLboolean GLEE_ATI_draw_buffers;
 extern   GLboolean GLEE_ATI_texture_env_combine3;
 extern   GLboolean GLEE_ATI_texture_float;
 extern   GLboolean GLEE_NV_float_buffer;
 extern   GLboolean GLEE_NV_fragment_program;
 extern   GLboolean GLEE_NV_half_float;
 extern   GLboolean GLEE_NV_pixel_data_range;
 extern   GLboolean GLEE_NV_primitive_restart;
 extern   GLboolean GLEE_NV_texture_expand_normal;
 extern   GLboolean GLEE_NV_vertex_program2;
 extern   GLboolean GLEE_ATI_map_object_buffer;
 extern   GLboolean GLEE_ATI_separate_stencil;
 extern   GLboolean GLEE_ATI_vertex_attrib_array_object;
 extern   GLboolean GLEE_EXT_depth_bounds_test;
 extern   GLboolean GLEE_EXT_texture_mirror_clamp;
 extern   GLboolean GLEE_EXT_blend_equation_separate;
 extern   GLboolean GLEE_MESA_pack_invert;
 extern   GLboolean GLEE_MESA_ycbcr_texture;
 extern   GLboolean GLEE_EXT_color_matrix;
 extern   GLboolean GLEE_SGIS_texture_border_clamp;
 extern   GLboolean GLEE_SGIX_texture_select;
 extern   GLboolean GLEE_INGR_blend_func_separate;
 extern   GLboolean GLEE_SGIX_depth_pass_instrument;
 extern   GLboolean GLEE_SGIX_igloo_interface;

//Additional types needed for extensions
/* Copyright (C) 1986-2001 by Digital Mars. $Revision: 1.1.1.1 $ */
//#if = 0x838    || __RCC__;
//#pragma once;
//#endif;

//#ifndef __STDDEF_H;
//#define __STDDEF_H = 1;

//#if __cplusplus;
//#endif ;

/* Define _CRTAPI1 (for compatibility with the NT SDK) */
//#ifndef _CRTAPI1;
//#define _CRTAPI1 __cdecl;
//#endif;

/* Define _CRTAPI2 (for compatibility with the NT SDK) */
//#ifndef _CRTAPI2;
//#define _CRTAPI2 __cdecl;
//#endif;

/* Define CRTIMP */
//#ifndef _CRTIMP;
//#if defined(_WIN32) && defined(_DLL);
//#else;
//#define _CRTIMP;
//#endif;
//#endif;

//#if __OS2__ && 4    == 4;
//#else;
//#define __CLIB	__cdecl;
//#endif;

//#if defined(_MT);
//#else;
extern (Windows) int errno;
//#endif;

typedef int ptrdiff_t;
typedef uint size_t;
//#if !defined(_WCHAR_T_DEFINED);
typedef ushort wchar_t;
//#define _WCHAR_T_DEFINED = 1;
//#endif;

//#define offsetof(t,i)	((size_t)((char *)&((t *)0)->i - (char *)0));

//#ifndef NULL;
//#ifdef __cplusplus;
//#else;
//#define NULL ((void *)0);
//#endif ;
//#endif ;

//#if __cplusplus && !__NEW_DEFINED;
//#endif ;

//#if __cplusplus;
//#endif ;

//#endif;

//#ifndef GL_VERSION_1_5;
typedef ptrdiff_t GLintptr;
typedef ptrdiff_t GLsizeiptr;
//#endif;

//#ifndef GL_NV_half_float;
typedef ushort GLhalfNV;
//#endif;

//#ifndef GL_ARB_vertex_buffer_object;
typedef ptrdiff_t GLintptrARB;
typedef ptrdiff_t GLsizeiptrARB;
//#endif;

//#ifndef GL_ARB_shader_objects;
typedef int GLhandleARB;
typedef char GLcharARB;
//#endif;

//platform specific :;

//#ifdef WIN32    ;
//WINDOWS ONLY
//#ifndef WGL_ARB_pbuffer;
typedef HANDLE HPBUFFERARB ;
//#endif;
//#ifndef WGL_EXT_pbuffer;
typedef HANDLE HPBUFFEREXT ;
//#endif;

//#else          ;
//#endif //end platform specific


//GL_VERSION_1_2

//#ifndef GL_VERSION_1_2;
const uint GL_VERSION_1_2 = 1;
const uint __GLEE_GL_VERSION_1_2 = 1;
//constants

const uint GL_UNSIGNED_BYTE_3_3_2                             = 0x8032;
const uint GL_UNSIGNED_SHORT_4_4_4_4                          = 0x8033;
const uint GL_UNSIGNED_SHORT_5_5_5_1                          = 0x8034;
const uint GL_UNSIGNED_INT_8_8_8_8                            = 0x8035;
const uint GL_UNSIGNED_INT_10_10_10_2                         = 0x8036;
const uint GL_RESCALE_NORMAL                                  = 0x803A;
const uint GL_TEXTURE_BINDING_3D                              = 0x806A;
const uint GL_PACK_SKIP_IMAGES                                = 0x806B;
const uint GL_PACK_IMAGE_HEIGHT                               = 0x806C;
const uint GL_UNPACK_SKIP_IMAGES                              = 0x806D;
const uint GL_UNPACK_IMAGE_HEIGHT                             = 0x806E;
const uint GL_TEXTURE_3D                                      = 0x806F;
const uint GL_PROXY_TEXTURE_3D                                = 0x8070;
const uint GL_TEXTURE_DEPTH                                   = 0x8071;
const uint GL_TEXTURE_WRAP_R                                  = 0x8072;
const uint GL_MAX_3D_TEXTURE_SIZE                             = 0x8073;
const uint GL_UNSIGNED_BYTE_2_3_3_REV                         = 0x8362;
const uint GL_UNSIGNED_SHORT_5_6_5                            = 0x8363;
const uint GL_UNSIGNED_SHORT_5_6_5_REV                        = 0x8364;
const uint GL_UNSIGNED_SHORT_4_4_4_4_REV                      = 0x8365;
const uint GL_UNSIGNED_SHORT_1_5_5_5_REV                      = 0x8366;
const uint GL_UNSIGNED_INT_8_8_8_8_REV                        = 0x8367;
const uint GL_UNSIGNED_INT_2_10_10_10_REV                     = 0x8368;
const uint GL_BGR                                             = 0x80E0;
const uint GL_BGRA                                            = 0x80E1;
const uint GL_MAX_ELEMENTS_VERTICES                           = 0x80E8;
const uint GL_MAX_ELEMENTS_INDICES                            = 0x80E9;
const uint GL_CLAMP_TO_EDGE                                   = 0x812F;
const uint GL_TEXTURE_MIN_LOD                                 = 0x813A;
const uint GL_TEXTURE_MAX_LOD                                 = 0x813B;
const uint GL_TEXTURE_BASE_LEVEL                              = 0x813C;
const uint GL_TEXTURE_MAX_LEVEL                               = 0x813D;
const uint GL_LIGHT_MODEL_COLOR_CONTROL                       = 0x81F8;
const uint GL_SINGLE_COLOR                                    = 0x81F9;
const uint GL_SEPARATE_SPECULAR_COLOR                         = 0x81FA;
const uint GL_SMOOTH_POINT_SIZE_RANGE                         = 0x0B12;
const uint GL_SMOOTH_POINT_SIZE_GRANULARITY                   = 0x0B13;
const uint GL_SMOOTH_LINE_WIDTH_RANGE                         = 0x0B22;
const uint GL_SMOOTH_LINE_WIDTH_GRANULARITY                   = 0x0B23;
const uint GL_ALIASED_POINT_SIZE_RANGE                        = 0x846D;
const uint GL_ALIASED_LINE_WIDTH_RANGE                        = 0x846E;

typedef void     function(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) PFNGLBLENDCOLORPROC; //extern (Windows) ;
typedef void     function(GLenum mode) PFNGLBLENDEQUATIONPROC;
typedef void     function(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, GLvoid *indices) PFNGLDRAWRANGEELEMENTSPROC;
typedef void     function(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, GLvoid *table) PFNGLCOLORTABLEPROC;
typedef void     function(GLenum target, GLenum pname, GLfloat *params) PFNGLCOLORTABLEPARAMETERFVPROC;
typedef void     function(GLenum target, GLenum pname, GLint *params) PFNGLCOLORTABLEPARAMETERIVPROC;
typedef void     function(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) PFNGLCOPYCOLORTABLEPROC;
typedef void     function(GLenum target, GLenum format, GLenum type, GLvoid *table) PFNGLGETCOLORTABLEPROC;
typedef void     function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETCOLORTABLEPARAMETERFVPROC;
typedef void     function(GLenum target, GLenum pname, GLint *params) PFNGLGETCOLORTABLEPARAMETERIVPROC;
typedef void     function(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, GLvoid *data) PFNGLCOLORSUBTABLEPROC;
typedef void     function(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) PFNGLCOPYCOLORSUBTABLEPROC;
typedef void     function(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, GLvoid *image) PFNGLCONVOLUTIONFILTER1DPROC;
typedef void     function(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *image) PFNGLCONVOLUTIONFILTER2DPROC;
typedef void     function(GLenum target, GLenum pname, GLfloat params) PFNGLCONVOLUTIONPARAMETERFPROC;
typedef void     function(GLenum target, GLenum pname, GLfloat *params) PFNGLCONVOLUTIONPARAMETERFVPROC;
typedef void     function(GLenum target, GLenum pname, GLint params) PFNGLCONVOLUTIONPARAMETERIPROC;
typedef void     function(GLenum target, GLenum pname, GLint *params) PFNGLCONVOLUTIONPARAMETERIVPROC;
typedef void     function(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) PFNGLCOPYCONVOLUTIONFILTER1DPROC;
typedef void     function(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) PFNGLCOPYCONVOLUTIONFILTER2DPROC;
typedef void     function(GLenum target, GLenum format, GLenum type, GLvoid *image) PFNGLGETCONVOLUTIONFILTERPROC;
typedef void     function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETCONVOLUTIONPARAMETERFVPROC;
typedef void     function(GLenum target, GLenum pname, GLint *params) PFNGLGETCONVOLUTIONPARAMETERIVPROC;
typedef void     function(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span) PFNGLGETSEPARABLEFILTERPROC;
typedef void     function(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *row, GLvoid *column) PFNGLSEPARABLEFILTER2DPROC;
typedef void     function(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) PFNGLGETHISTOGRAMPROC;
typedef void     function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETHISTOGRAMPARAMETERFVPROC;
typedef void     function(GLenum target, GLenum pname, GLint *params) PFNGLGETHISTOGRAMPARAMETERIVPROC;
typedef void     function(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) PFNGLGETMINMAXPROC;
typedef void     function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETMINMAXPARAMETERFVPROC;
typedef void     function(GLenum target, GLenum pname, GLint *params) PFNGLGETMINMAXPARAMETERIVPROC;
typedef void     function(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) PFNGLHISTOGRAMPROC;
typedef void     function(GLenum target, GLenum internalformat, GLboolean sink) PFNGLMINMAXPROC;
typedef void     function(GLenum target) PFNGLRESETHISTOGRAMPROC;
typedef void     function(GLenum target) PFNGLRESETMINMAXPROC;
typedef void     function(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXIMAGE3DPROC;
typedef void     function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXSUBIMAGE3DPROC;
typedef void     function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) PFNGLCOPYTEXSUBIMAGE3DPROC;

 extern   PFNGLBLENDCOLORPROC pglBlendColor;
 extern   PFNGLBLENDEQUATIONPROC pglBlendEquation;
 extern   PFNGLDRAWRANGEELEMENTSPROC pglDrawRangeElements;
 extern   PFNGLCOLORTABLEPROC pglColorTable;
 extern   PFNGLCOLORTABLEPARAMETERFVPROC pglColorTableParameterfv;
 extern   PFNGLCOLORTABLEPARAMETERIVPROC pglColorTableParameteriv;
 extern   PFNGLCOPYCOLORTABLEPROC pglCopyColorTable;
 extern   PFNGLGETCOLORTABLEPROC pglGetColorTable;
 extern   PFNGLGETCOLORTABLEPARAMETERFVPROC pglGetColorTableParameterfv;
 extern   PFNGLGETCOLORTABLEPARAMETERIVPROC pglGetColorTableParameteriv;
 extern   PFNGLCOLORSUBTABLEPROC pglColorSubTable;
 extern   PFNGLCOPYCOLORSUBTABLEPROC pglCopyColorSubTable;
 extern   PFNGLCONVOLUTIONFILTER1DPROC pglConvolutionFilter1D;
 extern   PFNGLCONVOLUTIONFILTER2DPROC pglConvolutionFilter2D;
 extern   PFNGLCONVOLUTIONPARAMETERFPROC pglConvolutionParameterf;
 extern   PFNGLCONVOLUTIONPARAMETERFVPROC pglConvolutionParameterfv;
 extern   PFNGLCONVOLUTIONPARAMETERIPROC pglConvolutionParameteri;
 extern   PFNGLCONVOLUTIONPARAMETERIVPROC pglConvolutionParameteriv;
 extern   PFNGLCOPYCONVOLUTIONFILTER1DPROC pglCopyConvolutionFilter1D;
 extern   PFNGLCOPYCONVOLUTIONFILTER2DPROC pglCopyConvolutionFilter2D;
 extern   PFNGLGETCONVOLUTIONFILTERPROC pglGetConvolutionFilter;
 extern   PFNGLGETCONVOLUTIONPARAMETERFVPROC pglGetConvolutionParameterfv;
 extern   PFNGLGETCONVOLUTIONPARAMETERIVPROC pglGetConvolutionParameteriv;
 extern   PFNGLGETSEPARABLEFILTERPROC pglGetSeparableFilter;
 extern   PFNGLSEPARABLEFILTER2DPROC pglSeparableFilter2D;
 extern   PFNGLGETHISTOGRAMPROC pglGetHistogram;
 extern   PFNGLGETHISTOGRAMPARAMETERFVPROC pglGetHistogramParameterfv;
 extern   PFNGLGETHISTOGRAMPARAMETERIVPROC pglGetHistogramParameteriv;
 extern   PFNGLGETMINMAXPROC pglGetMinmax;
 extern   PFNGLGETMINMAXPARAMETERFVPROC pglGetMinmaxParameterfv;
 extern   PFNGLGETMINMAXPARAMETERIVPROC pglGetMinmaxParameteriv;
 extern   PFNGLHISTOGRAMPROC pglHistogram;
 extern   PFNGLMINMAXPROC pglMinmax;
 extern   PFNGLRESETHISTOGRAMPROC pglResetHistogram;
 extern   PFNGLRESETMINMAXPROC pglResetMinmax;
 extern   PFNGLTEXIMAGE3DPROC pglTexImage3D;
 extern   PFNGLTEXSUBIMAGE3DPROC pglTexSubImage3D;
 extern   PFNGLCOPYTEXSUBIMAGE3DPROC pglCopyTexSubImage3D;
alias pglBlendColor glBlendColor;
alias pglBlendEquation glBlendEquation;
alias pglDrawRangeElements glDrawRangeElements;
alias pglColorTable glColorTable;
alias pglColorTableParameterfv glColorTableParameterfv;
alias pglColorTableParameteriv glColorTableParameteriv;
alias pglCopyColorTable glCopyColorTable;
alias pglGetColorTable glGetColorTable;
alias pglGetColorTableParameterfv glGetColorTableParameterfv;
alias pglGetColorTableParameteriv glGetColorTableParameteriv;
alias pglColorSubTable glColorSubTable;
alias pglCopyColorSubTable glCopyColorSubTable;
alias pglConvolutionFilter1D glConvolutionFilter1D;
alias pglConvolutionFilter2D glConvolutionFilter2D;
alias pglConvolutionParameterf glConvolutionParameterf;
alias pglConvolutionParameterfv glConvolutionParameterfv;
alias pglConvolutionParameteri glConvolutionParameteri;
alias pglConvolutionParameteriv glConvolutionParameteriv;
alias pglCopyConvolutionFilter1D glCopyConvolutionFilter1D;
alias pglCopyConvolutionFilter2D glCopyConvolutionFilter2D;
alias pglGetConvolutionFilter glGetConvolutionFilter;
alias pglGetConvolutionParameterfv glGetConvolutionParameterfv;
alias pglGetConvolutionParameteriv glGetConvolutionParameteriv;
alias pglGetSeparableFilter glGetSeparableFilter;
alias pglSeparableFilter2D glSeparableFilter2D;
alias pglGetHistogram glGetHistogram;
alias pglGetHistogramParameterfv glGetHistogramParameterfv;
alias pglGetHistogramParameteriv glGetHistogramParameteriv;
alias pglGetMinmax glGetMinmax;
alias pglGetMinmaxParameterfv glGetMinmaxParameterfv;
alias pglGetMinmaxParameteriv glGetMinmaxParameteriv;
alias pglHistogram glHistogram;
alias pglMinmax glMinmax;
alias pglResetHistogram glResetHistogram;
alias pglResetMinmax glResetMinmax;
alias pglTexImage3D glTexImage3D;
alias pglTexSubImage3D glTexSubImage3D;
alias pglCopyTexSubImage3D glCopyTexSubImage3D;
//#endif ;

//GL_ARB_imaging

//#ifndef GL_ARB_imaging;
const uint GL_ARB_imaging = 1;
const uint  __GLEE_GL_ARB_imaging = 1;
//constants
const uint GL_CONSTANT_COLOR                                  = 0x8001;
const uint GL_ONE_MINUS_CONSTANT_COLOR                        = 0x8002;
const uint GL_CONSTANT_ALPHA                                  = 0x8003;
const uint GL_ONE_MINUS_CONSTANT_ALPHA                        = 0x8004;
const uint GL_BLEND_COLOR                                     = 0x8005;
const uint GL_FUNC_ADD                                        = 0x8006;
const uint GL_MIN                                             = 0x8007;
const uint GL_MAX                                             = 0x8008;
const uint GL_BLEND_EQUATION                                  = 0x8009;
const uint GL_FUNC_SUBTRACT                                   = 0x800A;
const uint GL_FUNC_REVERSE_SUBTRACT                           = 0x800B;
const uint GL_CONVOLUTION_1D                                  = 0x8010;
const uint GL_CONVOLUTION_2D                                  = 0x8011;
const uint GL_SEPARABLE_2D                                    = 0x8012;
const uint GL_CONVOLUTION_BORDER_MODE                         = 0x8013;
const uint GL_CONVOLUTION_FILTER_SCALE                        = 0x8014;
const uint GL_CONVOLUTION_FILTER_BIAS                         = 0x8015;
const uint GL_REDUCE                                          = 0x8016;
const uint GL_CONVOLUTION_FORMAT                              = 0x8017;
const uint GL_CONVOLUTION_WIDTH                               = 0x8018;
const uint GL_CONVOLUTION_HEIGHT                              = 0x8019;
const uint GL_MAX_CONVOLUTION_WIDTH                           = 0x801A;
const uint GL_MAX_CONVOLUTION_HEIGHT                          = 0x801B;
const uint GL_POST_CONVOLUTION_RED_SCALE                      = 0x801C;
const uint GL_POST_CONVOLUTION_GREEN_SCALE                    = 0x801D;
const uint GL_POST_CONVOLUTION_BLUE_SCALE                     = 0x801E;
const uint GL_POST_CONVOLUTION_ALPHA_SCALE                    = 0x801F;
const uint GL_POST_CONVOLUTION_RED_BIAS                       = 0x8020;
const uint GL_POST_CONVOLUTION_GREEN_BIAS                     = 0x8021;
const uint GL_POST_CONVOLUTION_BLUE_BIAS                      = 0x8022;
const uint GL_POST_CONVOLUTION_ALPHA_BIAS                     = 0x8023;
const uint GL_HISTOGRAM                                       = 0x8024;
const uint GL_PROXY_HISTOGRAM                                 = 0x8025;
const uint GL_HISTOGRAM_WIDTH                                 = 0x8026;
const uint GL_HISTOGRAM_FORMAT                                = 0x8027;
const uint GL_HISTOGRAM_RED_SIZE                              = 0x8028;
const uint GL_HISTOGRAM_GREEN_SIZE                            = 0x8029;
const uint GL_HISTOGRAM_BLUE_SIZE                             = 0x802A;
const uint GL_HISTOGRAM_ALPHA_SIZE                            = 0x802B;
const uint GL_HISTOGRAM_LUMINANCE_SIZE                        = 0x802C;
const uint GL_HISTOGRAM_SINK                                  = 0x802D;
const uint GL_MINMAX                                          = 0x802E;
const uint GL_MINMAX_FORMAT                                   = 0x802F;
const uint GL_MINMAX_SINK                                     = 0x8030;
const uint GL_TABLE_TOO_LARGE                                 = 0x8031;
const uint GL_COLOR_MATRIX                                    = 0x80B1;
const uint GL_COLOR_MATRIX_STACK_DEPTH                        = 0x80B2;
const uint GL_MAX_COLOR_MATRIX_STACK_DEPTH                    = 0x80B3;
const uint GL_POST_COLOR_MATRIX_RED_SCALE                     = 0x80B4;
const uint GL_POST_COLOR_MATRIX_GREEN_SCALE                   = 0x80B5;
const uint GL_POST_COLOR_MATRIX_BLUE_SCALE                    = 0x80B6;
const uint GL_POST_COLOR_MATRIX_ALPHA_SCALE                   = 0x80B7;
const uint GL_POST_COLOR_MATRIX_RED_BIAS                      = 0x80B8;
const uint GL_POST_COLOR_MATRIX_GREEN_BIAS                    = 0x80B9;
const uint GL_POST_COLOR_MATRIX_BLUE_BIAS                     = 0x80BA;
const uint GL_POST_COLOR_MATRIX_ALPHA_BIAS                    = 0x80BB;
const uint GL_COLOR_TABLE                                     = 0x80D0;
const uint GL_POST_CONVOLUTION_COLOR_TABLE                    = 0x80D1;
const uint GL_POST_COLOR_MATRIX_COLOR_TABLE                   = 0x80D2;
const uint GL_PROXY_COLOR_TABLE                               = 0x80D3;
const uint GL_PROXY_POST_CONVOLUTION_COLOR_TABLE              = 0x80D4;
const uint GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE             = 0x80D5;
const uint GL_COLOR_TABLE_SCALE                               = 0x80D6;
const uint GL_COLOR_TABLE_BIAS                                = 0x80D7;
const uint GL_COLOR_TABLE_FORMAT                              = 0x80D8;
const uint GL_COLOR_TABLE_WIDTH                               = 0x80D9;
const uint GL_COLOR_TABLE_RED_SIZE                            = 0x80DA;
const uint GL_COLOR_TABLE_GREEN_SIZE                          = 0x80DB;
const uint GL_COLOR_TABLE_BLUE_SIZE                           = 0x80DC;
const uint GL_COLOR_TABLE_ALPHA_SIZE                          = 0x80DD;
const uint GL_COLOR_TABLE_LUMINANCE_SIZE                      = 0x80DE;
const uint GL_COLOR_TABLE_INTENSITY_SIZE                      = 0x80DF;
const uint GL_CONSTANT_BORDER                                 = 0x8151;
const uint GL_REPLICATE_BORDER                                = 0x8153;
const uint GL_CONVOLUTION_BORDER_COLOR                        = 0x8154;
//#endif ;

//GL_VERSION_1_3

//#ifndef GL_VERSION_1_3;
const uint GL_VERSION_1_3 = 1;
const uint  __GLEE_GL_VERSION_1_3 = 1;
//constants
const uint GL_TEXTURE0                                        = 0x84C0;
const uint GL_TEXTURE1                                        = 0x84C1;
const uint GL_TEXTURE2                                        = 0x84C2;
const uint GL_TEXTURE3                                        = 0x84C3;
const uint GL_TEXTURE4                                        = 0x84C4;
const uint GL_TEXTURE5                                        = 0x84C5;
const uint GL_TEXTURE6                                        = 0x84C6;
const uint GL_TEXTURE7                                        = 0x84C7;
const uint GL_TEXTURE8                                        = 0x84C8;
const uint GL_TEXTURE9                                        = 0x84C9;
const uint GL_TEXTURE10                                       = 0x84CA;
const uint GL_TEXTURE11                                       = 0x84CB;
const uint GL_TEXTURE12                                       = 0x84CC;
const uint GL_TEXTURE13                                       = 0x84CD;
const uint GL_TEXTURE14                                       = 0x84CE;
const uint GL_TEXTURE15                                       = 0x84CF;
const uint GL_TEXTURE16                                       = 0x84D0;
const uint GL_TEXTURE17                                       = 0x84D1;
const uint GL_TEXTURE18                                       = 0x84D2;
const uint GL_TEXTURE19                                       = 0x84D3;
const uint GL_TEXTURE20                                       = 0x84D4;
const uint GL_TEXTURE21                                       = 0x84D5;
const uint GL_TEXTURE22                                       = 0x84D6;
const uint GL_TEXTURE23                                       = 0x84D7;
const uint GL_TEXTURE24                                       = 0x84D8;
const uint GL_TEXTURE25                                       = 0x84D9;
const uint GL_TEXTURE26                                       = 0x84DA;
const uint GL_TEXTURE27                                       = 0x84DB;
const uint GL_TEXTURE28                                       = 0x84DC;
const uint GL_TEXTURE29                                       = 0x84DD;
const uint GL_TEXTURE30                                       = 0x84DE;
const uint GL_TEXTURE31                                       = 0x84DF;
const uint GL_ACTIVE_TEXTURE                                  = 0x84E0;
const uint GL_CLIENT_ACTIVE_TEXTURE                           = 0x84E1;
const uint GL_MAX_TEXTURE_UNITS                               = 0x84E2;
const uint GL_TRANSPOSE_MODELVIEW_MATRIX                      = 0x84E3;
const uint GL_TRANSPOSE_PROJECTION_MATRIX                     = 0x84E4;
const uint GL_TRANSPOSE_TEXTURE_MATRIX                        = 0x84E5;
const uint GL_TRANSPOSE_COLOR_MATRIX                          = 0x84E6;
const uint GL_MULTISAMPLE                                     = 0x809D;
const uint GL_SAMPLE_ALPHA_TO_COVERAGE                        = 0x809E;
const uint GL_SAMPLE_ALPHA_TO_ONE                             = 0x809F;
const uint GL_SAMPLE_COVERAGE                                 = 0x80A0;
const uint GL_SAMPLE_BUFFERS                                  = 0x80A8;
const uint GL_SAMPLES                                         = 0x80A9;
const uint GL_SAMPLE_COVERAGE_VALUE                           = 0x80AA;
const uint GL_SAMPLE_COVERAGE_INVERT                          = 0x80AB;
const uint GL_MULTISAMPLE_BIT                                 = 0x20000000;
const uint GL_NORMAL_MAP                                      = 0x8511;
const uint GL_REFLECTION_MAP                                  = 0x8512;
const uint GL_TEXTURE_CUBE_MAP                                = 0x8513;
const uint GL_TEXTURE_BINDING_CUBE_MAP                        = 0x8514;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_X                     = 0x8515;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_X                     = 0x8516;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Y                     = 0x8517;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Y                     = 0x8518;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Z                     = 0x8519;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Z                     = 0x851A;
const uint GL_PROXY_TEXTURE_CUBE_MAP                          = 0x851B;
const uint GL_MAX_CUBE_MAP_TEXTURE_SIZE                       = 0x851C;
const uint GL_COMPRESSED_ALPHA                                = 0x84E9;
const uint GL_COMPRESSED_LUMINANCE                            = 0x84EA;
const uint GL_COMPRESSED_LUMINANCE_ALPHA                      = 0x84EB;
const uint GL_COMPRESSED_INTENSITY                            = 0x84EC;
const uint GL_COMPRESSED_RGB                                  = 0x84ED;
const uint GL_COMPRESSED_RGBA                                 = 0x84EE;
const uint GL_TEXTURE_COMPRESSION_HINT                        = 0x84EF;
const uint GL_TEXTURE_COMPRESSED_IMAGE_SIZE                   = 0x86A0;
const uint GL_TEXTURE_COMPRESSED                              = 0x86A1;
const uint GL_NUM_COMPRESSED_TEXTURE_FORMATS                  = 0x86A2;
const uint GL_COMPRESSED_TEXTURE_FORMATS                      = 0x86A3;
const uint GL_CLAMP_TO_BORDER                                 = 0x812D;
const uint GL_CLAMP_TO_BORDER_SGIS                            = 0x812D;
const uint GL_COMBINE                                         = 0x8570;
const uint GL_COMBINE_RGB                                     = 0x8571;
const uint GL_COMBINE_ALPHA                                   = 0x8572;
const uint GL_SOURCE0_RGB                                     = 0x8580;
const uint GL_SOURCE1_RGB                                     = 0x8581;
const uint GL_SOURCE2_RGB                                     = 0x8582;
const uint GL_SOURCE0_ALPHA                                   = 0x8588;
const uint GL_SOURCE1_ALPHA                                   = 0x8589;
const uint GL_SOURCE2_ALPHA                                   = 0x858A;
const uint GL_OPERAND0_RGB                                    = 0x8590;
const uint GL_OPERAND1_RGB                                    = 0x8591;
const uint GL_OPERAND2_RGB                                    = 0x8592;
const uint GL_OPERAND0_ALPHA                                  = 0x8598;
const uint GL_OPERAND1_ALPHA                                  = 0x8599;
const uint GL_OPERAND2_ALPHA                                  = 0x859A;
const uint GL_RGB_SCALE                                       = 0x8573;
const uint GL_ADD_SIGNED                                      = 0x8574;
const uint GL_INTERPOLATE                                     = 0x8575;
const uint GL_SUBTRACT                                        = 0x84E7;
const uint GL_CONSTANT                                        = 0x8576;
const uint GL_PRIMARY_COLOR                                   = 0x8577;
const uint GL_PREVIOUS                                        = 0x8578;
const uint GL_DOT3_RGB                                        = 0x86AE;
const uint GL_DOT3_RGBA                                       = 0x86AF;
typedef void     function(GLenum texture) PFNGLACTIVETEXTUREPROC;
typedef void     function(GLenum texture) PFNGLCLIENTACTIVETEXTUREPROC;
typedef void     function(GLenum target, GLdouble s) PFNGLMULTITEXCOORD1DPROC;
typedef void     function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD1DVPROC;
typedef void     function(GLenum target, GLfloat s) PFNGLMULTITEXCOORD1FPROC;
typedef void     function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD1FVPROC;
typedef void     function(GLenum target, GLint s) PFNGLMULTITEXCOORD1IPROC;
typedef void     function(GLenum target, GLint *v) PFNGLMULTITEXCOORD1IVPROC;
typedef void     function(GLenum target, GLshort s) PFNGLMULTITEXCOORD1SPROC;
typedef void     function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD1SVPROC;
typedef void     function(GLenum target, GLdouble s, GLdouble t) PFNGLMULTITEXCOORD2DPROC;
typedef void     function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD2DVPROC;
typedef void     function(GLenum target, GLfloat s, GLfloat t) PFNGLMULTITEXCOORD2FPROC;
typedef void     function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD2FVPROC;
typedef void     function(GLenum target, GLint s, GLint t) PFNGLMULTITEXCOORD2IPROC;
typedef void     function(GLenum target, GLint *v) PFNGLMULTITEXCOORD2IVPROC;
typedef void     function(GLenum target, GLshort s, GLshort t) PFNGLMULTITEXCOORD2SPROC;
typedef void     function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD2SVPROC;
typedef void     function(GLenum target, GLdouble s, GLdouble t, GLdouble r) PFNGLMULTITEXCOORD3DPROC;
typedef void     function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD3DVPROC;
typedef void     function(GLenum target, GLfloat s, GLfloat t, GLfloat r) PFNGLMULTITEXCOORD3FPROC;
typedef void     function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD3FVPROC;
typedef void     function(GLenum target, GLint s, GLint t, GLint r) PFNGLMULTITEXCOORD3IPROC;
typedef void     function(GLenum target, GLint *v) PFNGLMULTITEXCOORD3IVPROC;
typedef void     function(GLenum target, GLshort s, GLshort t, GLshort r) PFNGLMULTITEXCOORD3SPROC;
typedef void     function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD3SVPROC;
typedef void     function(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) PFNGLMULTITEXCOORD4DPROC;
typedef void     function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD4DVPROC;
typedef void     function(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) PFNGLMULTITEXCOORD4FPROC;
typedef void     function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD4FVPROC;
typedef void     function(GLenum target, GLint s, GLint t, GLint r, GLint q) PFNGLMULTITEXCOORD4IPROC;
typedef void     function(GLenum target, GLint *v) PFNGLMULTITEXCOORD4IVPROC;
typedef void     function(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) PFNGLMULTITEXCOORD4SPROC;
typedef void     function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD4SVPROC;
typedef void     function(GLfloat *m) PFNGLLOADTRANSPOSEMATRIXFPROC;
typedef void     function(GLdouble *m) PFNGLLOADTRANSPOSEMATRIXDPROC;
typedef void     function(GLfloat *m) PFNGLMULTTRANSPOSEMATRIXFPROC;
typedef void     function(GLdouble *m) PFNGLMULTTRANSPOSEMATRIXDPROC;
typedef void     function(GLclampf value, GLboolean invert) PFNGLSAMPLECOVERAGEPROC;
typedef void     function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXIMAGE3DPROC;
typedef void     function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXIMAGE2DPROC;
typedef void     function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXIMAGE1DPROC;
typedef void     function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC;
typedef void     function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC;
typedef void     function(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC;
typedef void     function(GLenum target, GLint level, GLvoid *img) PFNGLGETCOMPRESSEDTEXIMAGEPROC;
 extern   PFNGLACTIVETEXTUREPROC pglActiveTexture;
 extern   PFNGLCLIENTACTIVETEXTUREPROC pglClientActiveTexture;
 extern   PFNGLMULTITEXCOORD1DPROC pglMultiTexCoord1d;
 extern   PFNGLMULTITEXCOORD1DVPROC pglMultiTexCoord1dv;
 extern   PFNGLMULTITEXCOORD1FPROC pglMultiTexCoord1f;
 extern   PFNGLMULTITEXCOORD1FVPROC pglMultiTexCoord1fv;
 extern   PFNGLMULTITEXCOORD1IPROC pglMultiTexCoord1i;
 extern   PFNGLMULTITEXCOORD1IVPROC pglMultiTexCoord1iv;
 extern   PFNGLMULTITEXCOORD1SPROC pglMultiTexCoord1s;
 extern   PFNGLMULTITEXCOORD1SVPROC pglMultiTexCoord1sv;
 extern   PFNGLMULTITEXCOORD2DPROC pglMultiTexCoord2d;
 extern   PFNGLMULTITEXCOORD2DVPROC pglMultiTexCoord2dv;
 extern   PFNGLMULTITEXCOORD2FPROC pglMultiTexCoord2f;
 extern   PFNGLMULTITEXCOORD2FVPROC pglMultiTexCoord2fv;
 extern   PFNGLMULTITEXCOORD2IPROC pglMultiTexCoord2i;
 extern   PFNGLMULTITEXCOORD2IVPROC pglMultiTexCoord2iv;
 extern   PFNGLMULTITEXCOORD2SPROC pglMultiTexCoord2s;
 extern   PFNGLMULTITEXCOORD2SVPROC pglMultiTexCoord2sv;
 extern   PFNGLMULTITEXCOORD3DPROC pglMultiTexCoord3d;
 extern   PFNGLMULTITEXCOORD3DVPROC pglMultiTexCoord3dv;
 extern   PFNGLMULTITEXCOORD3FPROC pglMultiTexCoord3f;
 extern   PFNGLMULTITEXCOORD3FVPROC pglMultiTexCoord3fv;
 extern   PFNGLMULTITEXCOORD3IPROC pglMultiTexCoord3i;
 extern   PFNGLMULTITEXCOORD3IVPROC pglMultiTexCoord3iv;
 extern   PFNGLMULTITEXCOORD3SPROC pglMultiTexCoord3s;
 extern   PFNGLMULTITEXCOORD3SVPROC pglMultiTexCoord3sv;
 extern   PFNGLMULTITEXCOORD4DPROC pglMultiTexCoord4d;
 extern   PFNGLMULTITEXCOORD4DVPROC pglMultiTexCoord4dv;
 extern   PFNGLMULTITEXCOORD4FPROC pglMultiTexCoord4f;
 extern   PFNGLMULTITEXCOORD4FVPROC pglMultiTexCoord4fv;
 extern   PFNGLMULTITEXCOORD4IPROC pglMultiTexCoord4i;
 extern   PFNGLMULTITEXCOORD4IVPROC pglMultiTexCoord4iv;
 extern   PFNGLMULTITEXCOORD4SPROC pglMultiTexCoord4s;
 extern   PFNGLMULTITEXCOORD4SVPROC pglMultiTexCoord4sv;
 extern   PFNGLLOADTRANSPOSEMATRIXFPROC pglLoadTransposeMatrixf;
 extern   PFNGLLOADTRANSPOSEMATRIXDPROC pglLoadTransposeMatrixd;
 extern   PFNGLMULTTRANSPOSEMATRIXFPROC pglMultTransposeMatrixf;
 extern   PFNGLMULTTRANSPOSEMATRIXDPROC pglMultTransposeMatrixd;
 extern   PFNGLSAMPLECOVERAGEPROC pglSampleCoverage;
 extern   PFNGLCOMPRESSEDTEXIMAGE3DPROC pglCompressedTexImage3D;
 extern   PFNGLCOMPRESSEDTEXIMAGE2DPROC pglCompressedTexImage2D;
 extern   PFNGLCOMPRESSEDTEXIMAGE1DPROC pglCompressedTexImage1D;
 extern   PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC pglCompressedTexSubImage3D;
 extern   PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC pglCompressedTexSubImage2D;
 extern   PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC pglCompressedTexSubImage1D;
 extern   PFNGLGETCOMPRESSEDTEXIMAGEPROC pglGetCompressedTexImage;
alias pglActiveTexture glActiveTexture;
alias pglClientActiveTexture glClientActiveTexture;
alias pglMultiTexCoord1d glMultiTexCoord1d;
alias pglMultiTexCoord1dv glMultiTexCoord1dv;
alias pglMultiTexCoord1f glMultiTexCoord1f;
alias pglMultiTexCoord1fv glMultiTexCoord1fv;
alias pglMultiTexCoord1i glMultiTexCoord1i;
alias pglMultiTexCoord1iv glMultiTexCoord1iv;
alias pglMultiTexCoord1s glMultiTexCoord1s;
alias pglMultiTexCoord1sv glMultiTexCoord1sv;
alias pglMultiTexCoord2d glMultiTexCoord2d;
alias pglMultiTexCoord2dv glMultiTexCoord2dv;
alias pglMultiTexCoord2f glMultiTexCoord2f;
alias pglMultiTexCoord2fv glMultiTexCoord2fv;
alias pglMultiTexCoord2i glMultiTexCoord2i;
alias pglMultiTexCoord2iv glMultiTexCoord2iv;
alias pglMultiTexCoord2s glMultiTexCoord2s;
alias pglMultiTexCoord2sv glMultiTexCoord2sv;
alias pglMultiTexCoord3d glMultiTexCoord3d;
alias pglMultiTexCoord3dv glMultiTexCoord3dv;
alias pglMultiTexCoord3f glMultiTexCoord3f;
alias pglMultiTexCoord3fv glMultiTexCoord3fv;
alias pglMultiTexCoord3i glMultiTexCoord3i;
alias pglMultiTexCoord3iv glMultiTexCoord3iv;
alias pglMultiTexCoord3s glMultiTexCoord3s;
alias pglMultiTexCoord3sv glMultiTexCoord3sv;
alias pglMultiTexCoord4d glMultiTexCoord4d;
alias pglMultiTexCoord4dv glMultiTexCoord4dv;
alias pglMultiTexCoord4f glMultiTexCoord4f;
alias pglMultiTexCoord4fv glMultiTexCoord4fv;
alias pglMultiTexCoord4i glMultiTexCoord4i;
alias pglMultiTexCoord4iv glMultiTexCoord4iv;
alias pglMultiTexCoord4s glMultiTexCoord4s;
alias pglMultiTexCoord4sv glMultiTexCoord4sv;
alias pglLoadTransposeMatrixf glLoadTransposeMatrixf;
alias pglLoadTransposeMatrixd glLoadTransposeMatrixd;
alias pglMultTransposeMatrixf glMultTransposeMatrixf;
alias pglMultTransposeMatrixd glMultTransposeMatrixd;
alias pglSampleCoverage glSampleCoverage;
alias pglCompressedTexImage3D glCompressedTexImage3D;
alias pglCompressedTexImage2D glCompressedTexImage2D;
alias pglCompressedTexImage1D glCompressedTexImage1D;
alias pglCompressedTexSubImage3D glCompressedTexSubImage3D;
alias pglCompressedTexSubImage2D glCompressedTexSubImage2D;
alias pglCompressedTexSubImage1D glCompressedTexSubImage1D;
alias pglGetCompressedTexImage glGetCompressedTexImage;
//#endif ;

//GL_VERSION_1_4

//#ifndef GL_VERSION_1_4;
const uint GL_VERSION_1_4 = 1;
const uint  __GLEE_GL_VERSION_1_4 = 1;
//constants
const uint GL_BLEND_DST_RGB                                    = 0x80C8;
const uint GL_BLEND_SRC_RGB                                    = 0x80C9;
const uint GL_BLEND_DST_ALPHA                                  = 0x80CA;
const uint GL_BLEND_SRC_ALPHA                                  = 0x80CB;
const uint GL_POINT_SIZE_MIN                                   = 0x8126;
const uint GL_POINT_SIZE_MAX                                   = 0x8127;
const uint GL_POINT_FADE_THRESHOLD_SIZE                        = 0x8128;
const uint GL_POINT_DISTANCE_ATTENUATION                       = 0x8129;
const uint GL_GENERATE_MIPMAP                                  = 0x8191;
const uint GL_GENERATE_MIPMAP_HINT                             = 0x8192;
const uint GL_DEPTH_COMPONENT16                                = 0x81A5;
const uint GL_DEPTH_COMPONENT24                                = 0x81A6;
const uint GL_DEPTH_COMPONENT32                                = 0x81A7;
const uint GL_MIRRORED_REPEAT                                  = 0x8370;
const uint GL_FOG_COORDINATE_SOURCE                            = 0x8450;
const uint GL_FOG_COORDINATE                                   = 0x8451;
const uint GL_FRAGMENT_DEPTH                                   = 0x8452;
const uint GL_CURRENT_FOG_COORDINATE                           = 0x8453;
const uint GL_FOG_COORDINATE_ARRAY_TYPE                        = 0x8454;
const uint GL_FOG_COORDINATE_ARRAY_STRIDE                      = 0x8455;
const uint GL_FOG_COORDINATE_ARRAY_POINTER                     = 0x8456;
const uint GL_FOG_COORDINATE_ARRAY                             = 0x8457;
const uint GL_COLOR_SUM                                        = 0x8458;
const uint GL_CURRENT_SECONDARY_COLOR                          = 0x8459;
const uint GL_SECONDARY_COLOR_ARRAY_SIZE                       = 0x845A;
const uint GL_SECONDARY_COLOR_ARRAY_TYPE                       = 0x845B;
const uint GL_SECONDARY_COLOR_ARRAY_STRIDE                     = 0x845C;
const uint GL_SECONDARY_COLOR_ARRAY_POINTER                    = 0x845D;
const uint GL_SECONDARY_COLOR_ARRAY                            = 0x845E;
const uint GL_MAX_TEXTURE_LOD_BIAS                             = 0x84FD;
const uint GL_TEXTURE_FILTER_CONTROL                           = 0x8500;
const uint GL_TEXTURE_LOD_BIAS                                 = 0x8501;
const uint GL_INCR_WRAP                                        = 0x8507;
const uint GL_DECR_WRAP                                        = 0x8508;
const uint GL_TEXTURE_DEPTH_SIZE                               = 0x884A;
const uint GL_DEPTH_TEXTURE_MODE                               = 0x884B;
const uint GL_TEXTURE_COMPARE_MODE                             = 0x884C;
const uint GL_TEXTURE_COMPARE_FUNC                             = 0x884D;
const uint GL_COMPARE_R_TO_TEXTURE                             = 0x884E;
typedef void   function(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) PFNGLBLENDFUNCSEPARATEPROC;
typedef void   function(GLfloat coord) PFNGLFOGCOORDFPROC;
typedef void   function(GLfloat *coord) PFNGLFOGCOORDFVPROC;
typedef void   function(GLdouble coord) PFNGLFOGCOORDDPROC;
typedef void   function(GLdouble *coord) PFNGLFOGCOORDDVPROC;
typedef void   function(GLenum type, GLsizei stride, GLvoid *pointer) PFNGLFOGCOORDPOINTERPROC;
typedef void   function(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount) PFNGLMULTIDRAWARRAYSPROC;
typedef void   function(GLenum mode, GLsizei *count, GLenum type, GLvoid* *indices, GLsizei primcount) PFNGLMULTIDRAWELEMENTSPROC;
typedef void   function(GLenum pname, GLfloat param) PFNGLPOINTPARAMETERFPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLPOINTPARAMETERFVPROC;
typedef void   function(GLenum pname, GLint param) PFNGLPOINTPARAMETERIPROC;
typedef void   function(GLenum pname, GLint *params) PFNGLPOINTPARAMETERIVPROC;
typedef void   function(GLbyte red, GLbyte green, GLbyte blue) PFNGLSECONDARYCOLOR3BPROC;
typedef void   function(GLbyte *v) PFNGLSECONDARYCOLOR3BVPROC;
typedef void   function(GLdouble red, GLdouble green, GLdouble blue) PFNGLSECONDARYCOLOR3DPROC;
typedef void   function(GLdouble *v) PFNGLSECONDARYCOLOR3DVPROC;
typedef void   function(GLfloat red, GLfloat green, GLfloat blue) PFNGLSECONDARYCOLOR3FPROC;
typedef void   function(GLfloat *v) PFNGLSECONDARYCOLOR3FVPROC;
typedef void   function(GLint red, GLint green, GLint blue) PFNGLSECONDARYCOLOR3IPROC;
typedef void   function(GLint *v) PFNGLSECONDARYCOLOR3IVPROC;
typedef void   function(GLshort red, GLshort green, GLshort blue) PFNGLSECONDARYCOLOR3SPROC;
typedef void   function(GLshort *v) PFNGLSECONDARYCOLOR3SVPROC;
typedef void   function(GLubyte red, GLubyte green, GLubyte blue) PFNGLSECONDARYCOLOR3UBPROC;
typedef void   function(GLubyte *v) PFNGLSECONDARYCOLOR3UBVPROC;
typedef void   function(GLuint red, GLuint green, GLuint blue) PFNGLSECONDARYCOLOR3UIPROC;
typedef void   function(GLuint *v) PFNGLSECONDARYCOLOR3UIVPROC;
typedef void   function(GLushort red, GLushort green, GLushort blue) PFNGLSECONDARYCOLOR3USPROC;
typedef void   function(GLushort *v) PFNGLSECONDARYCOLOR3USVPROC;
typedef void   function(GLint size, GLenum type, GLsizei stride, GLvoid *pointer) PFNGLSECONDARYCOLORPOINTERPROC;
typedef void   function(GLdouble x, GLdouble y) PFNGLWINDOWPOS2DPROC;
typedef void   function(GLdouble *v) PFNGLWINDOWPOS2DVPROC;
typedef void   function(GLfloat x, GLfloat y) PFNGLWINDOWPOS2FPROC;
typedef void   function(GLfloat *v) PFNGLWINDOWPOS2FVPROC;
typedef void   function(GLint x, GLint y) PFNGLWINDOWPOS2IPROC;
typedef void   function(GLint *v) PFNGLWINDOWPOS2IVPROC;
typedef void   function(GLshort x, GLshort y) PFNGLWINDOWPOS2SPROC;
typedef void   function(GLshort *v) PFNGLWINDOWPOS2SVPROC;
typedef void   function(GLdouble x, GLdouble y, GLdouble z) PFNGLWINDOWPOS3DPROC;
typedef void   function(GLdouble *v) PFNGLWINDOWPOS3DVPROC;
typedef void   function(GLfloat x, GLfloat y, GLfloat z) PFNGLWINDOWPOS3FPROC;
typedef void   function(GLfloat *v) PFNGLWINDOWPOS3FVPROC;
typedef void   function(GLint x, GLint y, GLint z) PFNGLWINDOWPOS3IPROC;
typedef void   function(GLint *v) PFNGLWINDOWPOS3IVPROC;
typedef void   function(GLshort x, GLshort y, GLshort z) PFNGLWINDOWPOS3SPROC;
typedef void   function(GLshort *v) PFNGLWINDOWPOS3SVPROC;
 extern   PFNGLBLENDFUNCSEPARATEPROC pglBlendFuncSeparate;
 extern   PFNGLFOGCOORDFPROC pglFogCoordf;
 extern   PFNGLFOGCOORDFVPROC pglFogCoordfv;
 extern   PFNGLFOGCOORDDPROC pglFogCoordd;
 extern   PFNGLFOGCOORDDVPROC pglFogCoorddv;
 extern   PFNGLFOGCOORDPOINTERPROC pglFogCoordPointer;
 extern   PFNGLMULTIDRAWARRAYSPROC pglMultiDrawArrays;
 extern   PFNGLMULTIDRAWELEMENTSPROC pglMultiDrawElements;
 extern   PFNGLPOINTPARAMETERFPROC pglPointParameterf;
 extern   PFNGLPOINTPARAMETERFVPROC pglPointParameterfv;
 extern   PFNGLPOINTPARAMETERIPROC pglPointParameteri;
 extern   PFNGLPOINTPARAMETERIVPROC pglPointParameteriv;
 extern   PFNGLSECONDARYCOLOR3BPROC pglSecondaryColor3b;
 extern   PFNGLSECONDARYCOLOR3BVPROC pglSecondaryColor3bv;
 extern   PFNGLSECONDARYCOLOR3DPROC pglSecondaryColor3d;
 extern   PFNGLSECONDARYCOLOR3DVPROC pglSecondaryColor3dv;
 extern   PFNGLSECONDARYCOLOR3FPROC pglSecondaryColor3f;
 extern   PFNGLSECONDARYCOLOR3FVPROC pglSecondaryColor3fv;
 extern   PFNGLSECONDARYCOLOR3IPROC pglSecondaryColor3i;
 extern   PFNGLSECONDARYCOLOR3IVPROC pglSecondaryColor3iv;
 extern   PFNGLSECONDARYCOLOR3SPROC pglSecondaryColor3s;
 extern   PFNGLSECONDARYCOLOR3SVPROC pglSecondaryColor3sv;
 extern   PFNGLSECONDARYCOLOR3UBPROC pglSecondaryColor3ub;
 extern   PFNGLSECONDARYCOLOR3UBVPROC pglSecondaryColor3ubv;
 extern   PFNGLSECONDARYCOLOR3UIPROC pglSecondaryColor3ui;
 extern   PFNGLSECONDARYCOLOR3UIVPROC pglSecondaryColor3uiv;
 extern   PFNGLSECONDARYCOLOR3USPROC pglSecondaryColor3us;
 extern   PFNGLSECONDARYCOLOR3USVPROC pglSecondaryColor3usv;
 extern   PFNGLSECONDARYCOLORPOINTERPROC pglSecondaryColorPointer;
 extern   PFNGLWINDOWPOS2DPROC pglWindowPos2d;
 extern   PFNGLWINDOWPOS2DVPROC pglWindowPos2dv;
 extern   PFNGLWINDOWPOS2FPROC pglWindowPos2f;
 extern   PFNGLWINDOWPOS2FVPROC pglWindowPos2fv;
 extern   PFNGLWINDOWPOS2IPROC pglWindowPos2i;
 extern   PFNGLWINDOWPOS2IVPROC pglWindowPos2iv;
 extern   PFNGLWINDOWPOS2SPROC pglWindowPos2s;
 extern   PFNGLWINDOWPOS2SVPROC pglWindowPos2sv;
 extern   PFNGLWINDOWPOS3DPROC pglWindowPos3d;
 extern   PFNGLWINDOWPOS3DVPROC pglWindowPos3dv;
 extern   PFNGLWINDOWPOS3FPROC pglWindowPos3f;
 extern   PFNGLWINDOWPOS3FVPROC pglWindowPos3fv;
 extern   PFNGLWINDOWPOS3IPROC pglWindowPos3i;
 extern   PFNGLWINDOWPOS3IVPROC pglWindowPos3iv;
 extern   PFNGLWINDOWPOS3SPROC pglWindowPos3s;
 extern   PFNGLWINDOWPOS3SVPROC pglWindowPos3sv;
alias pglBlendFuncSeparate glBlendFuncSeparate;
alias pglFogCoordf glFogCoordf;
alias pglFogCoordfv glFogCoordfv;
alias pglFogCoordd glFogCoordd;
alias pglFogCoorddv glFogCoorddv;
alias pglFogCoordPointer glFogCoordPointer;
alias pglMultiDrawArrays glMultiDrawArrays;
alias pglMultiDrawElements glMultiDrawElements;
alias pglPointParameterf glPointParameterf;
alias pglPointParameterfv glPointParameterfv;
alias pglPointParameteri glPointParameteri;
alias pglPointParameteriv glPointParameteriv;
alias pglSecondaryColor3b glSecondaryColor3b;
alias pglSecondaryColor3bv glSecondaryColor3bv;
alias pglSecondaryColor3d glSecondaryColor3d;
alias pglSecondaryColor3dv glSecondaryColor3dv;
alias pglSecondaryColor3f glSecondaryColor3f;
alias pglSecondaryColor3fv glSecondaryColor3fv;
alias pglSecondaryColor3i glSecondaryColor3i;
alias pglSecondaryColor3iv glSecondaryColor3iv;
alias pglSecondaryColor3s glSecondaryColor3s;
alias pglSecondaryColor3sv glSecondaryColor3sv;
alias pglSecondaryColor3ub glSecondaryColor3ub;
alias pglSecondaryColor3ubv glSecondaryColor3ubv;
alias pglSecondaryColor3ui glSecondaryColor3ui;
alias pglSecondaryColor3uiv glSecondaryColor3uiv;
alias pglSecondaryColor3us glSecondaryColor3us;
alias pglSecondaryColor3usv glSecondaryColor3usv;
alias pglSecondaryColorPointer glSecondaryColorPointer;
alias pglWindowPos2d glWindowPos2d;
alias pglWindowPos2dv glWindowPos2dv;
alias pglWindowPos2f glWindowPos2f;
alias pglWindowPos2fv glWindowPos2fv;
alias pglWindowPos2i glWindowPos2i;
alias pglWindowPos2iv glWindowPos2iv;
alias pglWindowPos2s glWindowPos2s;
alias pglWindowPos2sv glWindowPos2sv;
alias pglWindowPos3d glWindowPos3d;
alias pglWindowPos3dv glWindowPos3dv;
alias pglWindowPos3f glWindowPos3f;
alias pglWindowPos3fv glWindowPos3fv;
alias pglWindowPos3i glWindowPos3i;
alias pglWindowPos3iv glWindowPos3iv;
alias pglWindowPos3s glWindowPos3s;
alias pglWindowPos3sv glWindowPos3sv;
//#endif ;

//GL_VERSION_1_5

//#ifndef GL_VERSION_1_5;
const uint GL_VERSION_1_5 = 1;
const uint  __GLEE_GL_VERSION_1_5 = 1;
//constants
const uint GL_BUFFER_SIZE                                     = 0x8764;
const uint GL_BUFFER_USAGE                                    = 0x8765;
const uint GL_QUERY_COUNTER_BITS                              = 0x8864;
const uint GL_CURRENT_QUERY                                   = 0x8865;
const uint GL_QUERY_RESULT                                    = 0x8866;
const uint GL_QUERY_RESULT_AVAILABLE                          = 0x8867;
const uint GL_ARRAY_BUFFER                                    = 0x8892;
const uint GL_ELEMENT_ARRAY_BUFFER                            = 0x8893;
const uint GL_ARRAY_BUFFER_BINDING                            = 0x8894;
const uint GL_ELEMENT_ARRAY_BUFFER_BINDING                    = 0x8895;
const uint GL_VERTEX_ARRAY_BUFFER_BINDING                     = 0x8896;
const uint GL_NORMAL_ARRAY_BUFFER_BINDING                     = 0x8897;
const uint GL_COLOR_ARRAY_BUFFER_BINDING                      = 0x8898;
const uint GL_INDEX_ARRAY_BUFFER_BINDING                      = 0x8899;
const uint GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING              = 0x889A;
const uint GL_EDGE_FLAG_ARRAY_BUFFER_BINDING                  = 0x889B;
const uint GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING            = 0x889C;
const uint GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING             = 0x889D;
const uint GL_WEIGHT_ARRAY_BUFFER_BINDING                     = 0x889E;
const uint GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING              = 0x889F;
const uint GL_READ_ONLY                                       = 0x88B8;
const uint GL_WRITE_ONLY                                      = 0x88B9;
const uint GL_READ_WRITE                                      = 0x88BA;
const uint GL_BUFFER_ACCESS                                   = 0x88BB;
const uint GL_BUFFER_MAPPED                                   = 0x88BC;
const uint GL_BUFFER_MAP_POINTER                              = 0x88BD;
const uint GL_STREAM_DRAW                                     = 0x88E0;
const uint GL_STREAM_READ                                     = 0x88E1;
const uint GL_STREAM_COPY                                     = 0x88E2;
const uint GL_STATIC_DRAW                                     = 0x88E4;
const uint GL_STATIC_READ                                     = 0x88E5;
const uint GL_STATIC_COPY                                     = 0x88E6;
const uint GL_DYNAMIC_DRAW                                    = 0x88E8;
const uint GL_DYNAMIC_READ                                    = 0x88E9;
const uint GL_DYNAMIC_COPY                                    = 0x88EA;
const uint   GL_SAMPLES_PASSED                                 = 0x8914;
alias GL_FOG_COORDINATE_SOURCE                                GL_FOG_COORD_SOURCE;
alias GL_FOG_COORDINATE                                       GL_FOG_COORD;
alias GL_CURRENT_FOG_COORDINATE                               GL_CURRENT_FOG_COORD;
alias GL_FOG_COORDINATE_ARRAY_TYPE                            GL_FOG_COORD_ARRAY_TYPE;
alias GL_FOG_COORDINATE_ARRAY_STRIDE                          GL_FOG_COORD_ARRAY_STRIDE;
alias GL_FOG_COORDINATE_ARRAY_POINTER                         GL_FOG_COORD_ARRAY_POINTER;
alias GL_FOG_COORDINATE_ARRAY                                 GL_FOG_COORD_ARRAY;
alias GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING                  GL_FOG_COORD_ARRAY_BUFFER_BINDING;
alias GL_SOURCE0_RGB                                        GL_SRC0_RGB;
alias GL_SOURCE1_RGB                                        GL_SRC1_RGB;
alias GL_SOURCE2_RGB                                        GL_SRC2_RGB;
alias GL_SOURCE0_ALPHA                                      GL_SRC0_ALPHA;
alias GL_SOURCE1_ALPHA                                      GL_SRC1_ALPHA;
alias GL_SOURCE2_ALPHA                                      GL_SRC2_ALPHA;
typedef void		function(GLsizei n, GLuint *ids) PFNGLGENQUERIESPROC;
typedef void		function(GLsizei n, GLuint *ids) PFNGLDELETEQUERIESPROC;
typedef GLboolean	function(GLuint id) PFNGLISQUERYPROC;
typedef void		function(GLenum target, GLuint id) PFNGLBEGINQUERYPROC;
typedef void		function(GLenum target) PFNGLENDQUERYPROC;
typedef void		function(GLenum target, GLenum pname, GLint *params) PFNGLGETQUERYIVPROC;
typedef void		function(GLuint id, GLenum pname, GLint *params) PFNGLGETQUERYOBJECTIVPROC;
typedef void		function(GLuint id, GLenum pname, GLuint *params) PFNGLGETQUERYOBJECTUIVPROC;
typedef void		function(GLenum target, GLuint buffer) PFNGLBINDBUFFERPROC;
typedef void		function(GLsizei n, GLuint *buffers) PFNGLDELETEBUFFERSPROC;
typedef void		function(GLsizei n, GLuint *buffers) PFNGLGENBUFFERSPROC;
typedef GLboolean	function(GLuint buffer) PFNGLISBUFFERPROC;
typedef void		function(GLenum target, GLsizeiptr size, GLvoid *data, GLenum usage) PFNGLBUFFERDATAPROC;
typedef void		function(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data) PFNGLBUFFERSUBDATAPROC;
typedef void		function(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data) PFNGLGETBUFFERSUBDATAPROC;
typedef GLvoid*		function(GLenum target, GLenum access) PFNGLMAPBUFFERPROC;
typedef GLboolean	function(GLenum target) PFNGLUNMAPBUFFERPROC;
typedef void		function(GLenum target, GLenum pname, GLint *params) PFNGLGETBUFFERPARAMETERIVPROC;
typedef void		function(GLenum target, GLenum pname, GLvoid* *params) PFNGLGETBUFFERPOINTERVPROC;
 extern   PFNGLGENQUERIESPROC pglGenQueries;
 extern   PFNGLDELETEQUERIESPROC pglDeleteQueries;
 extern   PFNGLISQUERYPROC pglIsQuery;
 extern   PFNGLBEGINQUERYPROC pglBeginQuery;
 extern   PFNGLENDQUERYPROC pglEndQuery;
 extern   PFNGLGETQUERYIVPROC pglGetQueryiv;
 extern   PFNGLGETQUERYOBJECTIVPROC pglGetQueryObjectiv;
 extern   PFNGLGETQUERYOBJECTUIVPROC pglGetQueryObjectuiv;
 extern   PFNGLBINDBUFFERPROC pglBindBuffer;
 extern   PFNGLDELETEBUFFERSPROC pglDeleteBuffers;
 extern   PFNGLGENBUFFERSPROC pglGenBuffers;
 extern   PFNGLISBUFFERPROC pglIsBuffer;
 extern   PFNGLBUFFERDATAPROC pglBufferData;
 extern   PFNGLBUFFERSUBDATAPROC pglBufferSubData;
 extern   PFNGLGETBUFFERSUBDATAPROC pglGetBufferSubData;
 extern   PFNGLMAPBUFFERPROC pglMapBuffer;
 extern   PFNGLUNMAPBUFFERPROC pglUnmapBuffer;
 extern   PFNGLGETBUFFERPARAMETERIVPROC pglGetBufferParameteriv;
 extern   PFNGLGETBUFFERPOINTERVPROC pglGetBufferPointerv;

alias pglGenQueries glGenQueries;
alias pglDeleteQueries glDeleteQueries;
alias pglIsQuery glIsQuery;
alias pglBeginQuery glBeginQuery;
alias pglEndQuery glEndQuery;
alias pglGetQueryiv glGetQueryiv;
alias pglGetQueryObjectiv glGetQueryObjectiv;
alias pglGetQueryObjectuiv glGetQueryObjectuiv;
alias pglBindBuffer glBindBuffer;
alias pglDeleteBuffers glDeleteBuffers;
alias pglGenBuffers glGenBuffers;
alias pglIsBuffer glIsBuffer;
alias pglBufferData glBufferData;
alias pglBufferSubData glBufferSubData;
alias pglGetBufferSubData glGetBufferSubData;
alias pglMapBuffer glMapBuffer;
alias pglUnmapBuffer glUnmapBuffer;
alias pglGetBufferParameteriv glGetBufferParameteriv;
alias pglGetBufferPointerv glGetBufferPointerv;
//#endif ;

//GL_ARB_multitexture

//#ifndef GL_ARB_multitexture;
const uint GL_ARB_multitexture = 1;
const uint  __GLEE_GL_ARB_multitexture = 1;
//constants
const uint GL_TEXTURE0_ARB                                    = 0x84C0;
const uint GL_TEXTURE1_ARB                                    = 0x84C1;
const uint GL_TEXTURE2_ARB                                    = 0x84C2;
const uint GL_TEXTURE3_ARB                                    = 0x84C3;
const uint GL_TEXTURE4_ARB                                    = 0x84C4;
const uint GL_TEXTURE5_ARB                                    = 0x84C5;
const uint GL_TEXTURE6_ARB                                    = 0x84C6;
const uint GL_TEXTURE7_ARB                                    = 0x84C7;
const uint GL_TEXTURE8_ARB                                    = 0x84C8;
const uint GL_TEXTURE9_ARB                                    = 0x84C9;
const uint GL_TEXTURE10_ARB                                   = 0x84CA;
const uint GL_TEXTURE11_ARB                                   = 0x84CB;
const uint GL_TEXTURE12_ARB                                   = 0x84CC;
const uint GL_TEXTURE13_ARB                                   = 0x84CD;
const uint GL_TEXTURE14_ARB                                   = 0x84CE;
const uint GL_TEXTURE15_ARB                                   = 0x84CF;
const uint GL_TEXTURE16_ARB                                   = 0x84D0;
const uint GL_TEXTURE17_ARB                                   = 0x84D1;
const uint GL_TEXTURE18_ARB                                   = 0x84D2;
const uint GL_TEXTURE19_ARB                                   = 0x84D3;
const uint GL_TEXTURE20_ARB                                   = 0x84D4;
const uint GL_TEXTURE21_ARB                                   = 0x84D5;
const uint GL_TEXTURE22_ARB                                   = 0x84D6;
const uint GL_TEXTURE23_ARB                                   = 0x84D7;
const uint GL_TEXTURE24_ARB                                   = 0x84D8;
const uint GL_TEXTURE25_ARB                                   = 0x84D9;
const uint GL_TEXTURE26_ARB                                   = 0x84DA;
const uint GL_TEXTURE27_ARB                                   = 0x84DB;
const uint GL_TEXTURE28_ARB                                   = 0x84DC;
const uint GL_TEXTURE29_ARB                                   = 0x84DD;
const uint GL_TEXTURE30_ARB                                   = 0x84DE;
const uint GL_TEXTURE31_ARB                                   = 0x84DF;
const uint GL_ACTIVE_TEXTURE_ARB                              = 0x84E0;
const uint GL_CLIENT_ACTIVE_TEXTURE_ARB                       = 0x84E1;
const uint GL_MAX_TEXTURE_UNITS_ARB                           = 0x84E2;
typedef void   function(GLenum texture) PFNGLACTIVETEXTUREARBPROC;
typedef void   function(GLenum texture) PFNGLCLIENTACTIVETEXTUREARBPROC;
typedef void   function(GLenum target, GLdouble s) PFNGLMULTITEXCOORD1DARBPROC;
typedef void   function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD1DVARBPROC;
typedef void   function(GLenum target, GLfloat s) PFNGLMULTITEXCOORD1FARBPROC;
typedef void   function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD1FVARBPROC;
typedef void   function(GLenum target, GLint s) PFNGLMULTITEXCOORD1IARBPROC;
typedef void   function(GLenum target, GLint *v) PFNGLMULTITEXCOORD1IVARBPROC;
typedef void   function(GLenum target, GLshort s) PFNGLMULTITEXCOORD1SARBPROC;
typedef void   function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD1SVARBPROC;
typedef void   function(GLenum target, GLdouble s, GLdouble t) PFNGLMULTITEXCOORD2DARBPROC;
typedef void   function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD2DVARBPROC;
typedef void   function(GLenum target, GLfloat s, GLfloat t) PFNGLMULTITEXCOORD2FARBPROC;
typedef void   function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD2FVARBPROC;
typedef void   function(GLenum target, GLint s, GLint t) PFNGLMULTITEXCOORD2IARBPROC;
typedef void   function(GLenum target, GLint *v) PFNGLMULTITEXCOORD2IVARBPROC;
typedef void   function(GLenum target, GLshort s, GLshort t) PFNGLMULTITEXCOORD2SARBPROC;
typedef void   function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD2SVARBPROC;
typedef void   function(GLenum target, GLdouble s, GLdouble t, GLdouble r) PFNGLMULTITEXCOORD3DARBPROC;
typedef void   function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD3DVARBPROC;
typedef void   function(GLenum target, GLfloat s, GLfloat t, GLfloat r) PFNGLMULTITEXCOORD3FARBPROC;
typedef void   function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD3FVARBPROC;
typedef void   function(GLenum target, GLint s, GLint t, GLint r) PFNGLMULTITEXCOORD3IARBPROC;
typedef void   function(GLenum target, GLint *v) PFNGLMULTITEXCOORD3IVARBPROC;
typedef void   function(GLenum target, GLshort s, GLshort t, GLshort r) PFNGLMULTITEXCOORD3SARBPROC;
typedef void   function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD3SVARBPROC;
typedef void   function(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) PFNGLMULTITEXCOORD4DARBPROC;
typedef void   function(GLenum target, GLdouble *v) PFNGLMULTITEXCOORD4DVARBPROC;
typedef void   function(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) PFNGLMULTITEXCOORD4FARBPROC;
typedef void   function(GLenum target, GLfloat *v) PFNGLMULTITEXCOORD4FVARBPROC;
typedef void   function(GLenum target, GLint s, GLint t, GLint r, GLint q) PFNGLMULTITEXCOORD4IARBPROC;
typedef void   function(GLenum target, GLint *v) PFNGLMULTITEXCOORD4IVARBPROC;
typedef void   function(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) PFNGLMULTITEXCOORD4SARBPROC;
typedef void   function(GLenum target, GLshort *v) PFNGLMULTITEXCOORD4SVARBPROC;
 extern   PFNGLACTIVETEXTUREARBPROC pglActiveTextureARB;
 extern   PFNGLCLIENTACTIVETEXTUREARBPROC pglClientActiveTextureARB;
 extern   PFNGLMULTITEXCOORD1DARBPROC pglMultiTexCoord1dARB;
 extern   PFNGLMULTITEXCOORD1DVARBPROC pglMultiTexCoord1dvARB;
 extern   PFNGLMULTITEXCOORD1FARBPROC pglMultiTexCoord1fARB;
 extern   PFNGLMULTITEXCOORD1FVARBPROC pglMultiTexCoord1fvARB;
 extern   PFNGLMULTITEXCOORD1IARBPROC pglMultiTexCoord1iARB;
 extern   PFNGLMULTITEXCOORD1IVARBPROC pglMultiTexCoord1ivARB;
 extern   PFNGLMULTITEXCOORD1SARBPROC pglMultiTexCoord1sARB;
 extern   PFNGLMULTITEXCOORD1SVARBPROC pglMultiTexCoord1svARB;
 extern   PFNGLMULTITEXCOORD2DARBPROC pglMultiTexCoord2dARB;
 extern   PFNGLMULTITEXCOORD2DVARBPROC pglMultiTexCoord2dvARB;
 extern   PFNGLMULTITEXCOORD2FARBPROC pglMultiTexCoord2fARB;
 extern   PFNGLMULTITEXCOORD2FVARBPROC pglMultiTexCoord2fvARB;
 extern   PFNGLMULTITEXCOORD2IARBPROC pglMultiTexCoord2iARB;
 extern   PFNGLMULTITEXCOORD2IVARBPROC pglMultiTexCoord2ivARB;
 extern   PFNGLMULTITEXCOORD2SARBPROC pglMultiTexCoord2sARB;
 extern   PFNGLMULTITEXCOORD2SVARBPROC pglMultiTexCoord2svARB;
 extern   PFNGLMULTITEXCOORD3DARBPROC pglMultiTexCoord3dARB;
 extern   PFNGLMULTITEXCOORD3DVARBPROC pglMultiTexCoord3dvARB;
 extern   PFNGLMULTITEXCOORD3FARBPROC pglMultiTexCoord3fARB;
 extern   PFNGLMULTITEXCOORD3FVARBPROC pglMultiTexCoord3fvARB;
 extern   PFNGLMULTITEXCOORD3IARBPROC pglMultiTexCoord3iARB;
 extern   PFNGLMULTITEXCOORD3IVARBPROC pglMultiTexCoord3ivARB;
 extern   PFNGLMULTITEXCOORD3SARBPROC pglMultiTexCoord3sARB;
 extern   PFNGLMULTITEXCOORD3SVARBPROC pglMultiTexCoord3svARB;
 extern   PFNGLMULTITEXCOORD4DARBPROC pglMultiTexCoord4dARB;
 extern   PFNGLMULTITEXCOORD4DVARBPROC pglMultiTexCoord4dvARB;
 extern   PFNGLMULTITEXCOORD4FARBPROC pglMultiTexCoord4fARB;
 extern   PFNGLMULTITEXCOORD4FVARBPROC pglMultiTexCoord4fvARB;
 extern   PFNGLMULTITEXCOORD4IARBPROC pglMultiTexCoord4iARB;
 extern   PFNGLMULTITEXCOORD4IVARBPROC pglMultiTexCoord4ivARB;
 extern   PFNGLMULTITEXCOORD4SARBPROC pglMultiTexCoord4sARB;
 extern   PFNGLMULTITEXCOORD4SVARBPROC pglMultiTexCoord4svARB;
alias pglActiveTextureARB glActiveTextureARB;
alias pglClientActiveTextureARB glClientActiveTextureARB;
alias pglMultiTexCoord1dARB glMultiTexCoord1dARB;
alias pglMultiTexCoord1dvARB glMultiTexCoord1dvARB;
alias pglMultiTexCoord1fARB glMultiTexCoord1fARB;
alias pglMultiTexCoord1fvARB glMultiTexCoord1fvARB;
alias pglMultiTexCoord1iARB glMultiTexCoord1iARB;
alias pglMultiTexCoord1ivARB glMultiTexCoord1ivARB;
alias pglMultiTexCoord1sARB glMultiTexCoord1sARB;
alias pglMultiTexCoord1svARB glMultiTexCoord1svARB;
alias pglMultiTexCoord2dARB glMultiTexCoord2dARB;
alias pglMultiTexCoord2dvARB glMultiTexCoord2dvARB;
alias pglMultiTexCoord2fARB glMultiTexCoord2fARB;
alias pglMultiTexCoord2fvARB glMultiTexCoord2fvARB;
alias pglMultiTexCoord2iARB glMultiTexCoord2iARB;
alias pglMultiTexCoord2ivARB glMultiTexCoord2ivARB;
alias pglMultiTexCoord2sARB glMultiTexCoord2sARB;
alias pglMultiTexCoord2svARB glMultiTexCoord2svARB;
alias pglMultiTexCoord3dARB glMultiTexCoord3dARB;
alias pglMultiTexCoord3dvARB glMultiTexCoord3dvARB;
alias pglMultiTexCoord3fARB glMultiTexCoord3fARB;
alias pglMultiTexCoord3fvARB glMultiTexCoord3fvARB;
alias pglMultiTexCoord3iARB glMultiTexCoord3iARB;
alias pglMultiTexCoord3ivARB glMultiTexCoord3ivARB;
alias pglMultiTexCoord3sARB glMultiTexCoord3sARB;
alias pglMultiTexCoord3svARB glMultiTexCoord3svARB;
alias pglMultiTexCoord4dARB glMultiTexCoord4dARB;
alias pglMultiTexCoord4dvARB glMultiTexCoord4dvARB;
alias pglMultiTexCoord4fARB glMultiTexCoord4fARB;
alias pglMultiTexCoord4fvARB glMultiTexCoord4fvARB;
alias pglMultiTexCoord4iARB glMultiTexCoord4iARB;
alias pglMultiTexCoord4ivARB glMultiTexCoord4ivARB;
alias pglMultiTexCoord4sARB glMultiTexCoord4sARB;
alias pglMultiTexCoord4svARB glMultiTexCoord4svARB;
//#endif ;

//GL_ARB_transpose_matrix

//#ifndef GL_ARB_transpose_matrix;
const uint GL_ARB_transpose_matrix = 1;
const uint __GLEE_GL_ARB_transpose_matrix = 1;
//constants
const uint GL_TRANSPOSE_MODELVIEW_MATRIX_ARB                  = 0x84E3;
const uint GL_TRANSPOSE_PROJECTION_MATRIX_ARB                 = 0x84E4;
const uint GL_TRANSPOSE_TEXTURE_MATRIX_ARB                    = 0x84E5;
const uint GL_TRANSPOSE_COLOR_MATRIX_ARB                      = 0x84E6;
typedef void   function(GLfloat *m) PFNGLLOADTRANSPOSEMATRIXFARBPROC;
typedef void   function(GLdouble *m) PFNGLLOADTRANSPOSEMATRIXDARBPROC;
typedef void   function(GLfloat *m) PFNGLMULTTRANSPOSEMATRIXFARBPROC;
typedef void   function(GLdouble *m) PFNGLMULTTRANSPOSEMATRIXDARBPROC;
 extern   PFNGLLOADTRANSPOSEMATRIXFARBPROC pglLoadTransposeMatrixfARB;
 extern   PFNGLLOADTRANSPOSEMATRIXDARBPROC pglLoadTransposeMatrixdARB;
 extern   PFNGLMULTTRANSPOSEMATRIXFARBPROC pglMultTransposeMatrixfARB;
 extern   PFNGLMULTTRANSPOSEMATRIXDARBPROC pglMultTransposeMatrixdARB;
alias pglLoadTransposeMatrixfARB glLoadTransposeMatrixfARB;
alias pglLoadTransposeMatrixdARB glLoadTransposeMatrixdARB;
alias pglMultTransposeMatrixfARB glMultTransposeMatrixfARB;
alias pglMultTransposeMatrixdARB glMultTransposeMatrixdARB;
//#endif ;

//GL_ARB_multisample

//#ifndef GL_ARB_multisample;
const uint GL_ARB_multisample = 1;
const uint __GLEE_GL_ARB_multisample = 1;
//constants
const uint GL_MULTISAMPLE_ARB                                 = 0x809D;
const uint GL_SAMPLE_ALPHA_TO_COVERAGE_ARB                    = 0x809E;
const uint GL_SAMPLE_ALPHA_TO_ONE_ARB                         = 0x809F;
const uint GL_SAMPLE_COVERAGE_ARB                             = 0x80A0;
const uint GL_SAMPLE_BUFFERS_ARB                              = 0x80A8;
const uint GL_SAMPLES_ARB                                     = 0x80A9;
const uint GL_SAMPLE_COVERAGE_VALUE_ARB                       = 0x80AA;
const uint GL_SAMPLE_COVERAGE_INVERT_ARB                      = 0x80AB;
const uint GL_MULTISAMPLE_BIT_ARB                             = 0x20000000;
typedef void   function(GLclampf value, GLboolean invert) PFNGLSAMPLECOVERAGEARBPROC;
extern   PFNGLSAMPLECOVERAGEARBPROC pglSampleCoverageARB;
alias pglSampleCoverageARB glSampleCoverageARB;
//#endif ;

//GL_ARB_texture_env_add

//#ifndef GL_ARB_texture_env_add;
const uint GL_ARB_texture_env_add = 1;
const uint __GLEE_GL_ARB_texture_env_add = 1;
//constants
//#endif ;

//GL_ARB_texture_cube_map

//#ifndef GL_ARB_texture_cube_map;
const uint GL_ARB_texture_cube_map = 1;
const uint __GLEE_GL_ARB_texture_cube_map = 1;
//constants
const uint GL_NORMAL_MAP_ARB                                  = 0x8511;
const uint GL_REFLECTION_MAP_ARB                              = 0x8512;
const uint GL_TEXTURE_CUBE_MAP_ARB                            = 0x8513;
const uint GL_TEXTURE_BINDING_CUBE_MAP_ARB                    = 0x8514;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB                 = 0x8515;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB                 = 0x8516;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB                 = 0x8517;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB                 = 0x8518;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB                 = 0x8519;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB                 = 0x851A;
const uint GL_PROXY_TEXTURE_CUBE_MAP_ARB                      = 0x851B;
const uint GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB                   = 0x851C;
//#endif ;

//GL_ARB_texture_compression

//#ifndef GL_ARB_texture_compression;
const uint GL_ARB_texture_compression = 1;
const uint __GLEE_GL_ARB_texture_compression = 1;
//constants
const uint GL_COMPRESSED_ALPHA_ARB                            = 0x84E9;
const uint GL_COMPRESSED_LUMINANCE_ARB                        = 0x84EA;
const uint GL_COMPRESSED_LUMINANCE_ALPHA_ARB                  = 0x84EB;
const uint GL_COMPRESSED_INTENSITY_ARB                        = 0x84EC;
const uint GL_COMPRESSED_RGB_ARB                              = 0x84ED;
const uint GL_COMPRESSED_RGBA_ARB                             = 0x84EE;
const uint GL_TEXTURE_COMPRESSION_HINT_ARB                    = 0x84EF;
const uint GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB               = 0x86A0;
const uint GL_TEXTURE_COMPRESSED_ARB                          = 0x86A1;
const uint GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB              = 0x86A2;
const uint GL_COMPRESSED_TEXTURE_FORMATS_ARB                  = 0x86A3;
typedef void   function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXIMAGE3DARBPROC;
typedef void   function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXIMAGE2DARBPROC;
typedef void   function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXIMAGE1DARBPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, GLvoid *data) PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC;
typedef void   function(GLenum target, GLint level, GLvoid *img) PFNGLGETCOMPRESSEDTEXIMAGEARBPROC;
 extern   PFNGLCOMPRESSEDTEXIMAGE3DARBPROC pglCompressedTexImage3DARB;
 extern   PFNGLCOMPRESSEDTEXIMAGE2DARBPROC pglCompressedTexImage2DARB;
 extern   PFNGLCOMPRESSEDTEXIMAGE1DARBPROC pglCompressedTexImage1DARB;
 extern   PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC pglCompressedTexSubImage3DARB;
 extern   PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC pglCompressedTexSubImage2DARB;
 extern   PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC pglCompressedTexSubImage1DARB;
 extern   PFNGLGETCOMPRESSEDTEXIMAGEARBPROC pglGetCompressedTexImageARB;
alias pglCompressedTexImage3DARB glCompressedTexImage3DARB;
alias pglCompressedTexImage2DARB glCompressedTexImage2DARB;
alias pglCompressedTexImage1DARB glCompressedTexImage1DARB;
alias pglCompressedTexSubImage3DARB glCompressedTexSubImage3DARB;
alias pglCompressedTexSubImage2DARB glCompressedTexSubImage2DARB;
alias pglCompressedTexSubImage1DARB glCompressedTexSubImage1DARB;
alias pglGetCompressedTexImageARB glGetCompressedTexImageARB;
//#endif ;

//GL_ARB_texture_border_clamp

//#ifndef GL_ARB_texture_border_clamp;
const uint GL_ARB_texture_border_clamp = 1;
const uint __GLEE_GL_ARB_texture_border_clamp = 1;
//constants
const uint GL_CLAMP_TO_BORDER_ARB                             = 0x812D;
//#endif ;

//GL_ARB_point_parameters

//#ifndef GL_ARB_point_parameters;
const uint GL_ARB_point_parameters = 1;
const uint __GLEE_GL_ARB_point_parameters = 1;
//constants
const uint GL_POINT_SIZE_MIN_ARB                              = 0x8126;
const uint GL_POINT_SIZE_MAX_ARB                              = 0x8127;
const uint GL_POINT_FADE_THRESHOLD_SIZE_ARB                   = 0x8128;
const uint GL_POINT_DISTANCE_ATTENUATION_ARB                  = 0x8129;
typedef void   function(GLenum pname, GLfloat param) PFNGLPOINTPARAMETERFARBPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLPOINTPARAMETERFVARBPROC;
 extern   PFNGLPOINTPARAMETERFARBPROC pglPointParameterfARB;
 extern   PFNGLPOINTPARAMETERFVARBPROC pglPointParameterfvARB;
alias pglPointParameterfARB glPointParameterfARB;
alias pglPointParameterfvARB glPointParameterfvARB;
//#endif ;

//GL_ARB_vertex_blend

//#ifndef GL_ARB_vertex_blend;
const uint GL_ARB_vertex_blend = 1;
const uint __GLEE_GL_ARB_vertex_blend = 1;
//constants
const uint GL_MAX_VERTEX_UNITS_ARB                            = 0x86A4;
const uint GL_ACTIVE_VERTEX_UNITS_ARB                         = 0x86A5;
const uint GL_WEIGHT_SUM_UNITY_ARB                            = 0x86A6;
const uint GL_VERTEX_BLEND_ARB                                = 0x86A7;
const uint GL_CURRENT_WEIGHT_ARB                              = 0x86A8;
const uint GL_WEIGHT_ARRAY_TYPE_ARB                           = 0x86A9;
const uint GL_WEIGHT_ARRAY_STRIDE_ARB                         = 0x86AA;
const uint GL_WEIGHT_ARRAY_SIZE_ARB                           = 0x86AB;
const uint GL_WEIGHT_ARRAY_POINTER_ARB                        = 0x86AC;
const uint GL_WEIGHT_ARRAY_ARB                                = 0x86AD;
const uint GL_MODELVIEW0_ARB                                  = 0x1700;
const uint GL_MODELVIEW1_ARB                                  = 0x850A;
const uint GL_MODELVIEW2_ARB                                  = 0x8722;
const uint GL_MODELVIEW3_ARB                                  = 0x8723;
const uint GL_MODELVIEW4_ARB                                  = 0x8724;
const uint GL_MODELVIEW5_ARB                                  = 0x8725;
const uint GL_MODELVIEW6_ARB                                  = 0x8726;
const uint GL_MODELVIEW7_ARB                                  = 0x8727;
const uint GL_MODELVIEW8_ARB                                  = 0x8728;
const uint GL_MODELVIEW9_ARB                                  = 0x8729;
const uint GL_MODELVIEW10_ARB                                 = 0x872A;
const uint GL_MODELVIEW11_ARB                                 = 0x872B;
const uint GL_MODELVIEW12_ARB                                 = 0x872C;
const uint GL_MODELVIEW13_ARB                                 = 0x872D;
const uint GL_MODELVIEW14_ARB                                 = 0x872E;
const uint GL_MODELVIEW15_ARB                                 = 0x872F;
const uint GL_MODELVIEW16_ARB                                 = 0x8730;
const uint GL_MODELVIEW17_ARB                                 = 0x8731;
const uint GL_MODELVIEW18_ARB                                 = 0x8732;
const uint GL_MODELVIEW19_ARB                                 = 0x8733;
const uint GL_MODELVIEW20_ARB                                 = 0x8734;
const uint GL_MODELVIEW21_ARB                                 = 0x8735;
const uint GL_MODELVIEW22_ARB                                 = 0x8736;
const uint GL_MODELVIEW23_ARB                                 = 0x8737;
const uint GL_MODELVIEW24_ARB                                 = 0x8738;
const uint GL_MODELVIEW25_ARB                                 = 0x8739;
const uint GL_MODELVIEW26_ARB                                 = 0x873A;
const uint GL_MODELVIEW27_ARB                                 = 0x873B;
const uint GL_MODELVIEW28_ARB                                 = 0x873C;
const uint GL_MODELVIEW29_ARB                                 = 0x873D;
const uint GL_MODELVIEW30_ARB                                 = 0x873E;
const uint GL_MODELVIEW31_ARB                                 = 0x873F;
typedef void   function(GLint size, GLbyte *weights) PFNGLWEIGHTBVARBPROC;
typedef void   function(GLint size, GLshort *weights) PFNGLWEIGHTSVARBPROC;
typedef void   function(GLint size, GLint *weights) PFNGLWEIGHTIVARBPROC;
typedef void   function(GLint size, GLfloat *weights) PFNGLWEIGHTFVARBPROC;
typedef void   function(GLint size, GLdouble *weights) PFNGLWEIGHTDVARBPROC;
typedef void   function(GLint size, GLubyte *weights) PFNGLWEIGHTUBVARBPROC;
typedef void   function(GLint size, GLushort *weights) PFNGLWEIGHTUSVARBPROC;
typedef void   function(GLint size, GLuint *weights) PFNGLWEIGHTUIVARBPROC;
typedef void   function(GLint size, GLenum type, GLsizei stride, GLvoid *pointer) PFNGLWEIGHTPOINTERARBPROC;
typedef void   function(GLint count) PFNGLVERTEXBLENDARBPROC;
 extern   PFNGLWEIGHTBVARBPROC pglWeightbvARB;
 extern   PFNGLWEIGHTSVARBPROC pglWeightsvARB;
 extern   PFNGLWEIGHTIVARBPROC pglWeightivARB;
 extern   PFNGLWEIGHTFVARBPROC pglWeightfvARB;
 extern   PFNGLWEIGHTDVARBPROC pglWeightdvARB;
 extern   PFNGLWEIGHTUBVARBPROC pglWeightubvARB;
 extern   PFNGLWEIGHTUSVARBPROC pglWeightusvARB;
 extern   PFNGLWEIGHTUIVARBPROC pglWeightuivARB;
 extern   PFNGLWEIGHTPOINTERARBPROC pglWeightPointerARB;
 extern   PFNGLVERTEXBLENDARBPROC pglVertexBlendARB;
alias pglWeightbvARB glWeightbvARB;
alias pglWeightsvARB glWeightsvARB;
alias pglWeightivARB glWeightivARB;
alias pglWeightfvARB glWeightfvARB;
alias pglWeightdvARB glWeightdvARB;
alias pglWeightubvARB glWeightubvARB;
alias pglWeightusvARB glWeightusvARB;
alias pglWeightuivARB glWeightuivARB;
alias pglWeightPointerARB glWeightPointerARB;
alias pglVertexBlendARB glVertexBlendARB;
//#endif ;

//GL_ARB_matrix_palette

//#ifndef GL_ARB_matrix_palette;
const uint  GL_ARB_matrix_palette = 1;
const uint  __GLEE_GL_ARB_matrix_palette = 1;
//constants
const uint  GL_MATRIX_PALETTE_ARB                              = 0x8840;
const uint  GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB              = 0x8841;
const uint  GL_MAX_PALETTE_MATRICES_ARB                        = 0x8842;
const uint  GL_CURRENT_PALETTE_MATRIX_ARB                      = 0x8843;
const uint  GL_MATRIX_INDEX_ARRAY_ARB                          = 0x8844;
const uint  GL_CURRENT_MATRIX_INDEX_ARB                        = 0x8845;
const uint  GL_MATRIX_INDEX_ARRAY_SIZE_ARB                     = 0x8846;
const uint  GL_MATRIX_INDEX_ARRAY_TYPE_ARB                     = 0x8847;
const uint  GL_MATRIX_INDEX_ARRAY_STRIDE_ARB                   = 0x8848;
const uint  GL_MATRIX_INDEX_ARRAY_POINTER_ARB                  = 0x8849;
typedef void   function(GLint index) PFNGLCURRENTPALETTEMATRIXARBPROC;
typedef void   function(GLint size, GLubyte *indices) PFNGLMATRIXINDEXUBVARBPROC;
typedef void   function(GLint size, GLushort *indices) PFNGLMATRIXINDEXUSVARBPROC;
typedef void   function(GLint size, GLuint *indices) PFNGLMATRIXINDEXUIVARBPROC;
typedef void   function(GLint size, GLenum type, GLsizei stride, GLvoid *pointer) PFNGLMATRIXINDEXPOINTERARBPROC;
 extern   PFNGLCURRENTPALETTEMATRIXARBPROC pglCurrentPaletteMatrixARB;
 extern   PFNGLMATRIXINDEXUBVARBPROC pglMatrixIndexubvARB;
 extern   PFNGLMATRIXINDEXUSVARBPROC pglMatrixIndexusvARB;
 extern   PFNGLMATRIXINDEXUIVARBPROC pglMatrixIndexuivARB;
 extern   PFNGLMATRIXINDEXPOINTERARBPROC pglMatrixIndexPointerARB;
alias pglCurrentPaletteMatrixARB glCurrentPaletteMatrixARB;
alias pglMatrixIndexubvARB glMatrixIndexubvARB;
alias pglMatrixIndexusvARB glMatrixIndexusvARB;
alias pglMatrixIndexuivARB glMatrixIndexuivARB;
alias pglMatrixIndexPointerARB glMatrixIndexPointerARB;
//#endif ;

//GL_ARB_texture_env_combine

//#ifndef GL_ARB_texture_env_combine;
const uint  GL_ARB_texture_env_combine = 1;
const uint  __GLEE_GL_ARB_texture_env_combine = 1;
//constants
const uint  GL_COMBINE_ARB                                     = 0x8570;
const uint  GL_COMBINE_RGB_ARB                                 = 0x8571;
const uint  GL_COMBINE_ALPHA_ARB                               = 0x8572;
const uint  GL_SOURCE0_RGB_ARB                                 = 0x8580;
const uint  GL_SOURCE1_RGB_ARB                                 = 0x8581;
const uint  GL_SOURCE2_RGB_ARB                                 = 0x8582;
const uint  GL_SOURCE0_ALPHA_ARB                               = 0x8588;
const uint  GL_SOURCE1_ALPHA_ARB                               = 0x8589;
const uint  GL_SOURCE2_ALPHA_ARB                               = 0x858A;
const uint  GL_OPERAND0_RGB_ARB                                = 0x8590;
const uint  GL_OPERAND1_RGB_ARB                                = 0x8591;
const uint  GL_OPERAND2_RGB_ARB                                = 0x8592;
const uint  GL_OPERAND0_ALPHA_ARB                              = 0x8598;
const uint  GL_OPERAND1_ALPHA_ARB                              = 0x8599;
const uint  GL_OPERAND2_ALPHA_ARB                              = 0x859A;
const uint  GL_RGB_SCALE_ARB                                   = 0x8573;
const uint  GL_ADD_SIGNED_ARB                                  = 0x8574;
const uint  GL_INTERPOLATE_ARB                                 = 0x8575;
const uint  GL_SUBTRACT_ARB                                    = 0x84E7;
const uint  GL_CONSTANT_ARB                                    = 0x8576;
const uint  GL_PRIMARY_COLOR_ARB                               = 0x8577;
const uint  GL_PREVIOUS_ARB                                    = 0x8578;
//#endif ;

//GL_ARB_texture_env_crossbar

//#ifndef GL_ARB_texture_env_crossbar;
const uint  GL_ARB_texture_env_crossbar = 1;
const uint  __GLEE_GL_ARB_texture_env_crossbar = 1;
//constants
//#endif ;

//GL_ARB_texture_env_dot3

//#ifndef GL_ARB_texture_env_dot3;
const uint  GL_ARB_texture_env_dot3 = 1;
const uint  __GLEE_GL_ARB_texture_env_dot3 = 1;
//constants
const uint  GL_DOT3_RGB_ARB                                    = 0x86AE;
const uint  GL_DOT3_RGBA_ARB                                   = 0x86AF;
//#endif ;

//GL_ARB_texture_mirrored_repeat

//#ifndef GL_ARB_texture_mirrored_repeat;
const uint  GL_ARB_texture_mirrored_repeat = 1;
const uint  __GLEE_GL_ARB_texture_mirrored_repeat = 1;
//constants
const uint  GL_MIRRORED_REPEAT_ARB                             = 0x8370;
//#endif ;

//GL_ARB_depth_texture

//#ifndef GL_ARB_depth_texture;
const uint  GL_ARB_depth_texture = 1;
const uint  __GLEE_GL_ARB_depth_texture = 1;
//constants
const uint  GL_DEPTH_COMPONENT16_ARB                           = 0x81A5;
const uint  GL_DEPTH_COMPONENT24_ARB                           = 0x81A6;
const uint  GL_DEPTH_COMPONENT32_ARB                           = 0x81A7;
const uint  GL_TEXTURE_DEPTH_SIZE_ARB                          = 0x884A;
const uint  GL_DEPTH_TEXTURE_MODE_ARB                          = 0x884B;
//#endif ;

//GL_ARB_shadow

//#ifndef GL_ARB_shadow;
const uint  GL_ARB_shadow = 1;
const uint  __GLEE_GL_ARB_shadow = 1;
//constants
const uint  GL_TEXTURE_COMPARE_MODE_ARB                        = 0x884C;
const uint  GL_TEXTURE_COMPARE_FUNC_ARB                        = 0x884D;
const uint  GL_COMPARE_R_TO_TEXTURE_ARB                        = 0x884E;
//#endif ;

//GL_ARB_shadow_ambient

//#ifndef GL_ARB_shadow_ambient;
const uint  GL_ARB_shadow_ambient = 1;
const uint  __GLEE_GL_ARB_shadow_ambient = 1;
//constants
const uint  GL_TEXTURE_COMPARE_FAIL_VALUE_ARB                  = 0x80BF;
//#endif ;

//GL_ARB_window_pos

//#ifndef GL_ARB_window_pos;
const uint GL_ARB_window_pos = 1;
const uint __GLEE_GL_ARB_window_pos = 1;
//constants
typedef void   function(GLdouble x, GLdouble y) PFNGLWINDOWPOS2DARBPROC;
typedef void   function(GLdouble *v) PFNGLWINDOWPOS2DVARBPROC;
typedef void   function(GLfloat x, GLfloat y) PFNGLWINDOWPOS2FARBPROC;
typedef void   function(GLfloat *v) PFNGLWINDOWPOS2FVARBPROC;
typedef void   function(GLint x, GLint y) PFNGLWINDOWPOS2IARBPROC;
typedef void   function(GLint *v) PFNGLWINDOWPOS2IVARBPROC;
typedef void   function(GLshort x, GLshort y) PFNGLWINDOWPOS2SARBPROC;
typedef void   function(GLshort *v) PFNGLWINDOWPOS2SVARBPROC;
typedef void   function(GLdouble x, GLdouble y, GLdouble z) PFNGLWINDOWPOS3DARBPROC;
typedef void   function(GLdouble *v) PFNGLWINDOWPOS3DVARBPROC;
typedef void   function(GLfloat x, GLfloat y, GLfloat z) PFNGLWINDOWPOS3FARBPROC;
typedef void   function(GLfloat *v) PFNGLWINDOWPOS3FVARBPROC;
typedef void   function(GLint x, GLint y, GLint z) PFNGLWINDOWPOS3IARBPROC;
typedef void   function(GLint *v) PFNGLWINDOWPOS3IVARBPROC;
typedef void   function(GLshort x, GLshort y, GLshort z) PFNGLWINDOWPOS3SARBPROC;
typedef void   function(GLshort *v) PFNGLWINDOWPOS3SVARBPROC;
 extern   PFNGLWINDOWPOS2DARBPROC pglWindowPos2dARB;
 extern   PFNGLWINDOWPOS2DVARBPROC pglWindowPos2dvARB;
 extern   PFNGLWINDOWPOS2FARBPROC pglWindowPos2fARB;
 extern   PFNGLWINDOWPOS2FVARBPROC pglWindowPos2fvARB;
 extern   PFNGLWINDOWPOS2IARBPROC pglWindowPos2iARB;
 extern   PFNGLWINDOWPOS2IVARBPROC pglWindowPos2ivARB;
 extern   PFNGLWINDOWPOS2SARBPROC pglWindowPos2sARB;
 extern   PFNGLWINDOWPOS2SVARBPROC pglWindowPos2svARB;
 extern   PFNGLWINDOWPOS3DARBPROC pglWindowPos3dARB;
 extern   PFNGLWINDOWPOS3DVARBPROC pglWindowPos3dvARB;
 extern   PFNGLWINDOWPOS3FARBPROC pglWindowPos3fARB;
 extern   PFNGLWINDOWPOS3FVARBPROC pglWindowPos3fvARB;
 extern   PFNGLWINDOWPOS3IARBPROC pglWindowPos3iARB;
 extern   PFNGLWINDOWPOS3IVARBPROC pglWindowPos3ivARB;
 extern   PFNGLWINDOWPOS3SARBPROC pglWindowPos3sARB;
 extern   PFNGLWINDOWPOS3SVARBPROC pglWindowPos3svARB;
alias pglWindowPos2dARB glWindowPos2dARB;
alias pglWindowPos2dvARB glWindowPos2dvARB;
alias pglWindowPos2fARB glWindowPos2fARB;
alias pglWindowPos2fvARB glWindowPos2fvARB;
alias pglWindowPos2iARB glWindowPos2iARB;
alias pglWindowPos2ivARB glWindowPos2ivARB;
alias pglWindowPos2sARB glWindowPos2sARB;
alias pglWindowPos2svARB glWindowPos2svARB;
alias pglWindowPos3dARB glWindowPos3dARB;
alias pglWindowPos3dvARB glWindowPos3dvARB;
alias pglWindowPos3fARB glWindowPos3fARB;
alias pglWindowPos3fvARB glWindowPos3fvARB;
alias pglWindowPos3iARB glWindowPos3iARB;
alias pglWindowPos3ivARB glWindowPos3ivARB;
alias pglWindowPos3sARB glWindowPos3sARB;
alias pglWindowPos3svARB glWindowPos3svARB;
//#endif ;

//GL_ARB_vertex_program

//#ifndef GL_ARB_vertex_program;
const uint  GL_ARB_vertex_program = 1;
const uint  __GLEE_GL_ARB_vertex_program = 1;
//constants
const uint  GL_COLOR_SUM_ARB                                   = 0x8458;
const uint  GL_VERTEX_PROGRAM_ARB                              = 0x8620;
const uint  GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                 = 0x8622;
const uint  GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                    = 0x8623;
const uint  GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                  = 0x8624;
const uint  GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                    = 0x8625;
const uint  GL_CURRENT_VERTEX_ATTRIB_ARB                       = 0x8626;
const uint  GL_PROGRAM_LENGTH_ARB                              = 0x8627;
const uint  GL_PROGRAM_STRING_ARB                              = 0x8628;
const uint  GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB              = 0x862E;
const uint  GL_MAX_PROGRAM_MATRICES_ARB                        = 0x862F;
const uint  GL_CURRENT_MATRIX_STACK_DEPTH_ARB                  = 0x8640;
const uint  GL_CURRENT_MATRIX_ARB                              = 0x8641;
const uint  GL_VERTEX_PROGRAM_POINT_SIZE_ARB                   = 0x8642;
const uint  GL_VERTEX_PROGRAM_TWO_SIDE_ARB                     = 0x8643;
const uint  GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                 = 0x8645;
const uint  GL_PROGRAM_ERROR_POSITION_ARB                      = 0x864B;
const uint  GL_PROGRAM_BINDING_ARB                             = 0x8677;
const uint  GL_MAX_VERTEX_ATTRIBS_ARB                          = 0x8869;
const uint  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB              = 0x886A;
const uint  GL_PROGRAM_ERROR_STRING_ARB                        = 0x8874;
const uint  GL_PROGRAM_FORMAT_ASCII_ARB                        = 0x8875;
const uint  GL_PROGRAM_FORMAT_ARB                              = 0x8876;
const uint  GL_PROGRAM_INSTRUCTIONS_ARB                        = 0x88A0;
const uint  GL_MAX_PROGRAM_INSTRUCTIONS_ARB                    = 0x88A1;
const uint  GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                 = 0x88A2;
const uint  GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB             = 0x88A3;
const uint  GL_PROGRAM_TEMPORARIES_ARB                         = 0x88A4;
const uint  GL_MAX_PROGRAM_TEMPORARIES_ARB                     = 0x88A5;
const uint  GL_PROGRAM_NATIVE_TEMPORARIES_ARB                  = 0x88A6;
const uint  GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB              = 0x88A7;
const uint  GL_PROGRAM_PARAMETERS_ARB                          = 0x88A8;
const uint  GL_MAX_PROGRAM_PARAMETERS_ARB                      = 0x88A9;
const uint  GL_PROGRAM_NATIVE_PARAMETERS_ARB                   = 0x88AA;
const uint  GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB               = 0x88AB;
const uint  GL_PROGRAM_ATTRIBS_ARB                             = 0x88AC;
const uint  GL_MAX_PROGRAM_ATTRIBS_ARB                         = 0x88AD;
const uint  GL_PROGRAM_NATIVE_ATTRIBS_ARB                      = 0x88AE;
const uint  GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                  = 0x88AF;
const uint  GL_PROGRAM_ADDRESS_REGISTERS_ARB                   = 0x88B0;
const uint  GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB               = 0x88B1;
const uint  GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB            = 0x88B2;
const uint  GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB        = 0x88B3;
const uint  GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                = 0x88B4;
const uint  GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                  = 0x88B5;
const uint  GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                 = 0x88B6;
const uint  GL_TRANSPOSE_CURRENT_MATRIX_ARB                    = 0x88B7;
const uint  GL_MATRIX0_ARB                                     = 0x88C0;
const uint  GL_MATRIX1_ARB                                     = 0x88C1;
const uint  GL_MATRIX2_ARB                                     = 0x88C2;
const uint  GL_MATRIX3_ARB                                     = 0x88C3;
const uint  GL_MATRIX4_ARB                                     = 0x88C4;
const uint  GL_MATRIX5_ARB                                     = 0x88C5;
const uint  GL_MATRIX6_ARB                                     = 0x88C6;
const uint  GL_MATRIX7_ARB                                     = 0x88C7;
const uint  GL_MATRIX8_ARB                                     = 0x88C8;
const uint  GL_MATRIX9_ARB                                     = 0x88C9;
const uint  GL_MATRIX10_ARB                                    = 0x88CA;
const uint  GL_MATRIX11_ARB                                    = 0x88CB;
const uint  GL_MATRIX12_ARB                                    = 0x88CC;
const uint  GL_MATRIX13_ARB                                    = 0x88CD;
const uint  GL_MATRIX14_ARB                                    = 0x88CE;
const uint  GL_MATRIX15_ARB                                    = 0x88CF;
const uint  GL_MATRIX16_ARB                                    = 0x88D0;
const uint  GL_MATRIX17_ARB                                    = 0x88D1;
const uint  GL_MATRIX18_ARB                                    = 0x88D2;
const uint  GL_MATRIX19_ARB                                    = 0x88D3;
const uint  GL_MATRIX20_ARB                                    = 0x88D4;
const uint  GL_MATRIX21_ARB                                    = 0x88D5;
const uint  GL_MATRIX22_ARB                                    = 0x88D6;
const uint  GL_MATRIX23_ARB                                    = 0x88D7;
const uint  GL_MATRIX24_ARB                                    = 0x88D8;
const uint  GL_MATRIX25_ARB                                    = 0x88D9;
const uint  GL_MATRIX26_ARB                                    = 0x88DA;
const uint  GL_MATRIX27_ARB                                    = 0x88DB;
const uint  GL_MATRIX28_ARB                                    = 0x88DC;
const uint  GL_MATRIX29_ARB                                    = 0x88DD;
const uint  GL_MATRIX30_ARB                                    = 0x88DE;
const uint  GL_MATRIX31_ARB                                    = 0x88DF;
typedef void   function(GLuint index, GLdouble x) PFNGLVERTEXATTRIB1DARBPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB1DVARBPROC;
typedef void   function(GLuint index, GLfloat x) PFNGLVERTEXATTRIB1FARBPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB1FVARBPROC;
typedef void   function(GLuint index, GLshort x) PFNGLVERTEXATTRIB1SARBPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB1SVARBPROC;
typedef void   function(GLuint index, GLdouble x, GLdouble y) PFNGLVERTEXATTRIB2DARBPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB2DVARBPROC;
typedef void   function(GLuint index, GLfloat x, GLfloat y) PFNGLVERTEXATTRIB2FARBPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB2FVARBPROC;
typedef void   function(GLuint index, GLshort x, GLshort y) PFNGLVERTEXATTRIB2SARBPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB2SVARBPROC;
typedef void   function(GLuint index, GLdouble x, GLdouble y, GLdouble z) PFNGLVERTEXATTRIB3DARBPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB3DVARBPROC;
typedef void   function(GLuint index, GLfloat x, GLfloat y, GLfloat z) PFNGLVERTEXATTRIB3FARBPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB3FVARBPROC;
typedef void   function(GLuint index, GLshort x, GLshort y, GLshort z) PFNGLVERTEXATTRIB3SARBPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB3SVARBPROC;
typedef void   function(GLuint index, GLbyte *v) PFNGLVERTEXATTRIB4NBVARBPROC;
typedef void   function(GLuint index, GLint *v) PFNGLVERTEXATTRIB4NIVARBPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB4NSVARBPROC;
typedef void   function(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) PFNGLVERTEXATTRIB4NUBARBPROC;
typedef void   function(GLuint index, GLubyte *v) PFNGLVERTEXATTRIB4NUBVARBPROC;
typedef void   function(GLuint index, GLuint *v) PFNGLVERTEXATTRIB4NUIVARBPROC;
typedef void   function(GLuint index, GLushort *v) PFNGLVERTEXATTRIB4NUSVARBPROC;
typedef void   function(GLuint index, GLbyte *v) PFNGLVERTEXATTRIB4BVARBPROC;
typedef void   function(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLVERTEXATTRIB4DARBPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB4DVARBPROC;
typedef void   function(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLVERTEXATTRIB4FARBPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB4FVARBPROC;
typedef void   function(GLuint index, GLint *v) PFNGLVERTEXATTRIB4IVARBPROC;
typedef void   function(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) PFNGLVERTEXATTRIB4SARBPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB4SVARBPROC;
typedef void   function(GLuint index, GLubyte *v) PFNGLVERTEXATTRIB4UBVARBPROC;
typedef void   function(GLuint index, GLuint *v) PFNGLVERTEXATTRIB4UIVARBPROC;
typedef void   function(GLuint index, GLushort *v) PFNGLVERTEXATTRIB4USVARBPROC;
typedef void   function(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLvoid *pointer) PFNGLVERTEXATTRIBPOINTERARBPROC;
typedef void   function(GLuint index) PFNGLENABLEVERTEXATTRIBARRAYARBPROC;
typedef void   function(GLuint index) PFNGLDISABLEVERTEXATTRIBARRAYARBPROC;
typedef void   function(GLenum target, GLenum format, GLsizei len, GLvoid *string) PFNGLPROGRAMSTRINGARBPROC;
typedef void   function(GLenum target, GLuint program) PFNGLBINDPROGRAMARBPROC;
typedef void   function(GLsizei n, GLuint *programs) PFNGLDELETEPROGRAMSARBPROC;
typedef void   function(GLsizei n, GLuint *programs) PFNGLGENPROGRAMSARBPROC;
typedef void   function(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLPROGRAMENVPARAMETER4DARBPROC;
typedef void   function(GLenum target, GLuint index, GLdouble *params) PFNGLPROGRAMENVPARAMETER4DVARBPROC;
typedef void   function(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLPROGRAMENVPARAMETER4FARBPROC;
typedef void   function(GLenum target, GLuint index, GLfloat *params) PFNGLPROGRAMENVPARAMETER4FVARBPROC;
typedef void   function(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLPROGRAMLOCALPARAMETER4DARBPROC;
typedef void   function(GLenum target, GLuint index, GLdouble *params) PFNGLPROGRAMLOCALPARAMETER4DVARBPROC;
typedef void   function(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLPROGRAMLOCALPARAMETER4FARBPROC;
typedef void   function(GLenum target, GLuint index, GLfloat *params) PFNGLPROGRAMLOCALPARAMETER4FVARBPROC;
typedef void   function(GLenum target, GLuint index, GLdouble *params) PFNGLGETPROGRAMENVPARAMETERDVARBPROC;
typedef void   function(GLenum target, GLuint index, GLfloat *params) PFNGLGETPROGRAMENVPARAMETERFVARBPROC;
typedef void   function(GLenum target, GLuint index, GLdouble *params) PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC;
typedef void   function(GLenum target, GLuint index, GLfloat *params) PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETPROGRAMIVARBPROC;
typedef void   function(GLenum target, GLenum pname, GLvoid *string) PFNGLGETPROGRAMSTRINGARBPROC;
typedef void   function(GLuint index, GLenum pname, GLdouble *params) PFNGLGETVERTEXATTRIBDVARBPROC;
typedef void   function(GLuint index, GLenum pname, GLfloat *params) PFNGLGETVERTEXATTRIBFVARBPROC;
typedef void   function(GLuint index, GLenum pname, GLint *params) PFNGLGETVERTEXATTRIBIVARBPROC;
typedef void   function(GLuint index, GLenum pname, GLvoid* *pointer) PFNGLGETVERTEXATTRIBPOINTERVARBPROC;
typedef GLboolean function(GLuint program) PFNGLISPROGRAMARBPROC;
 extern   PFNGLVERTEXATTRIB1DARBPROC pglVertexAttrib1dARB;
 extern   PFNGLVERTEXATTRIB1DVARBPROC pglVertexAttrib1dvARB;
 extern   PFNGLVERTEXATTRIB1FARBPROC pglVertexAttrib1fARB;
 extern   PFNGLVERTEXATTRIB1FVARBPROC pglVertexAttrib1fvARB;
 extern   PFNGLVERTEXATTRIB1SARBPROC pglVertexAttrib1sARB;
 extern   PFNGLVERTEXATTRIB1SVARBPROC pglVertexAttrib1svARB;
 extern   PFNGLVERTEXATTRIB2DARBPROC pglVertexAttrib2dARB;
 extern   PFNGLVERTEXATTRIB2DVARBPROC pglVertexAttrib2dvARB;
 extern   PFNGLVERTEXATTRIB2FARBPROC pglVertexAttrib2fARB;
 extern   PFNGLVERTEXATTRIB2FVARBPROC pglVertexAttrib2fvARB;
 extern   PFNGLVERTEXATTRIB2SARBPROC pglVertexAttrib2sARB;
 extern   PFNGLVERTEXATTRIB2SVARBPROC pglVertexAttrib2svARB;
 extern   PFNGLVERTEXATTRIB3DARBPROC pglVertexAttrib3dARB;
 extern   PFNGLVERTEXATTRIB3DVARBPROC pglVertexAttrib3dvARB;
 extern   PFNGLVERTEXATTRIB3FARBPROC pglVertexAttrib3fARB;
 extern   PFNGLVERTEXATTRIB3FVARBPROC pglVertexAttrib3fvARB;
 extern   PFNGLVERTEXATTRIB3SARBPROC pglVertexAttrib3sARB;
 extern   PFNGLVERTEXATTRIB3SVARBPROC pglVertexAttrib3svARB;
 extern   PFNGLVERTEXATTRIB4NBVARBPROC pglVertexAttrib4NbvARB;
 extern   PFNGLVERTEXATTRIB4NIVARBPROC pglVertexAttrib4NivARB;
 extern   PFNGLVERTEXATTRIB4NSVARBPROC pglVertexAttrib4NsvARB;
 extern   PFNGLVERTEXATTRIB4NUBARBPROC pglVertexAttrib4NubARB;
 extern   PFNGLVERTEXATTRIB4NUBVARBPROC pglVertexAttrib4NubvARB;
 extern   PFNGLVERTEXATTRIB4NUIVARBPROC pglVertexAttrib4NuivARB;
 extern   PFNGLVERTEXATTRIB4NUSVARBPROC pglVertexAttrib4NusvARB;
 extern   PFNGLVERTEXATTRIB4BVARBPROC pglVertexAttrib4bvARB;
 extern   PFNGLVERTEXATTRIB4DARBPROC pglVertexAttrib4dARB;
 extern   PFNGLVERTEXATTRIB4DVARBPROC pglVertexAttrib4dvARB;
 extern   PFNGLVERTEXATTRIB4FARBPROC pglVertexAttrib4fARB;
 extern   PFNGLVERTEXATTRIB4FVARBPROC pglVertexAttrib4fvARB;
 extern   PFNGLVERTEXATTRIB4IVARBPROC pglVertexAttrib4ivARB;
 extern   PFNGLVERTEXATTRIB4SARBPROC pglVertexAttrib4sARB;
 extern   PFNGLVERTEXATTRIB4SVARBPROC pglVertexAttrib4svARB;
 extern   PFNGLVERTEXATTRIB4UBVARBPROC pglVertexAttrib4ubvARB;
 extern   PFNGLVERTEXATTRIB4UIVARBPROC pglVertexAttrib4uivARB;
 extern   PFNGLVERTEXATTRIB4USVARBPROC pglVertexAttrib4usvARB;
 extern   PFNGLVERTEXATTRIBPOINTERARBPROC pglVertexAttribPointerARB;
 extern   PFNGLENABLEVERTEXATTRIBARRAYARBPROC pglEnableVertexAttribArrayARB;
 extern   PFNGLDISABLEVERTEXATTRIBARRAYARBPROC pglDisableVertexAttribArrayARB;
 extern   PFNGLPROGRAMSTRINGARBPROC pglProgramStringARB;
 extern   PFNGLBINDPROGRAMARBPROC pglBindProgramARB;
 extern   PFNGLDELETEPROGRAMSARBPROC pglDeleteProgramsARB;
 extern   PFNGLGENPROGRAMSARBPROC pglGenProgramsARB;
 extern   PFNGLPROGRAMENVPARAMETER4DARBPROC pglProgramEnvParameter4dARB;
 extern   PFNGLPROGRAMENVPARAMETER4DVARBPROC pglProgramEnvParameter4dvARB;
 extern   PFNGLPROGRAMENVPARAMETER4FARBPROC pglProgramEnvParameter4fARB;
 extern   PFNGLPROGRAMENVPARAMETER4FVARBPROC pglProgramEnvParameter4fvARB;
 extern   PFNGLPROGRAMLOCALPARAMETER4DARBPROC pglProgramLocalParameter4dARB;
 extern   PFNGLPROGRAMLOCALPARAMETER4DVARBPROC pglProgramLocalParameter4dvARB;
 extern   PFNGLPROGRAMLOCALPARAMETER4FARBPROC pglProgramLocalParameter4fARB;
 extern   PFNGLPROGRAMLOCALPARAMETER4FVARBPROC pglProgramLocalParameter4fvARB;
 extern   PFNGLGETPROGRAMENVPARAMETERDVARBPROC pglGetProgramEnvParameterdvARB;
 extern   PFNGLGETPROGRAMENVPARAMETERFVARBPROC pglGetProgramEnvParameterfvARB;
 extern   PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC pglGetProgramLocalParameterdvARB;
 extern   PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC pglGetProgramLocalParameterfvARB;
 extern   PFNGLGETPROGRAMIVARBPROC pglGetProgramivARB;
 extern   PFNGLGETPROGRAMSTRINGARBPROC pglGetProgramStringARB;
 extern   PFNGLGETVERTEXATTRIBDVARBPROC pglGetVertexAttribdvARB;
 extern   PFNGLGETVERTEXATTRIBFVARBPROC pglGetVertexAttribfvARB;
 extern   PFNGLGETVERTEXATTRIBIVARBPROC pglGetVertexAttribivARB;
 extern   PFNGLGETVERTEXATTRIBPOINTERVARBPROC pglGetVertexAttribPointervARB;
 extern   PFNGLISPROGRAMARBPROC pglIsProgramARB;
alias pglVertexAttrib1dARB glVertexAttrib1dARB;
alias pglVertexAttrib1dvARB glVertexAttrib1dvARB;
alias pglVertexAttrib1fARB glVertexAttrib1fARB;
alias pglVertexAttrib1fvARB glVertexAttrib1fvARB;
alias pglVertexAttrib1sARB glVertexAttrib1sARB;
alias pglVertexAttrib1svARB glVertexAttrib1svARB;
alias pglVertexAttrib2dARB glVertexAttrib2dARB;
alias pglVertexAttrib2dvARB glVertexAttrib2dvARB;
alias pglVertexAttrib2fARB glVertexAttrib2fARB;
alias pglVertexAttrib2fvARB glVertexAttrib2fvARB;
alias pglVertexAttrib2sARB glVertexAttrib2sARB;
alias pglVertexAttrib2svARB glVertexAttrib2svARB;
alias pglVertexAttrib3dARB glVertexAttrib3dARB;
alias pglVertexAttrib3dvARB glVertexAttrib3dvARB;
alias pglVertexAttrib3fARB glVertexAttrib3fARB;
alias pglVertexAttrib3fvARB glVertexAttrib3fvARB;
alias pglVertexAttrib3sARB glVertexAttrib3sARB;
alias pglVertexAttrib3svARB glVertexAttrib3svARB;
alias pglVertexAttrib4NbvARB glVertexAttrib4NbvARB;
alias pglVertexAttrib4NivARB glVertexAttrib4NivARB;
alias pglVertexAttrib4NsvARB glVertexAttrib4NsvARB;
alias pglVertexAttrib4NubARB glVertexAttrib4NubARB;
alias pglVertexAttrib4NubvARB glVertexAttrib4NubvARB;
alias pglVertexAttrib4NuivARB glVertexAttrib4NuivARB;
alias pglVertexAttrib4NusvARB glVertexAttrib4NusvARB;
alias pglVertexAttrib4bvARB glVertexAttrib4bvARB;
alias pglVertexAttrib4dARB glVertexAttrib4dARB;
alias pglVertexAttrib4dvARB glVertexAttrib4dvARB;
alias pglVertexAttrib4fARB glVertexAttrib4fARB;
alias pglVertexAttrib4fvARB glVertexAttrib4fvARB;
alias pglVertexAttrib4ivARB glVertexAttrib4ivARB;
alias pglVertexAttrib4sARB glVertexAttrib4sARB;
alias pglVertexAttrib4svARB glVertexAttrib4svARB;
alias pglVertexAttrib4ubvARB glVertexAttrib4ubvARB;
alias pglVertexAttrib4uivARB glVertexAttrib4uivARB;
alias pglVertexAttrib4usvARB glVertexAttrib4usvARB;
alias pglVertexAttribPointerARB glVertexAttribPointerARB;
alias pglEnableVertexAttribArrayARB glEnableVertexAttribArrayARB;
alias pglDisableVertexAttribArrayARB glDisableVertexAttribArrayARB;
alias pglProgramStringARB glProgramStringARB;
alias pglBindProgramARB glBindProgramARB;
alias pglDeleteProgramsARB glDeleteProgramsARB;
alias pglGenProgramsARB glGenProgramsARB;
alias pglProgramEnvParameter4dARB glProgramEnvParameter4dARB;
alias pglProgramEnvParameter4dvARB glProgramEnvParameter4dvARB;
alias pglProgramEnvParameter4fARB glProgramEnvParameter4fARB;
alias pglProgramEnvParameter4fvARB glProgramEnvParameter4fvARB;
alias pglProgramLocalParameter4dARB glProgramLocalParameter4dARB;
alias pglProgramLocalParameter4dvARB glProgramLocalParameter4dvARB;
alias pglProgramLocalParameter4fARB glProgramLocalParameter4fARB;
alias pglProgramLocalParameter4fvARB glProgramLocalParameter4fvARB;
alias pglGetProgramEnvParameterdvARB glGetProgramEnvParameterdvARB;
alias pglGetProgramEnvParameterfvARB glGetProgramEnvParameterfvARB;
alias pglGetProgramLocalParameterdvARB glGetProgramLocalParameterdvARB;
alias pglGetProgramLocalParameterfvARB glGetProgramLocalParameterfvARB;
alias pglGetProgramivARB glGetProgramivARB;
alias pglGetProgramStringARB glGetProgramStringARB;
alias pglGetVertexAttribdvARB glGetVertexAttribdvARB;
alias pglGetVertexAttribfvARB glGetVertexAttribfvARB;
alias pglGetVertexAttribivARB glGetVertexAttribivARB;
alias pglGetVertexAttribPointervARB glGetVertexAttribPointervARB;
alias pglIsProgramARB glIsProgramARB;
//#endif ;

//GL_ARB_fragment_program

//#ifndef GL_ARB_fragment_program;
const uint  GL_ARB_fragment_program = 1;
const uint  __GLEE_GL_ARB_fragment_program = 1;
//constants
const uint  GL_FRAGMENT_PROGRAM_ARB                            = 0x8804;
const uint  GL_PROGRAM_ALU_INSTRUCTIONS_ARB                    = 0x8805;
const uint  GL_PROGRAM_TEX_INSTRUCTIONS_ARB                    = 0x8806;
const uint  GL_PROGRAM_TEX_INDIRECTIONS_ARB                    = 0x8807;
const uint  GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB             = 0x8808;
const uint  GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB             = 0x8809;
const uint  GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB             = 0x880A;
const uint  GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB                = 0x880B;
const uint  GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB                = 0x880C;
const uint  GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB                = 0x880D;
const uint  GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB         = 0x880E;
const uint  GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB         = 0x880F;
const uint  GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB         = 0x8810;
const uint  GL_MAX_TEXTURE_COORDS_ARB                          = 0x8871;
const uint  GL_MAX_TEXTURE_IMAGE_UNITS_ARB                     = 0x8872;
//#endif ;

//GL_ARB_vertex_buffer_object

//#ifndef GL_ARB_vertex_buffer_object;
const uint  GL_ARB_vertex_buffer_object = 1;
const uint  __GLEE_GL_ARB_vertex_buffer_object = 1;
//constants
const uint  GL_BUFFER_SIZE_ARB                                 = 0x8764;
const uint  GL_BUFFER_USAGE_ARB                                = 0x8765;
const uint  GL_ARRAY_BUFFER_ARB                                = 0x8892;
const uint  GL_ELEMENT_ARRAY_BUFFER_ARB                        = 0x8893;
const uint  GL_ARRAY_BUFFER_BINDING_ARB                        = 0x8894;
const uint  GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB                = 0x8895;
const uint  GL_VERTEX_ARRAY_BUFFER_BINDING_ARB                 = 0x8896;
const uint  GL_NORMAL_ARRAY_BUFFER_BINDING_ARB                 = 0x8897;
const uint  GL_COLOR_ARRAY_BUFFER_BINDING_ARB                  = 0x8898;
const uint  GL_INDEX_ARRAY_BUFFER_BINDING_ARB                  = 0x8899;
const uint  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB          = 0x889A;
const uint  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB              = 0x889B;
const uint  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB        = 0x889C;
const uint  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB         = 0x889D;
const uint  GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB                 = 0x889E;
const uint  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB          = 0x889F;
const uint  GL_READ_ONLY_ARB                                   = 0x88B8;
const uint  GL_WRITE_ONLY_ARB                                  = 0x88B9;
const uint  GL_READ_WRITE_ARB                                  = 0x88BA;
const uint  GL_BUFFER_ACCESS_ARB                               = 0x88BB;
const uint  GL_BUFFER_MAPPED_ARB                               = 0x88BC;
const uint  GL_BUFFER_MAP_POINTER_ARB                          = 0x88BD;
const uint  GL_STREAM_DRAW_ARB                                 = 0x88E0;
const uint  GL_STREAM_READ_ARB                                 = 0x88E1;
const uint  GL_STREAM_COPY_ARB                                 = 0x88E2;
const uint  GL_STATIC_DRAW_ARB                                 = 0x88E4;
const uint  GL_STATIC_READ_ARB                                 = 0x88E5;
const uint  GL_STATIC_COPY_ARB                                 = 0x88E6;
const uint  GL_DYNAMIC_DRAW_ARB                                = 0x88E8;
const uint  GL_DYNAMIC_READ_ARB                                = 0x88E9;
const uint GL_DYNAMIC_COPY_ARB                                = 0x88EA;
typedef void   function(GLenum target, GLuint buffer) PFNGLBINDBUFFERARBPROC;
typedef void   function(GLsizei n, GLuint *buffers) PFNGLDELETEBUFFERSARBPROC;
typedef void   function(GLsizei n, GLuint *buffers) PFNGLGENBUFFERSARBPROC;
typedef GLboolean   function(GLuint buffer) PFNGLISBUFFERARBPROC;
typedef void   function(GLenum target, GLsizeiptrARB size, GLvoid *data, GLenum usage) PFNGLBUFFERDATAARBPROC;
typedef void   function(GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data) PFNGLBUFFERSUBDATAARBPROC;
typedef void   function(GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data) PFNGLGETBUFFERSUBDATAARBPROC;
typedef GLvoid*   function(GLenum target, GLenum access) PFNGLMAPBUFFERARBPROC;
typedef GLboolean   function(GLenum target) PFNGLUNMAPBUFFERARBPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETBUFFERPARAMETERIVARBPROC;
typedef void   function(GLenum target, GLenum pname, GLvoid* *params) PFNGLGETBUFFERPOINTERVARBPROC;
 extern   PFNGLBINDBUFFERARBPROC pglBindBufferARB;
 extern   PFNGLDELETEBUFFERSARBPROC pglDeleteBuffersARB;
 extern   PFNGLGENBUFFERSARBPROC pglGenBuffersARB;
 extern   PFNGLISBUFFERARBPROC pglIsBufferARB;
 extern   PFNGLBUFFERDATAARBPROC pglBufferDataARB;
 extern   PFNGLBUFFERSUBDATAARBPROC pglBufferSubDataARB;
 extern   PFNGLGETBUFFERSUBDATAARBPROC pglGetBufferSubDataARB;
 extern   PFNGLMAPBUFFERARBPROC pglMapBufferARB;
 extern   PFNGLUNMAPBUFFERARBPROC pglUnmapBufferARB;
 extern   PFNGLGETBUFFERPARAMETERIVARBPROC pglGetBufferParameterivARB;
 extern   PFNGLGETBUFFERPOINTERVARBPROC pglGetBufferPointervARB;
alias pglBindBufferARB glBindBufferARB;
alias pglDeleteBuffersARB glDeleteBuffersARB;
alias pglGenBuffersARB glGenBuffersARB;
alias pglIsBufferARB glIsBufferARB;
alias pglBufferDataARB glBufferDataARB;
alias pglBufferSubDataARB glBufferSubDataARB;
alias pglGetBufferSubDataARB glGetBufferSubDataARB;
alias pglMapBufferARB glMapBufferARB;
alias pglUnmapBufferARB glUnmapBufferARB;
alias pglGetBufferParameterivARB glGetBufferParameterivARB;
alias pglGetBufferPointervARB glGetBufferPointervARB;
//#endif ;

//GL_ARB_occlusion_query

//#ifndef GL_ARB_occlusion_query;
const uint  GL_ARB_occlusion_query = 1;
const uint  __GLEE_GL_ARB_occlusion_query = 1;
//constants
const uint  GL_QUERY_COUNTER_BITS_ARB                          = 0x8864;
const uint  GL_CURRENT_QUERY_ARB                               = 0x8865;
const uint  GL_QUERY_RESULT_ARB                                = 0x8866;
const uint  GL_QUERY_RESULT_AVAILABLE_ARB                      = 0x8867;
const uint  GL_SAMPLES_PASSED_ARB                              = 0x8914;
typedef void   function(GLsizei n, GLuint *ids) PFNGLGENQUERIESARBPROC;
typedef void   function(GLsizei n, GLuint *ids) PFNGLDELETEQUERIESARBPROC;
typedef GLboolean   function(GLuint id) PFNGLISQUERYARBPROC;
typedef void   function(GLenum target, GLuint id) PFNGLBEGINQUERYARBPROC;
typedef void   function(GLenum target) PFNGLENDQUERYARBPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETQUERYIVARBPROC;
typedef void   function(GLuint id, GLenum pname, GLint *params) PFNGLGETQUERYOBJECTIVARBPROC;
typedef void   function(GLuint id, GLenum pname, GLuint *params) PFNGLGETQUERYOBJECTUIVARBPROC;
 extern   PFNGLGENQUERIESARBPROC pglGenQueriesARB;
 extern   PFNGLDELETEQUERIESARBPROC pglDeleteQueriesARB;
 extern   PFNGLISQUERYARBPROC pglIsQueryARB;
 extern   PFNGLBEGINQUERYARBPROC pglBeginQueryARB;
 extern   PFNGLENDQUERYARBPROC pglEndQueryARB;
 extern   PFNGLGETQUERYIVARBPROC pglGetQueryivARB;
 extern   PFNGLGETQUERYOBJECTIVARBPROC pglGetQueryObjectivARB;
 extern   PFNGLGETQUERYOBJECTUIVARBPROC pglGetQueryObjectuivARB;
alias pglGenQueriesARB glGenQueriesARB;
alias pglDeleteQueriesARB glDeleteQueriesARB;
alias pglIsQueryARB glIsQueryARB;
alias pglBeginQueryARB glBeginQueryARB;
alias pglEndQueryARB glEndQueryARB;
alias pglGetQueryivARB glGetQueryivARB;
alias pglGetQueryObjectivARB glGetQueryObjectivARB;
alias pglGetQueryObjectuivARB glGetQueryObjectuivARB;
//#endif ;

//GL_ARB_shader_objects

//#ifndef GL_ARB_shader_objects;
const uint  GL_ARB_shader_objects = 1;
const uint  __GLEE_GL_ARB_shader_objects = 1;
//constants
const uint  GL_PROGRAM_OBJECT_ARB                              = 0x8B40;
const uint  GL_SHADER_OBJECT_ARB                               = 0x8B48;
const uint  GL_OBJECT_TYPE_ARB                                 = 0x8B4E;
const uint  GL_OBJECT_SUBTYPE_ARB                              = 0x8B4F;
const uint  GL_FLOAT_VEC2_ARB                                  = 0x8B50;
const uint  GL_FLOAT_VEC3_ARB                                  = 0x8B51;
const uint  GL_FLOAT_VEC4_ARB                                  = 0x8B52;
const uint  GL_INT_VEC2_ARB                                    = 0x8B53;
const uint  GL_INT_VEC3_ARB                                    = 0x8B54;
const uint  GL_INT_VEC4_ARB                                    = 0x8B55;
const uint  GL_BOOL_ARB                                        = 0x8B56;
const uint  GL_BOOL_VEC2_ARB                                   = 0x8B57;
const uint  GL_BOOL_VEC3_ARB                                   = 0x8B58;
const uint  GL_BOOL_VEC4_ARB                                   = 0x8B59;
const uint  GL_FLOAT_MAT2_ARB                                  = 0x8B5A;
const uint  GL_FLOAT_MAT3_ARB                                  = 0x8B5B;
const uint  GL_FLOAT_MAT4_ARB                                  = 0x8B5C;
const uint  GL_OBJECT_DELETE_STATUS_ARB                        = 0x8B80;
const uint  GL_OBJECT_COMPILE_STATUS_ARB                       = 0x8B81;
const uint  GL_OBJECT_LINK_STATUS_ARB                          = 0x8B82;
const uint  GL_OBJECT_VALIDATE_STATUS_ARB                      = 0x8B83;
const uint  GL_OBJECT_INFO_LOG_LENGTH_ARB                      = 0x8B84;
const uint  GL_OBJECT_ATTACHED_OBJECTS_ARB                     = 0x8B85;
const uint  GL_OBJECT_ACTIVE_UNIFORMS_ARB                      = 0x8B86;
const uint  GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB            = 0x8B87;
const uint  GL_OBJECT_SHADER_SOURCE_LENGTH_ARB                 = 0x8B88;

typedef void   function(GLhandleARB obj) PFNGLDELETEOBJECTARBPROC;

typedef GLhandleARB    function(GLenum pname) PFNGLGETHANDLEARBPROC;
typedef void   function(GLhandleARB containerObj, GLhandleARB attachedObj) PFNGLDETACHOBJECTARBPROC;

typedef GLhandleARB    function(GLenum shaderType) PFNGLCREATESHADEROBJECTARBPROC;
typedef void   function(GLhandleARB shaderObj, GLsizei count, GLcharARB* *string, GLint *length) PFNGLSHADERSOURCEARBPROC;

typedef void   function(GLhandleARB shaderObj) PFNGLCOMPILESHADERARBPROC;

typedef GLhandleARB    function() PFNGLCREATEPROGRAMOBJECTARBPROC;
typedef void   function(GLhandleARB containerObj, GLhandleARB obj) PFNGLATTACHOBJECTARBPROC;
typedef void   function(GLhandleARB programObj) PFNGLLINKPROGRAMARBPROC;

typedef void   function(GLhandleARB programObj) PFNGLUSEPROGRAMOBJECTARBPROC;
typedef void   function(GLhandleARB programObj) PFNGLVALIDATEPROGRAMARBPROC;

typedef void   function(GLint location, GLfloat v0) PFNGLUNIFORM1FARBPROC;
typedef void   function(GLint location, GLfloat v0, GLfloat v1) PFNGLUNIFORM2FARBPROC;
typedef void   function(GLint location, GLfloat v0, GLfloat v1, GLfloat v2) PFNGLUNIFORM3FARBPROC;
typedef void   function(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) PFNGLUNIFORM4FARBPROC;
typedef void   function(GLint location, GLint v0) PFNGLUNIFORM1IARBPROC;
typedef void   function(GLint location, GLint v0, GLint v1) PFNGLUNIFORM2IARBPROC;
typedef void   function(GLint location, GLint v0, GLint v1, GLint v2) PFNGLUNIFORM3IARBPROC;
typedef void   function(GLint location, GLint v0, GLint v1, GLint v2, GLint v3) PFNGLUNIFORM4IARBPROC;
typedef void   function(GLint location, GLsizei count, GLfloat *value) PFNGLUNIFORM1FVARBPROC;
typedef void   function(GLint location, GLsizei count, GLfloat *value) PFNGLUNIFORM2FVARBPROC;
typedef void   function(GLint location, GLsizei count, GLfloat *value) PFNGLUNIFORM3FVARBPROC;
typedef void   function(GLint location, GLsizei count, GLfloat *value) PFNGLUNIFORM4FVARBPROC;
typedef void   function(GLint location, GLsizei count, GLint *value) PFNGLUNIFORM1IVARBPROC;
typedef void   function(GLint location, GLsizei count, GLint *value) PFNGLUNIFORM2IVARBPROC;
typedef void   function(GLint location, GLsizei count, GLint *value) PFNGLUNIFORM3IVARBPROC;

typedef void   function(GLint location, GLsizei count, GLint *value) PFNGLUNIFORM4IVARBPROC;
typedef void   function(GLint location, GLsizei count, GLboolean transpose, GLfloat *value) PFNGLUNIFORMMATRIX2FVARBPROC;
typedef void   function(GLint location, GLsizei count, GLboolean transpose, GLfloat *value) PFNGLUNIFORMMATRIX3FVARBPROC;
typedef void   function(GLint location, GLsizei count, GLboolean transpose, GLfloat *value) PFNGLUNIFORMMATRIX4FVARBPROC;
typedef void   function(GLhandleARB obj, GLenum pname, GLfloat *params) PFNGLGETOBJECTPARAMETERFVARBPROC;
typedef void   function(GLhandleARB obj, GLenum pname, GLint *params) PFNGLGETOBJECTPARAMETERIVARBPROC;
typedef void   function(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog) PFNGLGETINFOLOGARBPROC;
typedef void   function(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj) PFNGLGETATTACHEDOBJECTSARBPROC;
typedef GLint   function(GLhandleARB programObj, GLcharARB *name) PFNGLGETUNIFORMLOCATIONARBPROC;
typedef void   function(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name) PFNGLGETACTIVEUNIFORMARBPROC;
typedef void   function(GLhandleARB programObj, GLint location, GLfloat *params) PFNGLGETUNIFORMFVARBPROC;
typedef void   function(GLhandleARB programObj, GLint location, GLint *params) PFNGLGETUNIFORMIVARBPROC;
typedef void   function(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source) PFNGLGETSHADERSOURCEARBPROC;
 extern   PFNGLDELETEOBJECTARBPROC pglDeleteObjectARB;
 extern   PFNGLGETHANDLEARBPROC pglGetHandleARB;
 extern   PFNGLDETACHOBJECTARBPROC pglDetachObjectARB;
 extern   PFNGLCREATESHADEROBJECTARBPROC pglCreateShaderObjectARB;
 extern   PFNGLSHADERSOURCEARBPROC pglShaderSourceARB;
 extern   PFNGLCOMPILESHADERARBPROC pglCompileShaderARB;
 extern   PFNGLCREATEPROGRAMOBJECTARBPROC pglCreateProgramObjectARB;
 extern   PFNGLATTACHOBJECTARBPROC pglAttachObjectARB;
 extern   PFNGLLINKPROGRAMARBPROC pglLinkProgramARB;
 extern   PFNGLUSEPROGRAMOBJECTARBPROC pglUseProgramObjectARB;
 extern   PFNGLVALIDATEPROGRAMARBPROC pglValidateProgramARB;
 extern   PFNGLUNIFORM1FARBPROC pglUniform1fARB;
 extern   PFNGLUNIFORM2FARBPROC pglUniform2fARB;
 extern   PFNGLUNIFORM3FARBPROC pglUniform3fARB;
 extern   PFNGLUNIFORM4FARBPROC pglUniform4fARB;
 extern   PFNGLUNIFORM1IARBPROC pglUniform1iARB;
 extern   PFNGLUNIFORM2IARBPROC pglUniform2iARB;
 extern   PFNGLUNIFORM3IARBPROC pglUniform3iARB;
 extern   PFNGLUNIFORM4IARBPROC pglUniform4iARB;
 extern   PFNGLUNIFORM1FVARBPROC pglUniform1fvARB;
 extern   PFNGLUNIFORM2FVARBPROC pglUniform2fvARB;
 extern   PFNGLUNIFORM3FVARBPROC pglUniform3fvARB;
 extern   PFNGLUNIFORM4FVARBPROC pglUniform4fvARB;
 extern   PFNGLUNIFORM1IVARBPROC pglUniform1ivARB;
 extern   PFNGLUNIFORM2IVARBPROC pglUniform2ivARB;
 extern   PFNGLUNIFORM3IVARBPROC pglUniform3ivARB;
 extern   PFNGLUNIFORM4IVARBPROC pglUniform4ivARB;
 extern   PFNGLUNIFORMMATRIX2FVARBPROC pglUniformMatrix2fvARB;
 extern   PFNGLUNIFORMMATRIX3FVARBPROC pglUniformMatrix3fvARB;
 extern   PFNGLUNIFORMMATRIX4FVARBPROC pglUniformMatrix4fvARB;
 extern   PFNGLGETOBJECTPARAMETERFVARBPROC pglGetObjectParameterfvARB;
 extern   PFNGLGETOBJECTPARAMETERIVARBPROC pglGetObjectParameterivARB;
 extern   PFNGLGETINFOLOGARBPROC pglGetInfoLogARB;
 extern   PFNGLGETATTACHEDOBJECTSARBPROC pglGetAttachedObjectsARB;
 extern   PFNGLGETUNIFORMLOCATIONARBPROC pglGetUniformLocationARB;
 extern   PFNGLGETACTIVEUNIFORMARBPROC pglGetActiveUniformARB;
 extern   PFNGLGETUNIFORMFVARBPROC pglGetUniformfvARB;
 extern   PFNGLGETUNIFORMIVARBPROC pglGetUniformivARB;
 extern   PFNGLGETSHADERSOURCEARBPROC pglGetShaderSourceARB;
alias pglDeleteObjectARB glDeleteObjectARB;
alias pglGetHandleARB glGetHandleARB;
alias pglDetachObjectARB glDetachObjectARB;
alias pglCreateShaderObjectARB glCreateShaderObjectARB;
alias pglShaderSourceARB glShaderSourceARB;
alias pglCompileShaderARB glCompileShaderARB;
alias pglCreateProgramObjectARB glCreateProgramObjectARB;
alias pglAttachObjectARB glAttachObjectARB;
alias pglLinkProgramARB glLinkProgramARB;
alias pglUseProgramObjectARB glUseProgramObjectARB;
alias pglValidateProgramARB glValidateProgramARB;
alias pglUniform1fARB glUniform1fARB;
alias pglUniform2fARB glUniform2fARB;
alias pglUniform3fARB glUniform3fARB;
alias pglUniform4fARB glUniform4fARB;
alias pglUniform1iARB glUniform1iARB;
alias pglUniform2iARB glUniform2iARB;
alias pglUniform3iARB glUniform3iARB;
alias pglUniform4iARB glUniform4iARB;
alias pglUniform1fvARB glUniform1fvARB;
alias pglUniform2fvARB glUniform2fvARB;
alias pglUniform3fvARB glUniform3fvARB;
alias pglUniform4fvARB glUniform4fvARB;
alias pglUniform1ivARB glUniform1ivARB;
alias pglUniform2ivARB glUniform2ivARB;
alias pglUniform3ivARB glUniform3ivARB;
alias pglUniform4ivARB glUniform4ivARB;
alias pglUniformMatrix2fvARB glUniformMatrix2fvARB;
alias pglUniformMatrix3fvARB glUniformMatrix3fvARB;
alias pglUniformMatrix4fvARB glUniformMatrix4fvARB;
alias pglGetObjectParameterfvARB glGetObjectParameterfvARB;
alias pglGetObjectParameterivARB glGetObjectParameterivARB;
alias pglGetInfoLogARB glGetInfoLogARB;
alias pglGetAttachedObjectsARB glGetAttachedObjectsARB;
alias pglGetUniformLocationARB glGetUniformLocationARB;
alias pglGetActiveUniformARB glGetActiveUniformARB;
alias pglGetUniformfvARB glGetUniformfvARB;
alias pglGetUniformivARB glGetUniformivARB;
alias pglGetShaderSourceARB glGetShaderSourceARB;
//#endif ;

//GL_ARB_vertex_shader

//#ifndef GL_ARB_vertex_shader;
const uint  GL_ARB_vertex_shader = 1;
const uint  __GLEE_GL_ARB_vertex_shader = 1;
//constants
const uint  GL_VERTEX_SHADER_ARB                               = 0x8B31;
const uint  GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB               = 0x8B4A;
const uint  GL_MAX_VARYING_FLOATS_ARB                          = 0x8B4B;
const uint  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB              = 0x8B4C;
const uint  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB            = 0x8B4D;
const uint  GL_OBJECT_ACTIVE_ATTRIBUTES_ARB                    = 0x8B89;
const uint  GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB          = 0x8B8A;
typedef void   function(GLhandleARB programObj, GLuint index, GLcharARB *name) PFNGLBINDATTRIBLOCATIONARBPROC;
typedef void   function(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name) PFNGLGETACTIVEATTRIBARBPROC;
typedef GLint   function(GLhandleARB programObj, GLcharARB *name) PFNGLGETATTRIBLOCATIONARBPROC;
 extern   PFNGLBINDATTRIBLOCATIONARBPROC pglBindAttribLocationARB;
 extern   PFNGLGETACTIVEATTRIBARBPROC pglGetActiveAttribARB;
 extern   PFNGLGETATTRIBLOCATIONARBPROC pglGetAttribLocationARB;
alias pglBindAttribLocationARB glBindAttribLocationARB;
alias pglGetActiveAttribARB glGetActiveAttribARB;
alias pglGetAttribLocationARB glGetAttribLocationARB;
//#endif ;

//GL_ARB_fragment_shader

//#ifndef GL_ARB_fragment_shader;
const uint  GL_ARB_fragment_shader = 1;
const uint  __GLEE_GL_ARB_fragment_shader = 1;
//constants
const uint  GL_FRAGMENT_SHADER_ARB                             = 0x8B30;
const uint  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB             = 0x8B49;
//#endif ;

//GL_ARB_shading_language_100

//#ifndef GL_ARB_shading_language_100;
const uint  GL_ARB_shading_language_100 = 1;
const uint  __GLEE_GL_ARB_shading_language_100 = 1;
//constants
//#endif ;

//GL_ARB_texture_non_power_of_two

//#ifndef GL_ARB_texture_non_power_of_two;
const uint  GL_ARB_texture_non_power_of_two = 1;
const uint  __GLEE_GL_ARB_texture_non_power_of_two = 1;
//constants
//#endif ;

//GL_ARB_point_sprite

//#ifndef GL_ARB_point_sprite;
const uint  GL_ARB_point_sprite = 1;
const uint  __GLEE_GL_ARB_point_sprite = 1;
//constants
const uint  GL_POINT_SPRITE_ARB                                = 0x8861;
const uint  GL_COORD_REPLACE_ARB                               = 0x8862;
//#endif ;

//GL_EXT_abgr

//#ifndef GL_EXT_abgr;
const uint  GL_EXT_abgr = 1;
const uint  __GLEE_GL_EXT_abgr = 1;
//constants
const uint  GL_ABGR_EXT                                        = 0x8000;
//#endif ;

//GL_EXT_blend_color

//#ifndef GL_EXT_blend_color;
const uint  GL_EXT_blend_color = 1;
const uint  __GLEE_GL_EXT_blend_color = 1;
//constants
const uint  GL_CONSTANT_COLOR_EXT                              = 0x8001;
const uint  GL_ONE_MINUS_CONSTANT_COLOR_EXT                    = 0x8002;
const uint  GL_CONSTANT_ALPHA_EXT                              = 0x8003;
const uint  GL_ONE_MINUS_CONSTANT_ALPHA_EXT                    = 0x8004;
const uint  GL_BLEND_COLOR_EXT                                 = 0x8005;
typedef void   function(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) PFNGLBLENDCOLOREXTPROC;
 extern   PFNGLBLENDCOLOREXTPROC pglBlendColorEXT;
alias pglBlendColorEXT glBlendColorEXT;
//#endif ;

//GL_EXT_polygon_offset

//#ifndef GL_EXT_polygon_offset;
const uint  GL_EXT_polygon_offset = 1;
const uint  __GLEE_GL_EXT_polygon_offset = 1;
//constants
const uint  GL_POLYGON_OFFSET_EXT                              = 0x8037;
const uint  GL_POLYGON_OFFSET_FACTOR_EXT                       = 0x8038;
const uint  GL_POLYGON_OFFSET_BIAS_EXT                         = 0x8039;
typedef void   function(GLfloat factor, GLfloat bias) PFNGLPOLYGONOFFSETEXTPROC;
 extern   PFNGLPOLYGONOFFSETEXTPROC pglPolygonOffsetEXT;
alias pglPolygonOffsetEXT glPolygonOffsetEXT;
//#endif ;

//GL_EXT_texture

//#ifndef GL_EXT_texture;
const uint  GL_EXT_texture = 1;
const uint  __GLEE_GL_EXT_texture = 1;
//constants
const uint  GL_ALPHA4_EXT                                      = 0x803B;
const uint  GL_ALPHA8_EXT                                      = 0x803C;
const uint  GL_ALPHA12_EXT                                     = 0x803D;
const uint  GL_ALPHA16_EXT                                     = 0x803E;
const uint  GL_LUMINANCE4_EXT                                  = 0x803F;
const uint  GL_LUMINANCE8_EXT                                  = 0x8040;
const uint  GL_LUMINANCE12_EXT                                 = 0x8041;
const uint  GL_LUMINANCE16_EXT                                 = 0x8042;
const uint  GL_LUMINANCE4_ALPHA4_EXT                           = 0x8043;
const uint  GL_LUMINANCE6_ALPHA2_EXT                           = 0x8044;
const uint  GL_LUMINANCE8_ALPHA8_EXT                           = 0x8045;
const uint  GL_LUMINANCE12_ALPHA4_EXT                          = 0x8046;
const uint  GL_LUMINANCE12_ALPHA12_EXT                         = 0x8047;
const uint  GL_LUMINANCE16_ALPHA16_EXT                         = 0x8048;
const uint  GL_INTENSITY_EXT                                   = 0x8049;
const uint  GL_INTENSITY4_EXT                                  = 0x804A;
const uint  GL_INTENSITY8_EXT                                  = 0x804B;
const uint  GL_INTENSITY12_EXT                                 = 0x804C;
const uint  GL_INTENSITY16_EXT                                 = 0x804D;
const uint  GL_RGB2_EXT                                        = 0x804E;
const uint  GL_RGB4_EXT                                        = 0x804F;
const uint  GL_RGB5_EXT                                        = 0x8050;
const uint  GL_RGB8_EXT                                        = 0x8051;
const uint  GL_RGB10_EXT                                       = 0x8052;
const uint  GL_RGB12_EXT                                       = 0x8053;
const uint  GL_RGB16_EXT                                       = 0x8054;
const uint  GL_RGBA2_EXT                                       = 0x8055;
const uint  GL_RGBA4_EXT                                       = 0x8056;
const uint  GL_RGB5_A1_EXT                                     = 0x8057;
const uint  GL_RGBA8_EXT                                       = 0x8058;
const uint  GL_RGB10_A2_EXT                                    = 0x8059;
const uint  GL_RGBA12_EXT                                      = 0x805A;
const uint  GL_RGBA16_EXT                                      = 0x805B;
const uint  GL_TEXTURE_RED_SIZE_EXT                            = 0x805C;
const uint  GL_TEXTURE_GREEN_SIZE_EXT                          = 0x805D;
const uint  GL_TEXTURE_BLUE_SIZE_EXT                           = 0x805E;
const uint  GL_TEXTURE_ALPHA_SIZE_EXT                          = 0x805F;
const uint  GL_TEXTURE_LUMINANCE_SIZE_EXT                      = 0x8060;
const uint  GL_TEXTURE_INTENSITY_SIZE_EXT                      = 0x8061;
const uint  GL_REPLACE_EXT                                     = 0x8062;
const uint  GL_PROXY_TEXTURE_1D_EXT                            = 0x8063;
const uint  GL_PROXY_TEXTURE_2D_EXT                            = 0x8064;
const uint  GL_TEXTURE_TOO_LARGE_EXT                           = 0x8065;
//#endif ;

//GL_EXT_texture3D

//#ifndef GL_EXT_texture3D;
const uint  GL_EXT_texture3D = 1;
const uint  __GLEE_GL_EXT_texture3D = 1;
//constants
const uint  GL_PACK_SKIP_IMAGES_EXT                            = 0x806B;
const uint  GL_PACK_IMAGE_HEIGHT_EXT                           = 0x806C;
const uint  GL_UNPACK_SKIP_IMAGES_EXT                          = 0x806D;
const uint  GL_UNPACK_IMAGE_HEIGHT_EXT                         = 0x806E;
const uint  GL_TEXTURE_3D_EXT                                  = 0x806F;
const uint  GL_PROXY_TEXTURE_3D_EXT                            = 0x8070;
const uint  GL_TEXTURE_DEPTH_EXT                               = 0x8071;
const uint  GL_TEXTURE_WRAP_R_EXT                              = 0x8072;
const uint  GL_MAX_3D_TEXTURE_SIZE_EXT                         = 0x8073;
typedef void   function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXIMAGE3DEXTPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXSUBIMAGE3DEXTPROC;
 extern   PFNGLTEXIMAGE3DEXTPROC pglTexImage3DEXT;
 extern   PFNGLTEXSUBIMAGE3DEXTPROC pglTexSubImage3DEXT;
alias pglTexImage3DEXT glTexImage3DEXT;
alias pglTexSubImage3DEXT glTexSubImage3DEXT;
//#endif ;

//GL_SGIS_texture_filter4

//#ifndef GL_SGIS_texture_filter4;
const uint  GL_SGIS_texture_filter4 = 1;
const uint  __GLEE_GL_SGIS_texture_filter4 = 1;
//constants
const uint  GL_FILTER4_SGIS                                    = 0x8146;
const uint  GL_TEXTURE_FILTER4_SIZE_SGIS                       = 0x8147;
typedef void   function(GLenum target, GLenum filter, GLfloat *weights) PFNGLGETTEXFILTERFUNCSGISPROC;
typedef void   function(GLenum target, GLenum filter, GLsizei n, GLfloat *weights) PFNGLTEXFILTERFUNCSGISPROC;
 extern   PFNGLGETTEXFILTERFUNCSGISPROC pglGetTexFilterFuncSGIS;
 extern   PFNGLTEXFILTERFUNCSGISPROC pglTexFilterFuncSGIS;
alias pglGetTexFilterFuncSGIS glGetTexFilterFuncSGIS;
alias pglTexFilterFuncSGIS glTexFilterFuncSGIS;
//#endif ;

//GL_EXT_subtexture

//#ifndef GL_EXT_subtexture;
const uint  GL_EXT_subtexture = 1;
const uint  __GLEE_GL_EXT_subtexture = 1;
//constants
typedef void   function(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXSUBIMAGE1DEXTPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXSUBIMAGE2DEXTPROC;
 extern   PFNGLTEXSUBIMAGE1DEXTPROC pglTexSubImage1DEXT;
 extern   PFNGLTEXSUBIMAGE2DEXTPROC pglTexSubImage2DEXT;
alias pglTexSubImage1DEXT glTexSubImage1DEXT;
alias pglTexSubImage2DEXT glTexSubImage2DEXT;
//#endif ;

//GL_EXT_copy_texture

//#ifndef GL_EXT_copy_texture;
const uint  GL_EXT_copy_texture = 1;
const uint  __GLEE_GL_EXT_copy_texture = 1;
//constants
typedef void   function(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) PFNGLCOPYTEXIMAGE1DEXTPROC;
typedef void   function(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) PFNGLCOPYTEXIMAGE2DEXTPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) PFNGLCOPYTEXSUBIMAGE1DEXTPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) PFNGLCOPYTEXSUBIMAGE2DEXTPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) PFNGLCOPYTEXSUBIMAGE3DEXTPROC;
 extern   PFNGLCOPYTEXIMAGE1DEXTPROC pglCopyTexImage1DEXT;
 extern   PFNGLCOPYTEXIMAGE2DEXTPROC pglCopyTexImage2DEXT;
 extern   PFNGLCOPYTEXSUBIMAGE1DEXTPROC pglCopyTexSubImage1DEXT;
 extern   PFNGLCOPYTEXSUBIMAGE2DEXTPROC pglCopyTexSubImage2DEXT;
 extern   PFNGLCOPYTEXSUBIMAGE3DEXTPROC pglCopyTexSubImage3DEXT;
alias pglCopyTexImage1DEXT glCopyTexImage1DEXT;
alias pglCopyTexImage2DEXT glCopyTexImage2DEXT;
alias pglCopyTexSubImage1DEXT glCopyTexSubImage1DEXT;
alias pglCopyTexSubImage2DEXT glCopyTexSubImage2DEXT;
alias pglCopyTexSubImage3DEXT glCopyTexSubImage3DEXT;
//#endif ;

//GL_EXT_histogram

//#ifndef GL_EXT_histogram;
const uint  GL_EXT_histogram = 1;
const uint  __GLEE_GL_EXT_histogram = 1;
//constants
const uint  GL_HISTOGRAM_EXT                                   = 0x8024;
const uint  GL_PROXY_HISTOGRAM_EXT                             = 0x8025;
const uint  GL_HISTOGRAM_WIDTH_EXT                             = 0x8026;
const uint  GL_HISTOGRAM_FORMAT_EXT                            = 0x8027;
const uint  GL_HISTOGRAM_RED_SIZE_EXT                          = 0x8028;
const uint  GL_HISTOGRAM_GREEN_SIZE_EXT                        = 0x8029;
const uint  GL_HISTOGRAM_BLUE_SIZE_EXT                         = 0x802A;
const uint  GL_HISTOGRAM_ALPHA_SIZE_EXT                        = 0x802B;
const uint  GL_HISTOGRAM_LUMINANCE_SIZE_EXT                    = 0x802C;
const uint  GL_HISTOGRAM_SINK_EXT                              = 0x802D;
const uint  GL_MINMAX_EXT                                      = 0x802E;
const uint  GL_MINMAX_FORMAT_EXT                               = 0x802F;
const uint  GL_MINMAX_SINK_EXT                                 = 0x8030;
const uint  GL_TABLE_TOO_LARGE_EXT                             = 0x8031;
typedef void   function(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) PFNGLGETHISTOGRAMEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETHISTOGRAMPARAMETERFVEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETHISTOGRAMPARAMETERIVEXTPROC;
typedef void   function(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values) PFNGLGETMINMAXEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETMINMAXPARAMETERFVEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETMINMAXPARAMETERIVEXTPROC;
typedef void   function(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink) PFNGLHISTOGRAMEXTPROC;
typedef void   function(GLenum target, GLenum internalformat, GLboolean sink) PFNGLMINMAXEXTPROC;
typedef void   function(GLenum target) PFNGLRESETHISTOGRAMEXTPROC;
typedef void   function(GLenum target) PFNGLRESETMINMAXEXTPROC;
 extern   PFNGLGETHISTOGRAMEXTPROC pglGetHistogramEXT;
 extern   PFNGLGETHISTOGRAMPARAMETERFVEXTPROC pglGetHistogramParameterfvEXT;
 extern   PFNGLGETHISTOGRAMPARAMETERIVEXTPROC pglGetHistogramParameterivEXT;
 extern   PFNGLGETMINMAXEXTPROC pglGetMinmaxEXT;
 extern   PFNGLGETMINMAXPARAMETERFVEXTPROC pglGetMinmaxParameterfvEXT;
 extern   PFNGLGETMINMAXPARAMETERIVEXTPROC pglGetMinmaxParameterivEXT;
 extern   PFNGLHISTOGRAMEXTPROC pglHistogramEXT;
 extern   PFNGLMINMAXEXTPROC pglMinmaxEXT;
 extern   PFNGLRESETHISTOGRAMEXTPROC pglResetHistogramEXT;
 extern   PFNGLRESETMINMAXEXTPROC pglResetMinmaxEXT;
alias pglGetHistogramEXT glGetHistogramEXT;
alias pglGetHistogramParameterfvEXT glGetHistogramParameterfvEXT;
alias pglGetHistogramParameterivEXT glGetHistogramParameterivEXT;
alias pglGetMinmaxEXT glGetMinmaxEXT;
alias pglGetMinmaxParameterfvEXT glGetMinmaxParameterfvEXT;
alias pglGetMinmaxParameterivEXT glGetMinmaxParameterivEXT;
alias pglHistogramEXT glHistogramEXT;
alias pglMinmaxEXT glMinmaxEXT;
alias pglResetHistogramEXT glResetHistogramEXT;
alias pglResetMinmaxEXT glResetMinmaxEXT;
//#endif ;

//GL_EXT_convolution

//#ifndef GL_EXT_convolution;
const uint  GL_EXT_convolution = 1;
const uint  __GLEE_GL_EXT_convolution = 1;
//constants
const uint  GL_CONVOLUTION_1D_EXT                              = 0x8010;
const uint  GL_CONVOLUTION_2D_EXT                              = 0x8011;
const uint  GL_SEPARABLE_2D_EXT                                = 0x8012;
const uint  GL_CONVOLUTION_BORDER_MODE_EXT                     = 0x8013;
const uint  GL_CONVOLUTION_FILTER_SCALE_EXT                    = 0x8014;
const uint  GL_CONVOLUTION_FILTER_BIAS_EXT                     = 0x8015;
const uint  GL_REDUCE_EXT                                      = 0x8016;
const uint  GL_CONVOLUTION_FORMAT_EXT                          = 0x8017;
const uint  GL_CONVOLUTION_WIDTH_EXT                           = 0x8018;
const uint  GL_CONVOLUTION_HEIGHT_EXT                          = 0x8019;
const uint  GL_MAX_CONVOLUTION_WIDTH_EXT                       = 0x801A;
const uint  GL_MAX_CONVOLUTION_HEIGHT_EXT                      = 0x801B;
const uint  GL_POST_CONVOLUTION_RED_SCALE_EXT                  = 0x801C;
const uint  GL_POST_CONVOLUTION_GREEN_SCALE_EXT                = 0x801D;
const uint  GL_POST_CONVOLUTION_BLUE_SCALE_EXT                 = 0x801E;
const uint  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT                = 0x801F;
const uint  GL_POST_CONVOLUTION_RED_BIAS_EXT                   = 0x8020;
const uint  GL_POST_CONVOLUTION_GREEN_BIAS_EXT                 = 0x8021;
const uint  GL_POST_CONVOLUTION_BLUE_BIAS_EXT                  = 0x8022;
const uint  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT                 = 0x8023;
typedef void   function(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, GLvoid *image) PFNGLCONVOLUTIONFILTER1DEXTPROC;
typedef void   function(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *image) PFNGLCONVOLUTIONFILTER2DEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat params) PFNGLCONVOLUTIONPARAMETERFEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLCONVOLUTIONPARAMETERFVEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLint params) PFNGLCONVOLUTIONPARAMETERIEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLCONVOLUTIONPARAMETERIVEXTPROC;
typedef void   function(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC;
typedef void   function(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height) PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC;
typedef void   function(GLenum target, GLenum format, GLenum type, GLvoid *image) PFNGLGETCONVOLUTIONFILTEREXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC;
typedef void   function(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span) PFNGLGETSEPARABLEFILTEREXTPROC;
typedef void   function(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *row, GLvoid *column) PFNGLSEPARABLEFILTER2DEXTPROC;
 extern   PFNGLCONVOLUTIONFILTER1DEXTPROC pglConvolutionFilter1DEXT;
 extern   PFNGLCONVOLUTIONFILTER2DEXTPROC pglConvolutionFilter2DEXT;
 extern   PFNGLCONVOLUTIONPARAMETERFEXTPROC pglConvolutionParameterfEXT;
 extern   PFNGLCONVOLUTIONPARAMETERFVEXTPROC pglConvolutionParameterfvEXT;
 extern   PFNGLCONVOLUTIONPARAMETERIEXTPROC pglConvolutionParameteriEXT;
 extern   PFNGLCONVOLUTIONPARAMETERIVEXTPROC pglConvolutionParameterivEXT;
 extern   PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC pglCopyConvolutionFilter1DEXT;
 extern   PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC pglCopyConvolutionFilter2DEXT;
 extern   PFNGLGETCONVOLUTIONFILTEREXTPROC pglGetConvolutionFilterEXT;
 extern   PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC pglGetConvolutionParameterfvEXT;
 extern   PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC pglGetConvolutionParameterivEXT;
 extern   PFNGLGETSEPARABLEFILTEREXTPROC pglGetSeparableFilterEXT;
 extern   PFNGLSEPARABLEFILTER2DEXTPROC pglSeparableFilter2DEXT;
alias pglConvolutionFilter1DEXT glConvolutionFilter1DEXT;
alias pglConvolutionFilter2DEXT glConvolutionFilter2DEXT;
alias pglConvolutionParameterfEXT glConvolutionParameterfEXT;
alias pglConvolutionParameterfvEXT glConvolutionParameterfvEXT;
alias pglConvolutionParameteriEXT glConvolutionParameteriEXT;
alias pglConvolutionParameterivEXT glConvolutionParameterivEXT;
alias pglCopyConvolutionFilter1DEXT glCopyConvolutionFilter1DEXT;
alias pglCopyConvolutionFilter2DEXT glCopyConvolutionFilter2DEXT;
alias pglGetConvolutionFilterEXT glGetConvolutionFilterEXT;
alias pglGetConvolutionParameterfvEXT glGetConvolutionParameterfvEXT;
alias pglGetConvolutionParameterivEXT glGetConvolutionParameterivEXT;
alias pglGetSeparableFilterEXT glGetSeparableFilterEXT;
alias pglSeparableFilter2DEXT glSeparableFilter2DEXT;
//#endif ;

//GL_SGI_color_matrix

//#ifndef GL_SGI_color_matrix;
const uint  GL_SGI_color_matrix = 1;
const uint  __GLEE_GL_SGI_color_matrix = 1;
//constants
const uint  GL_COLOR_MATRIX_SGI                                = 0x80B1;
const uint  GL_COLOR_MATRIX_STACK_DEPTH_SGI                    = 0x80B2;
const uint  GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI                = 0x80B3;
const uint  GL_POST_COLOR_MATRIX_RED_SCALE_SGI                 = 0x80B4;
const uint  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI               = 0x80B5;
const uint  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI                = 0x80B6;
const uint  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI               = 0x80B7;
const uint  GL_POST_COLOR_MATRIX_RED_BIAS_SGI                  = 0x80B8;
const uint  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI                = 0x80B9;
const uint  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI                 = 0x80BA;
const uint  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI                = 0x80BB;
//#endif ;

//GL_SGI_color_table

//#ifndef GL_SGI_color_table;
const uint  GL_SGI_color_table = 1;
const uint  __GLEE_GL_SGI_color_table = 1;
//constants
const uint  GL_COLOR_TABLE_SGI                                 = 0x80D0;
const uint  GL_POST_CONVOLUTION_COLOR_TABLE_SGI                = 0x80D1;
const uint  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI               = 0x80D2;
const uint  GL_PROXY_COLOR_TABLE_SGI                           = 0x80D3;
const uint  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI          = 0x80D4;
const uint  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI         = 0x80D5;
const uint  GL_COLOR_TABLE_SCALE_SGI                           = 0x80D6;
const uint  GL_COLOR_TABLE_BIAS_SGI                            = 0x80D7;
const uint  GL_COLOR_TABLE_FORMAT_SGI                          = 0x80D8;
const uint  GL_COLOR_TABLE_WIDTH_SGI                           = 0x80D9;
const uint  GL_COLOR_TABLE_RED_SIZE_SGI                        = 0x80DA;
const uint  GL_COLOR_TABLE_GREEN_SIZE_SGI                      = 0x80DB;
const uint  GL_COLOR_TABLE_BLUE_SIZE_SGI                       = 0x80DC;
const uint  GL_COLOR_TABLE_ALPHA_SIZE_SGI                      = 0x80DD;
const uint  GL_COLOR_TABLE_LUMINANCE_SIZE_SGI                  = 0x80DE;
const uint  GL_COLOR_TABLE_INTENSITY_SIZE_SGI                  = 0x80DF;
typedef void   function(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, GLvoid *table) PFNGLCOLORTABLESGIPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLCOLORTABLEPARAMETERFVSGIPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLCOLORTABLEPARAMETERIVSGIPROC;
typedef void   function(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width) PFNGLCOPYCOLORTABLESGIPROC;
typedef void   function(GLenum target, GLenum format, GLenum type, GLvoid *table) PFNGLGETCOLORTABLESGIPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETCOLORTABLEPARAMETERFVSGIPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETCOLORTABLEPARAMETERIVSGIPROC;
 extern   PFNGLCOLORTABLESGIPROC pglColorTableSGI;
 extern   PFNGLCOLORTABLEPARAMETERFVSGIPROC pglColorTableParameterfvSGI;
 extern   PFNGLCOLORTABLEPARAMETERIVSGIPROC pglColorTableParameterivSGI;
 extern   PFNGLCOPYCOLORTABLESGIPROC pglCopyColorTableSGI;
 extern   PFNGLGETCOLORTABLESGIPROC pglGetColorTableSGI;
 extern   PFNGLGETCOLORTABLEPARAMETERFVSGIPROC pglGetColorTableParameterfvSGI;
 extern   PFNGLGETCOLORTABLEPARAMETERIVSGIPROC pglGetColorTableParameterivSGI;
alias pglColorTableSGI glColorTableSGI;
alias pglColorTableParameterfvSGI glColorTableParameterfvSGI;
alias pglColorTableParameterivSGI glColorTableParameterivSGI;
alias pglCopyColorTableSGI glCopyColorTableSGI;
alias pglGetColorTableSGI glGetColorTableSGI;
alias pglGetColorTableParameterfvSGI glGetColorTableParameterfvSGI;
alias pglGetColorTableParameterivSGI glGetColorTableParameterivSGI;
//#endif ;

//GL_SGIS_pixel_texture

//#ifndef GL_SGIS_pixel_texture;
const uint  GL_SGIS_pixel_texture = 1;
const uint  __GLEE_GL_SGIS_pixel_texture = 1;
//constants
const uint  GL_PIXEL_TEXTURE_SGIS                              = 0x8353;
const uint  GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS                  = 0x8354;
const uint  GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS                = 0x8355;
const uint  GL_PIXEL_GROUP_COLOR_SGIS                          = 0x8356;
typedef void   function(GLenum pname, GLint param) PFNGLPIXELTEXGENPARAMETERISGISPROC;
typedef void   function(GLenum pname, GLint *params) PFNGLPIXELTEXGENPARAMETERIVSGISPROC;
typedef void   function(GLenum pname, GLfloat param) PFNGLPIXELTEXGENPARAMETERFSGISPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLPIXELTEXGENPARAMETERFVSGISPROC;
typedef void   function(GLenum pname, GLint *params) PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC;
 extern   PFNGLPIXELTEXGENPARAMETERISGISPROC pglPixelTexGenParameteriSGIS;
 extern   PFNGLPIXELTEXGENPARAMETERIVSGISPROC pglPixelTexGenParameterivSGIS;
 extern   PFNGLPIXELTEXGENPARAMETERFSGISPROC pglPixelTexGenParameterfSGIS;
 extern   PFNGLPIXELTEXGENPARAMETERFVSGISPROC pglPixelTexGenParameterfvSGIS;
 extern   PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC pglGetPixelTexGenParameterivSGIS;
 extern   PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC pglGetPixelTexGenParameterfvSGIS;
alias pglPixelTexGenParameteriSGIS glPixelTexGenParameteriSGIS;
alias pglPixelTexGenParameterivSGIS glPixelTexGenParameterivSGIS;
alias pglPixelTexGenParameterfSGIS glPixelTexGenParameterfSGIS;
alias pglPixelTexGenParameterfvSGIS glPixelTexGenParameterfvSGIS;
alias pglGetPixelTexGenParameterivSGIS glGetPixelTexGenParameterivSGIS;
alias pglGetPixelTexGenParameterfvSGIS glGetPixelTexGenParameterfvSGIS;
//#endif ;

//GL_SGIX_pixel_texture

//#ifndef GL_SGIX_pixel_texture;
const uint  GL_SGIX_pixel_texture = 1;
const uint  __GLEE_GL_SGIX_pixel_texture = 1;
//constants
const uint  GL_PIXEL_TEX_GEN_SGIX                              = 0x8139;
const uint  GL_PIXEL_TEX_GEN_MODE_SGIX                         = 0x832B;
typedef void   function(GLenum mode) PFNGLPIXELTEXGENSGIXPROC;
 extern   PFNGLPIXELTEXGENSGIXPROC pglPixelTexGenSGIX;
alias  pglPixelTexGenSGIX glPixelTexGenSGIX;
//#endif ;

//GL_SGIS_texture4D

//#ifndef GL_SGIS_texture4D;
const uint  GL_SGIS_texture4D = 1;
const uint  __GLEE_GL_SGIS_texture4D = 1;
//constants
const uint  GL_PACK_SKIP_VOLUMES_SGIS                          = 0x8130;
const uint  GL_PACK_IMAGE_DEPTH_SGIS                           = 0x8131;
const uint  GL_UNPACK_SKIP_VOLUMES_SGIS                        = 0x8132;
const uint  GL_UNPACK_IMAGE_DEPTH_SGIS                         = 0x8133;
const uint  GL_TEXTURE_4D_SGIS                                 = 0x8134;
const uint  GL_PROXY_TEXTURE_4D_SGIS                           = 0x8135;
const uint  GL_TEXTURE_4DSIZE_SGIS                             = 0x8136;
const uint  GL_TEXTURE_WRAP_Q_SGIS                             = 0x8137;
const uint  GL_MAX_4D_TEXTURE_SIZE_SGIS                        = 0x8138;
const uint  GL_TEXTURE_4D_BINDING_SGIS                         = 0x814F;
typedef void   function(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXIMAGE4DSGISPROC;
typedef void   function(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, GLvoid *pixels) PFNGLTEXSUBIMAGE4DSGISPROC;
 extern   PFNGLTEXIMAGE4DSGISPROC pglTexImage4DSGIS;
 extern   PFNGLTEXSUBIMAGE4DSGISPROC pglTexSubImage4DSGIS;
alias pglTexImage4DSGIS glTexImage4DSGIS;
alias pglTexSubImage4DSGIS glTexSubImage4DSGIS;
//#endif ;

//GL_SGI_texture_color_table

//#ifndef GL_SGI_texture_color_table;
const uint  GL_SGI_texture_color_table = 1;
const uint  __GLEE_GL_SGI_texture_color_table = 1;
//constants
const uint  GL_TEXTURE_COLOR_TABLE_SGI                         = 0x80BC;
const uint  GL_PROXY_TEXTURE_COLOR_TABLE_SGI                   = 0x80BD;
//#endif ;

//GL_EXT_cmyka

//#ifndef GL_EXT_cmyka;
const uint  GL_EXT_cmyka = 1;
const uint  __GLEE_GL_EXT_cmyka = 1;
//constants
const uint  GL_CMYK_EXT                                        = 0x800C;
const uint  GL_CMYKA_EXT                                       = 0x800D;
const uint  GL_PACK_CMYK_HINT_EXT                              = 0x800E;
const uint  GL_UNPACK_CMYK_HINT_EXT                            = 0x800F;
//#endif ;

//GL_EXT_texture_object

//#ifndef GL_EXT_texture_object;
const uint  GL_EXT_texture_object = 1;
const uint  __GLEE_GL_EXT_texture_object = 1;
//constants
const uint  GL_TEXTURE_PRIORITY_EXT                            = 0x8066;
const uint  GL_TEXTURE_RESIDENT_EXT                            = 0x8067;
const uint  GL_TEXTURE_1D_BINDING_EXT                          = 0x8068;
const uint  GL_TEXTURE_2D_BINDING_EXT                          = 0x8069;
const uint  GL_TEXTURE_3D_BINDING_EXT                          = 0x806A;
typedef GLboolean   function(GLsizei n, GLuint *textures, GLboolean *residences) PFNGLARETEXTURESRESIDENTEXTPROC;
typedef void   function(GLenum target, GLuint texture) PFNGLBINDTEXTUREEXTPROC;
typedef void   function(GLsizei n, GLuint *textures) PFNGLDELETETEXTURESEXTPROC;
typedef void   function(GLsizei n, GLuint *textures) PFNGLGENTEXTURESEXTPROC;
typedef GLboolean   function(GLuint texture) PFNGLISTEXTUREEXTPROC;
typedef void   function(GLsizei n, GLuint *textures, GLclampf *priorities) PFNGLPRIORITIZETEXTURESEXTPROC;
 extern   PFNGLARETEXTURESRESIDENTEXTPROC pglAreTexturesResidentEXT;
 extern   PFNGLBINDTEXTUREEXTPROC pglBindTextureEXT;
 extern   PFNGLDELETETEXTURESEXTPROC pglDeleteTexturesEXT;
 extern   PFNGLGENTEXTURESEXTPROC pglGenTexturesEXT;
 extern   PFNGLISTEXTUREEXTPROC pglIsTextureEXT;
 extern   PFNGLPRIORITIZETEXTURESEXTPROC pglPrioritizeTexturesEXT;
alias pglAreTexturesResidentEXT glAreTexturesResidentEXT;
alias pglBindTextureEXT glBindTextureEXT;
alias pglDeleteTexturesEXT glDeleteTexturesEXT;
alias pglGenTexturesEXT glGenTexturesEXT;
alias pglIsTextureEXT glIsTextureEXT;
alias pglPrioritizeTexturesEXT glPrioritizeTexturesEXT;
//#endif ;

//GL_SGIS_detail_texture

//#ifndef GL_SGIS_detail_texture;
const uint  GL_SGIS_detail_texture = 1;
const uint  __GLEE_GL_SGIS_detail_texture = 1;
//constants
const uint  GL_DETAIL_TEXTURE_2D_SGIS                          = 0x8095;
const uint  GL_DETAIL_TEXTURE_2D_BINDING_SGIS                  = 0x8096;
const uint  GL_LINEAR_DETAIL_SGIS                              = 0x8097;
const uint  GL_LINEAR_DETAIL_ALPHA_SGIS                        = 0x8098;
const uint  GL_LINEAR_DETAIL_COLOR_SGIS                        = 0x8099;
const uint  GL_DETAIL_TEXTURE_LEVEL_SGIS                       = 0x809A;
const uint  GL_DETAIL_TEXTURE_MODE_SGIS                        = 0x809B;
const uint  GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS                 = 0x809C;
typedef void   function(GLenum target, GLsizei n, GLfloat *points) PFNGLDETAILTEXFUNCSGISPROC;
typedef void   function(GLenum target, GLfloat *points) PFNGLGETDETAILTEXFUNCSGISPROC;
 extern   PFNGLDETAILTEXFUNCSGISPROC pglDetailTexFuncSGIS;
 extern   PFNGLGETDETAILTEXFUNCSGISPROC pglGetDetailTexFuncSGIS;
alias pglDetailTexFuncSGIS glDetailTexFuncSGIS;
alias pglGetDetailTexFuncSGIS glGetDetailTexFuncSGIS;
//#endif ;

//GL_SGIS_sharpen_texture

//#ifndef GL_SGIS_sharpen_texture;
const uint  GL_SGIS_sharpen_texture = 1;
const uint  __GLEE_GL_SGIS_sharpen_texture = 1;
//constants
const uint  GL_LINEAR_SHARPEN_SGIS                             = 0x80AD;
const uint  GL_LINEAR_SHARPEN_ALPHA_SGIS                       = 0x80AE;
const uint  GL_LINEAR_SHARPEN_COLOR_SGIS                       = 0x80AF;
const uint  GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS                = 0x80B0;
typedef void   function(GLenum target, GLsizei n, GLfloat *points) PFNGLSHARPENTEXFUNCSGISPROC;
typedef void   function(GLenum target, GLfloat *points) PFNGLGETSHARPENTEXFUNCSGISPROC;
 extern   PFNGLSHARPENTEXFUNCSGISPROC pglSharpenTexFuncSGIS;
 extern   PFNGLGETSHARPENTEXFUNCSGISPROC pglGetSharpenTexFuncSGIS;
alias pglSharpenTexFuncSGIS glSharpenTexFuncSGIS;
alias pglGetSharpenTexFuncSGIS glGetSharpenTexFuncSGIS;
//#endif ;

//GL_EXT_packed_pixels

//#ifndef GL_EXT_packed_pixels;
const uint  GL_EXT_packed_pixels = 1;
const uint  __GLEE_GL_EXT_packed_pixels = 1;
//constants
const uint  GL_UNSIGNED_BYTE_3_3_2_EXT                         = 0x8032;
const uint  GL_UNSIGNED_SHORT_4_4_4_4_EXT                      = 0x8033;
const uint  GL_UNSIGNED_SHORT_5_5_5_1_EXT                      = 0x8034;
const uint  GL_UNSIGNED_INT_8_8_8_8_EXT                        = 0x8035;
const uint  GL_UNSIGNED_INT_10_10_10_2_EXT                     = 0x8036;
//#endif ;

//GL_SGIS_texture_lod

//#ifndef GL_SGIS_texture_lod;
const uint  GL_SGIS_texture_lod = 1;
const uint  __GLEE_GL_SGIS_texture_lod = 1;
//constants
const uint  GL_TEXTURE_MIN_LOD_SGIS                            = 0x813A;
const uint  GL_TEXTURE_MAX_LOD_SGIS                            = 0x813B;
const uint  GL_TEXTURE_BASE_LEVEL_SGIS                         = 0x813C;
const uint  GL_TEXTURE_MAX_LEVEL_SGIS                          = 0x813D;
//#endif ;

//GL_SGIS_multisample

//#ifndef GL_SGIS_multisample;
const uint  GL_SGIS_multisample = 1;
const uint  __GLEE_GL_SGIS_multisample = 1;
//constants
const uint  GL_MULTISAMPLE_SGIS                                = 0x809D;
const uint  GL_SAMPLE_ALPHA_TO_MASK_SGIS                       = 0x809E;
const uint  GL_SAMPLE_ALPHA_TO_ONE_SGIS                        = 0x809F;
const uint  GL_SAMPLE_MASK_SGIS                                = 0x80A0;
const uint  GL_1PASS_SGIS                                      = 0x80A1;
const uint  GL_2PASS_0_SGIS                                    = 0x80A2;
const uint  GL_2PASS_1_SGIS                                    = 0x80A3;
const uint  GL_4PASS_0_SGIS                                    = 0x80A4;
const uint  GL_4PASS_1_SGIS                                    = 0x80A5;
const uint  GL_4PASS_2_SGIS                                    = 0x80A6;
const uint  GL_4PASS_3_SGIS                                    = 0x80A7;
const uint  GL_SAMPLE_BUFFERS_SGIS                             = 0x80A8;
const uint  GL_SAMPLES_SGIS                                    = 0x80A9;
const uint  GL_SAMPLE_MASK_VALUE_SGIS                          = 0x80AA;
const uint  GL_SAMPLE_MASK_INVERT_SGIS                         = 0x80AB;
const uint  GL_SAMPLE_PATTERN_SGIS                             = 0x80AC;
typedef void   function(GLclampf value, GLboolean invert) PFNGLSAMPLEMASKSGISPROC;
typedef void   function(GLenum pattern) PFNGLSAMPLEPATTERNSGISPROC;
 extern   PFNGLSAMPLEMASKSGISPROC pglSampleMaskSGIS;
 extern   PFNGLSAMPLEPATTERNSGISPROC pglSamplePatternSGIS;
alias pglSampleMaskSGIS glSampleMaskSGIS;
alias pglSamplePatternSGIS glSamplePatternSGIS;
//#endif ;

//GL_EXT_rescale_normal

//#ifndef GL_EXT_rescale_normal;
const uint  GL_EXT_rescale_normal = 1;
const uint  __GLEE_GL_EXT_rescale_normal = 1;
//constants
const uint  GL_RESCALE_NORMAL_EXT                              = 0x803A;
//#endif ;

//GL_EXT_vertex_array

//#ifndef GL_EXT_vertex_array;
const uint  GL_EXT_vertex_array = 1;
const uint  __GLEE_GL_EXT_vertex_array = 1;
//constants
const uint  GL_VERTEX_ARRAY_EXT                                = 0x8074;
const uint  GL_NORMAL_ARRAY_EXT                                = 0x8075;
const uint  GL_COLOR_ARRAY_EXT                                 = 0x8076;
const uint  GL_INDEX_ARRAY_EXT                                 = 0x8077;
const uint  GL_TEXTURE_COORD_ARRAY_EXT                         = 0x8078;
const uint  GL_EDGE_FLAG_ARRAY_EXT                             = 0x8079;
const uint  GL_VERTEX_ARRAY_SIZE_EXT                           = 0x807A;
const uint  GL_VERTEX_ARRAY_TYPE_EXT                           = 0x807B;
const uint  GL_VERTEX_ARRAY_STRIDE_EXT                         = 0x807C;
const uint  GL_VERTEX_ARRAY_COUNT_EXT                          = 0x807D;
const uint  GL_NORMAL_ARRAY_TYPE_EXT                           = 0x807E;
const uint  GL_NORMAL_ARRAY_STRIDE_EXT                         = 0x807F;
const uint  GL_NORMAL_ARRAY_COUNT_EXT                          = 0x8080;
const uint  GL_COLOR_ARRAY_SIZE_EXT                            = 0x8081;
const uint  GL_COLOR_ARRAY_TYPE_EXT                            = 0x8082;
const uint  GL_COLOR_ARRAY_STRIDE_EXT                          = 0x8083;
const uint  GL_COLOR_ARRAY_COUNT_EXT                           = 0x8084;
const uint  GL_INDEX_ARRAY_TYPE_EXT                            = 0x8085;
const uint  GL_INDEX_ARRAY_STRIDE_EXT                          = 0x8086;
const uint  GL_INDEX_ARRAY_COUNT_EXT                           = 0x8087;
const uint  GL_TEXTURE_COORD_ARRAY_SIZE_EXT                    = 0x8088;
const uint  GL_TEXTURE_COORD_ARRAY_TYPE_EXT                    = 0x8089;
const uint  GL_TEXTURE_COORD_ARRAY_STRIDE_EXT                  = 0x808A;
const uint  GL_TEXTURE_COORD_ARRAY_COUNT_EXT                   = 0x808B;
const uint  GL_EDGE_FLAG_ARRAY_STRIDE_EXT                      = 0x808C;
const uint  GL_EDGE_FLAG_ARRAY_COUNT_EXT                       = 0x808D;
const uint  GL_VERTEX_ARRAY_POINTER_EXT                        = 0x808E;
const uint  GL_NORMAL_ARRAY_POINTER_EXT                        = 0x808F;
const uint  GL_COLOR_ARRAY_POINTER_EXT                         = 0x8090;
const uint  GL_INDEX_ARRAY_POINTER_EXT                         = 0x8091;
const uint  GL_TEXTURE_COORD_ARRAY_POINTER_EXT                 = 0x8092;
const uint  GL_EDGE_FLAG_ARRAY_POINTER_EXT                     = 0x8093;
typedef void   function(GLint i) PFNGLARRAYELEMENTEXTPROC;
typedef void   function(GLint size, GLenum type, GLsizei stride, GLsizei count, GLvoid *pointer) PFNGLCOLORPOINTEREXTPROC;
typedef void   function(GLenum mode, GLint first, GLsizei count) PFNGLDRAWARRAYSEXTPROC;
typedef void   function(GLsizei stride, GLsizei count, GLboolean *pointer) PFNGLEDGEFLAGPOINTEREXTPROC;
typedef void   function(GLenum pname, GLvoid* *params) PFNGLGETPOINTERVEXTPROC;
typedef void   function(GLenum type, GLsizei stride, GLsizei count, GLvoid *pointer) PFNGLINDEXPOINTEREXTPROC;
typedef void   function(GLenum type, GLsizei stride, GLsizei count, GLvoid *pointer) PFNGLNORMALPOINTEREXTPROC;
typedef void   function(GLint size, GLenum type, GLsizei stride, GLsizei count, GLvoid *pointer) PFNGLTEXCOORDPOINTEREXTPROC;
typedef void   function(GLint size, GLenum type, GLsizei stride, GLsizei count, GLvoid *pointer) PFNGLVERTEXPOINTEREXTPROC;
 extern   PFNGLARRAYELEMENTEXTPROC pglArrayElementEXT;
 extern   PFNGLCOLORPOINTEREXTPROC pglColorPointerEXT;
 extern   PFNGLDRAWARRAYSEXTPROC pglDrawArraysEXT;
 extern   PFNGLEDGEFLAGPOINTEREXTPROC pglEdgeFlagPointerEXT;
 extern   PFNGLGETPOINTERVEXTPROC pglGetPointervEXT;
 extern   PFNGLINDEXPOINTEREXTPROC pglIndexPointerEXT;
 extern   PFNGLNORMALPOINTEREXTPROC pglNormalPointerEXT;
 extern   PFNGLTEXCOORDPOINTEREXTPROC pglTexCoordPointerEXT;
 extern   PFNGLVERTEXPOINTEREXTPROC pglVertexPointerEXT;
alias pglArrayElementEXT glArrayElementEXT;
alias pglColorPointerEXT glColorPointerEXT;
alias pglDrawArraysEXT glDrawArraysEXT;
alias pglEdgeFlagPointerEXT glEdgeFlagPointerEXT;
alias pglGetPointervEXT glGetPointervEXT;
alias pglIndexPointerEXT glIndexPointerEXT;
alias pglNormalPointerEXT glNormalPointerEXT;
alias pglTexCoordPointerEXT glTexCoordPointerEXT;
alias pglVertexPointerEXT glVertexPointerEXT;
//#endif ;

//GL_EXT_misc_attribute

//#ifndef GL_EXT_misc_attribute;
const uint GL_EXT_misc_attribute = 1;
const uint __GLEE_GL_EXT_misc_attribute = 1;
//constants
//#endif ;

//GL_SGIS_generate_mipmap

//#ifndef GL_SGIS_generate_mipmap;
const uint  GL_SGIS_generate_mipmap = 1;
const uint  __GLEE_GL_SGIS_generate_mipmap = 1;
//constants
const uint  GL_GENERATE_MIPMAP_SGIS                            = 0x8191;
const uint  GL_GENERATE_MIPMAP_HINT_SGIS                       = 0x8192;
//#endif ;

//GL_SGIX_clipmap

//#ifndef GL_SGIX_clipmap;
const uint  GL_SGIX_clipmap = 1;
const uint  __GLEE_GL_SGIX_clipmap = 1;
//constants
const uint  GL_LINEAR_CLIPMAP_LINEAR_SGIX                      = 0x8170;
const uint  GL_TEXTURE_CLIPMAP_CENTER_SGIX                     = 0x8171;
const uint  GL_TEXTURE_CLIPMAP_FRAME_SGIX                      = 0x8172;
const uint  GL_TEXTURE_CLIPMAP_OFFSET_SGIX                     = 0x8173;
const uint  GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX              = 0x8174;
const uint  GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX                 = 0x8175;
const uint  GL_TEXTURE_CLIPMAP_DEPTH_SGIX                      = 0x8176;
const uint  GL_MAX_CLIPMAP_DEPTH_SGIX                          = 0x8177;
const uint  GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX                  = 0x8178;
const uint  GL_NEAREST_CLIPMAP_NEAREST_SGIX                    = 0x844D;
const uint  GL_NEAREST_CLIPMAP_LINEAR_SGIX                     = 0x844E;
const uint  GL_LINEAR_CLIPMAP_NEAREST_SGIX                     = 0x844F;
//#endif ;

//GL_SGIX_shadow

//#ifndef GL_SGIX_shadow;
const uint  GL_SGIX_shadow = 1;
const uint  __GLEE_GL_SGIX_shadow = 1;
//constants
const uint  GL_TEXTURE_COMPARE_SGIX                            = 0x819A;
const uint  GL_TEXTURE_COMPARE_OPERATOR_SGIX                   = 0x819B;
const uint  GL_TEXTURE_LEQUAL_R_SGIX                           = 0x819C;
const uint  GL_TEXTURE_GEQUAL_R_SGIX                           = 0x819D;
//#endif ;

//GL_SGIS_texture_edge_clamp

//#ifndef GL_SGIS_texture_edge_clamp;
const uint  GL_SGIS_texture_edge_clamp = 1;
const uint  __GLEE_GL_SGIS_texture_edge_clamp = 1;
//constants
const uint  GL_CLAMP_TO_EDGE_SGIS                              = 0x812F;
//#endif ;

//GL_EXT_blend_minmax

//#ifndef GL_EXT_blend_minmax;
const uint  GL_EXT_blend_minmax = 1;
const uint  __GLEE_GL_EXT_blend_minmax = 1;
//constants
const uint  GL_FUNC_ADD_EXT                                    = 0x8006;
const uint  GL_MIN_EXT                                         = 0x8007;
const uint  GL_MAX_EXT                                         = 0x8008;
const uint  GL_BLEND_EQUATION_EXT                              = 0x8009;
typedef void   function(GLenum mode) PFNGLBLENDEQUATIONEXTPROC;
 extern   PFNGLBLENDEQUATIONEXTPROC pglBlendEquationEXT;
alias  pglBlendEquationEXT glBlendEquationEXT;
//#endif ;

//GL_EXT_blend_subtract

//#ifndef GL_EXT_blend_subtract;
const uint  GL_EXT_blend_subtract = 1;
const uint  __GLEE_GL_EXT_blend_subtract = 1;
//constants
const uint  GL_FUNC_SUBTRACT_EXT                               = 0x800A;
const uint  GL_FUNC_REVERSE_SUBTRACT_EXT                       = 0x800B;
//#endif ;

//GL_EXT_blend_logic_op

//#ifndef GL_EXT_blend_logic_op;
const uint  GL_EXT_blend_logic_op = 1;
const uint  __GLEE_GL_EXT_blend_logic_op = 1;
//constants
//#endif ;

//GL_SGIX_interlace

//#ifndef GL_SGIX_interlace;
const uint  GL_SGIX_interlace = 1;
const uint  __GLEE_GL_SGIX_interlace = 1;
//constants
const uint  GL_INTERLACE_SGIX                                  = 0x8094;
//#endif ;

//GL_SGIX_pixel_tiles

//#ifndef GL_SGIX_pixel_tiles;
const uint  GL_SGIX_pixel_tiles = 1;
const uint  __GLEE_GL_SGIX_pixel_tiles = 1;
//constants
const uint  GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX                  = 0x813E;
const uint  GL_PIXEL_TILE_CACHE_INCREMENT_SGIX                 = 0x813F;
const uint  GL_PIXEL_TILE_WIDTH_SGIX                           = 0x8140;
const uint  GL_PIXEL_TILE_HEIGHT_SGIX                          = 0x8141;
const uint  GL_PIXEL_TILE_GRID_WIDTH_SGIX                      = 0x8142;
const uint  GL_PIXEL_TILE_GRID_HEIGHT_SGIX                     = 0x8143;
const uint  GL_PIXEL_TILE_GRID_DEPTH_SGIX                      = 0x8144;
const uint  GL_PIXEL_TILE_CACHE_SIZE_SGIX                      = 0x8145;
//#endif ;

//GL_SGIS_texture_select

//#ifndef GL_SGIS_texture_select;
const uint  GL_SGIS_texture_select = 1;
const uint  __GLEE_GL_SGIS_texture_select = 1;
//constants
const uint  GL_DUAL_ALPHA4_SGIS                                = 0x8110;
const uint  GL_DUAL_ALPHA8_SGIS                                = 0x8111;
const uint  GL_DUAL_ALPHA12_SGIS                               = 0x8112;
const uint  GL_DUAL_ALPHA16_SGIS                               = 0x8113;
const uint  GL_DUAL_LUMINANCE4_SGIS                            = 0x8114;
const uint  GL_DUAL_LUMINANCE8_SGIS                            = 0x8115;
const uint  GL_DUAL_LUMINANCE12_SGIS                           = 0x8116;
const uint  GL_DUAL_LUMINANCE16_SGIS                           = 0x8117;
const uint  GL_DUAL_INTENSITY4_SGIS                            = 0x8118;
const uint  GL_DUAL_INTENSITY8_SGIS                            = 0x8119;
const uint  GL_DUAL_INTENSITY12_SGIS                           = 0x811A;
const uint  GL_DUAL_INTENSITY16_SGIS                           = 0x811B;
const uint  GL_DUAL_LUMINANCE_ALPHA4_SGIS                      = 0x811C;
const uint  GL_DUAL_LUMINANCE_ALPHA8_SGIS                      = 0x811D;
const uint  GL_QUAD_ALPHA4_SGIS                                = 0x811E;
const uint  GL_QUAD_ALPHA8_SGIS                                = 0x811F;
const uint  GL_QUAD_LUMINANCE4_SGIS                            = 0x8120;
const uint  GL_QUAD_LUMINANCE8_SGIS                            = 0x8121;
const uint  GL_QUAD_INTENSITY4_SGIS                            = 0x8122;
const uint  GL_QUAD_INTENSITY8_SGIS                            = 0x8123;
const uint  GL_DUAL_TEXTURE_SELECT_SGIS                        = 0x8124;
const uint  GL_QUAD_TEXTURE_SELECT_SGIS                        = 0x8125;
//#endif ;

//GL_SGIX_sprite

//#ifndef GL_SGIX_sprite;
const uint  GL_SGIX_sprite = 1;
const uint  __GLEE_GL_SGIX_sprite = 1;
//constants
const uint  GL_SPRITE_SGIX                                     = 0x8148;
const uint  GL_SPRITE_MODE_SGIX                                = 0x8149;
const uint  GL_SPRITE_AXIS_SGIX                                = 0x814A;
const uint  GL_SPRITE_TRANSLATION_SGIX                         = 0x814B;
const uint  GL_SPRITE_AXIAL_SGIX                               = 0x814C;
const uint  GL_SPRITE_OBJECT_ALIGNED_SGIX                      = 0x814D;
const uint  GL_SPRITE_EYE_ALIGNED_SGIX                         = 0x814E;
typedef void   function(GLenum pname, GLfloat param) PFNGLSPRITEPARAMETERFSGIXPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLSPRITEPARAMETERFVSGIXPROC;
typedef void   function(GLenum pname, GLint param) PFNGLSPRITEPARAMETERISGIXPROC;
typedef void   function(GLenum pname, GLint *params) PFNGLSPRITEPARAMETERIVSGIXPROC;
 extern   PFNGLSPRITEPARAMETERFSGIXPROC pglSpriteParameterfSGIX;
 extern   PFNGLSPRITEPARAMETERFVSGIXPROC pglSpriteParameterfvSGIX;
 extern   PFNGLSPRITEPARAMETERISGIXPROC pglSpriteParameteriSGIX;
 extern   PFNGLSPRITEPARAMETERIVSGIXPROC pglSpriteParameterivSGIX;
alias pglSpriteParameterfSGIX glSpriteParameterfSGIX;
alias pglSpriteParameterfvSGIX glSpriteParameterfvSGIX;
alias pglSpriteParameteriSGIX glSpriteParameteriSGIX;
alias pglSpriteParameterivSGIX glSpriteParameterivSGIX;
//#endif ;

//GL_SGIX_texture_multi_buffer

//#ifndef GL_SGIX_texture_multi_buffer;
const uint  GL_SGIX_texture_multi_buffer = 1;
const uint  __GLEE_GL_SGIX_texture_multi_buffer = 1;
//constants
const uint  GL_TEXTURE_MULTI_BUFFER_HINT_SGIX                  = 0x812E;
//#endif ;

//GL_EXT_point_parameters

//#ifndef GL_EXT_point_parameters;
const uint  GL_EXT_point_parameters = 1;
const uint  __GLEE_GL_EXT_point_parameters = 1;
//constants
const uint  GL_POINT_SIZE_MIN_EXT                              = 0x8126;
const uint  GL_POINT_SIZE_MAX_EXT                              = 0x8127;
const uint  GL_POINT_FADE_THRESHOLD_SIZE_EXT                   = 0x8128;
const uint  GL_DISTANCE_ATTENUATION_EXT                        = 0x8129;
typedef void   function(GLenum pname, GLfloat param) PFNGLPOINTPARAMETERFEXTPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLPOINTPARAMETERFVEXTPROC;
 extern   PFNGLPOINTPARAMETERFEXTPROC pglPointParameterfEXT;
 extern   PFNGLPOINTPARAMETERFVEXTPROC pglPointParameterfvEXT;
alias pglPointParameterfEXT glPointParameterfEXT;
alias pglPointParameterfvEXT glPointParameterfvEXT;
//#endif ;

//GL_SGIS_point_parameters

//#ifndef GL_SGIS_point_parameters;
const uint  GL_SGIS_point_parameters = 1;
const uint  __GLEE_GL_SGIS_point_parameters = 1;
//constants
const uint  GL_POINT_SIZE_MIN_SGIS                             = 0x8126;
const uint  GL_POINT_SIZE_MAX_SGIS                             = 0x8127;
const uint  GL_POINT_FADE_THRESHOLD_SIZE_SGIS                  = 0x8128;
const uint  GL_DISTANCE_ATTENUATION_SGIS                       = 0x8129;
typedef void   function(GLenum pname, GLfloat param) PFNGLPOINTPARAMETERFSGISPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLPOINTPARAMETERFVSGISPROC;
 extern   PFNGLPOINTPARAMETERFSGISPROC pglPointParameterfSGIS;
 extern   PFNGLPOINTPARAMETERFVSGISPROC pglPointParameterfvSGIS;
alias pglPointParameterfSGIS glPointParameterfSGIS;
alias pglPointParameterfvSGIS glPointParameterfvSGIS;
//#endif ;

//GL_SGIX_instruments

//#ifndef GL_SGIX_instruments;
const uint GL_SGIX_instruments = 1;
const uint __GLEE_GL_SGIX_instruments = 1;
//constants
const uint GL_INSTRUMENT_BUFFER_POINTER_SGIX                  = 0x8180;
const uint GL_INSTRUMENT_MEASUREMENTS_SGIX                    = 0x8181;
typedef GLint   function() PFNGLGETINSTRUMENTSSGIXPROC;
typedef void   function(GLsizei size, GLint *buffer) PFNGLINSTRUMENTSBUFFERSGIXPROC;
typedef GLint   function(GLint *marker_p) PFNGLPOLLINSTRUMENTSSGIXPROC;
typedef void   function(GLint marker) PFNGLREADINSTRUMENTSSGIXPROC;
typedef void   function() PFNGLSTARTINSTRUMENTSSGIXPROC;
typedef void   function(GLint marker) PFNGLSTOPINSTRUMENTSSGIXPROC;
 extern   PFNGLGETINSTRUMENTSSGIXPROC pglGetInstrumentsSGIX;
 extern   PFNGLINSTRUMENTSBUFFERSGIXPROC pglInstrumentsBufferSGIX;
 extern   PFNGLPOLLINSTRUMENTSSGIXPROC pglPollInstrumentsSGIX;
 extern   PFNGLREADINSTRUMENTSSGIXPROC pglReadInstrumentsSGIX;
 extern   PFNGLSTARTINSTRUMENTSSGIXPROC pglStartInstrumentsSGIX;
 extern   PFNGLSTOPINSTRUMENTSSGIXPROC pglStopInstrumentsSGIX;
alias pglGetInstrumentsSGIX glGetInstrumentsSGIX;
alias pglInstrumentsBufferSGIX glInstrumentsBufferSGIX;
alias pglPollInstrumentsSGIX glPollInstrumentsSGIX;
alias pglReadInstrumentsSGIX glReadInstrumentsSGIX;
alias pglStartInstrumentsSGIX glStartInstrumentsSGIX;
alias pglStopInstrumentsSGIX glStopInstrumentsSGIX;
//#endif ;

//GL_SGIX_texture_scale_bias

//#ifndef GL_SGIX_texture_scale_bias;
const uint  GL_SGIX_texture_scale_bias = 1;
const uint  __GLEE_GL_SGIX_texture_scale_bias = 1;
//constants
const uint  GL_POST_TEXTURE_FILTER_BIAS_SGIX                   = 0x8179;
const uint  GL_POST_TEXTURE_FILTER_SCALE_SGIX                  = 0x817A;
const uint  GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX             = 0x817B;
const uint  GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX            = 0x817C;
//#endif ;

//GL_SGIX_framezoom

//#ifndef GL_SGIX_framezoom;
const uint  GL_SGIX_framezoom = 1;
const uint  __GLEE_GL_SGIX_framezoom = 1;
//constants
const uint  GL_FRAMEZOOM_SGIX                                  = 0x818B;
const uint  GL_FRAMEZOOM_FACTOR_SGIX                           = 0x818C;
const uint  GL_MAX_FRAMEZOOM_FACTOR_SGIX                       = 0x818D;
typedef void   function(GLint factor) PFNGLFRAMEZOOMSGIXPROC;
 extern   PFNGLFRAMEZOOMSGIXPROC pglFrameZoomSGIX;
alias pglFrameZoomSGIX glFrameZoomSGIX;
//#endif ;

//GL_SGIX_tag_sample_buffer

//#ifndef GL_SGIX_tag_sample_buffer;
const uint GL_SGIX_tag_sample_buffer = 1;
const uint __GLEE_GL_SGIX_tag_sample_buffer = 1;
//constants
typedef void   function() PFNGLTAGSAMPLEBUFFERSGIXPROC;
 extern   PFNGLTAGSAMPLEBUFFERSGIXPROC pglTagSampleBufferSGIX;
alias pglTagSampleBufferSGIX glTagSampleBufferSGIX;
//#endif ;

//GL_FfdMaskSGIX

//#ifndef GL_FfdMaskSGIX;
const uint  GL_FfdMaskSGIX = 1;
const uint  __GLEE_GL_FfdMaskSGIX = 1;
//constants
const uint  GL_TEXTURE_DEFORMATION_BIT_SGIX                    = 0x00000001;
const uint  GL_GEOMETRY_DEFORMATION_BIT_SGIX                   = 0x00000002;
//#endif ;

//GL_SGIX_polynomial_ffd

//#ifndef GL_SGIX_polynomial_ffd;
const uint  GL_SGIX_polynomial_ffd = 1;
const uint  __GLEE_GL_SGIX_polynomial_ffd = 1;
//constants
const uint  GL_GEOMETRY_DEFORMATION_SGIX                       = 0x8194;
const uint  GL_TEXTURE_DEFORMATION_SGIX                        = 0x8195;
const uint  GL_DEFORMATIONS_MASK_SGIX                          = 0x8196;
const uint  GL_MAX_DEFORMATION_ORDER_SGIX                      = 0x8197;
typedef void   function(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, GLdouble *points) PFNGLDEFORMATIONMAP3DSGIXPROC;
typedef void   function(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, GLfloat *points) PFNGLDEFORMATIONMAP3FSGIXPROC;
typedef void   function(GLbitfield mask) PFNGLDEFORMSGIXPROC;
typedef void   function(GLbitfield mask) PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC;
 extern   PFNGLDEFORMATIONMAP3DSGIXPROC pglDeformationMap3dSGIX;
 extern   PFNGLDEFORMATIONMAP3FSGIXPROC pglDeformationMap3fSGIX;
 extern   PFNGLDEFORMSGIXPROC pglDeformSGIX;
 extern   PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC pglLoadIdentityDeformationMapSGIX;
alias pglDeformationMap3dSGIX glDeformationMap3dSGIX;
alias pglDeformationMap3fSGIX glDeformationMap3fSGIX;
alias pglDeformSGIX glDeformSGIX;
alias pglLoadIdentityDeformationMapSGIX glLoadIdentityDeformationMapSGIX;
//#endif ;

//GL_SGIX_reference_plane

//#ifndef GL_SGIX_reference_plane;
const uint GL_SGIX_reference_plane = 1;
const uint __GLEE_GL_SGIX_reference_plane = 1;
//constants
const uint GL_REFERENCE_PLANE_SGIX                            = 0x817D;
const uint GL_REFERENCE_PLANE_EQUATION_SGIX                   = 0x817E;
typedef void   function(GLdouble *equation) PFNGLREFERENCEPLANESGIXPROC;
 extern   PFNGLREFERENCEPLANESGIXPROC pglReferencePlaneSGIX;
alias pglReferencePlaneSGIX glReferencePlaneSGIX;
//#endif ;

//GL_SGIX_flush_raster

//#ifndef GL_SGIX_flush_raster;
const uint GL_SGIX_flush_raster = 1;
const uint __GLEE_GL_SGIX_flush_raster = 1;
//constants
typedef void   function() PFNGLFLUSHRASTERSGIXPROC;
 extern   PFNGLFLUSHRASTERSGIXPROC pglFlushRasterSGIX;
alias pglFlushRasterSGIX glFlushRasterSGIX;
//#endif ;

//GL_SGIX_depth_texture

//#ifndef GL_SGIX_depth_texture;
const uint  GL_SGIX_depth_texture = 1;
const uint  __GLEE_GL_SGIX_depth_texture = 1;
//constants
const uint  GL_DEPTH_COMPONENT16_SGIX                          = 0x81A5;
const uint  GL_DEPTH_COMPONENT24_SGIX                          = 0x81A6;
const uint  GL_DEPTH_COMPONENT32_SGIX                          = 0x81A7;
//#endif ;

//GL_SGIS_fog_function

//#ifndef GL_SGIS_fog_function;
const uint  GL_SGIS_fog_function = 1;
const uint  __GLEE_GL_SGIS_fog_function = 1;
//constants
const uint  GL_FOG_FUNC_SGIS                                   = 0x812A;
const uint  GL_FOG_FUNC_POINTS_SGIS                            = 0x812B;
const uint  GL_MAX_FOG_FUNC_POINTS_SGIS                        = 0x812C;
typedef void   function(GLsizei n, GLfloat *points) PFNGLFOGFUNCSGISPROC;
typedef void   function(GLfloat *points) PFNGLGETFOGFUNCSGISPROC;
 extern   PFNGLFOGFUNCSGISPROC pglFogFuncSGIS;
 extern   PFNGLGETFOGFUNCSGISPROC pglGetFogFuncSGIS;
alias pglFogFuncSGIS glFogFuncSGIS;
alias pglGetFogFuncSGIS glGetFogFuncSGIS;
//#endif ;

//GL_SGIX_fog_offset

//#ifndef GL_SGIX_fog_offset;
const uint  GL_SGIX_fog_offset = 1;
const uint  __GLEE_GL_SGIX_fog_offset = 1;
//constants
const uint  GL_FOG_OFFSET_SGIX                                 = 0x8198;
const uint  GL_FOG_OFFSET_VALUE_SGIX                           = 0x8199;
//#endif ;

//GL_HP_image_transform

//#ifndef GL_HP_image_transform;
const uint  GL_HP_image_transform = 1;
const uint  __GLEE_GL_HP_image_transform = 1;
//constants
const uint  GL_IMAGE_SCALE_X_HP                                = 0x8155;
const uint  GL_IMAGE_SCALE_Y_HP                                = 0x8156;
const uint  GL_IMAGE_TRANSLATE_X_HP                            = 0x8157;
const uint  GL_IMAGE_TRANSLATE_Y_HP                            = 0x8158;
const uint  GL_IMAGE_ROTATE_ANGLE_HP                           = 0x8159;
const uint  GL_IMAGE_ROTATE_ORIGIN_X_HP                        = 0x815A;
const uint  GL_IMAGE_ROTATE_ORIGIN_Y_HP                        = 0x815B;
const uint  GL_IMAGE_MAG_FILTER_HP                             = 0x815C;
const uint  GL_IMAGE_MIN_FILTER_HP                             = 0x815D;
const uint  GL_IMAGE_CUBIC_WEIGHT_HP                           = 0x815E;
const uint  GL_CUBIC_HP                                        = 0x815F;
const uint  GL_AVERAGE_HP                                      = 0x8160;
const uint  GL_IMAGE_TRANSFORM_2D_HP                           = 0x8161;
const uint  GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP             = 0x8162;
const uint  GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP       = 0x8163;
typedef void   function(GLenum target, GLenum pname, GLint param) PFNGLIMAGETRANSFORMPARAMETERIHPPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat param) PFNGLIMAGETRANSFORMPARAMETERFHPPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLIMAGETRANSFORMPARAMETERIVHPPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLIMAGETRANSFORMPARAMETERFVHPPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC;
 extern   PFNGLIMAGETRANSFORMPARAMETERIHPPROC pglImageTransformParameteriHP;
 extern   PFNGLIMAGETRANSFORMPARAMETERFHPPROC pglImageTransformParameterfHP;
 extern   PFNGLIMAGETRANSFORMPARAMETERIVHPPROC pglImageTransformParameterivHP;
 extern   PFNGLIMAGETRANSFORMPARAMETERFVHPPROC pglImageTransformParameterfvHP;
 extern   PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC pglGetImageTransformParameterivHP;
 extern   PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC pglGetImageTransformParameterfvHP;
alias pglImageTransformParameteriHP glImageTransformParameteriHP;
alias pglImageTransformParameterfHP glImageTransformParameterfHP;
alias pglImageTransformParameterivHP glImageTransformParameterivHP;
alias pglImageTransformParameterfvHP glImageTransformParameterfvHP;
alias pglGetImageTransformParameterivHP glGetImageTransformParameterivHP;
alias pglGetImageTransformParameterfvHP glGetImageTransformParameterfvHP;
//#endif ;

//GL_HP_convolution_border_modes

//#ifndef GL_HP_convolution_border_modes;
const uint  GL_HP_convolution_border_modes = 1;
const uint  __GLEE_GL_HP_convolution_border_modes = 1;
//constants
const uint  GL_IGNORE_BORDER_HP                                = 0x8150;
const uint  GL_CONSTANT_BORDER_HP                              = 0x8151;
const uint  GL_REPLICATE_BORDER_HP                             = 0x8153;
const uint  GL_CONVOLUTION_BORDER_COLOR_HP                     = 0x8154;
//#endif ;

//GL_INGR_palette_buffer

//#ifndef GL_INGR_palette_buffer;
const uint GL_INGR_palette_buffer = 1;
const uint __GLEE_GL_INGR_palette_buffer = 1;
//constants
//#endif ;

//GL_SGIX_texture_add_env

//#ifndef GL_SGIX_texture_add_env;
const uint  GL_SGIX_texture_add_env = 1;
const uint  __GLEE_GL_SGIX_texture_add_env = 1;
//constants
const uint  GL_TEXTURE_ENV_BIAS_SGIX                           = 0x80BE;
//#endif ;

//GL_EXT_color_subtable

//#ifndef GL_EXT_color_subtable;
const uint GL_EXT_color_subtable = 1;
const uint __GLEE_GL_EXT_color_subtable = 1;
//constants
typedef void   function(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, GLvoid *data) PFNGLCOLORSUBTABLEEXTPROC;
typedef void   function(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width) PFNGLCOPYCOLORSUBTABLEEXTPROC;
 extern   PFNGLCOLORSUBTABLEEXTPROC pglColorSubTableEXT;
 extern   PFNGLCOPYCOLORSUBTABLEEXTPROC pglCopyColorSubTableEXT;
alias pglColorSubTableEXT glColorSubTableEXT;
alias pglCopyColorSubTableEXT glCopyColorSubTableEXT;
//#endif ;

//GL_PGI_vertex_hints

//#ifndef GL_PGI_vertex_hints;
const uint  GL_PGI_vertex_hints = 1;
const uint  __GLEE_GL_PGI_vertex_hints = 1;
//constants
const uint  GL_VERTEX_DATA_HINT_PGI                            = 0x1A22A;
const uint  GL_VERTEX_CONSISTENT_HINT_PGI                      = 0x1A22B;
const uint  GL_MATERIAL_SIDE_HINT_PGI                          = 0x1A22C;
const uint  GL_MAX_VERTEX_HINT_PGI                             = 0x1A22D;
const uint  GL_COLOR3_BIT_PGI                                  = 0x00010000;
const uint  GL_COLOR4_BIT_PGI                                  = 0x00020000;
const uint  GL_EDGEFLAG_BIT_PGI                                = 0x00040000;
const uint  GL_INDEX_BIT_PGI                                   = 0x00080000;
const uint  GL_MAT_AMBIENT_BIT_PGI                             = 0x00100000;
const uint  GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI                 = 0x00200000;
const uint  GL_MAT_DIFFUSE_BIT_PGI                             = 0x00400000;
const uint  GL_MAT_EMISSION_BIT_PGI                            = 0x00800000;
const uint  GL_MAT_COLOR_INDEXES_BIT_PGI                       = 0x01000000;
const uint  GL_MAT_SHININESS_BIT_PGI                           = 0x02000000;
const uint  GL_MAT_SPECULAR_BIT_PGI                            = 0x04000000;
const uint  GL_NORMAL_BIT_PGI                                  = 0x08000000;
const uint  GL_TEXCOORD1_BIT_PGI                               = 0x10000000;
const uint  GL_TEXCOORD2_BIT_PGI                               = 0x20000000;
const uint  GL_TEXCOORD3_BIT_PGI                               = 0x40000000;
const uint  GL_TEXCOORD4_BIT_PGI                               = 0x80000000;
const uint  GL_VERTEX23_BIT_PGI                                = 0x00000004;
const uint  GL_VERTEX4_BIT_PGI                                 = 0x00000008;
//#endif ;

//GL_PGI_misc_hints

//#ifndef GL_PGI_misc_hints;
const uint  GL_PGI_misc_hints = 1;
const uint  __GLEE_GL_PGI_misc_hints = 1;
//constants
const uint  GL_PREFER_DOUBLEBUFFER_HINT_PGI                    = 0x1A1F8;
const uint  GL_CONSERVE_MEMORY_HINT_PGI                        = 0x1A1FD;
const uint  GL_RECLAIM_MEMORY_HINT_PGI                         = 0x1A1FE;
const uint  GL_NATIVE_GRAPHICS_HANDLE_PGI                      = 0x1A202;
const uint  GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI                  = 0x1A203;
const uint  GL_NATIVE_GRAPHICS_END_HINT_PGI                    = 0x1A204;
const uint  GL_ALWAYS_FAST_HINT_PGI                            = 0x1A20C;
const uint  GL_ALWAYS_SOFT_HINT_PGI                            = 0x1A20D;
const uint  GL_ALLOW_DRAW_OBJ_HINT_PGI                         = 0x1A20E;
const uint  GL_ALLOW_DRAW_WIN_HINT_PGI                         = 0x1A20F;
const uint  GL_ALLOW_DRAW_FRG_HINT_PGI                         = 0x1A210;
const uint  GL_ALLOW_DRAW_MEM_HINT_PGI                         = 0x1A211;
const uint  GL_STRICT_DEPTHFUNC_HINT_PGI                       = 0x1A216;
const uint  GL_STRICT_LIGHTING_HINT_PGI                        = 0x1A217;
const uint  GL_STRICT_SCISSOR_HINT_PGI                         = 0x1A218;
const uint  GL_FULL_STIPPLE_HINT_PGI                           = 0x1A219;
const uint  GL_CLIP_NEAR_HINT_PGI                              = 0x1A220;
const uint  GL_CLIP_FAR_HINT_PGI                               = 0x1A221;
const uint  GL_WIDE_LINE_HINT_PGI                              = 0x1A222;
const uint  GL_BACK_NORMALS_HINT_PGI                           = 0x1A223;
typedef void   function(GLenum target, GLint mode) PFNGLHINTPGIPROC;
 extern   PFNGLHINTPGIPROC pglHintPGI;
alias pglHintPGI glHintPGI;
//#endif ;

//GL_EXT_paletted_texture

//#ifndef GL_EXT_paletted_texture;
const uint  GL_EXT_paletted_texture = 1;
const uint  __GLEE_GL_EXT_paletted_texture = 1;
//constants
const uint  GL_COLOR_INDEX1_EXT                                = 0x80E2;
const uint  GL_COLOR_INDEX2_EXT                                = 0x80E3;
const uint  GL_COLOR_INDEX4_EXT                                = 0x80E4;
const uint  GL_COLOR_INDEX8_EXT                                = 0x80E5;
const uint  GL_COLOR_INDEX12_EXT                               = 0x80E6;
const uint  GL_COLOR_INDEX16_EXT                               = 0x80E7;
const uint  GL_TEXTURE_INDEX_SIZE_EXT                          = 0x80ED;
typedef void   function(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, GLvoid *table) PFNGLCOLORTABLEEXTPROC;
typedef void   function(GLenum target, GLenum format, GLenum type, GLvoid *data) PFNGLGETCOLORTABLEEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETCOLORTABLEPARAMETERIVEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETCOLORTABLEPARAMETERFVEXTPROC;
 extern   PFNGLCOLORTABLEEXTPROC pglColorTableEXT;
 extern   PFNGLGETCOLORTABLEEXTPROC pglGetColorTableEXT;
 extern   PFNGLGETCOLORTABLEPARAMETERIVEXTPROC pglGetColorTableParameterivEXT;
 extern   PFNGLGETCOLORTABLEPARAMETERFVEXTPROC pglGetColorTableParameterfvEXT;
alias pglColorTableEXT glColorTableEXT;
alias pglGetColorTableEXT glGetColorTableEXT;
alias pglGetColorTableParameterivEXT glGetColorTableParameterivEXT;
alias pglGetColorTableParameterfvEXT glGetColorTableParameterfvEXT;
//#endif ;

//GL_EXT_clip_volume_hint

//#ifndef GL_EXT_clip_volume_hint;
const uint GL_EXT_clip_volume_hint = 1;
const uint __GLEE_GL_EXT_clip_volume_hint = 1;
//constants
const uint GL_CLIP_VOLUME_CLIPPING_HINT_EXT                   = 0x80F0;
//#endif ;

//GL_SGIX_list_priority

//#ifndef GL_SGIX_list_priority;
const uint GL_SGIX_list_priority = 1;
const uint __GLEE_GL_SGIX_list_priority = 1;
//constants
const uint GL_LIST_PRIORITY_SGIX                              = 0x8182;
typedef void   function(GLuint list, GLenum pname, GLfloat *params) PFNGLGETLISTPARAMETERFVSGIXPROC;
typedef void   function(GLuint list, GLenum pname, GLint *params) PFNGLGETLISTPARAMETERIVSGIXPROC;
typedef void   function(GLuint list, GLenum pname, GLfloat param) PFNGLLISTPARAMETERFSGIXPROC;
typedef void   function(GLuint list, GLenum pname, GLfloat *params) PFNGLLISTPARAMETERFVSGIXPROC;
typedef void   function(GLuint list, GLenum pname, GLint param) PFNGLLISTPARAMETERISGIXPROC;
typedef void   function(GLuint list, GLenum pname, GLint *params) PFNGLLISTPARAMETERIVSGIXPROC;
 extern   PFNGLGETLISTPARAMETERFVSGIXPROC pglGetListParameterfvSGIX;
 extern   PFNGLGETLISTPARAMETERIVSGIXPROC pglGetListParameterivSGIX;
 extern   PFNGLLISTPARAMETERFSGIXPROC pglListParameterfSGIX;
 extern   PFNGLLISTPARAMETERFVSGIXPROC pglListParameterfvSGIX;
 extern   PFNGLLISTPARAMETERISGIXPROC pglListParameteriSGIX;
 extern   PFNGLLISTPARAMETERIVSGIXPROC pglListParameterivSGIX;
alias pglGetListParameterfvSGIX glGetListParameterfvSGIX;
alias pglGetListParameterivSGIX glGetListParameterivSGIX;
alias pglListParameterfSGIX glListParameterfSGIX;
alias pglListParameterfvSGIX glListParameterfvSGIX;
alias pglListParameteriSGIX glListParameteriSGIX;
alias pglListParameterivSGIX glListParameterivSGIX;
//#endif ;

//GL_SGIX_ir_instrument1

//#ifndef GL_SGIX_ir_instrument1;
const uint GL_SGIX_ir_instrument1 = 1;
const uint __GLEE_GL_SGIX_ir_instrument1 = 1;
//constants
const uint GL_IR_INSTRUMENT1_SGIX                             = 0x817F;
//#endif ;

//GL_SGIX_calligraphic_fragment

//#ifndef GL_SGIX_calligraphic_fragment;
const uint GL_SGIX_calligraphic_fragment = 1;
const uint __GLEE_GL_SGIX_calligraphic_fragment = 1;
//constants
const uint GL_CALLIGRAPHIC_FRAGMENT_SGIX                      = 0x8183;
//#endif ;

//GL_SGIX_texture_lod_bias

//#ifndef GL_SGIX_texture_lod_bias;
const uint GL_SGIX_texture_lod_bias = 1;
const uint __GLEE_GL_SGIX_texture_lod_bias = 1;
//constants
const uint GL_TEXTURE_LOD_BIAS_S_SGIX                         = 0x818E;
const uint GL_TEXTURE_LOD_BIAS_T_SGIX                         = 0x818F;
const uint GL_TEXTURE_LOD_BIAS_R_SGIX                         = 0x8190;
//#endif ;

//GL_SGIX_shadow_ambient

//#ifndef GL_SGIX_shadow_ambient;
const uint GL_SGIX_shadow_ambient = 1;
const uint __GLEE_GL_SGIX_shadow_ambient = 1;
//constants
const uint GL_SHADOW_AMBIENT_SGIX                             = 0x80BF;
//#endif ;

//GL_EXT_index_texture

//#ifndef GL_EXT_index_texture;
const uint GL_EXT_index_texture = 1;
const uint __GLEE_GL_EXT_index_texture = 1;
//constants
//#endif ;

//GL_EXT_index_material

//#ifndef GL_EXT_index_material;
const uint GL_EXT_index_material = 1;
const uint __GLEE_GL_EXT_index_material = 1;
//constants
const uint GL_INDEX_MATERIAL_EXT                              = 0x81B8;
const uint GL_INDEX_MATERIAL_PARAMETER_EXT                    = 0x81B9;
const uint GL_INDEX_MATERIAL_FACE_EXT                         = 0x81BA;
typedef void   function(GLenum face, GLenum mode) PFNGLINDEXMATERIALEXTPROC;
 extern   PFNGLINDEXMATERIALEXTPROC pglIndexMaterialEXT;
alias pglIndexMaterialEXT glIndexMaterialEXT;
//#endif ;

//GL_EXT_index_func

//#ifndef GL_EXT_index_func;
const uint GL_EXT_index_func = 1;
const uint __GLEE_GL_EXT_index_func = 1;
//constants
const uint GL_INDEX_TEST_EXT                                  = 0x81B5;
const uint GL_INDEX_TEST_FUNC_EXT                             = 0x81B6;
const uint GL_INDEX_TEST_REF_EXT                              = 0x81B7;
typedef void   function(GLenum func, GLclampf ref) PFNGLINDEXFUNCEXTPROC;
 extern   PFNGLINDEXFUNCEXTPROC pglIndexFuncEXT;
alias pglIndexFuncEXT glIndexFuncEXT;
//#endif ;

//GL_EXT_index_array_formats

//#ifndef GL_EXT_index_array_formats;
const uint GL_EXT_index_array_formats = 1;
const uint __GLEE_GL_EXT_index_array_formats = 1;
//constants
const uint GL_IUI_V2F_EXT                                     = 0x81AD;
const uint GL_IUI_V3F_EXT                                     = 0x81AE;
const uint GL_IUI_N3F_V2F_EXT                                 = 0x81AF;
const uint GL_IUI_N3F_V3F_EXT                                 = 0x81B0;
const uint GL_T2F_IUI_V2F_EXT                                 = 0x81B1;
const uint GL_T2F_IUI_V3F_EXT                                 = 0x81B2;
const uint GL_T2F_IUI_N3F_V2F_EXT                             = 0x81B3;
const uint GL_T2F_IUI_N3F_V3F_EXT                             = 0x81B4;
//#endif ;

//GL_EXT_compiled_vertex_array

//#ifndef GL_EXT_compiled_vertex_array;
const uint GL_EXT_compiled_vertex_array = 1;
const uint __GLEE_GL_EXT_compiled_vertex_array = 1;
//constants
const uint GL_ARRAY_ELEMENT_LOCK_FIRST_EXT                    = 0x81A8;
const uint GL_ARRAY_ELEMENT_LOCK_COUNT_EXT                    = 0x81A9;
typedef void   function(GLint first, GLsizei count) PFNGLLOCKARRAYSEXTPROC;
typedef void   function() PFNGLUNLOCKARRAYSEXTPROC;
 extern   PFNGLLOCKARRAYSEXTPROC pglLockArraysEXT;
 extern   PFNGLUNLOCKARRAYSEXTPROC pglUnlockArraysEXT;
alias pglLockArraysEXT glLockArraysEXT;
alias pglUnlockArraysEXT glUnlockArraysEXT;
//#endif ;

//GL_EXT_cull_vertex

//#ifndef GL_EXT_cull_vertex;
const uint GL_EXT_cull_vertex = 1;
const uint __GLEE_GL_EXT_cull_vertex = 1;
//constants
const uint GL_CULL_VERTEX_EXT                                 = 0x81AA;
const uint GL_CULL_VERTEX_EYE_POSITION_EXT                    = 0x81AB;
const uint GL_CULL_VERTEX_OBJECT_POSITION_EXT                 = 0x81AC;
typedef void   function(GLenum pname, GLdouble *params) PFNGLCULLPARAMETERDVEXTPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLCULLPARAMETERFVEXTPROC;
 extern   PFNGLCULLPARAMETERDVEXTPROC pglCullParameterdvEXT;
 extern   PFNGLCULLPARAMETERFVEXTPROC pglCullParameterfvEXT;
alias pglCullParameterdvEXT glCullParameterdvEXT;
alias pglCullParameterfvEXT glCullParameterfvEXT;
//#endif ;

//GL_SGIX_ycrcb

//#ifndef GL_SGIX_ycrcb;
const uint GL_SGIX_ycrcb = 1;
const uint __GLEE_GL_SGIX_ycrcb = 1;
//constants
const uint GL_YCRCB_422_SGIX                                  = 0x81BB;
const uint GL_YCRCB_444_SGIX                                  = 0x81BC;
//#endif ;

//GL_SGIX_fragment_lighting

//#ifndef GL_SGIX_fragment_lighting;
const uint GL_SGIX_fragment_lighting = 1;
const uint __GLEE_GL_SGIX_fragment_lighting = 1;
//constants
const uint GL_FRAGMENT_LIGHTING_SGIX                          = 0x8400;
const uint GL_FRAGMENT_COLOR_MATERIAL_SGIX                    = 0x8401;
const uint GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX               = 0x8402;
const uint GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX          = 0x8403;
const uint GL_MAX_FRAGMENT_LIGHTS_SGIX                        = 0x8404;
const uint GL_MAX_ACTIVE_LIGHTS_SGIX                          = 0x8405;
const uint GL_CURRENT_RASTER_NORMAL_SGIX                      = 0x8406;
const uint GL_LIGHT_ENV_MODE_SGIX                             = 0x8407;
const uint GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX          = 0x8408;
const uint GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX              = 0x8409;
const uint GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX               = 0x840A;
const uint GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX  = 0x840B;
const uint GL_FRAGMENT_LIGHT0_SGIX                            = 0x840C;
const uint GL_FRAGMENT_LIGHT1_SGIX                            = 0x840D;
const uint GL_FRAGMENT_LIGHT2_SGIX                            = 0x840E;
const uint GL_FRAGMENT_LIGHT3_SGIX                            = 0x840F;
const uint GL_FRAGMENT_LIGHT4_SGIX                            = 0x8410;
const uint GL_FRAGMENT_LIGHT5_SGIX                            = 0x8411;
const uint GL_FRAGMENT_LIGHT6_SGIX                            = 0x8412;
const uint GL_FRAGMENT_LIGHT7_SGIX                            = 0x8413;
typedef void   function(GLenum face, GLenum mode) PFNGLFRAGMENTCOLORMATERIALSGIXPROC;
typedef void   function(GLenum light, GLenum pname, GLfloat param) PFNGLFRAGMENTLIGHTFSGIXPROC;
typedef void   function(GLenum light, GLenum pname, GLfloat *params) PFNGLFRAGMENTLIGHTFVSGIXPROC;
typedef void   function(GLenum light, GLenum pname, GLint param) PFNGLFRAGMENTLIGHTISGIXPROC;
typedef void   function(GLenum light, GLenum pname, GLint *params) PFNGLFRAGMENTLIGHTIVSGIXPROC;
typedef void   function(GLenum pname, GLfloat param) PFNGLFRAGMENTLIGHTMODELFSGIXPROC;
typedef void   function(GLenum pname, GLfloat *params) PFNGLFRAGMENTLIGHTMODELFVSGIXPROC;
typedef void   function(GLenum pname, GLint param) PFNGLFRAGMENTLIGHTMODELISGIXPROC;
typedef void   function(GLenum pname, GLint *params) PFNGLFRAGMENTLIGHTMODELIVSGIXPROC;
typedef void   function(GLenum face, GLenum pname, GLfloat param) PFNGLFRAGMENTMATERIALFSGIXPROC;
typedef void   function(GLenum face, GLenum pname, GLfloat *params) PFNGLFRAGMENTMATERIALFVSGIXPROC;
typedef void   function(GLenum face, GLenum pname, GLint param) PFNGLFRAGMENTMATERIALISGIXPROC;
typedef void   function(GLenum face, GLenum pname, GLint *params) PFNGLFRAGMENTMATERIALIVSGIXPROC;
typedef void   function(GLenum light, GLenum pname, GLfloat *params) PFNGLGETFRAGMENTLIGHTFVSGIXPROC;
typedef void   function(GLenum light, GLenum pname, GLint *params) PFNGLGETFRAGMENTLIGHTIVSGIXPROC;
typedef void   function(GLenum face, GLenum pname, GLfloat *params) PFNGLGETFRAGMENTMATERIALFVSGIXPROC;
typedef void   function(GLenum face, GLenum pname, GLint *params) PFNGLGETFRAGMENTMATERIALIVSGIXPROC;
typedef void   function(GLenum pname, GLint param) PFNGLLIGHTENVISGIXPROC;
 extern   PFNGLFRAGMENTCOLORMATERIALSGIXPROC pglFragmentColorMaterialSGIX;
 extern   PFNGLFRAGMENTLIGHTFSGIXPROC pglFragmentLightfSGIX;
 extern   PFNGLFRAGMENTLIGHTFVSGIXPROC pglFragmentLightfvSGIX;
 extern   PFNGLFRAGMENTLIGHTISGIXPROC pglFragmentLightiSGIX;
 extern   PFNGLFRAGMENTLIGHTIVSGIXPROC pglFragmentLightivSGIX;
 extern   PFNGLFRAGMENTLIGHTMODELFSGIXPROC pglFragmentLightModelfSGIX;
 extern   PFNGLFRAGMENTLIGHTMODELFVSGIXPROC pglFragmentLightModelfvSGIX;
 extern   PFNGLFRAGMENTLIGHTMODELISGIXPROC pglFragmentLightModeliSGIX;
 extern   PFNGLFRAGMENTLIGHTMODELIVSGIXPROC pglFragmentLightModelivSGIX;
 extern   PFNGLFRAGMENTMATERIALFSGIXPROC pglFragmentMaterialfSGIX;
 extern   PFNGLFRAGMENTMATERIALFVSGIXPROC pglFragmentMaterialfvSGIX;
 extern   PFNGLFRAGMENTMATERIALISGIXPROC pglFragmentMaterialiSGIX;
 extern   PFNGLFRAGMENTMATERIALIVSGIXPROC pglFragmentMaterialivSGIX;
 extern   PFNGLGETFRAGMENTLIGHTFVSGIXPROC pglGetFragmentLightfvSGIX;
 extern   PFNGLGETFRAGMENTLIGHTIVSGIXPROC pglGetFragmentLightivSGIX;
 extern   PFNGLGETFRAGMENTMATERIALFVSGIXPROC pglGetFragmentMaterialfvSGIX;
 extern   PFNGLGETFRAGMENTMATERIALIVSGIXPROC pglGetFragmentMaterialivSGIX;
 extern   PFNGLLIGHTENVISGIXPROC pglLightEnviSGIX;
alias pglFragmentColorMaterialSGIX glFragmentColorMaterialSGIX;
alias pglFragmentLightfSGIX glFragmentLightfSGIX;
alias pglFragmentLightfvSGIX glFragmentLightfvSGIX;
alias pglFragmentLightiSGIX glFragmentLightiSGIX;
alias pglFragmentLightivSGIX glFragmentLightivSGIX;
alias pglFragmentLightModelfSGIX glFragmentLightModelfSGIX;
alias pglFragmentLightModelfvSGIX glFragmentLightModelfvSGIX;
alias pglFragmentLightModeliSGIX glFragmentLightModeliSGIX;
alias pglFragmentLightModelivSGIX glFragmentLightModelivSGIX;
alias pglFragmentMaterialfSGIX glFragmentMaterialfSGIX;
alias pglFragmentMaterialfvSGIX glFragmentMaterialfvSGIX;
alias pglFragmentMaterialiSGIX glFragmentMaterialiSGIX;
alias pglFragmentMaterialivSGIX glFragmentMaterialivSGIX;
alias pglGetFragmentLightfvSGIX glGetFragmentLightfvSGIX;
alias pglGetFragmentLightivSGIX glGetFragmentLightivSGIX;
alias pglGetFragmentMaterialfvSGIX glGetFragmentMaterialfvSGIX;
alias pglGetFragmentMaterialivSGIX glGetFragmentMaterialivSGIX;
alias pglLightEnviSGIX glLightEnviSGIX;
//#endif ;

//GL_IBM_rasterpos_clip

//#ifndef GL_IBM_rasterpos_clip;
const uint GL_IBM_rasterpos_clip = 1;
const uint __GLEE_GL_IBM_rasterpos_clip = 1;
//constants
const uint GL_RASTER_POSITION_UNCLIPPED_IBM                   = 0x19262;
//#endif ;

//GL_HP_texture_lighting

//#ifndef GL_HP_texture_lighting;
const uint GL_HP_texture_lighting = 1;
const uint __GLEE_GL_HP_texture_lighting = 1;
//constants
const uint GL_TEXTURE_LIGHTING_MODE_HP                        = 0x8167;
const uint GL_TEXTURE_POST_SPECULAR_HP                        = 0x8168;
const uint GL_TEXTURE_PRE_SPECULAR_HP                         = 0x8169;
//#endif ;

//GL_EXT_draw_range_elements

//#ifndef GL_EXT_draw_range_elements;
const uint GL_EXT_draw_range_elements = 1;
const uint __GLEE_GL_EXT_draw_range_elements = 1;
//constants
const uint GL_MAX_ELEMENTS_VERTICES_EXT                       = 0x80E8;
const uint GL_MAX_ELEMENTS_INDICES_EXT                        = 0x80E9;
typedef void   function(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, GLvoid *indices) PFNGLDRAWRANGEELEMENTSEXTPROC;
 extern   PFNGLDRAWRANGEELEMENTSEXTPROC pglDrawRangeElementsEXT;
alias pglDrawRangeElementsEXT glDrawRangeElementsEXT;
//#endif ;

//GL_WIN_phong_shading

//#ifndef GL_WIN_phong_shading;
const uint GL_WIN_phong_shading = 1;
const uint __GLEE_GL_WIN_phong_shading = 1;
//constants
const uint GL_PHONG_WIN                                       = 0x80EA;
const uint GL_PHONG_HINT_WIN                                  = 0x80EB;
//#endif ;

//GL_WIN_specular_fog

//#ifndef GL_WIN_specular_fog;
const uint GL_WIN_specular_fog = 1;
const uint __GLEE_GL_WIN_specular_fog = 1;
//constants
const uint GL_FOG_SPECULAR_TEXTURE_WIN                        = 0x80EC;
//#endif ;

//GL_EXT_light_texture

//#ifndef GL_EXT_light_texture;
const uint GL_EXT_light_texture = 1;
const uint __GLEE_GL_EXT_light_texture = 1;
//constants
const uint GL_FRAGMENT_MATERIAL_EXT                           = 0x8349;
const uint GL_FRAGMENT_NORMAL_EXT                             = 0x834A;
const uint GL_FRAGMENT_COLOR_EXT                              = 0x834C;
const uint GL_ATTENUATION_EXT                                 = 0x834D;
const uint GL_SHADOW_ATTENUATION_EXT                          = 0x834E;
const uint GL_TEXTURE_APPLICATION_MODE_EXT                    = 0x834F;
const uint GL_TEXTURE_LIGHT_EXT                               = 0x8350;
const uint GL_TEXTURE_MATERIAL_FACE_EXT                       = 0x8351;
const uint GL_TEXTURE_MATERIAL_PARAMETER_EXT                  = 0x8352;
typedef void   function(GLenum mode) PFNGLAPPLYTEXTUREEXTPROC;
typedef void   function(GLenum pname) PFNGLTEXTURELIGHTEXTPROC;
typedef void   function(GLenum face, GLenum mode) PFNGLTEXTUREMATERIALEXTPROC;
 extern   PFNGLAPPLYTEXTUREEXTPROC pglApplyTextureEXT;
 extern   PFNGLTEXTURELIGHTEXTPROC pglTextureLightEXT;
 extern   PFNGLTEXTUREMATERIALEXTPROC pglTextureMaterialEXT;
alias pglApplyTextureEXT glApplyTextureEXT;
alias pglTextureLightEXT glTextureLightEXT;
alias pglTextureMaterialEXT glTextureMaterialEXT;
//#endif ;

//GL_SGIX_blend_alpha_minmax

//#ifndef GL_SGIX_blend_alpha_minmax;
const uint GL_SGIX_blend_alpha_minmax = 1;
const uint __GLEE_GL_SGIX_blend_alpha_minmax = 1;
//constants
const uint GL_ALPHA_MIN_SGIX                                  = 0x8320;
const uint GL_ALPHA_MAX_SGIX                                  = 0x8321;
//#endif ;

//GL_SGIX_impact_pixel_texture

//#ifndef GL_SGIX_impact_pixel_texture;
const uint GL_SGIX_impact_pixel_texture = 1;
const uint __GLEE_GL_SGIX_impact_pixel_texture = 1;
//constants
const uint GL_PIXEL_TEX_GEN_Q_CEILING_SGIX                    = 0x8184;
const uint GL_PIXEL_TEX_GEN_Q_ROUND_SGIX                      = 0x8185;
const uint GL_PIXEL_TEX_GEN_Q_FLOOR_SGIX                      = 0x8186;
const uint GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX                = 0x8187;
const uint GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX             = 0x8188;
const uint GL_PIXEL_TEX_GEN_ALPHA_LS_SGIX                     = 0x8189;
const uint GL_PIXEL_TEX_GEN_ALPHA_MS_SGIX                     = 0x818A;
//#endif ;

//GL_EXT_bgra

//#ifndef GL_EXT_bgra;
const uint GL_EXT_bgra = 1;
const uint __GLEE_GL_EXT_bgra = 1;
//constants
const uint GL_BGR_EXT                                         = 0x80E0;
const uint GL_BGRA_EXT                                        = 0x80E1;
//#endif ;

//GL_SGIX_async

//#ifndef GL_SGIX_async;
const uint GL_SGIX_async = 1;
const uint __GLEE_GL_SGIX_async = 1;
//constants
const uint GL_ASYNC_MARKER_SGIX                               = 0x8329;
typedef void   function(GLuint marker) PFNGLASYNCMARKERSGIXPROC;
typedef GLint   function(GLuint *markerp) PFNGLFINISHASYNCSGIXPROC;
typedef GLint   function(GLuint *markerp) PFNGLPOLLASYNCSGIXPROC;
typedef GLuint   function(GLsizei range) PFNGLGENASYNCMARKERSSGIXPROC;
typedef void   function(GLuint marker, GLsizei range) PFNGLDELETEASYNCMARKERSSGIXPROC;
typedef GLboolean   function(GLuint marker) PFNGLISASYNCMARKERSGIXPROC;
 extern   PFNGLASYNCMARKERSGIXPROC pglAsyncMarkerSGIX;
 extern   PFNGLFINISHASYNCSGIXPROC pglFinishAsyncSGIX;
 extern   PFNGLPOLLASYNCSGIXPROC pglPollAsyncSGIX;
 extern   PFNGLGENASYNCMARKERSSGIXPROC pglGenAsyncMarkersSGIX;
 extern   PFNGLDELETEASYNCMARKERSSGIXPROC pglDeleteAsyncMarkersSGIX;
 extern   PFNGLISASYNCMARKERSGIXPROC pglIsAsyncMarkerSGIX;
alias pglAsyncMarkerSGIX glAsyncMarkerSGIX;
alias pglFinishAsyncSGIX glFinishAsyncSGIX;
alias pglPollAsyncSGIX glPollAsyncSGIX;
alias pglGenAsyncMarkersSGIX glGenAsyncMarkersSGIX;
alias pglDeleteAsyncMarkersSGIX glDeleteAsyncMarkersSGIX;
alias pglIsAsyncMarkerSGIX glIsAsyncMarkerSGIX;
//#endif ;

//GL_SGIX_async_pixel

//#ifndef GL_SGIX_async_pixel;
const uint GL_SGIX_async_pixel = 1;
const uint __GLEE_GL_SGIX_async_pixel = 1;
//constants
const uint GL_ASYNC_TEX_IMAGE_SGIX                            = 0x835C;
const uint GL_ASYNC_DRAW_PIXELS_SGIX                          = 0x835D;
const uint GL_ASYNC_READ_PIXELS_SGIX                          = 0x835E;
const uint GL_MAX_ASYNC_TEX_IMAGE_SGIX                        = 0x835F;
const uint GL_MAX_ASYNC_DRAW_PIXELS_SGIX                      = 0x8360;
const uint GL_MAX_ASYNC_READ_PIXELS_SGIX                      = 0x8361;
//#endif ;

//GL_SGIX_async_histogram

//#ifndef GL_SGIX_async_histogram;
const uint GL_SGIX_async_histogram = 1;
const uint __GLEE_GL_SGIX_async_histogram = 1;
//constants
const uint GL_ASYNC_HISTOGRAM_SGIX                            = 0x832C;
const uint GL_MAX_ASYNC_HISTOGRAM_SGIX                        = 0x832D;
//#endif ;

//GL_INTEL_texture_scissor

//#ifndef GL_INTEL_texture_scissor;
const uint GL_INTEL_texture_scissor = 1;
const uint __GLEE_GL_INTEL_texture_scissor = 1;
//constants
//#endif ;

//GL_INTEL_parallel_arrays

//#ifndef GL_INTEL_parallel_arrays;
const uint GL_INTEL_parallel_arrays = 1;
const uint __GLEE_GL_INTEL_parallel_arrays = 1;
//constants
const uint GL_PARALLEL_ARRAYS_INTEL                           = 0x83F4;
const uint GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL            = 0x83F5;
const uint GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL            = 0x83F6;
const uint GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL             = 0x83F7;
const uint GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL     = 0x83F8;
typedef void   function(GLint size, GLenum type, GLvoid* *pointer) PFNGLVERTEXPOINTERVINTELPROC;
typedef void   function(GLenum type, GLvoid* *pointer) PFNGLNORMALPOINTERVINTELPROC;
typedef void   function(GLint size, GLenum type, GLvoid* *pointer) PFNGLCOLORPOINTERVINTELPROC;
typedef void   function(GLint size, GLenum type, GLvoid* *pointer) PFNGLTEXCOORDPOINTERVINTELPROC;
 extern   PFNGLVERTEXPOINTERVINTELPROC pglVertexPointervINTEL;
 extern   PFNGLNORMALPOINTERVINTELPROC pglNormalPointervINTEL;
 extern   PFNGLCOLORPOINTERVINTELPROC pglColorPointervINTEL;
 extern   PFNGLTEXCOORDPOINTERVINTELPROC pglTexCoordPointervINTEL;
alias pglVertexPointervINTEL glVertexPointervINTEL;
alias pglNormalPointervINTEL glNormalPointervINTEL;
alias pglColorPointervINTEL glColorPointervINTEL;
alias pglTexCoordPointervINTEL glTexCoordPointervINTEL;
//#endif ;

//GL_HP_occlusion_test

//#ifndef GL_HP_occlusion_test;
const uint GL_HP_occlusion_test = 1;
const uint __GLEE_GL_HP_occlusion_test = 1;
//constants
const uint GL_OCCLUSION_TEST_HP                               = 0x8165;
const uint GL_OCCLUSION_TEST_RESULT_HP                        = 0x8166;
//#endif ;

//GL_EXT_pixel_transform

//#ifndef GL_EXT_pixel_transform;
const uint GL_EXT_pixel_transform = 1;
const uint __GLEE_GL_EXT_pixel_transform = 1;
//constants
const uint GL_PIXEL_TRANSFORM_2D_EXT                          = 0x8330;
const uint GL_PIXEL_MAG_FILTER_EXT                            = 0x8331;
const uint GL_PIXEL_MIN_FILTER_EXT                            = 0x8332;
const uint GL_PIXEL_CUBIC_WEIGHT_EXT                          = 0x8333;
const uint GL_CUBIC_EXT                                       = 0x8334;
const uint GL_AVERAGE_EXT                                     = 0x8335;
const uint GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT              = 0x8336;
const uint GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT          = 0x8337;
const uint GL_PIXEL_TRANSFORM_2D_MATRIX_EXT                   = 0x8338;
typedef void   function(GLenum target, GLenum pname, GLint param) PFNGLPIXELTRANSFORMPARAMETERIEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat param) PFNGLPIXELTRANSFORMPARAMETERFEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC;
 extern   PFNGLPIXELTRANSFORMPARAMETERIEXTPROC pglPixelTransformParameteriEXT;
 extern   PFNGLPIXELTRANSFORMPARAMETERFEXTPROC pglPixelTransformParameterfEXT;
 extern   PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC pglPixelTransformParameterivEXT;
 extern   PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC pglPixelTransformParameterfvEXT;
alias pglPixelTransformParameteriEXT glPixelTransformParameteriEXT;
alias pglPixelTransformParameterfEXT glPixelTransformParameterfEXT;
alias pglPixelTransformParameterivEXT glPixelTransformParameterivEXT;
alias pglPixelTransformParameterfvEXT glPixelTransformParameterfvEXT;
//#endif ;

//GL_EXT_pixel_transform_color_table

//#ifndef GL_EXT_pixel_transform_color_table;
const uint GL_EXT_pixel_transform_color_table = 1;
const uint __GLEE_GL_EXT_pixel_transform_color_table = 1;
//constants
//#endif ;

//GL_EXT_shared_texture_palette

//#ifndef GL_EXT_shared_texture_palette;
const uint GL_EXT_shared_texture_palette = 1;
const uint __GLEE_GL_EXT_shared_texture_palette = 1;
//constants
const uint GL_SHARED_TEXTURE_PALETTE_EXT                      = 0x81FB;
//#endif ;

//GL_EXT_separate_specular_color

//#ifndef GL_EXT_separate_specular_color;
const uint GL_EXT_separate_specular_color = 1;
const uint __GLEE_GL_EXT_separate_specular_color = 1;
//constants
const uint GL_LIGHT_MODEL_COLOR_CONTROL_EXT                   = 0x81F8;
const uint GL_SINGLE_COLOR_EXT                                = 0x81F9;
const uint GL_SEPARATE_SPECULAR_COLOR_EXT                     = 0x81FA;
//#endif ;

//GL_EXT_secondary_color

//#ifndef GL_EXT_secondary_color;
const uint GL_EXT_secondary_color = 1;
const uint __GLEE_GL_EXT_secondary_color = 1;
//constants
const uint GL_COLOR_SUM_EXT                                   = 0x8458;
const uint GL_CURRENT_SECONDARY_COLOR_EXT                     = 0x8459;
const uint GL_SECONDARY_COLOR_ARRAY_SIZE_EXT                  = 0x845A;
const uint GL_SECONDARY_COLOR_ARRAY_TYPE_EXT                  = 0x845B;
const uint GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT                = 0x845C;
const uint GL_SECONDARY_COLOR_ARRAY_POINTER_EXT               = 0x845D;
const uint GL_SECONDARY_COLOR_ARRAY_EXT                       = 0x845E;
typedef void   function(GLbyte red, GLbyte green, GLbyte blue) PFNGLSECONDARYCOLOR3BEXTPROC;
typedef void   function(GLbyte *v) PFNGLSECONDARYCOLOR3BVEXTPROC;
typedef void   function(GLdouble red, GLdouble green, GLdouble blue) PFNGLSECONDARYCOLOR3DEXTPROC;
typedef void   function(GLdouble *v) PFNGLSECONDARYCOLOR3DVEXTPROC;
typedef void   function(GLfloat red, GLfloat green, GLfloat blue) PFNGLSECONDARYCOLOR3FEXTPROC;
typedef void   function(GLfloat *v) PFNGLSECONDARYCOLOR3FVEXTPROC;
typedef void   function(GLint red, GLint green, GLint blue) PFNGLSECONDARYCOLOR3IEXTPROC;
typedef void   function(GLint *v) PFNGLSECONDARYCOLOR3IVEXTPROC;
typedef void   function(GLshort red, GLshort green, GLshort blue) PFNGLSECONDARYCOLOR3SEXTPROC;
typedef void   function(GLshort *v) PFNGLSECONDARYCOLOR3SVEXTPROC;
typedef void   function(GLubyte red, GLubyte green, GLubyte blue) PFNGLSECONDARYCOLOR3UBEXTPROC;
typedef void   function(GLubyte *v) PFNGLSECONDARYCOLOR3UBVEXTPROC;
typedef void   function(GLuint red, GLuint green, GLuint blue) PFNGLSECONDARYCOLOR3UIEXTPROC;
typedef void   function(GLuint *v) PFNGLSECONDARYCOLOR3UIVEXTPROC;
typedef void   function(GLushort red, GLushort green, GLushort blue) PFNGLSECONDARYCOLOR3USEXTPROC;
typedef void   function(GLushort *v) PFNGLSECONDARYCOLOR3USVEXTPROC;
typedef void   function(GLint size, GLenum type, GLsizei stride, GLvoid *pointer) PFNGLSECONDARYCOLORPOINTEREXTPROC;
 extern   PFNGLSECONDARYCOLOR3BEXTPROC pglSecondaryColor3bEXT;
 extern   PFNGLSECONDARYCOLOR3BVEXTPROC pglSecondaryColor3bvEXT;
 extern   PFNGLSECONDARYCOLOR3DEXTPROC pglSecondaryColor3dEXT;
 extern   PFNGLSECONDARYCOLOR3DVEXTPROC pglSecondaryColor3dvEXT;
 extern   PFNGLSECONDARYCOLOR3FEXTPROC pglSecondaryColor3fEXT;
 extern   PFNGLSECONDARYCOLOR3FVEXTPROC pglSecondaryColor3fvEXT;
 extern   PFNGLSECONDARYCOLOR3IEXTPROC pglSecondaryColor3iEXT;
 extern   PFNGLSECONDARYCOLOR3IVEXTPROC pglSecondaryColor3ivEXT;
 extern   PFNGLSECONDARYCOLOR3SEXTPROC pglSecondaryColor3sEXT;
 extern   PFNGLSECONDARYCOLOR3SVEXTPROC pglSecondaryColor3svEXT;
 extern   PFNGLSECONDARYCOLOR3UBEXTPROC pglSecondaryColor3ubEXT;
 extern   PFNGLSECONDARYCOLOR3UBVEXTPROC pglSecondaryColor3ubvEXT;
 extern   PFNGLSECONDARYCOLOR3UIEXTPROC pglSecondaryColor3uiEXT;
 extern   PFNGLSECONDARYCOLOR3UIVEXTPROC pglSecondaryColor3uivEXT;
 extern   PFNGLSECONDARYCOLOR3USEXTPROC pglSecondaryColor3usEXT;
 extern   PFNGLSECONDARYCOLOR3USVEXTPROC pglSecondaryColor3usvEXT;
 extern   PFNGLSECONDARYCOLORPOINTEREXTPROC pglSecondaryColorPointerEXT;
alias pglSecondaryColor3bEXT glSecondaryColor3bEXT;
alias pglSecondaryColor3bvEXT glSecondaryColor3bvEXT;
alias pglSecondaryColor3dEXT glSecondaryColor3dEXT;
alias pglSecondaryColor3dvEXT glSecondaryColor3dvEXT;
alias pglSecondaryColor3fEXT glSecondaryColor3fEXT;
alias pglSecondaryColor3fvEXT glSecondaryColor3fvEXT;
alias pglSecondaryColor3iEXT glSecondaryColor3iEXT;
alias pglSecondaryColor3ivEXT glSecondaryColor3ivEXT;
alias pglSecondaryColor3sEXT glSecondaryColor3sEXT;
alias pglSecondaryColor3svEXT glSecondaryColor3svEXT;
alias pglSecondaryColor3ubEXT glSecondaryColor3ubEXT;
alias pglSecondaryColor3ubvEXT glSecondaryColor3ubvEXT;
alias pglSecondaryColor3uiEXT glSecondaryColor3uiEXT;
alias pglSecondaryColor3uivEXT glSecondaryColor3uivEXT;
alias pglSecondaryColor3usEXT glSecondaryColor3usEXT;
alias pglSecondaryColor3usvEXT glSecondaryColor3usvEXT;
alias pglSecondaryColorPointerEXT glSecondaryColorPointerEXT;
//#endif ;

//GL_EXT_texture_perturb_normal

//#ifndef GL_EXT_texture_perturb_normal;
const uint GL_EXT_texture_perturb_normal = 1;
const uint __GLEE_GL_EXT_texture_perturb_normal = 1;
//constants
const uint GL_PERTURB_EXT                                     = 0x85AE;
const uint GL_TEXTURE_NORMAL_EXT                              = 0x85AF;
typedef void   function(GLenum mode) PFNGLTEXTURENORMALEXTPROC;
 extern   PFNGLTEXTURENORMALEXTPROC pglTextureNormalEXT;
alias pglTextureNormalEXT glTextureNormalEXT;
//#endif ;

//GL_EXT_multi_draw_arrays

//#ifndef GL_EXT_multi_draw_arrays;
const uint GL_EXT_multi_draw_arrays = 1;
const uint __GLEE_GL_EXT_multi_draw_arrays = 1;
//constants
typedef void   function(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount) PFNGLMULTIDRAWARRAYSEXTPROC;
typedef void   function(GLenum mode, GLsizei *count, GLenum type, GLvoid* *indices, GLsizei primcount) PFNGLMULTIDRAWELEMENTSEXTPROC;
 extern   PFNGLMULTIDRAWARRAYSEXTPROC pglMultiDrawArraysEXT;
 extern   PFNGLMULTIDRAWELEMENTSEXTPROC pglMultiDrawElementsEXT;
alias pglMultiDrawArraysEXT glMultiDrawArraysEXT;
alias pglMultiDrawElementsEXT glMultiDrawElementsEXT;
//#endif ;

//GL_EXT_fog_coord

//#ifndef GL_EXT_fog_coord;
const uint GL_EXT_fog_coord = 1;
const uint __GLEE_GL_EXT_fog_coord = 1;
//constants
const uint GL_FOG_COORDINATE_SOURCE_EXT                       = 0x8450;
const uint GL_FOG_COORDINATE_EXT                              = 0x8451;
const uint GL_FRAGMENT_DEPTH_EXT                              = 0x8452;
const uint GL_CURRENT_FOG_COORDINATE_EXT                      = 0x8453;
const uint GL_FOG_COORDINATE_ARRAY_TYPE_EXT                   = 0x8454;
const uint GL_FOG_COORDINATE_ARRAY_STRIDE_EXT                 = 0x8455;
const uint GL_FOG_COORDINATE_ARRAY_POINTER_EXT                = 0x8456;
const uint GL_FOG_COORDINATE_ARRAY_EXT                        = 0x8457;
typedef void   function(GLfloat coord) PFNGLFOGCOORDFEXTPROC;
typedef void   function(GLfloat *coord) PFNGLFOGCOORDFVEXTPROC;
typedef void   function(GLdouble coord) PFNGLFOGCOORDDEXTPROC;
typedef void   function(GLdouble *coord) PFNGLFOGCOORDDVEXTPROC;
typedef void   function(GLenum type, GLsizei stride, GLvoid *pointer) PFNGLFOGCOORDPOINTEREXTPROC;
 extern   PFNGLFOGCOORDFEXTPROC pglFogCoordfEXT;
 extern   PFNGLFOGCOORDFVEXTPROC pglFogCoordfvEXT;
 extern   PFNGLFOGCOORDDEXTPROC pglFogCoorddEXT;
 extern   PFNGLFOGCOORDDVEXTPROC pglFogCoorddvEXT;
 extern   PFNGLFOGCOORDPOINTEREXTPROC pglFogCoordPointerEXT;
alias pglFogCoordfEXT glFogCoordfEXT;
alias pglFogCoordfvEXT glFogCoordfvEXT;
alias pglFogCoorddEXT glFogCoorddEXT;
alias pglFogCoorddvEXT glFogCoorddvEXT;
alias pglFogCoordPointerEXT glFogCoordPointerEXT;
//#endif ;

//GL_REND_screen_coordinates

//#ifndef GL_REND_screen_coordinates;
const uint GL_REND_screen_coordinates = 1;
const uint __GLEE_GL_REND_screen_coordinates = 1;
//constants
const uint GL_SCREEN_COORDINATES_REND                         = 0x8490;
const uint GL_INVERTED_SCREEN_W_REND                          = 0x8491;
//#endif ;

//GL_EXT_coordinate_frame

//#ifndef GL_EXT_coordinate_frame;
const uint GL_EXT_coordinate_frame = 1;
const uint __GLEE_GL_EXT_coordinate_frame = 1;
//constants
const uint GL_TANGENT_ARRAY_EXT                               = 0x8439;
const uint GL_BINORMAL_ARRAY_EXT                              = 0x843A;
const uint GL_CURRENT_TANGENT_EXT                             = 0x843B;
const uint GL_CURRENT_BINORMAL_EXT                            = 0x843C;
const uint GL_TANGENT_ARRAY_TYPE_EXT                          = 0x843E;
const uint GL_TANGENT_ARRAY_STRIDE_EXT                        = 0x843F;
const uint GL_BINORMAL_ARRAY_TYPE_EXT                         = 0x8440;
const uint GL_BINORMAL_ARRAY_STRIDE_EXT                       = 0x8441;
const uint GL_TANGENT_ARRAY_POINTER_EXT                       = 0x8442;
const uint GL_BINORMAL_ARRAY_POINTER_EXT                      = 0x8443;
const uint GL_MAP1_TANGENT_EXT                                = 0x8444;
const uint GL_MAP2_TANGENT_EXT                                = 0x8445;
const uint GL_MAP1_BINORMAL_EXT                               = 0x8446;
const uint GL_MAP2_BINORMAL_EXT                               = 0x8447;
typedef void   function(GLbyte tx, GLbyte ty, GLbyte tz) PFNGLTANGENT3BEXTPROC;
typedef void   function(GLbyte *v) PFNGLTANGENT3BVEXTPROC;
typedef void   function(GLdouble tx, GLdouble ty, GLdouble tz) PFNGLTANGENT3DEXTPROC;
typedef void   function(GLdouble *v) PFNGLTANGENT3DVEXTPROC;
typedef void   function(GLfloat tx, GLfloat ty, GLfloat tz) PFNGLTANGENT3FEXTPROC;
typedef void   function(GLfloat *v) PFNGLTANGENT3FVEXTPROC;
typedef void   function(GLint tx, GLint ty, GLint tz) PFNGLTANGENT3IEXTPROC;
typedef void   function(GLint *v) PFNGLTANGENT3IVEXTPROC;
typedef void   function(GLshort tx, GLshort ty, GLshort tz) PFNGLTANGENT3SEXTPROC;
typedef void   function(GLshort *v) PFNGLTANGENT3SVEXTPROC;
typedef void   function(GLbyte bx, GLbyte by, GLbyte bz) PFNGLBINORMAL3BEXTPROC;
typedef void   function(GLbyte *v) PFNGLBINORMAL3BVEXTPROC;
typedef void   function(GLdouble bx, GLdouble by, GLdouble bz) PFNGLBINORMAL3DEXTPROC;
typedef void   function(GLdouble *v) PFNGLBINORMAL3DVEXTPROC;
typedef void   function(GLfloat bx, GLfloat by, GLfloat bz) PFNGLBINORMAL3FEXTPROC;
typedef void   function(GLfloat *v) PFNGLBINORMAL3FVEXTPROC;
typedef void   function(GLint bx, GLint by, GLint bz) PFNGLBINORMAL3IEXTPROC;
typedef void   function(GLint *v) PFNGLBINORMAL3IVEXTPROC;
typedef void   function(GLshort bx, GLshort by, GLshort bz) PFNGLBINORMAL3SEXTPROC;
typedef void   function(GLshort *v) PFNGLBINORMAL3SVEXTPROC;
typedef void   function(GLenum type, GLsizei stride, GLvoid *pointer) PFNGLTANGENTPOINTEREXTPROC;
typedef void   function(GLenum type, GLsizei stride, GLvoid *pointer) PFNGLBINORMALPOINTEREXTPROC;
 extern   PFNGLTANGENT3BEXTPROC pglTangent3bEXT;
 extern   PFNGLTANGENT3BVEXTPROC pglTangent3bvEXT;
 extern   PFNGLTANGENT3DEXTPROC pglTangent3dEXT;
 extern   PFNGLTANGENT3DVEXTPROC pglTangent3dvEXT;
 extern   PFNGLTANGENT3FEXTPROC pglTangent3fEXT;
 extern   PFNGLTANGENT3FVEXTPROC pglTangent3fvEXT;
 extern   PFNGLTANGENT3IEXTPROC pglTangent3iEXT;
 extern   PFNGLTANGENT3IVEXTPROC pglTangent3ivEXT;
 extern   PFNGLTANGENT3SEXTPROC pglTangent3sEXT;
 extern   PFNGLTANGENT3SVEXTPROC pglTangent3svEXT;
 extern   PFNGLBINORMAL3BEXTPROC pglBinormal3bEXT;
 extern   PFNGLBINORMAL3BVEXTPROC pglBinormal3bvEXT;
 extern   PFNGLBINORMAL3DEXTPROC pglBinormal3dEXT;
 extern   PFNGLBINORMAL3DVEXTPROC pglBinormal3dvEXT;
 extern   PFNGLBINORMAL3FEXTPROC pglBinormal3fEXT;
 extern   PFNGLBINORMAL3FVEXTPROC pglBinormal3fvEXT;
 extern   PFNGLBINORMAL3IEXTPROC pglBinormal3iEXT;
 extern   PFNGLBINORMAL3IVEXTPROC pglBinormal3ivEXT;
 extern   PFNGLBINORMAL3SEXTPROC pglBinormal3sEXT;
 extern   PFNGLBINORMAL3SVEXTPROC pglBinormal3svEXT;
 extern   PFNGLTANGENTPOINTEREXTPROC pglTangentPointerEXT;
 extern   PFNGLBINORMALPOINTEREXTPROC pglBinormalPointerEXT;
alias pglTangent3bEXT glTangent3bEXT;
alias pglTangent3bvEXT glTangent3bvEXT;
alias pglTangent3dEXT glTangent3dEXT;
alias pglTangent3dvEXT glTangent3dvEXT;
alias pglTangent3fEXT glTangent3fEXT;
alias pglTangent3fvEXT glTangent3fvEXT;
alias pglTangent3iEXT glTangent3iEXT;
alias pglTangent3ivEXT glTangent3ivEXT;
alias pglTangent3sEXT glTangent3sEXT;
alias pglTangent3svEXT glTangent3svEXT;
alias pglBinormal3bEXT glBinormal3bEXT;
alias pglBinormal3bvEXT glBinormal3bvEXT;
alias pglBinormal3dEXT glBinormal3dEXT;
alias pglBinormal3dvEXT glBinormal3dvEXT;
alias pglBinormal3fEXT glBinormal3fEXT;
alias pglBinormal3fvEXT glBinormal3fvEXT;
alias pglBinormal3iEXT glBinormal3iEXT;
alias pglBinormal3ivEXT glBinormal3ivEXT;
alias pglBinormal3sEXT glBinormal3sEXT;
alias pglBinormal3svEXT glBinormal3svEXT;
alias pglTangentPointerEXT glTangentPointerEXT;
alias pglBinormalPointerEXT glBinormalPointerEXT;
//#endif ;

//GL_EXT_texture_env_combine

//#ifndef GL_EXT_texture_env_combine;
const uint GL_EXT_texture_env_combine = 1;
const uint __GLEE_GL_EXT_texture_env_combine = 1;
//constants
const uint GL_COMBINE_EXT                                     = 0x8570;
const uint GL_COMBINE_RGB_EXT                                 = 0x8571;
const uint GL_COMBINE_ALPHA_EXT                               = 0x8572;
const uint GL_RGB_SCALE_EXT                                   = 0x8573;
const uint GL_ADD_SIGNED_EXT                                  = 0x8574;
const uint GL_INTERPOLATE_EXT                                 = 0x8575;
const uint GL_CONSTANT_EXT                                    = 0x8576;
const uint GL_PRIMARY_COLOR_EXT                               = 0x8577;
const uint GL_PREVIOUS_EXT                                    = 0x8578;
const uint GL_SOURCE0_RGB_EXT                                 = 0x8580;
const uint GL_SOURCE1_RGB_EXT                                 = 0x8581;
const uint GL_SOURCE2_RGB_EXT                                 = 0x8582;
const uint GL_SOURCE0_ALPHA_EXT                               = 0x8588;
const uint GL_SOURCE1_ALPHA_EXT                               = 0x8589;
const uint GL_SOURCE2_ALPHA_EXT                               = 0x858A;
const uint GL_OPERAND0_RGB_EXT                                = 0x8590;
const uint GL_OPERAND1_RGB_EXT                                = 0x8591;
const uint GL_OPERAND2_RGB_EXT                                = 0x8592;
const uint GL_OPERAND0_ALPHA_EXT                              = 0x8598;
const uint GL_OPERAND1_ALPHA_EXT                              = 0x8599;
const uint GL_OPERAND2_ALPHA_EXT                              = 0x859A;
//#endif ;

//GL_APPLE_specular_vector

//#ifndef GL_APPLE_specular_vector;
const uint GL_APPLE_specular_vector = 1;
const uint __GLEE_GL_APPLE_specular_vector = 1;
//constants
const uint GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE               = 0x85B0;
//#endif ;

//GL_APPLE_transform_hint

//#ifndef GL_APPLE_transform_hint;
const uint GL_APPLE_transform_hint = 1;
const uint __GLEE_GL_APPLE_transform_hint = 1;
//constants
const uint GL_TRANSFORM_HINT_APPLE                            = 0x85B1;
//#endif ;

//GL_SGIX_fog_scale

//#ifndef GL_SGIX_fog_scale;
const uint GL_SGIX_fog_scale = 1;
const uint __GLEE_GL_SGIX_fog_scale = 1;
//constants
const uint GL_FOG_SCALE_SGIX                                  = 0x81FC;
const uint GL_FOG_SCALE_VALUE_SGIX                            = 0x81FD;
//#endif ;

//GL_SUNX_constant_data

//#ifndef GL_SUNX_constant_data;
const uint GL_SUNX_constant_data = 1;
const uint __GLEE_GL_SUNX_constant_data = 1;
//constants
const uint GL_UNPACK_CONSTANT_DATA_SUNX                       = 0x81D5;
const uint GL_TEXTURE_CONSTANT_DATA_SUNX                      = 0x81D6;
typedef void   function() PFNGLFINISHTEXTURESUNXPROC;
 extern   PFNGLFINISHTEXTURESUNXPROC pglFinishTextureSUNX;
alias pglFinishTextureSUNX glFinishTextureSUNX;
//#endif ;

//GL_SUN_global_alpha

//#ifndef GL_SUN_global_alpha;
const uint GL_SUN_global_alpha = 1;
const uint __GLEE_GL_SUN_global_alpha = 1;
//constants
const uint GL_GLOBAL_ALPHA_SUN                                = 0x81D9;
const uint GL_GLOBAL_ALPHA_FACTOR_SUN                         = 0x81DA;
typedef void   function(GLbyte factor) PFNGLGLOBALALPHAFACTORBSUNPROC;
typedef void   function(GLshort factor) PFNGLGLOBALALPHAFACTORSSUNPROC;
typedef void   function(GLint factor) PFNGLGLOBALALPHAFACTORISUNPROC;
typedef void   function(GLfloat factor) PFNGLGLOBALALPHAFACTORFSUNPROC;
typedef void   function(GLdouble factor) PFNGLGLOBALALPHAFACTORDSUNPROC;
typedef void   function(GLubyte factor) PFNGLGLOBALALPHAFACTORUBSUNPROC;
typedef void   function(GLushort factor) PFNGLGLOBALALPHAFACTORUSSUNPROC;
typedef void   function(GLuint factor) PFNGLGLOBALALPHAFACTORUISUNPROC;
 extern   PFNGLGLOBALALPHAFACTORBSUNPROC pglGlobalAlphaFactorbSUN;
 extern   PFNGLGLOBALALPHAFACTORSSUNPROC pglGlobalAlphaFactorsSUN;
 extern   PFNGLGLOBALALPHAFACTORISUNPROC pglGlobalAlphaFactoriSUN;
 extern   PFNGLGLOBALALPHAFACTORFSUNPROC pglGlobalAlphaFactorfSUN;
 extern   PFNGLGLOBALALPHAFACTORDSUNPROC pglGlobalAlphaFactordSUN;
 extern   PFNGLGLOBALALPHAFACTORUBSUNPROC pglGlobalAlphaFactorubSUN;
 extern   PFNGLGLOBALALPHAFACTORUSSUNPROC pglGlobalAlphaFactorusSUN;
 extern   PFNGLGLOBALALPHAFACTORUISUNPROC pglGlobalAlphaFactoruiSUN;
alias pglGlobalAlphaFactorbSUN glGlobalAlphaFactorbSUN;
alias pglGlobalAlphaFactorsSUN glGlobalAlphaFactorsSUN;
alias pglGlobalAlphaFactoriSUN glGlobalAlphaFactoriSUN;
alias pglGlobalAlphaFactorfSUN glGlobalAlphaFactorfSUN;
alias pglGlobalAlphaFactordSUN glGlobalAlphaFactordSUN;
alias pglGlobalAlphaFactorubSUN glGlobalAlphaFactorubSUN;
alias pglGlobalAlphaFactorusSUN glGlobalAlphaFactorusSUN;
alias pglGlobalAlphaFactoruiSUN glGlobalAlphaFactoruiSUN;
//#endif ;

//GL_SUN_triangle_list

//#ifndef GL_SUN_triangle_list;
const uint GL_SUN_triangle_list = 1;
const uint __GLEE_GL_SUN_triangle_list = 1;
//constants
const uint GL_RESTART_SUN                                     = 0x0001;
const uint GL_REPLACE_MIDDLE_SUN                              = 0x0002;
const uint GL_REPLACE_OLDEST_SUN                              = 0x0003;
const uint GL_TRIANGLE_LIST_SUN                               = 0x81D7;
const uint GL_REPLACEMENT_CODE_SUN                            = 0x81D8;
const uint GL_REPLACEMENT_CODE_ARRAY_SUN                      = 0x85C0;
const uint GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN                 = 0x85C1;
const uint GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN               = 0x85C2;
const uint GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN              = 0x85C3;
const uint GL_R1UI_V3F_SUN                                    = 0x85C4;
const uint GL_R1UI_C4UB_V3F_SUN                               = 0x85C5;
const uint GL_R1UI_C3F_V3F_SUN                                = 0x85C6;
const uint GL_R1UI_N3F_V3F_SUN                                = 0x85C7;
const uint GL_R1UI_C4F_N3F_V3F_SUN                            = 0x85C8;
const uint GL_R1UI_T2F_V3F_SUN                                = 0x85C9;
const uint GL_R1UI_T2F_N3F_V3F_SUN                            = 0x85CA;
const uint GL_R1UI_T2F_C4F_N3F_V3F_SUN                        = 0x85CB;
typedef void   function(GLuint code) PFNGLREPLACEMENTCODEUISUNPROC;
typedef void   function(GLushort code) PFNGLREPLACEMENTCODEUSSUNPROC;
typedef void   function(GLubyte code) PFNGLREPLACEMENTCODEUBSUNPROC;
typedef void   function(GLuint *code) PFNGLREPLACEMENTCODEUIVSUNPROC;
typedef void   function(GLushort *code) PFNGLREPLACEMENTCODEUSVSUNPROC;
typedef void   function(GLubyte *code) PFNGLREPLACEMENTCODEUBVSUNPROC;
typedef void   function(GLenum type, GLsizei stride, GLvoid* *pointer) PFNGLREPLACEMENTCODEPOINTERSUNPROC;
 extern   PFNGLREPLACEMENTCODEUISUNPROC pglReplacementCodeuiSUN;
 extern   PFNGLREPLACEMENTCODEUSSUNPROC pglReplacementCodeusSUN;
 extern   PFNGLREPLACEMENTCODEUBSUNPROC pglReplacementCodeubSUN;
 extern   PFNGLREPLACEMENTCODEUIVSUNPROC pglReplacementCodeuivSUN;
 extern   PFNGLREPLACEMENTCODEUSVSUNPROC pglReplacementCodeusvSUN;
 extern   PFNGLREPLACEMENTCODEUBVSUNPROC pglReplacementCodeubvSUN;
 extern   PFNGLREPLACEMENTCODEPOINTERSUNPROC pglReplacementCodePointerSUN;
alias pglReplacementCodeuiSUN glReplacementCodeuiSUN;
alias pglReplacementCodeusSUN glReplacementCodeusSUN;
alias pglReplacementCodeubSUN glReplacementCodeubSUN;
alias pglReplacementCodeuivSUN glReplacementCodeuivSUN;
alias pglReplacementCodeusvSUN glReplacementCodeusvSUN;
alias pglReplacementCodeubvSUN glReplacementCodeubvSUN;
alias pglReplacementCodePointerSUN glReplacementCodePointerSUN;
//#endif ;

//GL_SUN_vertex

//#ifndef GL_SUN_vertex;
const uint GL_SUN_vertex = 1;
const uint __GLEE_GL_SUN_vertex = 1;
//constants
typedef void   function(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y) PFNGLCOLOR4UBVERTEX2FSUNPROC;
typedef void   function(GLubyte *c, GLfloat *v) PFNGLCOLOR4UBVERTEX2FVSUNPROC;
typedef void   function(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z) PFNGLCOLOR4UBVERTEX3FSUNPROC;
typedef void   function(GLubyte *c, GLfloat *v) PFNGLCOLOR4UBVERTEX3FVSUNPROC;
typedef void   function(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z) PFNGLCOLOR3FVERTEX3FSUNPROC;
typedef void   function(GLfloat *c, GLfloat *v) PFNGLCOLOR3FVERTEX3FVSUNPROC;
typedef void   function(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLNORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLfloat *n, GLfloat *v) PFNGLNORMAL3FVERTEX3FVSUNPROC;
typedef void   function(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLfloat *c, GLfloat *n, GLfloat *v) PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC;
typedef void   function(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z) PFNGLTEXCOORD2FVERTEX3FSUNPROC;
typedef void   function(GLfloat *tc, GLfloat *v) PFNGLTEXCOORD2FVERTEX3FVSUNPROC;
typedef void   function(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLTEXCOORD4FVERTEX4FSUNPROC;
typedef void   function(GLfloat *tc, GLfloat *v) PFNGLTEXCOORD4FVERTEX4FVSUNPROC;
typedef void   function(GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z) PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC;
typedef void   function(GLfloat *tc, GLubyte *c, GLfloat *v) PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC;
typedef void   function(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z) PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC;
typedef void   function(GLfloat *tc, GLfloat *c, GLfloat *v) PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC;
typedef void   function(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLfloat *tc, GLfloat *n, GLfloat *v) PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC;
typedef void   function(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLfloat *tc, GLfloat *c, GLfloat *n, GLfloat *v) PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC;
typedef void   function(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC;
typedef void   function(GLfloat *tc, GLfloat *c, GLfloat *n, GLfloat *v) PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC;
typedef void   function(GLuint rc, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLfloat *v) PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC;
typedef void   function(GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLubyte *c, GLfloat *v) PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC;
typedef void   function(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLfloat *c, GLfloat *v) PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC;
typedef void   function(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLfloat *n, GLfloat *v) PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC;
typedef void   function(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLfloat *c, GLfloat *n, GLfloat *v) PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC;
typedef void   function(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLfloat *tc, GLfloat *v) PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC;
typedef void   function(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLfloat *tc, GLfloat *n, GLfloat *v) PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC;
typedef void   function(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z) PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC;
typedef void   function(GLuint *rc, GLfloat *tc, GLfloat *c, GLfloat *n, GLfloat *v) PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC;
 extern   PFNGLCOLOR4UBVERTEX2FSUNPROC pglColor4ubVertex2fSUN;
 extern   PFNGLCOLOR4UBVERTEX2FVSUNPROC pglColor4ubVertex2fvSUN;
 extern   PFNGLCOLOR4UBVERTEX3FSUNPROC pglColor4ubVertex3fSUN;
 extern   PFNGLCOLOR4UBVERTEX3FVSUNPROC pglColor4ubVertex3fvSUN;
 extern   PFNGLCOLOR3FVERTEX3FSUNPROC pglColor3fVertex3fSUN;
 extern   PFNGLCOLOR3FVERTEX3FVSUNPROC pglColor3fVertex3fvSUN;
 extern   PFNGLNORMAL3FVERTEX3FSUNPROC pglNormal3fVertex3fSUN;
 extern   PFNGLNORMAL3FVERTEX3FVSUNPROC pglNormal3fVertex3fvSUN;
 extern   PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC pglColor4fNormal3fVertex3fSUN;
 extern   PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC pglColor4fNormal3fVertex3fvSUN;
 extern   PFNGLTEXCOORD2FVERTEX3FSUNPROC pglTexCoord2fVertex3fSUN;
 extern   PFNGLTEXCOORD2FVERTEX3FVSUNPROC pglTexCoord2fVertex3fvSUN;
 extern   PFNGLTEXCOORD4FVERTEX4FSUNPROC pglTexCoord4fVertex4fSUN;
 extern   PFNGLTEXCOORD4FVERTEX4FVSUNPROC pglTexCoord4fVertex4fvSUN;
 extern   PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC pglTexCoord2fColor4ubVertex3fSUN;
 extern   PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC pglTexCoord2fColor4ubVertex3fvSUN;
 extern   PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC pglTexCoord2fColor3fVertex3fSUN;
 extern   PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC pglTexCoord2fColor3fVertex3fvSUN;
 extern   PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC pglTexCoord2fNormal3fVertex3fSUN;
 extern   PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC pglTexCoord2fNormal3fVertex3fvSUN;
 extern   PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC pglTexCoord2fColor4fNormal3fVertex3fSUN;
 extern   PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC pglTexCoord2fColor4fNormal3fVertex3fvSUN;
 extern   PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC pglTexCoord4fColor4fNormal3fVertex4fSUN;
 extern   PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC pglTexCoord4fColor4fNormal3fVertex4fvSUN;
 extern   PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC pglReplacementCodeuiVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC pglReplacementCodeuiVertex3fvSUN;
 extern   PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC pglReplacementCodeuiColor4ubVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC pglReplacementCodeuiColor4ubVertex3fvSUN;
 extern   PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC pglReplacementCodeuiColor3fVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC pglReplacementCodeuiColor3fVertex3fvSUN;
 extern   PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC pglReplacementCodeuiNormal3fVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC pglReplacementCodeuiNormal3fVertex3fvSUN;
 extern   PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC pglReplacementCodeuiColor4fNormal3fVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC pglReplacementCodeuiColor4fNormal3fVertex3fvSUN;
 extern   PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC pglReplacementCodeuiTexCoord2fVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC pglReplacementCodeuiTexCoord2fVertex3fvSUN;
 extern   PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC pglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC pglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
 extern   PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC pglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
 extern   PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC pglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
alias pglColor4ubVertex2fSUN glColor4ubVertex2fSUN;
alias pglColor4ubVertex2fvSUN glColor4ubVertex2fvSUN;
alias pglColor4ubVertex3fSUN glColor4ubVertex3fSUN;
alias pglColor4ubVertex3fvSUN glColor4ubVertex3fvSUN;
alias pglColor3fVertex3fSUN glColor3fVertex3fSUN;
alias pglColor3fVertex3fvSUN glColor3fVertex3fvSUN;
alias pglNormal3fVertex3fSUN glNormal3fVertex3fSUN;
alias pglNormal3fVertex3fvSUN glNormal3fVertex3fvSUN;
alias pglColor4fNormal3fVertex3fSUN glColor4fNormal3fVertex3fSUN;
alias pglColor4fNormal3fVertex3fvSUN glColor4fNormal3fVertex3fvSUN;
alias pglTexCoord2fVertex3fSUN glTexCoord2fVertex3fSUN;
alias pglTexCoord2fVertex3fvSUN glTexCoord2fVertex3fvSUN;
alias pglTexCoord4fVertex4fSUN glTexCoord4fVertex4fSUN;
alias pglTexCoord4fVertex4fvSUN glTexCoord4fVertex4fvSUN;
alias pglTexCoord2fColor4ubVertex3fSUN glTexCoord2fColor4ubVertex3fSUN;
alias pglTexCoord2fColor4ubVertex3fvSUN glTexCoord2fColor4ubVertex3fvSUN;
alias pglTexCoord2fColor3fVertex3fSUN glTexCoord2fColor3fVertex3fSUN;
alias pglTexCoord2fColor3fVertex3fvSUN glTexCoord2fColor3fVertex3fvSUN;
alias pglTexCoord2fNormal3fVertex3fSUN glTexCoord2fNormal3fVertex3fSUN;
alias pglTexCoord2fNormal3fVertex3fvSUN glTexCoord2fNormal3fVertex3fvSUN;
alias pglTexCoord2fColor4fNormal3fVertex3fSUN glTexCoord2fColor4fNormal3fVertex3fSUN;
alias pglTexCoord2fColor4fNormal3fVertex3fvSUN glTexCoord2fColor4fNormal3fVertex3fvSUN;
alias pglTexCoord4fColor4fNormal3fVertex4fSUN glTexCoord4fColor4fNormal3fVertex4fSUN;
alias pglTexCoord4fColor4fNormal3fVertex4fvSUN glTexCoord4fColor4fNormal3fVertex4fvSUN;
alias pglReplacementCodeuiVertex3fSUN glReplacementCodeuiVertex3fSUN;
alias pglReplacementCodeuiVertex3fvSUN glReplacementCodeuiVertex3fvSUN;
alias pglReplacementCodeuiColor4ubVertex3fSUN glReplacementCodeuiColor4ubVertex3fSUN;
alias pglReplacementCodeuiColor4ubVertex3fvSUN glReplacementCodeuiColor4ubVertex3fvSUN;
alias pglReplacementCodeuiColor3fVertex3fSUN glReplacementCodeuiColor3fVertex3fSUN;
alias pglReplacementCodeuiColor3fVertex3fvSUN glReplacementCodeuiColor3fVertex3fvSUN;
alias pglReplacementCodeuiNormal3fVertex3fSUN glReplacementCodeuiNormal3fVertex3fSUN;
alias pglReplacementCodeuiNormal3fVertex3fvSUN glReplacementCodeuiNormal3fVertex3fvSUN;
alias pglReplacementCodeuiColor4fNormal3fVertex3fSUN glReplacementCodeuiColor4fNormal3fVertex3fSUN;
alias pglReplacementCodeuiColor4fNormal3fVertex3fvSUN glReplacementCodeuiColor4fNormal3fVertex3fvSUN;
alias pglReplacementCodeuiTexCoord2fVertex3fSUN glReplacementCodeuiTexCoord2fVertex3fSUN;
alias pglReplacementCodeuiTexCoord2fVertex3fvSUN glReplacementCodeuiTexCoord2fVertex3fvSUN;
alias pglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
alias pglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
alias pglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
alias pglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
//#endif ;

//GL_EXT_blend_func_separate

//#ifndef GL_EXT_blend_func_separate;
const uint GL_EXT_blend_func_separate = 1;
const uint __GLEE_GL_EXT_blend_func_separate = 1;
//constants
const uint GL_BLEND_DST_RGB_EXT                               = 0x80C8;
const uint GL_BLEND_SRC_RGB_EXT                               = 0x80C9;
const uint GL_BLEND_DST_ALPHA_EXT                             = 0x80CA;
const uint GL_BLEND_SRC_ALPHA_EXT                             = 0x80CB;
typedef void   function(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) PFNGLBLENDFUNCSEPARATEEXTPROC;
 extern   PFNGLBLENDFUNCSEPARATEEXTPROC pglBlendFuncSeparateEXT;
alias pglBlendFuncSeparateEXT glBlendFuncSeparateEXT;
//#endif ;

//GL_INGR_color_clamp

//#ifndef GL_INGR_color_clamp;
const uint GL_INGR_color_clamp = 1;
const uint __GLEE_GL_INGR_color_clamp = 1;
//constants
const uint GL_RED_MIN_CLAMP_INGR                              = 0x8560;
const uint GL_GREEN_MIN_CLAMP_INGR                            = 0x8561;
const uint GL_BLUE_MIN_CLAMP_INGR                             = 0x8562;
const uint GL_ALPHA_MIN_CLAMP_INGR                            = 0x8563;
const uint GL_RED_MAX_CLAMP_INGR                              = 0x8564;
const uint GL_GREEN_MAX_CLAMP_INGR                            = 0x8565;
const uint GL_BLUE_MAX_CLAMP_INGR                             = 0x8566;
const uint GL_ALPHA_MAX_CLAMP_INGR                            = 0x8567;
//#endif ;

//GL_INGR_interlace_read

//#ifndef GL_INGR_interlace_read;
const uint GL_INGR_interlace_read = 1;
const uint __GLEE_GL_INGR_interlace_read = 1;
//constants
const uint GL_INTERLACE_READ_INGR                             = 0x8568;
//#endif ;

//GL_EXT_stencil_wrap

//#ifndef GL_EXT_stencil_wrap;
const uint GL_EXT_stencil_wrap = 1;
const uint __GLEE_GL_EXT_stencil_wrap = 1;
//constants
const uint GL_INCR_WRAP_EXT                                   = 0x8507;
const uint GL_DECR_WRAP_EXT                                   = 0x8508;
//#endif ;

//GL_EXT_422_pixels

//#ifndef GL_EXT_422_pixels;
const uint GL_EXT_422_pixels = 1;
const uint __GLEE_GL_EXT_422_pixels = 1;
//constants
const uint GL_422_EXT                                         = 0x80CC;
const uint GL_422_REV_EXT                                     = 0x80CD;
const uint GL_422_AVERAGE_EXT                                 = 0x80CE;
const uint GL_422_REV_AVERAGE_EXT                             = 0x80CF;
//#endif ;

//GL_NV_texgen_reflection

//#ifndef GL_NV_texgen_reflection;
const uint GL_NV_texgen_reflection = 1;
const uint __GLEE_GL_NV_texgen_reflection = 1;
//constants
const uint GL_NORMAL_MAP_NV                                   = 0x8511;
const uint GL_REFLECTION_MAP_NV                               = 0x8512;
//#endif ;

//GL_EXT_texture_cube_map

//#ifndef GL_EXT_texture_cube_map;
const uint GL_EXT_texture_cube_map = 1;
const uint __GLEE_GL_EXT_texture_cube_map = 1;
//constants
const uint GL_NORMAL_MAP_EXT                                  = 0x8511;
const uint GL_REFLECTION_MAP_EXT                              = 0x8512;
const uint GL_TEXTURE_CUBE_MAP_EXT                            = 0x8513;
const uint GL_TEXTURE_BINDING_CUBE_MAP_EXT                    = 0x8514;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT                 = 0x8515;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT                 = 0x8516;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT                 = 0x8517;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT                 = 0x8518;
const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT                 = 0x8519;
const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT                 = 0x851A;
const uint GL_PROXY_TEXTURE_CUBE_MAP_EXT                      = 0x851B;
const uint GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT                   = 0x851C;
//#endif ;

//GL_SUN_convolution_border_modes

//#ifndef GL_SUN_convolution_border_modes;
const uint GL_SUN_convolution_border_modes = 1;
const uint __GLEE_GL_SUN_convolution_border_modes = 1;
//constants
const uint GL_WRAP_BORDER_SUN                                 = 0x81D4;
//#endif ;

//GL_EXT_texture_env_add

//#ifndef GL_EXT_texture_env_add;
const uint GL_EXT_texture_env_add = 1;
const uint __GLEE_GL_EXT_texture_env_add = 1;
//constants
//#endif ;

//GL_EXT_texture_lod_bias

//#ifndef GL_EXT_texture_lod_bias;
const uint GL_EXT_texture_lod_bias = 1;
const uint __GLEE_GL_EXT_texture_lod_bias = 1;
//constants
const uint GL_MAX_TEXTURE_LOD_BIAS_EXT                        = 0x84FD;
const uint GL_TEXTURE_FILTER_CONTROL_EXT                      = 0x8500;
const uint GL_TEXTURE_LOD_BIAS_EXT                            = 0x8501;
//#endif ;

//GL_EXT_texture_filter_anisotropic

//#ifndef GL_EXT_texture_filter_anisotropic;
const uint GL_EXT_texture_filter_anisotropic = 1;
const uint __GLEE_GL_EXT_texture_filter_anisotropic = 1;
//constants
const uint GL_TEXTURE_MAX_ANISOTROPY_EXT                      = 0x84FE;
const uint GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT                  = 0x84FF;
//#endif ;

//GL_EXT_vertex_weighting

//#ifndef GL_EXT_vertex_weighting;
const uint GL_EXT_vertex_weighting = 1;
const uint __GLEE_GL_EXT_vertex_weighting = 1;
//constants
const uint GL_MODELVIEW0_STACK_DEPTH_EXT                      = GL_MODELVIEW_STACK_DEPTH;
const uint GL_MODELVIEW1_STACK_DEPTH_EXT                      = 0x8502;
const uint GL_MODELVIEW0_MATRIX_EXT                           = GL_MODELVIEW_MATRIX;
const uint GL_MODELVIEW1_MATRIX_EXT                           = 0x8506;
const uint GL_VERTEX_WEIGHTING_EXT                            = 0x8509;
const uint GL_MODELVIEW0_EXT                                  = GL_MODELVIEW;
const uint GL_MODELVIEW1_EXT                                  = 0x850A;
const uint GL_CURRENT_VERTEX_WEIGHT_EXT                       = 0x850B;
const uint GL_VERTEX_WEIGHT_ARRAY_EXT                         = 0x850C;
const uint GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT                    = 0x850D;
const uint GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT                    = 0x850E;
const uint GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT                  = 0x850F;
const uint GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT                 = 0x8510;
typedef void   function(GLfloat weight) PFNGLVERTEXWEIGHTFEXTPROC;
typedef void   function(GLfloat *weight) PFNGLVERTEXWEIGHTFVEXTPROC;
typedef void   function(GLsizei size, GLenum type, GLsizei stride, GLvoid *pointer) PFNGLVERTEXWEIGHTPOINTEREXTPROC;
 extern   PFNGLVERTEXWEIGHTFEXTPROC pglVertexWeightfEXT;
 extern   PFNGLVERTEXWEIGHTFVEXTPROC pglVertexWeightfvEXT;
 extern   PFNGLVERTEXWEIGHTPOINTEREXTPROC pglVertexWeightPointerEXT;
alias pglVertexWeightfEXT glVertexWeightfEXT;
alias pglVertexWeightfvEXT glVertexWeightfvEXT;
alias pglVertexWeightPointerEXT glVertexWeightPointerEXT;
//#endif ;

//GL_NV_light_max_exponent

//#ifndef GL_NV_light_max_exponent;
const uint GL_NV_light_max_exponent = 1;
const uint __GLEE_GL_NV_light_max_exponent = 1;
//constants
const uint GL_MAX_SHININESS_NV                                = 0x8504;
const uint GL_MAX_SPOT_EXPONENT_NV                            = 0x8505;
//#endif ;

//GL_NV_vertex_array_range

//#ifndef GL_NV_vertex_array_range;
const uint GL_NV_vertex_array_range = 1;
const uint __GLEE_GL_NV_vertex_array_range = 1;
//constants
const uint GL_VERTEX_ARRAY_RANGE_NV                           = 0x851D;
const uint GL_VERTEX_ARRAY_RANGE_LENGTH_NV                    = 0x851E;
const uint GL_VERTEX_ARRAY_RANGE_VALID_NV                     = 0x851F;
const uint GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV               = 0x8520;
const uint GL_VERTEX_ARRAY_RANGE_POINTER_NV                   = 0x8521;
typedef void   function() PFNGLFLUSHVERTEXARRAYRANGENVPROC;
typedef void   function(GLsizei length, GLvoid *pointer) PFNGLVERTEXARRAYRANGENVPROC;
 extern   PFNGLFLUSHVERTEXARRAYRANGENVPROC pglFlushVertexArrayRangeNV;
 extern   PFNGLVERTEXARRAYRANGENVPROC pglVertexArrayRangeNV;
alias pglFlushVertexArrayRangeNV glFlushVertexArrayRangeNV;
alias pglVertexArrayRangeNV glVertexArrayRangeNV;
//#endif ;

//GL_NV_register_combiners

//#ifndef GL_NV_register_combiners;
const uint GL_NV_register_combiners = 1;
const uint __GLEE_GL_NV_register_combiners = 1;
//constants
const uint GL_REGISTER_COMBINERS_NV                           = 0x8522;
const uint GL_VARIABLE_A_NV                                   = 0x8523;
const uint GL_VARIABLE_B_NV                                   = 0x8524;
const uint GL_VARIABLE_C_NV                                   = 0x8525;
const uint GL_VARIABLE_D_NV                                   = 0x8526;
const uint GL_VARIABLE_E_NV                                   = 0x8527;
const uint GL_VARIABLE_F_NV                                   = 0x8528;
const uint GL_VARIABLE_G_NV                                   = 0x8529;
const uint GL_CONSTANT_COLOR0_NV                              = 0x852A;
const uint GL_CONSTANT_COLOR1_NV                              = 0x852B;
const uint GL_PRIMARY_COLOR_NV                                = 0x852C;
const uint GL_SECONDARY_COLOR_NV                              = 0x852D;
const uint GL_SPARE0_NV                                       = 0x852E;
const uint GL_SPARE1_NV                                       = 0x852F;
const uint GL_DISCARD_NV                                      = 0x8530;
const uint GL_E_TIMES_F_NV                                    = 0x8531;
const uint GL_SPARE0_PLUS_SECONDARY_COLOR_NV                  = 0x8532;
const uint GL_UNSIGNED_IDENTITY_NV                            = 0x8536;
const uint GL_UNSIGNED_INVERT_NV                              = 0x8537;
const uint GL_EXPAND_NORMAL_NV                                = 0x8538;
const uint GL_EXPAND_NEGATE_NV                                = 0x8539;
const uint GL_HALF_BIAS_NORMAL_NV                             = 0x853A;
const uint GL_HALF_BIAS_NEGATE_NV                             = 0x853B;
const uint GL_SIGNED_IDENTITY_NV                              = 0x853C;
const uint GL_SIGNED_NEGATE_NV                                = 0x853D;
const uint GL_SCALE_BY_TWO_NV                                 = 0x853E;
const uint GL_SCALE_BY_FOUR_NV                                = 0x853F;
const uint GL_SCALE_BY_ONE_HALF_NV                            = 0x8540;
const uint GL_BIAS_BY_NEGATIVE_ONE_HALF_NV                    = 0x8541;
const uint GL_COMBINER_INPUT_NV                               = 0x8542;
const uint GL_COMBINER_MAPPING_NV                             = 0x8543;
const uint GL_COMBINER_COMPONENT_USAGE_NV                     = 0x8544;
const uint GL_COMBINER_AB_DOT_PRODUCT_NV                      = 0x8545;
const uint GL_COMBINER_CD_DOT_PRODUCT_NV                      = 0x8546;
const uint GL_COMBINER_MUX_SUM_NV                             = 0x8547;
const uint GL_COMBINER_SCALE_NV                               = 0x8548;
const uint GL_COMBINER_BIAS_NV                                = 0x8549;
const uint GL_COMBINER_AB_OUTPUT_NV                           = 0x854A;
const uint GL_COMBINER_CD_OUTPUT_NV                           = 0x854B;
const uint GL_COMBINER_SUM_OUTPUT_NV                          = 0x854C;
const uint GL_MAX_GENERAL_COMBINERS_NV                        = 0x854D;
const uint GL_NUM_GENERAL_COMBINERS_NV                        = 0x854E;
const uint GL_COLOR_SUM_CLAMP_NV                              = 0x854F;
const uint GL_COMBINER0_NV                                    = 0x8550;
const uint GL_COMBINER1_NV                                    = 0x8551;
const uint GL_COMBINER2_NV                                    = 0x8552;
const uint GL_COMBINER3_NV                                    = 0x8553;
const uint GL_COMBINER4_NV                                    = 0x8554;
const uint GL_COMBINER5_NV                                    = 0x8555;
const uint GL_COMBINER6_NV                                    = 0x8556;
const uint GL_COMBINER7_NV                                    = 0x8557;
typedef void   function(GLenum pname, GLfloat *params) PFNGLCOMBINERPARAMETERFVNVPROC;
typedef void   function(GLenum pname, GLfloat param) PFNGLCOMBINERPARAMETERFNVPROC;
typedef void   function(GLenum pname, GLint *params) PFNGLCOMBINERPARAMETERIVNVPROC;
typedef void   function(GLenum pname, GLint param) PFNGLCOMBINERPARAMETERINVPROC;
typedef void   function(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage) PFNGLCOMBINERINPUTNVPROC;
typedef void   function(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum) PFNGLCOMBINEROUTPUTNVPROC;
typedef void   function(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage) PFNGLFINALCOMBINERINPUTNVPROC;
typedef void   function(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params) PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC;
typedef void   function(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params) PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC;
typedef void   function(GLenum stage, GLenum portion, GLenum pname, GLfloat *params) PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC;
typedef void   function(GLenum stage, GLenum portion, GLenum pname, GLint *params) PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC;
typedef void   function(GLenum variable, GLenum pname, GLfloat *params) PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC;
typedef void   function(GLenum variable, GLenum pname, GLint *params) PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC;
 extern   PFNGLCOMBINERPARAMETERFVNVPROC pglCombinerParameterfvNV;
 extern   PFNGLCOMBINERPARAMETERFNVPROC pglCombinerParameterfNV;
 extern   PFNGLCOMBINERPARAMETERIVNVPROC pglCombinerParameterivNV;
 extern   PFNGLCOMBINERPARAMETERINVPROC pglCombinerParameteriNV;
 extern   PFNGLCOMBINERINPUTNVPROC pglCombinerInputNV;
 extern   PFNGLCOMBINEROUTPUTNVPROC pglCombinerOutputNV;
 extern   PFNGLFINALCOMBINERINPUTNVPROC pglFinalCombinerInputNV;
 extern   PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC pglGetCombinerInputParameterfvNV;
 extern   PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC pglGetCombinerInputParameterivNV;
 extern   PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC pglGetCombinerOutputParameterfvNV;
 extern   PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC pglGetCombinerOutputParameterivNV;
 extern   PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC pglGetFinalCombinerInputParameterfvNV;
 extern   PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC pglGetFinalCombinerInputParameterivNV;
alias pglCombinerParameterfvNV glCombinerParameterfvNV;
alias pglCombinerParameterfNV glCombinerParameterfNV;
alias pglCombinerParameterivNV glCombinerParameterivNV;
alias pglCombinerParameteriNV glCombinerParameteriNV;
alias pglCombinerInputNV glCombinerInputNV;
alias pglCombinerOutputNV glCombinerOutputNV;
alias pglFinalCombinerInputNV glFinalCombinerInputNV;
alias pglGetCombinerInputParameterfvNV glGetCombinerInputParameterfvNV;
alias pglGetCombinerInputParameterivNV glGetCombinerInputParameterivNV;
alias pglGetCombinerOutputParameterfvNV glGetCombinerOutputParameterfvNV;
alias pglGetCombinerOutputParameterivNV glGetCombinerOutputParameterivNV;
alias pglGetFinalCombinerInputParameterfvNV glGetFinalCombinerInputParameterfvNV;
alias pglGetFinalCombinerInputParameterivNV glGetFinalCombinerInputParameterivNV;
//#endif ;

//GL_NV_fog_distance

//#ifndef GL_NV_fog_distance;
const uint GL_NV_fog_distance = 1;
const uint __GLEE_GL_NV_fog_distance = 1;
//constants
const uint GL_FOG_DISTANCE_MODE_NV                            = 0x855A;
const uint GL_EYE_RADIAL_NV                                   = 0x855B;
const uint GL_EYE_PLANE_ABSOLUTE_NV                           = 0x855C;
//#endif ;

//GL_NV_texgen_emboss

//#ifndef GL_NV_texgen_emboss;
const uint GL_NV_texgen_emboss = 1;
const uint __GLEE_GL_NV_texgen_emboss = 1;
//constants
const uint GL_EMBOSS_LIGHT_NV                                 = 0x855D;
const uint GL_EMBOSS_CONSTANT_NV                              = 0x855E;
const uint GL_EMBOSS_MAP_NV                                   = 0x855F;
//#endif ;

//GL_NV_blend_square

//#ifndef GL_NV_blend_square;
const uint GL_NV_blend_square = 1;
const uint __GLEE_GL_NV_blend_square = 1;
//constants
//#endif ;

//GL_NV_texture_env_combine4

//#ifndef GL_NV_texture_env_combine4;
const uint GL_NV_texture_env_combine4 = 1;
const uint __GLEE_GL_NV_texture_env_combine4 = 1;
//constants
const uint GL_COMBINE4_NV                                     = 0x8503;
const uint GL_SOURCE3_RGB_NV                                  = 0x8583;
const uint GL_SOURCE3_ALPHA_NV                                = 0x858B;
const uint GL_OPERAND3_RGB_NV                                 = 0x8593;
const uint GL_OPERAND3_ALPHA_NV                               = 0x859B;
//#endif ;

//GL_MESA_resize_buffers

//#ifndef GL_MESA_resize_buffers;
const uint GL_MESA_resize_buffers = 1;
const uint __GLEE_GL_MESA_resize_buffers = 1;
//constants
typedef void   function() PFNGLRESIZEBUFFERSMESAPROC;
 extern   PFNGLRESIZEBUFFERSMESAPROC pglResizeBuffersMESA;
alias pglResizeBuffersMESA glResizeBuffersMESA;
//#endif ;

//GL_MESA_window_pos

//#ifndef GL_MESA_window_pos;
const uint GL_MESA_window_pos = 1;
const uint __GLEE_GL_MESA_window_pos = 1;
//constants
typedef void   function(GLdouble x, GLdouble y) PFNGLWINDOWPOS2DMESAPROC;
typedef void   function(GLdouble *v) PFNGLWINDOWPOS2DVMESAPROC;
typedef void   function(GLfloat x, GLfloat y) PFNGLWINDOWPOS2FMESAPROC;
typedef void   function(GLfloat *v) PFNGLWINDOWPOS2FVMESAPROC;
typedef void   function(GLint x, GLint y) PFNGLWINDOWPOS2IMESAPROC;
typedef void   function(GLint *v) PFNGLWINDOWPOS2IVMESAPROC;
typedef void   function(GLshort x, GLshort y) PFNGLWINDOWPOS2SMESAPROC;
typedef void   function(GLshort *v) PFNGLWINDOWPOS2SVMESAPROC;
typedef void   function(GLdouble x, GLdouble y, GLdouble z) PFNGLWINDOWPOS3DMESAPROC;
typedef void   function(GLdouble *v) PFNGLWINDOWPOS3DVMESAPROC;
typedef void   function(GLfloat x, GLfloat y, GLfloat z) PFNGLWINDOWPOS3FMESAPROC;
typedef void   function(GLfloat *v) PFNGLWINDOWPOS3FVMESAPROC;
typedef void   function(GLint x, GLint y, GLint z) PFNGLWINDOWPOS3IMESAPROC;
typedef void   function(GLint *v) PFNGLWINDOWPOS3IVMESAPROC;
typedef void   function(GLshort x, GLshort y, GLshort z) PFNGLWINDOWPOS3SMESAPROC;
typedef void   function(GLshort *v) PFNGLWINDOWPOS3SVMESAPROC;
typedef void   function(GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLWINDOWPOS4DMESAPROC;
typedef void   function(GLdouble *v) PFNGLWINDOWPOS4DVMESAPROC;
typedef void   function(GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLWINDOWPOS4FMESAPROC;
typedef void   function(GLfloat *v) PFNGLWINDOWPOS4FVMESAPROC;
typedef void   function(GLint x, GLint y, GLint z, GLint w) PFNGLWINDOWPOS4IMESAPROC;
typedef void   function(GLint *v) PFNGLWINDOWPOS4IVMESAPROC;
typedef void   function(GLshort x, GLshort y, GLshort z, GLshort w) PFNGLWINDOWPOS4SMESAPROC;
typedef void   function(GLshort *v) PFNGLWINDOWPOS4SVMESAPROC;
 extern   PFNGLWINDOWPOS2DMESAPROC pglWindowPos2dMESA;
 extern   PFNGLWINDOWPOS2DVMESAPROC pglWindowPos2dvMESA;
 extern   PFNGLWINDOWPOS2FMESAPROC pglWindowPos2fMESA;
 extern   PFNGLWINDOWPOS2FVMESAPROC pglWindowPos2fvMESA;
 extern   PFNGLWINDOWPOS2IMESAPROC pglWindowPos2iMESA;
 extern   PFNGLWINDOWPOS2IVMESAPROC pglWindowPos2ivMESA;
 extern   PFNGLWINDOWPOS2SMESAPROC pglWindowPos2sMESA;
 extern   PFNGLWINDOWPOS2SVMESAPROC pglWindowPos2svMESA;
 extern   PFNGLWINDOWPOS3DMESAPROC pglWindowPos3dMESA;
 extern   PFNGLWINDOWPOS3DVMESAPROC pglWindowPos3dvMESA;
 extern   PFNGLWINDOWPOS3FMESAPROC pglWindowPos3fMESA;
 extern   PFNGLWINDOWPOS3FVMESAPROC pglWindowPos3fvMESA;
 extern   PFNGLWINDOWPOS3IMESAPROC pglWindowPos3iMESA;
 extern   PFNGLWINDOWPOS3IVMESAPROC pglWindowPos3ivMESA;
 extern   PFNGLWINDOWPOS3SMESAPROC pglWindowPos3sMESA;
 extern   PFNGLWINDOWPOS3SVMESAPROC pglWindowPos3svMESA;
 extern   PFNGLWINDOWPOS4DMESAPROC pglWindowPos4dMESA;
 extern   PFNGLWINDOWPOS4DVMESAPROC pglWindowPos4dvMESA;
 extern   PFNGLWINDOWPOS4FMESAPROC pglWindowPos4fMESA;
 extern   PFNGLWINDOWPOS4FVMESAPROC pglWindowPos4fvMESA;
 extern   PFNGLWINDOWPOS4IMESAPROC pglWindowPos4iMESA;
 extern   PFNGLWINDOWPOS4IVMESAPROC pglWindowPos4ivMESA;
 extern   PFNGLWINDOWPOS4SMESAPROC pglWindowPos4sMESA;
 extern   PFNGLWINDOWPOS4SVMESAPROC pglWindowPos4svMESA;
alias pglWindowPos2dMESA glWindowPos2dMESA;
alias pglWindowPos2dvMESA glWindowPos2dvMESA;
alias pglWindowPos2fMESA glWindowPos2fMESA;
alias pglWindowPos2fvMESA glWindowPos2fvMESA;
alias pglWindowPos2iMESA glWindowPos2iMESA;
alias pglWindowPos2ivMESA glWindowPos2ivMESA;
alias pglWindowPos2sMESA glWindowPos2sMESA;
alias pglWindowPos2svMESA glWindowPos2svMESA;
alias pglWindowPos3dMESA glWindowPos3dMESA;
alias pglWindowPos3dvMESA glWindowPos3dvMESA;
alias pglWindowPos3fMESA glWindowPos3fMESA;
alias pglWindowPos3fvMESA glWindowPos3fvMESA;
alias pglWindowPos3iMESA glWindowPos3iMESA;
alias pglWindowPos3ivMESA glWindowPos3ivMESA;
alias pglWindowPos3sMESA glWindowPos3sMESA;
alias pglWindowPos3svMESA glWindowPos3svMESA;
alias pglWindowPos4dMESA glWindowPos4dMESA;
alias pglWindowPos4dvMESA glWindowPos4dvMESA;
alias pglWindowPos4fMESA glWindowPos4fMESA;
alias pglWindowPos4fvMESA glWindowPos4fvMESA;
alias pglWindowPos4iMESA glWindowPos4iMESA;
alias pglWindowPos4ivMESA glWindowPos4ivMESA;
alias pglWindowPos4sMESA glWindowPos4sMESA;
alias pglWindowPos4svMESA glWindowPos4svMESA;
//#endif ;

//GL_EXT_texture_compression_s3tc

//#ifndef GL_EXT_texture_compression_s3tc;
const uint GL_EXT_texture_compression_s3tc = 1;
const uint __GLEE_GL_EXT_texture_compression_s3tc = 1;
//constants
const uint GL_COMPRESSED_RGB_S3TC_DXT1_EXT                    = 0x83F0;
const uint GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                   = 0x83F1;
const uint GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                   = 0x83F2;
const uint GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                   = 0x83F3;
//#endif ;

//GL_IBM_cull_vertex

//#ifndef GL_IBM_cull_vertex;
const uint GL_IBM_cull_vertex = 1;
const uint __GLEE_GL_IBM_cull_vertex = 1;
//constants
const uint GL_CULL_VERTEX_IBM                                 = 103050;
//#endif ;

//GL_IBM_multimode_draw_arrays

//#ifndef GL_IBM_multimode_draw_arrays;
const uint GL_IBM_multimode_draw_arrays = 1;
const uint __GLEE_GL_IBM_multimode_draw_arrays = 1;
//constants
typedef void   function(GLenum *mode, GLint *first, GLsizei *count, GLsizei primcount, GLint modestride) PFNGLMULTIMODEDRAWARRAYSIBMPROC;
typedef void   function(GLenum *mode, GLsizei *count, GLenum type, GLvoid* *indices, GLsizei primcount, GLint modestride) PFNGLMULTIMODEDRAWELEMENTSIBMPROC;
 extern   PFNGLMULTIMODEDRAWARRAYSIBMPROC pglMultiModeDrawArraysIBM;
 extern   PFNGLMULTIMODEDRAWELEMENTSIBMPROC pglMultiModeDrawElementsIBM;
alias pglMultiModeDrawArraysIBM glMultiModeDrawArraysIBM;
alias pglMultiModeDrawElementsIBM glMultiModeDrawElementsIBM;
//#endif ;

//GL_IBM_vertex_array_lists

//#ifndef GL_IBM_vertex_array_lists;
const uint GL_IBM_vertex_array_lists = 1;
const uint __GLEE_GL_IBM_vertex_array_lists = 1;
//constants
const uint GL_VERTEX_ARRAY_LIST_IBM                           = 103070;
const uint GL_NORMAL_ARRAY_LIST_IBM                           = 103071;
const uint GL_COLOR_ARRAY_LIST_IBM                            = 103072;
const uint GL_INDEX_ARRAY_LIST_IBM                            = 103073;
const uint GL_TEXTURE_COORD_ARRAY_LIST_IBM                    = 103074;
const uint GL_EDGE_FLAG_ARRAY_LIST_IBM                        = 103075;
const uint GL_FOG_COORDINATE_ARRAY_LIST_IBM                   = 103076;
const uint GL_SECONDARY_COLOR_ARRAY_LIST_IBM                  = 103077;
const uint GL_VERTEX_ARRAY_LIST_STRIDE_IBM                    = 103080;
const uint GL_NORMAL_ARRAY_LIST_STRIDE_IBM                    = 103081;
const uint GL_COLOR_ARRAY_LIST_STRIDE_IBM                     = 103082;
const uint GL_INDEX_ARRAY_LIST_STRIDE_IBM                     = 103083;
const uint GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM             = 103084;
const uint GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM                 = 103085;
const uint GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM            = 103086;
const uint GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM           = 103087;
typedef void   function(GLint size, GLenum type, GLint stride, GLvoid* *pointer, GLint ptrstride) PFNGLCOLORPOINTERLISTIBMPROC;
typedef void   function(GLint size, GLenum type, GLint stride, GLvoid* *pointer, GLint ptrstride) PFNGLSECONDARYCOLORPOINTERLISTIBMPROC;
typedef void   function(GLint stride, GLboolean* *pointer, GLint ptrstride) PFNGLEDGEFLAGPOINTERLISTIBMPROC;
typedef void   function(GLenum type, GLint stride, GLvoid* *pointer, GLint ptrstride) PFNGLFOGCOORDPOINTERLISTIBMPROC;
typedef void   function(GLenum type, GLint stride, GLvoid* *pointer, GLint ptrstride) PFNGLINDEXPOINTERLISTIBMPROC;
typedef void   function(GLenum type, GLint stride, GLvoid* *pointer, GLint ptrstride) PFNGLNORMALPOINTERLISTIBMPROC;
typedef void   function(GLint size, GLenum type, GLint stride, GLvoid* *pointer, GLint ptrstride) PFNGLTEXCOORDPOINTERLISTIBMPROC;
typedef void   function(GLint size, GLenum type, GLint stride, GLvoid* *pointer, GLint ptrstride) PFNGLVERTEXPOINTERLISTIBMPROC;
 extern   PFNGLCOLORPOINTERLISTIBMPROC pglColorPointerListIBM;
 extern   PFNGLSECONDARYCOLORPOINTERLISTIBMPROC pglSecondaryColorPointerListIBM;
 extern   PFNGLEDGEFLAGPOINTERLISTIBMPROC pglEdgeFlagPointerListIBM;
 extern   PFNGLFOGCOORDPOINTERLISTIBMPROC pglFogCoordPointerListIBM;
 extern   PFNGLINDEXPOINTERLISTIBMPROC pglIndexPointerListIBM;
 extern   PFNGLNORMALPOINTERLISTIBMPROC pglNormalPointerListIBM;
 extern   PFNGLTEXCOORDPOINTERLISTIBMPROC pglTexCoordPointerListIBM;
 extern   PFNGLVERTEXPOINTERLISTIBMPROC pglVertexPointerListIBM;
alias pglColorPointerListIBM glColorPointerListIBM;
alias pglSecondaryColorPointerListIBM glSecondaryColorPointerListIBM;
alias pglEdgeFlagPointerListIBM glEdgeFlagPointerListIBM;
alias pglFogCoordPointerListIBM glFogCoordPointerListIBM;
alias pglIndexPointerListIBM glIndexPointerListIBM;
alias pglNormalPointerListIBM glNormalPointerListIBM;
alias pglTexCoordPointerListIBM glTexCoordPointerListIBM;
alias pglVertexPointerListIBM glVertexPointerListIBM;
//#endif ;

//GL_SGIX_subsample

//#ifndef GL_SGIX_subsample;
const uint GL_SGIX_subsample = 1;
const uint __GLEE_GL_SGIX_subsample = 1;
//constants
const uint GL_PACK_SUBSAMPLE_RATE_SGIX                        = 0x85A0;
const uint GL_UNPACK_SUBSAMPLE_RATE_SGIX                      = 0x85A1;
const uint GL_PIXEL_SUBSAMPLE_4444_SGIX                       = 0x85A2;
const uint GL_PIXEL_SUBSAMPLE_2424_SGIX                       = 0x85A3;
const uint GL_PIXEL_SUBSAMPLE_4242_SGIX                       = 0x85A4;
//#endif ;

//GL_SGIX_ycrcb_subsample

//#ifndef GL_SGIX_ycrcb_subsample;
const uint GL_SGIX_ycrcb_subsample = 1;
const uint __GLEE_GL_SGIX_ycrcb_subsample = 1;
//constants
//#endif ;

//GL_SGIX_ycrcba

//#ifndef GL_SGIX_ycrcba;
const uint GL_SGIX_ycrcba = 1;
const uint __GLEE_GL_SGIX_ycrcba = 1;
//constants
const uint GL_YCRCB_SGIX                                      = 0x8318;
const uint GL_YCRCBA_SGIX                                     = 0x8319;
//#endif ;

//GL_SGI_depth_pass_instrument

//#ifndef GL_SGI_depth_pass_instrument;
const uint GL_SGI_depth_pass_instrument = 1;
const uint __GLEE_GL_SGI_depth_pass_instrument = 1;
//constants
const uint GL_DEPTH_PASS_INSTRUMENT_SGIX                      = 0x8310;
const uint GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX             = 0x8311;
const uint GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX                  = 0x8312;
//#endif ;

//GL_3DFX_texture_compression_FXT1

//#ifndef GL_3DFX_texture_compression_FXT1;
const uint GL_3DFX_texture_compression_FXT1 = 1;
const uint __GLEE_GL_3DFX_texture_compression_FXT1 = 1;
//constants
const uint GL_COMPRESSED_RGB_FXT1_3DFX                        = 0x86B0;
const uint GL_COMPRESSED_RGBA_FXT1_3DFX                       = 0x86B1;
//#endif ;

//GL_3DFX_multisample

//#ifndef GL_3DFX_multisample;
const uint GL_3DFX_multisample = 1;
const uint __GLEE_GL_3DFX_multisample = 1;
//constants
const uint GL_MULTISAMPLE_3DFX                                = 0x86B2;
const uint GL_SAMPLE_BUFFERS_3DFX                             = 0x86B3;
const uint GL_SAMPLES_3DFX                                    = 0x86B4;
const uint GL_MULTISAMPLE_BIT_3DFX                            = 0x20000000;
//#endif ;

//GL_3DFX_tbuffer

//#ifndef GL_3DFX_tbuffer;
const uint GL_3DFX_tbuffer = 1;
const uint __GLEE_GL_3DFX_tbuffer = 1;
//constants
typedef void   function(GLuint mask) PFNGLTBUFFERMASK3DFXPROC;
 extern   PFNGLTBUFFERMASK3DFXPROC pglTbufferMask3DFX;
alias pglTbufferMask3DFX glTbufferMask3DFX;
//#endif ;

//GL_EXT_multisample

//#ifndef GL_EXT_multisample;
const uint GL_EXT_multisample = 1;
const uint __GLEE_GL_EXT_multisample = 1;
//constants
const uint GL_MULTISAMPLE_EXT                                 = 0x809D;
const uint GL_SAMPLE_ALPHA_TO_MASK_EXT                        = 0x809E;
const uint GL_SAMPLE_ALPHA_TO_ONE_EXT                         = 0x809F;
const uint GL_SAMPLE_MASK_EXT                                 = 0x80A0;
const uint GL_1PASS_EXT                                       = 0x80A1;
const uint GL_2PASS_0_EXT                                     = 0x80A2;
const uint GL_2PASS_1_EXT                                     = 0x80A3;
const uint GL_4PASS_0_EXT                                     = 0x80A4;
const uint GL_4PASS_1_EXT                                     = 0x80A5;
const uint GL_4PASS_2_EXT                                     = 0x80A6;
const uint GL_4PASS_3_EXT                                     = 0x80A7;
const uint GL_SAMPLE_BUFFERS_EXT                              = 0x80A8;
const uint GL_SAMPLES_EXT                                     = 0x80A9;
const uint GL_SAMPLE_MASK_VALUE_EXT                           = 0x80AA;
const uint GL_SAMPLE_MASK_INVERT_EXT                          = 0x80AB;
const uint GL_SAMPLE_PATTERN_EXT                              = 0x80AC;
const uint GL_MULTISAMPLE_BIT_EXT                             = 0x20000000;
typedef void   function(GLclampf value, GLboolean invert) PFNGLSAMPLEMASKEXTPROC;
typedef void   function(GLenum pattern) PFNGLSAMPLEPATTERNEXTPROC;
 extern   PFNGLSAMPLEMASKEXTPROC pglSampleMaskEXT;
 extern   PFNGLSAMPLEPATTERNEXTPROC pglSamplePatternEXT;
alias pglSampleMaskEXT glSampleMaskEXT;
alias pglSamplePatternEXT glSamplePatternEXT;
//#endif ;

//GL_SGIX_vertex_preclip

//#ifndef GL_SGIX_vertex_preclip;
const uint GL_SGIX_vertex_preclip = 1;
const uint __GLEE_GL_SGIX_vertex_preclip = 1;
//constants
const uint GL_VERTEX_PRECLIP_SGIX                             = 0x83EE;
const uint GL_VERTEX_PRECLIP_HINT_SGIX                        = 0x83EF;
//#endif ;

//GL_SGIX_convolution_accuracy

//#ifndef GL_SGIX_convolution_accuracy;
const uint GL_SGIX_convolution_accuracy = 1;
const uint __GLEE_GL_SGIX_convolution_accuracy = 1;
//constants
const uint GL_CONVOLUTION_HINT_SGIX                           = 0x8316;
//#endif ;

//GL_SGIX_resample

//#ifndef GL_SGIX_resample;
const uint GL_SGIX_resample = 1;
const uint __GLEE_GL_SGIX_resample = 1;
//constants
const uint GL_PACK_RESAMPLE_SGIX                              = 0x842C;
const uint GL_UNPACK_RESAMPLE_SGIX                            = 0x842D;
const uint GL_RESAMPLE_REPLICATE_SGIX                         = 0x842E;
const uint GL_RESAMPLE_ZERO_FILL_SGIX                         = 0x842F;
const uint GL_RESAMPLE_DECIMATE_SGIX                          = 0x8430;
//#endif ;

//GL_SGIS_point_line_texgen

//#ifndef GL_SGIS_point_line_texgen;
const uint GL_SGIS_point_line_texgen = 1;
const uint __GLEE_GL_SGIS_point_line_texgen = 1;
//constants
const uint GL_EYE_DISTANCE_TO_POINT_SGIS                      = 0x81F0;
const uint GL_OBJECT_DISTANCE_TO_POINT_SGIS                   = 0x81F1;
const uint GL_EYE_DISTANCE_TO_LINE_SGIS                       = 0x81F2;
const uint GL_OBJECT_DISTANCE_TO_LINE_SGIS                    = 0x81F3;
const uint GL_EYE_POINT_SGIS                                  = 0x81F4;
const uint GL_OBJECT_POINT_SGIS                               = 0x81F5;
const uint GL_EYE_LINE_SGIS                                   = 0x81F6;
const uint GL_OBJECT_LINE_SGIS                                = 0x81F7;
//#endif ;

//GL_SGIS_texture_color_mask

//#ifndef GL_SGIS_texture_color_mask;
const uint GL_SGIS_texture_color_mask = 1;
const uint __GLEE_GL_SGIS_texture_color_mask = 1;
//constants
const uint GL_TEXTURE_COLOR_WRITEMASK_SGIS                    = 0x81EF;
typedef void   function(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) PFNGLTEXTURECOLORMASKSGISPROC;
 extern   PFNGLTEXTURECOLORMASKSGISPROC pglTextureColorMaskSGIS;
alias pglTextureColorMaskSGIS glTextureColorMaskSGIS;
//#endif ;

//GL_EXT_texture_env_dot3

//#ifndef GL_EXT_texture_env_dot3;
const uint GL_EXT_texture_env_dot3 = 1;
const uint __GLEE_GL_EXT_texture_env_dot3 = 1;
//constants
const uint GL_DOT3_RGB_EXT                                    = 0x8740;
const uint GL_DOT3_RGBA_EXT                                   = 0x8741;
//#endif ;

//GL_ATI_texture_mirror_once

//#ifndef GL_ATI_texture_mirror_once;
const uint GL_ATI_texture_mirror_once = 1;
const uint __GLEE_GL_ATI_texture_mirror_once = 1;
//constants
const uint GL_MIRROR_CLAMP_ATI                                = 0x8742;
const uint GL_MIRROR_CLAMP_TO_EDGE_ATI                        = 0x8743;
//#endif ;

//GL_NV_fence

//#ifndef GL_NV_fence;
const uint GL_NV_fence = 1;
const uint __GLEE_GL_NV_fence = 1;
//constants
const uint GL_ALL_COMPLETED_NV                                = 0x84F2;
const uint GL_FENCE_STATUS_NV                                 = 0x84F3;
const uint GL_FENCE_CONDITION_NV                              = 0x84F4;
typedef void   function(GLsizei n, GLuint *fences) PFNGLDELETEFENCESNVPROC;
typedef void   function(GLsizei n, GLuint *fences) PFNGLGENFENCESNVPROC;
typedef GLboolean   function(GLuint fence) PFNGLISFENCENVPROC;
typedef GLboolean   function(GLuint fence) PFNGLTESTFENCENVPROC;
typedef void   function(GLuint fence, GLenum pname, GLint *params) PFNGLGETFENCEIVNVPROC;
typedef void   function(GLuint fence) PFNGLFINISHFENCENVPROC;
typedef void   function(GLuint fence, GLenum condition) PFNGLSETFENCENVPROC;
 extern   PFNGLDELETEFENCESNVPROC pglDeleteFencesNV;
 extern   PFNGLGENFENCESNVPROC pglGenFencesNV;
 extern   PFNGLISFENCENVPROC pglIsFenceNV;
 extern   PFNGLTESTFENCENVPROC pglTestFenceNV;
 extern   PFNGLGETFENCEIVNVPROC pglGetFenceivNV;
 extern   PFNGLFINISHFENCENVPROC pglFinishFenceNV;
 extern   PFNGLSETFENCENVPROC pglSetFenceNV;
alias pglDeleteFencesNV glDeleteFencesNV;
alias pglGenFencesNV glGenFencesNV;
alias pglIsFenceNV glIsFenceNV;
alias pglTestFenceNV glTestFenceNV;
alias pglGetFenceivNV glGetFenceivNV;
alias pglFinishFenceNV glFinishFenceNV;
alias pglSetFenceNV glSetFenceNV;
//#endif ;

//GL_IBM_texture_mirrored_repeat

//#ifndef GL_IBM_texture_mirrored_repeat;
const uint GL_IBM_texture_mirrored_repeat = 1;
const uint __GLEE_GL_IBM_texture_mirrored_repeat = 1;
//constants
const uint GL_MIRRORED_REPEAT_IBM                             = 0x8370;
//#endif ;

//GL_NV_evaluators

//#ifndef GL_NV_evaluators;
const uint GL_NV_evaluators = 1;
const uint __GLEE_GL_NV_evaluators = 1;
//constants
const uint GL_EVAL_2D_NV                                      = 0x86C0;
const uint GL_EVAL_TRIANGULAR_2D_NV                           = 0x86C1;
const uint GL_MAP_TESSELLATION_NV                             = 0x86C2;
const uint GL_MAP_ATTRIB_U_ORDER_NV                           = 0x86C3;
const uint GL_MAP_ATTRIB_V_ORDER_NV                           = 0x86C4;
const uint GL_EVAL_FRACTIONAL_TESSELLATION_NV                 = 0x86C5;
const uint GL_EVAL_VERTEX_ATTRIB0_NV                          = 0x86C6;
const uint GL_EVAL_VERTEX_ATTRIB1_NV                          = 0x86C7;
const uint GL_EVAL_VERTEX_ATTRIB2_NV                          = 0x86C8;
const uint GL_EVAL_VERTEX_ATTRIB3_NV                          = 0x86C9;
const uint GL_EVAL_VERTEX_ATTRIB4_NV                          = 0x86CA;
const uint GL_EVAL_VERTEX_ATTRIB5_NV                          = 0x86CB;
const uint GL_EVAL_VERTEX_ATTRIB6_NV                          = 0x86CC;
const uint GL_EVAL_VERTEX_ATTRIB7_NV                          = 0x86CD;
const uint GL_EVAL_VERTEX_ATTRIB8_NV                          = 0x86CE;
const uint GL_EVAL_VERTEX_ATTRIB9_NV                          = 0x86CF;
const uint GL_EVAL_VERTEX_ATTRIB10_NV                         = 0x86D0;
const uint GL_EVAL_VERTEX_ATTRIB11_NV                         = 0x86D1;
const uint GL_EVAL_VERTEX_ATTRIB12_NV                         = 0x86D2;
const uint GL_EVAL_VERTEX_ATTRIB13_NV                         = 0x86D3;
const uint GL_EVAL_VERTEX_ATTRIB14_NV                         = 0x86D4;
const uint GL_EVAL_VERTEX_ATTRIB15_NV                         = 0x86D5;
const uint GL_MAX_MAP_TESSELLATION_NV                         = 0x86D6;
const uint GL_MAX_RATIONAL_EVAL_ORDER_NV                      = 0x86D7;
typedef void   function(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, GLvoid *points) PFNGLMAPCONTROLPOINTSNVPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLMAPPARAMETERIVNVPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLMAPPARAMETERFVNVPROC;
typedef void   function(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid *points) PFNGLGETMAPCONTROLPOINTSNVPROC;
typedef void   function(GLenum target, GLenum pname, GLint *params) PFNGLGETMAPPARAMETERIVNVPROC;
typedef void   function(GLenum target, GLenum pname, GLfloat *params) PFNGLGETMAPPARAMETERFVNVPROC;
typedef void   function(GLenum target, GLuint index, GLenum pname, GLint *params) PFNGLGETMAPATTRIBPARAMETERIVNVPROC;
typedef void   function(GLenum target, GLuint index, GLenum pname, GLfloat *params) PFNGLGETMAPATTRIBPARAMETERFVNVPROC;
typedef void   function(GLenum target, GLenum mode) PFNGLEVALMAPSNVPROC;
 extern   PFNGLMAPCONTROLPOINTSNVPROC pglMapControlPointsNV;
 extern   PFNGLMAPPARAMETERIVNVPROC pglMapParameterivNV;
 extern   PFNGLMAPPARAMETERFVNVPROC pglMapParameterfvNV;
 extern   PFNGLGETMAPCONTROLPOINTSNVPROC pglGetMapControlPointsNV;
 extern   PFNGLGETMAPPARAMETERIVNVPROC pglGetMapParameterivNV;
 extern   PFNGLGETMAPPARAMETERFVNVPROC pglGetMapParameterfvNV;
 extern   PFNGLGETMAPATTRIBPARAMETERIVNVPROC pglGetMapAttribParameterivNV;
 extern   PFNGLGETMAPATTRIBPARAMETERFVNVPROC pglGetMapAttribParameterfvNV;
 extern   PFNGLEVALMAPSNVPROC pglEvalMapsNV;
alias pglMapControlPointsNV glMapControlPointsNV;
alias pglMapParameterivNV glMapParameterivNV;
alias pglMapParameterfvNV glMapParameterfvNV;
alias pglGetMapControlPointsNV glGetMapControlPointsNV;
alias pglGetMapParameterivNV glGetMapParameterivNV;
alias pglGetMapParameterfvNV glGetMapParameterfvNV;
alias pglGetMapAttribParameterivNV glGetMapAttribParameterivNV;
alias pglGetMapAttribParameterfvNV glGetMapAttribParameterfvNV;
alias pglEvalMapsNV glEvalMapsNV;
//#endif ;

//GL_NV_packed_depth_stencil

//#ifndef GL_NV_packed_depth_stencil;
const uint GL_NV_packed_depth_stencil = 1;
const uint __GLEE_GL_NV_packed_depth_stencil = 1;
//constants
const uint GL_DEPTH_STENCIL_NV                                = 0x84F9;
const uint GL_UNSIGNED_INT_24_8_NV                            = 0x84FA;
//#endif ;

//GL_NV_register_combiners2

//#ifndef GL_NV_register_combiners2;
const uint GL_NV_register_combiners2 = 1;
const uint __GLEE_GL_NV_register_combiners2 = 1;
//constants
const uint GL_PER_STAGE_CONSTANTS_NV                          = 0x8535;
typedef void   function(GLenum stage, GLenum pname, GLfloat *params) PFNGLCOMBINERSTAGEPARAMETERFVNVPROC;
typedef void   function(GLenum stage, GLenum pname, GLfloat *params) PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC;
 extern   PFNGLCOMBINERSTAGEPARAMETERFVNVPROC pglCombinerStageParameterfvNV;
 extern   PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC pglGetCombinerStageParameterfvNV;
alias pglCombinerStageParameterfvNV glCombinerStageParameterfvNV;
alias pglGetCombinerStageParameterfvNV glGetCombinerStageParameterfvNV;
//#endif ;

//GL_NV_texture_compression_vtc

//#ifndef GL_NV_texture_compression_vtc;
const uint GL_NV_texture_compression_vtc = 1;
const uint __GLEE_GL_NV_texture_compression_vtc = 1;
//constants
//#endif ;

//GL_NV_texture_rectangle

//#ifndef GL_NV_texture_rectangle;
const uint GL_NV_texture_rectangle = 1;
const uint __GLEE_GL_NV_texture_rectangle = 1;
//constants
const uint GL_TEXTURE_RECTANGLE_NV                            = 0x84F5;
const uint GL_TEXTURE_BINDING_RECTANGLE_NV                    = 0x84F6;
const uint GL_PROXY_TEXTURE_RECTANGLE_NV                      = 0x84F7;
const uint GL_MAX_RECTANGLE_TEXTURE_SIZE_NV                   = 0x84F8;
//#endif ;

//GL_NV_texture_shader

//#ifndef GL_NV_texture_shader;
const uint GL_NV_texture_shader = 1;
const uint __GLEE_GL_NV_texture_shader = 1;
//constants
const uint GL_OFFSET_TEXTURE_RECTANGLE_NV                     = 0x864C;
const uint GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV               = 0x864D;
const uint GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV                = 0x864E;
const uint GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV            = 0x86D9;
const uint GL_UNSIGNED_INT_S8_S8_8_8_NV                       = 0x86DA;
const uint GL_UNSIGNED_INT_8_8_S8_S8_REV_NV                   = 0x86DB;
const uint GL_DSDT_MAG_INTENSITY_NV                           = 0x86DC;
const uint GL_SHADER_CONSISTENT_NV                            = 0x86DD;
const uint GL_TEXTURE_SHADER_NV                               = 0x86DE;
const uint GL_SHADER_OPERATION_NV                             = 0x86DF;
const uint GL_CULL_MODES_NV                                   = 0x86E0;
const uint GL_OFFSET_TEXTURE_MATRIX_NV                        = 0x86E1;
const uint GL_OFFSET_TEXTURE_SCALE_NV                         = 0x86E2;
const uint GL_OFFSET_TEXTURE_BIAS_NV                          = 0x86E3;
const uint GL_OFFSET_TEXTURE_2D_MATRIX_NV                     = GL_OFFSET_TEXTURE_MATRIX_NV;
const uint GL_OFFSET_TEXTURE_2D_SCALE_NV                      = GL_OFFSET_TEXTURE_SCALE_NV;
const uint GL_OFFSET_TEXTURE_2D_BIAS_NV                       = GL_OFFSET_TEXTURE_BIAS_NV;
const uint GL_PREVIOUS_TEXTURE_INPUT_NV                       = 0x86E4;
const uint GL_CONST_EYE_NV                                    = 0x86E5;
const uint GL_PASS_THROUGH_NV                                 = 0x86E6;
const uint GL_CULL_FRAGMENT_NV                                = 0x86E7;
const uint GL_OFFSET_TEXTURE_2D_NV                            = 0x86E8;
const uint GL_DEPENDENT_AR_TEXTURE_2D_NV                      = 0x86E9;
const uint GL_DEPENDENT_GB_TEXTURE_2D_NV                      = 0x86EA;
const uint GL_DOT_PRODUCT_NV                                  = 0x86EC;
const uint GL_DOT_PRODUCT_DEPTH_REPLACE_NV                    = 0x86ED;
const uint GL_DOT_PRODUCT_TEXTURE_2D_NV                       = 0x86EE;
const uint GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV                 = 0x86F0;
const uint GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV                 = 0x86F1;
const uint GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV                 = 0x86F2;
const uint GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV       = 0x86F3;
const uint GL_HILO_NV                                         = 0x86F4;
const uint GL_DSDT_NV                                         = 0x86F5;
const uint GL_DSDT_MAG_NV                                     = 0x86F6;
const uint GL_DSDT_MAG_VIB_NV                                 = 0x86F7;
const uint GL_HILO16_NV                                       = 0x86F8;
const uint GL_SIGNED_HILO_NV                                  = 0x86F9;
const uint GL_SIGNED_HILO16_NV                                = 0x86FA;
const uint GL_SIGNED_RGBA_NV                                  = 0x86FB;
const uint GL_SIGNED_RGBA8_NV                                 = 0x86FC;
const uint GL_SIGNED_RGB_NV                                   = 0x86FE;
const uint GL_SIGNED_RGB8_NV                                  = 0x86FF;
const uint GL_SIGNED_LUMINANCE_NV                             = 0x8701;
const uint GL_SIGNED_LUMINANCE8_NV                            = 0x8702;
const uint GL_SIGNED_LUMINANCE_ALPHA_NV                       = 0x8703;
const uint GL_SIGNED_LUMINANCE8_ALPHA8_NV                     = 0x8704;
const uint GL_SIGNED_ALPHA_NV                                 = 0x8705;
const uint GL_SIGNED_ALPHA8_NV                                = 0x8706;
const uint GL_SIGNED_INTENSITY_NV                             = 0x8707;
const uint GL_SIGNED_INTENSITY8_NV                            = 0x8708;
const uint GL_DSDT8_NV                                        = 0x8709;
const uint GL_DSDT8_MAG8_NV                                   = 0x870A;
const uint GL_DSDT8_MAG8_INTENSITY8_NV                        = 0x870B;
const uint GL_SIGNED_RGB_UNSIGNED_ALPHA_NV                    = 0x870C;
const uint GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV                  = 0x870D;
const uint GL_HI_SCALE_NV                                     = 0x870E;
const uint GL_LO_SCALE_NV                                     = 0x870F;
const uint GL_DS_SCALE_NV                                     = 0x8710;
const uint GL_DT_SCALE_NV                                     = 0x8711;
const uint GL_MAGNITUDE_SCALE_NV                              = 0x8712;
const uint GL_VIBRANCE_SCALE_NV                               = 0x8713;
const uint GL_HI_BIAS_NV                                      = 0x8714;
const uint GL_LO_BIAS_NV                                      = 0x8715;
const uint GL_DS_BIAS_NV                                      = 0x8716;
const uint GL_DT_BIAS_NV                                      = 0x8717;
const uint GL_MAGNITUDE_BIAS_NV                               = 0x8718;
const uint GL_VIBRANCE_BIAS_NV                                = 0x8719;
const uint GL_TEXTURE_BORDER_VALUES_NV                        = 0x871A;
const uint GL_TEXTURE_HI_SIZE_NV                              = 0x871B;
const uint GL_TEXTURE_LO_SIZE_NV                              = 0x871C;
const uint GL_TEXTURE_DS_SIZE_NV                              = 0x871D;
const uint GL_TEXTURE_DT_SIZE_NV                              = 0x871E;
const uint GL_TEXTURE_MAG_SIZE_NV                             = 0x871F;
//#endif ;

//GL_NV_texture_shader2

//#ifndef GL_NV_texture_shader2;
const uint GL_NV_texture_shader2 = 1;
const uint __GLEE_GL_NV_texture_shader2 = 1;
//constants
const uint GL_DOT_PRODUCT_TEXTURE_3D_NV                       = 0x86EF;
//#endif ;

//GL_NV_vertex_array_range2

//#ifndef GL_NV_vertex_array_range2;
const uint GL_NV_vertex_array_range2 = 1;
const uint __GLEE_GL_NV_vertex_array_range2 = 1;
//constants
const uint GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV             = 0x8533;
//#endif ;

//GL_NV_vertex_program

//#ifndef GL_NV_vertex_program;
const uint GL_NV_vertex_program = 1;
const uint __GLEE_GL_NV_vertex_program = 1;
//constants
const uint GL_VERTEX_PROGRAM_NV                               = 0x8620;
const uint GL_VERTEX_STATE_PROGRAM_NV                         = 0x8621;
const uint GL_ATTRIB_ARRAY_SIZE_NV                            = 0x8623;
const uint GL_ATTRIB_ARRAY_STRIDE_NV                          = 0x8624;
const uint GL_ATTRIB_ARRAY_TYPE_NV                            = 0x8625;
const uint GL_CURRENT_ATTRIB_NV                               = 0x8626;
const uint GL_PROGRAM_LENGTH_NV                               = 0x8627;
const uint GL_PROGRAM_STRING_NV                               = 0x8628;
const uint GL_MODELVIEW_PROJECTION_NV                         = 0x8629;
const uint GL_IDENTITY_NV                                     = 0x862A;
const uint GL_INVERSE_NV                                      = 0x862B;
const uint GL_TRANSPOSE_NV                                    = 0x862C;
const uint GL_INVERSE_TRANSPOSE_NV                            = 0x862D;
const uint GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV                 = 0x862E;
const uint GL_MAX_TRACK_MATRICES_NV                           = 0x862F;
const uint GL_MATRIX0_NV                                      = 0x8630;
const uint GL_MATRIX1_NV                                      = 0x8631;
const uint GL_MATRIX2_NV                                      = 0x8632;
const uint GL_MATRIX3_NV                                      = 0x8633;
const uint GL_MATRIX4_NV                                      = 0x8634;
const uint GL_MATRIX5_NV                                      = 0x8635;
const uint GL_MATRIX6_NV                                      = 0x8636;
const uint GL_MATRIX7_NV                                      = 0x8637;
const uint GL_CURRENT_MATRIX_STACK_DEPTH_NV                   = 0x8640;
const uint GL_CURRENT_MATRIX_NV                               = 0x8641;
const uint GL_VERTEX_PROGRAM_POINT_SIZE_NV                    = 0x8642;
const uint GL_VERTEX_PROGRAM_TWO_SIDE_NV                      = 0x8643;
const uint GL_PROGRAM_PARAMETER_NV                            = 0x8644;
const uint GL_ATTRIB_ARRAY_POINTER_NV                         = 0x8645;
const uint GL_PROGRAM_TARGET_NV                               = 0x8646;
const uint GL_PROGRAM_RESIDENT_NV                             = 0x8647;
const uint GL_TRACK_MATRIX_NV                                 = 0x8648;
const uint GL_TRACK_MATRIX_TRANSFORM_NV                       = 0x8649;
const uint GL_VERTEX_PROGRAM_BINDING_NV                       = 0x864A;
const uint GL_PROGRAM_ERROR_POSITION_NV                       = 0x864B;
const uint GL_VERTEX_ATTRIB_ARRAY0_NV                         = 0x8650;
const uint GL_VERTEX_ATTRIB_ARRAY1_NV                         = 0x8651;
const uint GL_VERTEX_ATTRIB_ARRAY2_NV                         = 0x8652;
const uint GL_VERTEX_ATTRIB_ARRAY3_NV                         = 0x8653;
const uint GL_VERTEX_ATTRIB_ARRAY4_NV                         = 0x8654;
const uint GL_VERTEX_ATTRIB_ARRAY5_NV                         = 0x8655;
const uint GL_VERTEX_ATTRIB_ARRAY6_NV                         = 0x8656;
const uint GL_VERTEX_ATTRIB_ARRAY7_NV                         = 0x8657;
const uint GL_VERTEX_ATTRIB_ARRAY8_NV                         = 0x8658;
const uint GL_VERTEX_ATTRIB_ARRAY9_NV                         = 0x8659;
const uint GL_VERTEX_ATTRIB_ARRAY10_NV                        = 0x865A;
const uint GL_VERTEX_ATTRIB_ARRAY11_NV                        = 0x865B;
const uint GL_VERTEX_ATTRIB_ARRAY12_NV                        = 0x865C;
const uint GL_VERTEX_ATTRIB_ARRAY13_NV                        = 0x865D;
const uint GL_VERTEX_ATTRIB_ARRAY14_NV                        = 0x865E;
const uint GL_VERTEX_ATTRIB_ARRAY15_NV                        = 0x865F;
const uint GL_MAP1_VERTEX_ATTRIB0_4_NV                        = 0x8660;
const uint GL_MAP1_VERTEX_ATTRIB1_4_NV                        = 0x8661;
const uint GL_MAP1_VERTEX_ATTRIB2_4_NV                        = 0x8662;
const uint GL_MAP1_VERTEX_ATTRIB3_4_NV                        = 0x8663;
const uint GL_MAP1_VERTEX_ATTRIB4_4_NV                        = 0x8664;
const uint GL_MAP1_VERTEX_ATTRIB5_4_NV                        = 0x8665;
const uint GL_MAP1_VERTEX_ATTRIB6_4_NV                        = 0x8666;
const uint GL_MAP1_VERTEX_ATTRIB7_4_NV                        = 0x8667;
const uint GL_MAP1_VERTEX_ATTRIB8_4_NV                        = 0x8668;
const uint GL_MAP1_VERTEX_ATTRIB9_4_NV                        = 0x8669;
const uint GL_MAP1_VERTEX_ATTRIB10_4_NV                       = 0x866A;
const uint GL_MAP1_VERTEX_ATTRIB11_4_NV                       = 0x866B;
const uint GL_MAP1_VERTEX_ATTRIB12_4_NV                       = 0x866C;
const uint GL_MAP1_VERTEX_ATTRIB13_4_NV                       = 0x866D;
const uint GL_MAP1_VERTEX_ATTRIB14_4_NV                       = 0x866E;
const uint GL_MAP1_VERTEX_ATTRIB15_4_NV                       = 0x866F;
const uint GL_MAP2_VERTEX_ATTRIB0_4_NV                        = 0x8670;
const uint GL_MAP2_VERTEX_ATTRIB1_4_NV                        = 0x8671;
const uint GL_MAP2_VERTEX_ATTRIB2_4_NV                        = 0x8672;
const uint GL_MAP2_VERTEX_ATTRIB3_4_NV                        = 0x8673;
const uint GL_MAP2_VERTEX_ATTRIB4_4_NV                        = 0x8674;
const uint GL_MAP2_VERTEX_ATTRIB5_4_NV                        = 0x8675;
const uint GL_MAP2_VERTEX_ATTRIB6_4_NV                        = 0x8676;
const uint GL_MAP2_VERTEX_ATTRIB7_4_NV                        = 0x8677;
const uint GL_MAP2_VERTEX_ATTRIB8_4_NV                        = 0x8678;
const uint GL_MAP2_VERTEX_ATTRIB9_4_NV                        = 0x8679;
const uint GL_MAP2_VERTEX_ATTRIB10_4_NV                       = 0x867A;
const uint GL_MAP2_VERTEX_ATTRIB11_4_NV                       = 0x867B;
const uint GL_MAP2_VERTEX_ATTRIB12_4_NV                       = 0x867C;
const uint GL_MAP2_VERTEX_ATTRIB13_4_NV                       = 0x867D;
const uint GL_MAP2_VERTEX_ATTRIB14_4_NV                       = 0x867E;
const uint GL_MAP2_VERTEX_ATTRIB15_4_NV                       = 0x867F;
typedef GLboolean   function(GLsizei n, GLuint *programs, GLboolean *residences) PFNGLAREPROGRAMSRESIDENTNVPROC;
typedef void   function(GLenum target, GLuint id) PFNGLBINDPROGRAMNVPROC;
typedef void   function(GLsizei n, GLuint *programs) PFNGLDELETEPROGRAMSNVPROC;
typedef void   function(GLenum target, GLuint id, GLfloat *params) PFNGLEXECUTEPROGRAMNVPROC;
typedef void   function(GLsizei n, GLuint *programs) PFNGLGENPROGRAMSNVPROC;
typedef void   function(GLenum target, GLuint index, GLenum pname, GLdouble *params) PFNGLGETPROGRAMPARAMETERDVNVPROC;
typedef void   function(GLenum target, GLuint index, GLenum pname, GLfloat *params) PFNGLGETPROGRAMPARAMETERFVNVPROC;
typedef void   function(GLuint id, GLenum pname, GLint *params) PFNGLGETPROGRAMIVNVPROC;
typedef void   function(GLuint id, GLenum pname, GLubyte *program) PFNGLGETPROGRAMSTRINGNVPROC;
typedef void   function(GLenum target, GLuint address, GLenum pname, GLint *params) PFNGLGETTRACKMATRIXIVNVPROC;
typedef void   function(GLuint index, GLenum pname, GLdouble *params) PFNGLGETVERTEXATTRIBDVNVPROC;
typedef void   function(GLuint index, GLenum pname, GLfloat *params) PFNGLGETVERTEXATTRIBFVNVPROC;
typedef void   function(GLuint index, GLenum pname, GLint *params) PFNGLGETVERTEXATTRIBIVNVPROC;
typedef void   function(GLuint index, GLenum pname, GLvoid* *pointer) PFNGLGETVERTEXATTRIBPOINTERVNVPROC;
typedef GLboolean   function(GLuint id) PFNGLISPROGRAMNVPROC;
typedef void   function(GLenum target, GLuint id, GLsizei len, GLubyte *program) PFNGLLOADPROGRAMNVPROC;
typedef void   function(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLPROGRAMPARAMETER4DNVPROC;
typedef void   function(GLenum target, GLuint index, GLdouble *v) PFNGLPROGRAMPARAMETER4DVNVPROC;
typedef void   function(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLPROGRAMPARAMETER4FNVPROC;
typedef void   function(GLenum target, GLuint index, GLfloat *v) PFNGLPROGRAMPARAMETER4FVNVPROC;
typedef void   function(GLenum target, GLuint index, GLuint count, GLdouble *v) PFNGLPROGRAMPARAMETERS4DVNVPROC;
typedef void   function(GLenum target, GLuint index, GLuint count, GLfloat *v) PFNGLPROGRAMPARAMETERS4FVNVPROC;
typedef void   function(GLsizei n, GLuint *programs) PFNGLREQUESTRESIDENTPROGRAMSNVPROC;
typedef void   function(GLenum target, GLuint address, GLenum matrix, GLenum transform) PFNGLTRACKMATRIXNVPROC;
typedef void   function(GLuint index, GLint fsize, GLenum type, GLsizei stride, GLvoid *pointer) PFNGLVERTEXATTRIBPOINTERNVPROC;
typedef void   function(GLuint index, GLdouble x) PFNGLVERTEXATTRIB1DNVPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB1DVNVPROC;
typedef void   function(GLuint index, GLfloat x) PFNGLVERTEXATTRIB1FNVPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB1FVNVPROC;
typedef void   function(GLuint index, GLshort x) PFNGLVERTEXATTRIB1SNVPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB1SVNVPROC;
typedef void   function(GLuint index, GLdouble x, GLdouble y) PFNGLVERTEXATTRIB2DNVPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB2DVNVPROC;
typedef void   function(GLuint index, GLfloat x, GLfloat y) PFNGLVERTEXATTRIB2FNVPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB2FVNVPROC;
typedef void   function(GLuint index, GLshort x, GLshort y) PFNGLVERTEXATTRIB2SNVPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB2SVNVPROC;
typedef void   function(GLuint index, GLdouble x, GLdouble y, GLdouble z) PFNGLVERTEXATTRIB3DNVPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB3DVNVPROC;
typedef void   function(GLuint index, GLfloat x, GLfloat y, GLfloat z) PFNGLVERTEXATTRIB3FNVPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB3FVNVPROC;
typedef void   function(GLuint index, GLshort x, GLshort y, GLshort z) PFNGLVERTEXATTRIB3SNVPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB3SVNVPROC;
typedef void   function(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLVERTEXATTRIB4DNVPROC;
typedef void   function(GLuint index, GLdouble *v) PFNGLVERTEXATTRIB4DVNVPROC;
typedef void   function(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLVERTEXATTRIB4FNVPROC;
typedef void   function(GLuint index, GLfloat *v) PFNGLVERTEXATTRIB4FVNVPROC;
typedef void   function(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) PFNGLVERTEXATTRIB4SNVPROC;
typedef void   function(GLuint index, GLshort *v) PFNGLVERTEXATTRIB4SVNVPROC;
typedef void   function(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) PFNGLVERTEXATTRIB4UBNVPROC;
typedef void   function(GLuint index, GLubyte *v) PFNGLVERTEXATTRIB4UBVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLdouble *v) PFNGLVERTEXATTRIBS1DVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLfloat *v) PFNGLVERTEXATTRIBS1FVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLshort *v) PFNGLVERTEXATTRIBS1SVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLdouble *v) PFNGLVERTEXATTRIBS2DVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLfloat *v) PFNGLVERTEXATTRIBS2FVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLshort *v) PFNGLVERTEXATTRIBS2SVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLdouble *v) PFNGLVERTEXATTRIBS3DVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLfloat *v) PFNGLVERTEXATTRIBS3FVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLshort *v) PFNGLVERTEXATTRIBS3SVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLdouble *v) PFNGLVERTEXATTRIBS4DVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLfloat *v) PFNGLVERTEXATTRIBS4FVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLshort *v) PFNGLVERTEXATTRIBS4SVNVPROC;
typedef void   function(GLuint index, GLsizei count, GLubyte *v) PFNGLVERTEXATTRIBS4UBVNVPROC;
 extern   PFNGLAREPROGRAMSRESIDENTNVPROC pglAreProgramsResidentNV;
 extern   PFNGLBINDPROGRAMNVPROC pglBindProgramNV;
 extern   PFNGLDELETEPROGRAMSNVPROC pglDeleteProgramsNV;
 extern   PFNGLEXECUTEPROGRAMNVPROC pglExecuteProgramNV;
 extern   PFNGLGENPROGRAMSNVPROC pglGenProgramsNV;
 extern   PFNGLGETPROGRAMPARAMETERDVNVPROC pglGetProgramParameterdvNV;
 extern   PFNGLGETPROGRAMPARAMETERFVNVPROC pglGetProgramParameterfvNV;
 extern   PFNGLGETPROGRAMIVNVPROC pglGetProgramivNV;
 extern   PFNGLGETPROGRAMSTRINGNVPROC pglGetProgramStringNV;
 extern   PFNGLGETTRACKMATRIXIVNVPROC pglGetTrackMatrixivNV;
 extern   PFNGLGETVERTEXATTRIBDVNVPROC pglGetVertexAttribdvNV;
 extern   PFNGLGETVERTEXATTRIBFVNVPROC pglGetVertexAttribfvNV;
 extern   PFNGLGETVERTEXATTRIBIVNVPROC pglGetVertexAttribivNV;
 extern   PFNGLGETVERTEXATTRIBPOINTERVNVPROC pglGetVertexAttribPointervNV;
 extern   PFNGLISPROGRAMNVPROC pglIsProgramNV;
 extern   PFNGLLOADPROGRAMNVPROC pglLoadProgramNV;
 extern   PFNGLPROGRAMPARAMETER4DNVPROC pglProgramParameter4dNV;
 extern   PFNGLPROGRAMPARAMETER4DVNVPROC pglProgramParameter4dvNV;
 extern   PFNGLPROGRAMPARAMETER4FNVPROC pglProgramParameter4fNV;
 extern   PFNGLPROGRAMPARAMETER4FVNVPROC pglProgramParameter4fvNV;
 extern   PFNGLPROGRAMPARAMETERS4DVNVPROC pglProgramParameters4dvNV;
 extern   PFNGLPROGRAMPARAMETERS4FVNVPROC pglProgramParameters4fvNV;
 extern   PFNGLREQUESTRESIDENTPROGRAMSNVPROC pglRequestResidentProgramsNV;
 extern   PFNGLTRACKMATRIXNVPROC pglTrackMatrixNV;
 extern   PFNGLVERTEXATTRIBPOINTERNVPROC pglVertexAttribPointerNV;
 extern   PFNGLVERTEXATTRIB1DNVPROC pglVertexAttrib1dNV;
 extern   PFNGLVERTEXATTRIB1DVNVPROC pglVertexAttrib1dvNV;
 extern   PFNGLVERTEXATTRIB1FNVPROC pglVertexAttrib1fNV;
 extern   PFNGLVERTEXATTRIB1FVNVPROC pglVertexAttrib1fvNV;
 extern   PFNGLVERTEXATTRIB1SNVPROC pglVertexAttrib1sNV;
 extern   PFNGLVERTEXATTRIB1SVNVPROC pglVertexAttrib1svNV;
 extern   PFNGLVERTEXATTRIB2DNVPROC pglVertexAttrib2dNV;
 extern   PFNGLVERTEXATTRIB2DVNVPROC pglVertexAttrib2dvNV;
 extern   PFNGLVERTEXATTRIB2FNVPROC pglVertexAttrib2fNV;
 extern   PFNGLVERTEXATTRIB2FVNVPROC pglVertexAttrib2fvNV;
 extern   PFNGLVERTEXATTRIB2SNVPROC pglVertexAttrib2sNV;
 extern   PFNGLVERTEXATTRIB2SVNVPROC pglVertexAttrib2svNV;
 extern   PFNGLVERTEXATTRIB3DNVPROC pglVertexAttrib3dNV;
 extern   PFNGLVERTEXATTRIB3DVNVPROC pglVertexAttrib3dvNV;
 extern   PFNGLVERTEXATTRIB3FNVPROC pglVertexAttrib3fNV;
 extern   PFNGLVERTEXATTRIB3FVNVPROC pglVertexAttrib3fvNV;
 extern   PFNGLVERTEXATTRIB3SNVPROC pglVertexAttrib3sNV;
 extern   PFNGLVERTEXATTRIB3SVNVPROC pglVertexAttrib3svNV;
 extern   PFNGLVERTEXATTRIB4DNVPROC pglVertexAttrib4dNV;
 extern   PFNGLVERTEXATTRIB4DVNVPROC pglVertexAttrib4dvNV;
 extern   PFNGLVERTEXATTRIB4FNVPROC pglVertexAttrib4fNV;
 extern   PFNGLVERTEXATTRIB4FVNVPROC pglVertexAttrib4fvNV;
 extern   PFNGLVERTEXATTRIB4SNVPROC pglVertexAttrib4sNV;
 extern   PFNGLVERTEXATTRIB4SVNVPROC pglVertexAttrib4svNV;
 extern   PFNGLVERTEXATTRIB4UBNVPROC pglVertexAttrib4ubNV;
 extern   PFNGLVERTEXATTRIB4UBVNVPROC pglVertexAttrib4ubvNV;
 extern   PFNGLVERTEXATTRIBS1DVNVPROC pglVertexAttribs1dvNV;
 extern   PFNGLVERTEXATTRIBS1FVNVPROC pglVertexAttribs1fvNV;
 extern   PFNGLVERTEXATTRIBS1SVNVPROC pglVertexAttribs1svNV;
 extern   PFNGLVERTEXATTRIBS2DVNVPROC pglVertexAttribs2dvNV;
 extern   PFNGLVERTEXATTRIBS2FVNVPROC pglVertexAttribs2fvNV;
 extern   PFNGLVERTEXATTRIBS2SVNVPROC pglVertexAttribs2svNV;
 extern   PFNGLVERTEXATTRIBS3DVNVPROC pglVertexAttribs3dvNV;
 extern   PFNGLVERTEXATTRIBS3FVNVPROC pglVertexAttribs3fvNV;
 extern   PFNGLVERTEXATTRIBS3SVNVPROC pglVertexAttribs3svNV;
 extern   PFNGLVERTEXATTRIBS4DVNVPROC pglVertexAttribs4dvNV;
 extern   PFNGLVERTEXATTRIBS4FVNVPROC pglVertexAttribs4fvNV;
 extern   PFNGLVERTEXATTRIBS4SVNVPROC pglVertexAttribs4svNV;
 extern   PFNGLVERTEXATTRIBS4UBVNVPROC pglVertexAttribs4ubvNV;
alias pglAreProgramsResidentNV glAreProgramsResidentNV;
alias pglBindProgramNV glBindProgramNV;
alias pglDeleteProgramsNV glDeleteProgramsNV;
alias pglExecuteProgramNV glExecuteProgramNV;
alias pglGenProgramsNV glGenProgramsNV;
alias pglGetProgramParameterdvNV glGetProgramParameterdvNV;
alias pglGetProgramParameterfvNV glGetProgramParameterfvNV;
alias pglGetProgramivNV glGetProgramivNV;
alias pglGetProgramStringNV glGetProgramStringNV;
alias pglGetTrackMatrixivNV glGetTrackMatrixivNV;
alias pglGetVertexAttribdvNV glGetVertexAttribdvNV;
alias pglGetVertexAttribfvNV glGetVertexAttribfvNV;
alias pglGetVertexAttribivNV glGetVertexAttribivNV;
alias pglGetVertexAttribPointervNV glGetVertexAttribPointervNV;
alias pglIsProgramNV glIsProgramNV;
alias pglLoadProgramNV glLoadProgramNV;
alias pglProgramParameter4dNV glProgramParameter4dNV;
alias pglProgramParameter4dvNV glProgramParameter4dvNV;
alias pglProgramParameter4fNV glProgramParameter4fNV;
alias pglProgramParameter4fvNV glProgramParameter4fvNV;
alias pglProgramParameters4dvNV glProgramParameters4dvNV;
alias pglProgramParameters4fvNV glProgramParameters4fvNV;
alias pglRequestResidentProgramsNV glRequestResidentProgramsNV;
alias pglTrackMatrixNV glTrackMatrixNV;
alias pglVertexAttribPointerNV glVertexAttribPointerNV;
alias pglVertexAttrib1dNV glVertexAttrib1dNV;
alias pglVertexAttrib1dvNV glVertexAttrib1dvNV;
alias pglVertexAttrib1fNV glVertexAttrib1fNV;
alias pglVertexAttrib1fvNV glVertexAttrib1fvNV;
alias pglVertexAttrib1sNV glVertexAttrib1sNV;
alias pglVertexAttrib1svNV glVertexAttrib1svNV;
alias pglVertexAttrib2dNV glVertexAttrib2dNV;
alias pglVertexAttrib2dvNV glVertexAttrib2dvNV;
alias pglVertexAttrib2fNV glVertexAttrib2fNV;
alias pglVertexAttrib2fvNV glVertexAttrib2fvNV;
alias pglVertexAttrib2sNV glVertexAttrib2sNV;
alias pglVertexAttrib2svNV glVertexAttrib2svNV;
alias pglVertexAttrib3dNV glVertexAttrib3dNV;
alias pglVertexAttrib3dvNV glVertexAttrib3dvNV;
alias pglVertexAttrib3fNV glVertexAttrib3fNV;
alias pglVertexAttrib3fvNV glVertexAttrib3fvNV;
alias pglVertexAttrib3sNV glVertexAttrib3sNV;
alias pglVertexAttrib3svNV glVertexAttrib3svNV;
alias pglVertexAttrib4dNV glVertexAttrib4dNV;
alias pglVertexAttrib4dvNV glVertexAttrib4dvNV;
alias pglVertexAttrib4fNV glVertexAttrib4fNV;
alias pglVertexAttrib4fvNV glVertexAttrib4fvNV;
alias pglVertexAttrib4sNV glVertexAttrib4sNV;
alias pglVertexAttrib4svNV glVertexAttrib4svNV;
alias pglVertexAttrib4ubNV glVertexAttrib4ubNV;
alias pglVertexAttrib4ubvNV glVertexAttrib4ubvNV;
alias pglVertexAttribs1dvNV glVertexAttribs1dvNV;
alias pglVertexAttribs1fvNV glVertexAttribs1fvNV;
alias pglVertexAttribs1svNV glVertexAttribs1svNV;
alias pglVertexAttribs2dvNV glVertexAttribs2dvNV;
alias pglVertexAttribs2fvNV glVertexAttribs2fvNV;
alias pglVertexAttribs2svNV glVertexAttribs2svNV;
alias pglVertexAttribs3dvNV glVertexAttribs3dvNV;
alias pglVertexAttribs3fvNV glVertexAttribs3fvNV;
alias pglVertexAttribs3svNV glVertexAttribs3svNV;
alias pglVertexAttribs4dvNV glVertexAttribs4dvNV;
alias pglVertexAttribs4fvNV glVertexAttribs4fvNV;
alias pglVertexAttribs4svNV glVertexAttribs4svNV;
alias pglVertexAttribs4ubvNV glVertexAttribs4ubvNV;
//#endif ;

//GL_SGIX_texture_coordinate_clamp

//#ifndef GL_SGIX_texture_coordinate_clamp;
const uint GL_SGIX_texture_coordinate_clamp = 1;
const uint __GLEE_GL_SGIX_texture_coordinate_clamp = 1;
//constants
const uint GL_TEXTURE_MAX_CLAMP_S_SGIX                        = 0x8369;
const uint GL_TEXTURE_MAX_CLAMP_T_SGIX                        = 0x836A;
const uint GL_TEXTURE_MAX_CLAMP_R_SGIX                        = 0x836B;
//#endif ;

//GL_SGIX_scalebias_hint

//#ifndef GL_SGIX_scalebias_hint;
const uint GL_SGIX_scalebias_hint = 1;
const uint __GLEE_GL_SGIX_scalebias_hint = 1;
//constants
const uint GL_SCALEBIAS_HINT_SGIX                             = 0x8322;
//#endif ;

//GL_OML_interlace

//#ifndef GL_OML_interlace;
const uint GL_OML_interlace = 1;
const uint __GLEE_GL_OML_interlace = 1;
//constants
const uint GL_INTERLACE_OML                                   = 0x8980;
const uint GL_INTERLACE_READ_OML                              = 0x8981;
//#endif ;

//GL_OML_subsample

//#ifndef GL_OML_subsample;
const uint GL_OML_subsample = 1;
const uint __GLEE_GL_OML_subsample = 1;
//constants
const uint GL_FORMAT_SUBSAMPLE_24_24_OML                      = 0x8982;
const uint GL_FORMAT_SUBSAMPLE_244_244_OML                    = 0x8983;
//#endif ;

//GL_OML_resample

//#ifndef GL_OML_resample;
const uint GL_OML_resample = 1;
const uint __GLEE_GL_OML_resample = 1;
//constants
const uint GL_PACK_RESAMPLE_OML                               = 0x8984;
const uint GL_UNPACK_RESAMPLE_OML                             = 0x8985;
const uint GL_RESAMPLE_REPLICATE_OML                          = 0x8986;
const uint GL_RESAMPLE_ZERO_FILL_OML                          = 0x8987;
const uint GL_RESAMPLE_AVERAGE_OML                            = 0x8988;
const uint GL_RESAMPLE_DECIMATE_OML                           = 0x8989;
//#endif ;

//GL_NV_copy_depth_to_color

//#ifndef GL_NV_copy_depth_to_color;
const uint GL_NV_copy_depth_to_color = 1;
const uint __GLEE_GL_NV_copy_depth_to_color = 1;
//constants
const uint GL_DEPTH_STENCIL_TO_RGBA_NV                        = 0x886E;
const uint GL_DEPTH_STENCIL_TO_BGRA_NV                        = 0x886F;
//#endif ;

//GL_ATI_envmap_bumpmap

//#ifndef GL_ATI_envmap_bumpmap;
const uint GL_ATI_envmap_bumpmap = 1;
const uint __GLEE_GL_ATI_envmap_bumpmap = 1;
//constants
const uint GL_BUMP_ROT_MATRIX_ATI                             = 0x8775;
const uint GL_BUMP_ROT_MATRIX_SIZE_ATI                        = 0x8776;
const uint GL_BUMP_NUM_TEX_UNITS_ATI                          = 0x8777;
const uint GL_BUMP_TEX_UNITS_ATI                              = 0x8778;
const uint GL_DUDV_ATI                                        = 0x8779;
const uint GL_DU8DV8_ATI                                      = 0x877A;
const uint GL_BUMP_ENVMAP_ATI                                 = 0x877B;
const uint GL_BUMP_TARGET_ATI                                 = 0x877C;
typedef void   function(GLenum pname, GLint *param) PFNGLTEXBUMPPARAMETERIVATIPROC;
typedef void   function(GLenum pname, GLfloat *param) PFNGLTEXBUMPPARAMETERFVATIPROC;
typedef void   function(GLenum pname, GLint *param) PFNGLGETTEXBUMPPARAMETERIVATIPROC;
typedef void   function(GLenum pname, GLfloat *param) PFNGLGETTEXBUMPPARAMETERFVATIPROC;
 extern   PFNGLTEXBUMPPARAMETERIVATIPROC pglTexBumpParameterivATI;
 extern   PFNGLTEXBUMPPARAMETERFVATIPROC pglTexBumpParameterfvATI;
 extern   PFNGLGETTEXBUMPPARAMETERIVATIPROC pglGetTexBumpParameterivATI;
 extern   PFNGLGETTEXBUMPPARAMETERFVATIPROC pglGetTexBumpParameterfvATI;
alias pglTexBumpParameterivATI glTexBumpParameterivATI;
alias pglTexBumpParameterfvATI glTexBumpParameterfvATI;
alias pglGetTexBumpParameterivATI glGetTexBumpParameterivATI;
alias pglGetTexBumpParameterfvATI glGetTexBumpParameterfvATI;
//#endif ;

//GL_ATI_fragment_shader

//#ifndef GL_ATI_fragment_shader;
const uint GL_ATI_fragment_shader = 1;
const uint __GLEE_GL_ATI_fragment_shader = 1;
//constants
const uint GL_FRAGMENT_SHADER_ATI                             = 0x8920;
const uint GL_REG_0_ATI                                       = 0x8921;
const uint GL_REG_1_ATI                                       = 0x8922;
const uint GL_REG_2_ATI                                       = 0x8923;
const uint GL_REG_3_ATI                                       = 0x8924;
const uint GL_REG_4_ATI                                       = 0x8925;
const uint GL_REG_5_ATI                                       = 0x8926;
const uint GL_REG_6_ATI                                       = 0x8927;
const uint GL_REG_7_ATI                                       = 0x8928;
const uint GL_REG_8_ATI                                       = 0x8929;
const uint GL_REG_9_ATI                                       = 0x892A;
const uint GL_REG_10_ATI                                      = 0x892B;
const uint GL_REG_11_ATI                                      = 0x892C;
const uint GL_REG_12_ATI                                      = 0x892D;
const uint GL_REG_13_ATI                                      = 0x892E;
const uint GL_REG_14_ATI                                      = 0x892F;
const uint GL_REG_15_ATI                                      = 0x8930;
const uint GL_REG_16_ATI                                      = 0x8931;
const uint GL_REG_17_ATI                                      = 0x8932;
const uint GL_REG_18_ATI                                      = 0x8933;
const uint GL_REG_19_ATI                                      = 0x8934;
const uint GL_REG_20_ATI                                      = 0x8935;
const uint GL_REG_21_ATI                                      = 0x8936;
const uint GL_REG_22_ATI                                      = 0x8937;
const uint GL_REG_23_ATI                                      = 0x8938;
const uint GL_REG_24_ATI                                      = 0x8939;
const uint GL_REG_25_ATI                                      = 0x893A;
const uint GL_REG_26_ATI                                      = 0x893B;
const uint GL_REG_27_ATI                                      = 0x893C;
const uint GL_REG_28_ATI                                      = 0x893D;
const uint GL_REG_29_ATI                                      = 0x893E;
const uint GL_REG_30_ATI                                      = 0x893F;
const uint GL_REG_31_ATI                                      = 0x8940;
const uint GL_CON_0_ATI                                       = 0x8941;
const uint GL_CON_1_ATI                                       = 0x8942;
const uint GL_CON_2_ATI                                       = 0x8943;
const uint GL_CON_3_ATI                                       = 0x8944;
const uint GL_CON_4_ATI                                       = 0x8945;
const uint GL_CON_5_ATI                                       = 0x8946;
const uint GL_CON_6_ATI                                       = 0x8947;
const uint GL_CON_7_ATI                                       = 0x8948;
const uint GL_CON_8_ATI                                       = 0x8949;
const uint GL_CON_9_ATI                                       = 0x894A;
const uint GL_CON_10_ATI                                      = 0x894B;
const uint GL_CON_11_ATI                                      = 0x894C;
const uint GL_CON_12_ATI                                      = 0x894D;
const uint GL_CON_13_ATI                                      = 0x894E;
const uint GL_CON_14_ATI                                      = 0x894F;
const uint GL_CON_15_ATI                                      = 0x8950;
const uint GL_CON_16_ATI                                      = 0x8951;
const uint GL_CON_17_ATI                                      = 0x8952;
const uint GL_CON_18_ATI                                      = 0x8953;
const uint GL_CON_19_ATI                                      = 0x8954;
const uint GL_CON_20_ATI                                      = 0x8955;
const uint GL_CON_21_ATI                                      = 0x8956;
const uint GL_CON_22_ATI                                      = 0x8957;
const uint GL_CON_23_ATI                                      = 0x8958;
const uint GL_CON_24_ATI                                      = 0x8959;
const uint GL_CON_25_ATI                                      = 0x895A;
const uint GL_CON_26_ATI                                      = 0x895B;
const uint GL_CON_27_ATI                                      = 0x895C;
const uint GL_CON_28_ATI                                      = 0x895D;
const uint GL_CON_29_ATI                                      = 0x895E;
const uint GL_CON_30_ATI                                      = 0x895F;
const uint GL_CON_31_ATI                                      = 0x8960;
const uint GL_MOV_ATI                                         = 0x8961;
const uint GL_ADD_ATI                                         = 0x8963;
const uint GL_MUL_ATI                                         = 0x8964;
const uint GL_SUB_ATI                                         = 0x8965;
const uint GL_DOT3_ATI                                        = 0x8966;
const uint GL_DOT4_ATI                                        = 0x8967;
const uint GL_MAD_ATI                                         = 0x8968;
const uint GL_LERP_ATI                                        = 0x8969;
const uint GL_CND_ATI                                         = 0x896A;
const uint GL_CND0_ATI                                        = 0x896B;
const uint GL_DOT2_ADD_ATI                                    = 0x896C;
const uint GL_SECONDARY_INTERPOLATOR_ATI                      = 0x896D;
const uint GL_NUM_FRAGMENT_REGISTERS_ATI                      = 0x896E;
const uint GL_NUM_FRAGMENT_CONSTANTS_ATI                      = 0x896F;
const uint GL_NUM_PASSES_ATI                                  = 0x8970;
const uint GL_NUM_INSTRUCTIONS_PER_PASS_ATI                   = 0x8971;
const uint GL_NUM_INSTRUCTIONS_TOTAL_ATI                      = 0x8972;
const uint GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI           = 0x8973;
const uint GL_NUM_LOOPBACK_COMPONENTS_ATI                     = 0x8974;
const uint GL_COLOR_ALPHA_PAIRING_ATI                         = 0x8975;
const uint GL_SWIZZLE_STR_ATI                                 = 0x8976;
const uint GL_SWIZZLE_STQ_ATI                                 = 0x8977;
const uint GL_SWIZZLE_STR_DR_ATI                              = 0x8978;
const uint GL_SWIZZLE_STQ_DQ_ATI                              = 0x8979;
const uint GL_SWIZZLE_STRQ_ATI                                = 0x897A;
const uint GL_SWIZZLE_STRQ_DQ_ATI                             = 0x897B;
const uint GL_RED_BIT_ATI                                     = 0x00000001;
const uint GL_GREEN_BIT_ATI                                   = 0x00000002;
const uint GL_BLUE_BIT_ATI                                    = 0x00000004;
const uint GL_2X_BIT_ATI                                      = 0x00000001;
const uint GL_4X_BIT_ATI                                      = 0x00000002;
const uint GL_8X_BIT_ATI                                      = 0x00000004;
const uint GL_HALF_BIT_ATI                                    = 0x00000008;
const uint GL_QUARTER_BIT_ATI                                 = 0x00000010;
const uint GL_EIGHTH_BIT_ATI                                  = 0x00000020;
const uint GL_SATURATE_BIT_ATI                                = 0x00000040;
const uint GL_COMP_BIT_ATI                                    = 0x00000002;
const uint GL_NEGATE_BIT_ATI                                  = 0x00000004;
const uint GL_BIAS_BIT_ATI                                    = 0x00000008;
typedef GLuint   function(GLuint range) PFNGLGENFRAGMENTSHADERSATIPROC;
typedef void   function(GLuint id) PFNGLBINDFRAGMENTSHADERATIPROC;
typedef void   function(GLuint id) PFNGLDELETEFRAGMENTSHADERATIPROC;
typedef void   function() PFNGLBEGINFRAGMENTSHADERATIPROC;
typedef void   function() PFNGLENDFRAGMENTSHADERATIPROC;
typedef void   function(GLuint dst, GLuint coord, GLenum swizzle) PFNGLPASSTEXCOORDATIPROC;
typedef void   function(GLuint dst, GLuint interp, GLenum swizzle) PFNGLSAMPLEMAPATIPROC;
typedef void   function(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod) PFNGLCOLORFRAGMENTOP1ATIPROC;
typedef void   function(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod) PFNGLCOLORFRAGMENTOP2ATIPROC;
typedef void   function(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod) PFNGLCOLORFRAGMENTOP3ATIPROC;
typedef void   function(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod) PFNGLALPHAFRAGMENTOP1ATIPROC;
typedef void   function(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod) PFNGLALPHAFRAGMENTOP2ATIPROC;
typedef void   function(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod) PFNGLALPHAFRAGMENTOP3ATIPROC;
typedef void   function(GLuint dst, GLfloat *value) PFNGLSETFRAGMENTSHADERCONSTANTATIPROC;
 extern   PFNGLGENFRAGMENTSHADERSATIPROC pglGenFragmentShadersATI;
 extern   PFNGLBINDFRAGMENTSHADERATIPROC pglBindFragmentShaderATI;
 extern   PFNGLDELETEFRAGMENTSHADERATIPROC pglDeleteFragmentShaderATI;
 extern   PFNGLBEGINFRAGMENTSHADERATIPROC pglBeginFragmentShaderATI;
 extern   PFNGLENDFRAGMENTSHADERATIPROC pglEndFragmentShaderATI;
 extern   PFNGLPASSTEXCOORDATIPROC pglPassTexCoordATI;
 extern   PFNGLSAMPLEMAPATIPROC pglSampleMapATI;
 extern   PFNGLCOLORFRAGMENTOP1ATIPROC pglColorFragmentOp1ATI;
 extern   PFNGLCOLORFRAGMENTOP2ATIPROC pglColorFragmentOp2ATI;
 extern   PFNGLCOLORFRAGMENTOP3ATIPROC pglColorFragmentOp3ATI;
 extern   PFNGLALPHAFRAGMENTOP1ATIPROC pglAlphaFragmentOp1ATI;
 extern   PFNGLALPHAFRAGMENTOP2ATIPROC pglAlphaFragmentOp2ATI;
 extern   PFNGLALPHAFRAGMENTOP3ATIPROC pglAlphaFragmentOp3ATI;
 extern   PFNGLSETFRAGMENTSHADERCONSTANTATIPROC pglSetFragmentShaderConstantATI;
alias pglGenFragmentShadersATI glGenFragmentShadersATI;
alias pglBindFragmentShaderATI glBindFragmentShaderATI;
alias pglDeleteFragmentShaderATI glDeleteFragmentShaderATI;
alias pglBeginFragmentShaderATI glBeginFragmentShaderATI;
alias pglEndFragmentShaderATI glEndFragmentShaderATI;
alias pglPassTexCoordATI glPassTexCoordATI;
alias pglSampleMapATI glSampleMapATI;
alias pglColorFragmentOp1ATI glColorFragmentOp1ATI;
alias pglColorFragmentOp2ATI glColorFragmentOp2ATI;
alias pglColorFragmentOp3ATI glColorFragmentOp3ATI;
alias pglAlphaFragmentOp1ATI glAlphaFragmentOp1ATI;
alias pglAlphaFragmentOp2ATI glAlphaFragmentOp2ATI;
alias pglAlphaFragmentOp3ATI glAlphaFragmentOp3ATI;
alias pglSetFragmentShaderConstantATI glSetFragmentShaderConstantATI;
//#endif ;

//GL_ATI_pn_triangles

//#ifndef GL_ATI_pn_triangles;
const uint GL_ATI_pn_triangles = 1;
const uint __GLEE_GL_ATI_pn_triangles = 1;
//constants
const uint GL_PN_TRIANGLES_ATI                                = 0x87F0;
const uint GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI          = 0x87F1;
const uint GL_PN_TRIANGLES_POINT_MODE_ATI                     = 0x87F2;
const uint GL_PN_TRIANGLES_NORMAL_MODE_ATI                    = 0x87F3;
const uint GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI              = 0x87F4;
const uint GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI              = 0x87F5;
const uint GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI               = 0x87F6;
const uint GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI             = 0x87F7;
const uint GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI          = 0x87F8;
typedef void   function(GLenum pname, GLint param) PFNGLPNTRIANGLESIATIPROC;
typedef void   function(GLenum pname, GLfloat param) PFNGLPNTRIANGLESFATIPROC;
 extern   PFNGLPNTRIANGLESIATIPROC pglPNTrianglesiATI;
 extern   PFNGLPNTRIANGLESFATIPROC pglPNTrianglesfATI;
alias pglPNTrianglesiATI glPNTrianglesiATI;
alias pglPNTrianglesfATI glPNTrianglesfATI;
//#endif ;

//GL_ATI_vertex_array_object

//#ifndef GL_ATI_vertex_array_object;
const uint GL_ATI_vertex_array_object = 1;
const uint __GLEE_GL_ATI_vertex_array_object = 1;
//constants
const uint GL_STATIC_ATI                                      = 0x8760;
const uint GL_DYNAMIC_ATI                                     = 0x8761;
const uint GL_PRESERVE_ATI                                    = 0x8762;
const uint GL_DISCARD_ATI                                     = 0x8763;
const uint GL_OBJECT_BUFFER_SIZE_ATI                          = 0x8764;
const uint GL_OBJECT_BUFFER_USAGE_ATI                         = 0x8765;
const uint GL_ARRAY_OBJECT_BUFFER_ATI                         = 0x8766;
const uint GL_ARRAY_OBJECT_OFFSET_ATI                         = 0x8767;
typedef GLuint   function(GLsizei size, GLvoid *pointer, GLenum usage) PFNGLNEWOBJECTBUFFERATIPROC;
typedef GLboolean   function(GLuint buffer) PFNGLISOBJECTBUFFERATIPROC;
typedef void   function(GLuint buffer, GLuint offset, GLsizei size, GLvoid *pointer, GLenum preserve) PFNGLUPDATEOBJECTBUFFERATIPROC;
typedef void   function(GLuint buffer, GLenum pname, GLfloat *params) PFNGLGETOBJECTBUFFERFVATIPROC;
typedef void   function(GLuint buffer, GLenum pname, GLint *params) PFNGLGETOBJECTBUFFERIVATIPROC;
typedef void   function(GLuint buffer) PFNGLFREEOBJECTBUFFERATIPROC;
typedef void   function(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset) PFNGLARRAYOBJECTATIPROC;
typedef void   function(GLenum array, GLenum pname, GLfloat *params) PFNGLGETARRAYOBJECTFVATIPROC;
typedef void   function(GLenum array, GLenum pname, GLint *params) PFNGLGETARRAYOBJECTIVATIPROC;
typedef void   function(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset) PFNGLVARIANTARRAYOBJECTATIPROC;
typedef void   function(GLuint id, GLenum pname, GLfloat *params) PFNGLGETVARIANTARRAYOBJECTFVATIPROC;
typedef void   function(GLuint id, GLenum pname, GLint *params) PFNGLGETVARIANTARRAYOBJECTIVATIPROC;
 extern   PFNGLNEWOBJECTBUFFERATIPROC pglNewObjectBufferATI;
 extern   PFNGLISOBJECTBUFFERATIPROC pglIsObjectBufferATI;
 extern   PFNGLUPDATEOBJECTBUFFERATIPROC pglUpdateObjectBufferATI;
 extern   PFNGLGETOBJECTBUFFERFVATIPROC pglGetObjectBufferfvATI;
 extern   PFNGLGETOBJECTBUFFERIVATIPROC pglGetObjectBufferivATI;
 extern   PFNGLFREEOBJECTBUFFERATIPROC pglFreeObjectBufferATI;
 extern   PFNGLARRAYOBJECTATIPROC pglArrayObjectATI;
 extern   PFNGLGETARRAYOBJECTFVATIPROC pglGetArrayObjectfvATI;
 extern   PFNGLGETARRAYOBJECTIVATIPROC pglGetArrayObjectivATI;
 extern   PFNGLVARIANTARRAYOBJECTATIPROC pglVariantArrayObjectATI;
 extern   PFNGLGETVARIANTARRAYOBJECTFVATIPROC pglGetVariantArrayObjectfvATI;
 extern   PFNGLGETVARIANTARRAYOBJECTIVATIPROC pglGetVariantArrayObjectivATI;
alias pglNewObjectBufferATI glNewObjectBufferATI;
alias pglIsObjectBufferATI glIsObjectBufferATI;
alias pglUpdateObjectBufferATI glUpdateObjectBufferATI;
alias pglGetObjectBufferfvATI glGetObjectBufferfvATI;
alias pglGetObjectBufferivATI glGetObjectBufferivATI;
alias pglFreeObjectBufferATI glFreeObjectBufferATI;
alias pglArrayObjectATI glArrayObjectATI;
alias pglGetArrayObjectfvATI glGetArrayObjectfvATI;
alias pglGetArrayObjectivATI glGetArrayObjectivATI;
alias pglVariantArrayObjectATI glVariantArrayObjectATI;
alias pglGetVariantArrayObjectfvATI glGetVariantArrayObjectfvATI;
alias pglGetVariantArrayObjectivATI glGetVariantArrayObjectivATI;
//#endif ;

//GL_EXT_vertex_shader

//#ifndef GL_EXT_vertex_shader;
const uint GL_EXT_vertex_shader = 1;
const uint __GLEE_GL_EXT_vertex_shader = 1;
//constants
const uint GL_VERTEX_SHADER_EXT                               = 0x8780;
const uint GL_VERTEX_SHADER_BINDING_EXT                       = 0x8781;
const uint GL_OP_INDEX_EXT                                    = 0x8782;
const uint GL_OP_NEGATE_EXT                                   = 0x8783;
const uint GL_OP_DOT3_EXT                                     = 0x8784;
const uint GL_OP_DOT4_EXT                                     = 0x8785;
const uint GL_OP_MUL_EXT                                      = 0x8786;
const uint GL_OP_ADD_EXT                                      = 0x8787;
const uint GL_OP_MADD_EXT                                     = 0x8788;
const uint GL_OP_FRAC_EXT                                     = 0x8789;
const uint GL_OP_MAX_EXT                                      = 0x878A;
const uint GL_OP_MIN_EXT                                      = 0x878B;
const uint GL_OP_SET_GE_EXT                                   = 0x878C;
const uint GL_OP_SET_LT_EXT                                   = 0x878D;
const uint GL_OP_CLAMP_EXT                                    = 0x878E;
const uint GL_OP_FLOOR_EXT                                    = 0x878F;
const uint GL_OP_ROUND_EXT                                    = 0x8790;
const uint GL_OP_EXP_BASE_2_EXT                               = 0x8791;
const uint GL_OP_LOG_BASE_2_EXT                               = 0x8792;
const uint GL_OP_POWER_EXT                                    = 0x8793;
const uint GL_OP_RECIP_EXT                                    = 0x8794;
const uint GL_OP_RECIP_SQRT_EXT                               = 0x8795;
const uint GL_OP_SUB_EXT                                      = 0x8796;
const uint GL_OP_CROSS_PRODUCT_EXT                            = 0x8797;
const uint GL_OP_MULTIPLY_MATRIX_EXT                          = 0x8798;
const uint GL_OP_MOV_EXT                                      = 0x8799;
const uint GL_OUTPUT_VERTEX_EXT                               = 0x879A;
const uint GL_OUTPUT_COLOR0_EXT                               = 0x879B;
const uint GL_OUTPUT_COLOR1_EXT                               = 0x879C;
const uint GL_OUTPUT_TEXTURE_COORD0_EXT                       = 0x879D;
const uint GL_OUTPUT_TEXTURE_COORD1_EXT                       = 0x879E;
const uint GL_OUTPUT_TEXTURE_COORD2_EXT                       = 0x879F;
const uint GL_OUTPUT_TEXTURE_COORD3_EXT                       = 0x87A0;
const uint GL_OUTPUT_TEXTURE_COORD4_EXT                       = 0x87A1;
const uint GL_OUTPUT_TEXTURE_COORD5_EXT                       = 0x87A2;
const uint GL_OUTPUT_TEXTURE_COORD6_EXT                       = 0x87A3;
const uint GL_OUTPUT_TEXTURE_COORD7_EXT                       = 0x87A4;
const uint GL_OUTPUT_TEXTURE_COORD8_EXT                       = 0x87A5;
const uint GL_OUTPUT_TEXTURE_COORD9_EXT                       = 0x87A6;
const uint GL_OUTPUT_TEXTURE_COORD10_EXT                      = 0x87A7;
const uint GL_OUTPUT_TEXTURE_COORD11_EXT                      = 0x87A8;
const uint GL_OUTPUT_TEXTURE_COORD12_EXT                      = 0x87A9;
const uint GL_OUTPUT_TEXTURE_COORD13_EXT                      = 0x87AA;
const uint GL_OUTPUT_TEXTURE_COORD14_EXT                      = 0x87AB;
const uint GL_OUTPUT_TEXTURE_COORD15_EXT                      = 0x87AC;
const uint GL_OUTPUT_TEXTURE_COORD16_EXT                      = 0x87AD;
const uint GL_OUTPUT_TEXTURE_COORD17_EXT                      = 0x87AE;
const uint GL_OUTPUT_TEXTURE_COORD18_EXT                      = 0x87AF;
const uint GL_OUTPUT_TEXTURE_COORD19_EXT                      = 0x87B0;
const uint GL_OUTPUT_TEXTURE_COORD20_EXT                      = 0x87B1;
const uint GL_OUTPUT_TEXTURE_COORD21_EXT                      = 0x87B2;
const uint GL_OUTPUT_TEXTURE_COORD22_EXT                      = 0x87B3;
const uint GL_OUTPUT_TEXTURE_COORD23_EXT                      = 0x87B4;
const uint GL_OUTPUT_TEXTURE_COORD24_EXT                      = 0x87B5;
const uint GL_OUTPUT_TEXTURE_COORD25_EXT                      = 0x87B6;
const uint GL_OUTPUT_TEXTURE_COORD26_EXT                      = 0x87B7;
const uint GL_OUTPUT_TEXTURE_COORD27_EXT                      = 0x87B8;
const uint GL_OUTPUT_TEXTURE_COORD28_EXT                      = 0x87B9;
const uint GL_OUTPUT_TEXTURE_COORD29_EXT                      = 0x87BA;
const uint GL_OUTPUT_TEXTURE_COORD30_EXT                      = 0x87BB;
const uint GL_OUTPUT_TEXTURE_COORD31_EXT                      = 0x87BC;
const uint GL_OUTPUT_FOG_EXT                                  = 0x87BD;
const uint GL_SCALAR_EXT                                      = 0x87BE;
const uint GL_VECTOR_EXT                                      = 0x87BF;
const uint GL_MATRIX_EXT                                      = 0x87C0;
const uint GL_VARIANT_EXT                                     = 0x87C1;
const uint GL_INVARIANT_EXT                                   = 0x87C2;
const uint GL_LOCAL_CONSTANT_EXT                              = 0x87C3;
const uint GL_LOCAL_EXT                                       = 0x87C4;
const uint GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT              = 0x87C5;
const uint GL_MAX_VERTEX_SHADER_VARIANTS_EXT                  = 0x87C6;
const uint GL_MAX_VERTEX_SHADER_INVARIANTS_EXT                = 0x87C7;
const uint GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT           = 0x87C8;
const uint GL_MAX_VERTEX_SHADER_LOCALS_EXT                    = 0x87C9;
const uint GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT    = 0x87CA;
const uint GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT        = 0x87CB;
const uint GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87CC;
const uint GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT      = 0x87CD;
const uint GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT          = 0x87CE;
const uint GL_VERTEX_SHADER_INSTRUCTIONS_EXT                  = 0x87CF;
const uint GL_VERTEX_SHADER_VARIANTS_EXT                      = 0x87D0;
const uint GL_VERTEX_SHADER_INVARIANTS_EXT                    = 0x87D1;
const uint GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT               = 0x87D2;
const uint GL_VERTEX_SHADER_LOCALS_EXT                        = 0x87D3;
const uint GL_VERTEX_SHADER_OPTIMIZED_EXT                     = 0x87D4;
const uint GL_X_EXT                                           = 0x87D5;
const uint GL_Y_EXT                                           = 0x87D6;
const uint GL_Z_EXT                                           = 0x87D7;
const uint GL_W_EXT                                           = 0x87D8;
const uint GL_NEGATIVE_X_EXT                                  = 0x87D9;
const uint GL_NEGATIVE_Y_EXT                                  = 0x87DA;
const uint GL_NEGATIVE_Z_EXT                                  = 0x87DB;
const uint GL_NEGATIVE_W_EXT                                  = 0x87DC;
const uint GL_ZERO_EXT                                        = 0x87DD;
const uint GL_ONE_EXT                                         = 0x87DE;
const uint GL_NEGATIVE_ONE_EXT                                = 0x87DF;
const uint GL_NORMALIZED_RANGE_EXT                            = 0x87E0;
const uint GL_FULL_RANGE_EXT                                  = 0x87E1;
const uint GL_CURRENT_VERTEX_EXT                              = 0x87E2;
const uint GL_MVP_MATRIX_EXT                                  = 0x87E3;
const uint GL_VARIANT_VALUE_EXT                               = 0x87E4;
const uint GL_VARIANT_DATATYPE_EXT                            = 0x87E5;
const uint GL_VARIANT_ARRAY_STRIDE_EXT                        = 0x87E6;
const uint GL_VARIANT_ARRAY_TYPE_EXT                          = 0x87E7;
const uint GL_VARIANT_ARRAY_EXT                               = 0x87E8;
const uint GL_VARIANT_ARRAY_POINTER_EXT                       = 0x87E9;
const uint GL_INVARIANT_VALUE_EXT                             = 0x87EA;
const uint GL_INVARIANT_DATATYPE_EXT                          = 0x87EB;
const uint GL_LOCAL_CONSTANT_VALUE_EXT                        = 0x87EC;
const uint GL_LOCAL_CONSTANT_DATATYPE_EXT                     = 0x87ED;
typedef void   function() PFNGLBEGINVERTEXSHADEREXTPROC;
typedef void   function() PFNGLENDVERTEXSHADEREXTPROC;
typedef void   function(GLuint id) PFNGLBINDVERTEXSHADEREXTPROC;
typedef GLuint   function(GLuint range) PFNGLGENVERTEXSHADERSEXTPROC;
typedef void   function(GLuint id) PFNGLDELETEVERTEXSHADEREXTPROC;
typedef void   function(GLenum op, GLuint res, GLuint arg1) PFNGLSHADEROP1EXTPROC;
typedef void   function(GLenum op, GLuint res, GLuint arg1, GLuint arg2) PFNGLSHADEROP2EXTPROC;
typedef void   function(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3) PFNGLSHADEROP3EXTPROC;
typedef void   function(GLuint res, GLuint _in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW) PFNGLSWIZZLEEXTPROC;
typedef void   function(GLuint res, GLuint _in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW) PFNGLWRITEMASKEXTPROC;
typedef void   function(GLuint res, GLuint src, GLuint num) PFNGLINSERTCOMPONENTEXTPROC;
typedef void   function(GLuint res, GLuint src, GLuint num) PFNGLEXTRACTCOMPONENTEXTPROC;
typedef GLuint   function(GLenum datatype, GLenum storagetype, GLenum range, GLuint components) PFNGLGENSYMBOLSEXTPROC;
typedef void   function(GLuint id, GLenum type, GLvoid *addr) PFNGLSETINVARIANTEXTPROC;
typedef void   function(GLuint id, GLenum type, GLvoid *addr) PFNGLSETLOCALCONSTANTEXTPROC;
typedef void   function(GLuint id, GLbyte *addr) PFNGLVARIANTBVEXTPROC;
typedef void   function(GLuint id, GLshort *addr) PFNGLVARIANTSVEXTPROC;
typedef void   function(GLuint id, GLint *addr) PFNGLVARIANTIVEXTPROC;
typedef void   function(GLuint id, GLfloat *addr) PFNGLVARIANTFVEXTPROC;
typedef void   function(GLuint id, GLdouble *addr) PFNGLVARIANTDVEXTPROC;
typedef void   function(GLuint id, GLubyte *addr) PFNGLVARIANTUBVEXTPROC;
typedef void   function(GLuint id, GLushort *addr) PFNGLVARIANTUSVEXTPROC;
typedef void   function(GLuint id, GLuint *addr) PFNGLVARIANTUIVEXTPROC;
typedef void   function(GLuint id, GLenum type, GLuint stride, GLvoid *addr) PFNGLVARIANTPOINTEREXTPROC;
typedef void   function(GLuint id) PFNGLENABLEVARIANTCLIENTSTATEEXTPROC;
typedef void   function(GLuint id) PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC;
typedef GLuint   function(GLenum light, GLenum value) PFNGLBINDLIGHTPARAMETEREXTPROC;
typedef GLuint   function(GLenum face, GLenum value) PFNGLBINDMATERIALPARAMETEREXTPROC;
typedef GLuint   function(GLenum unit, GLenum coord, GLenum value) PFNGLBINDTEXGENPARAMETEREXTPROC;
typedef GLuint   function(GLenum unit, GLenum value) PFNGLBINDTEXTUREUNITPARAMETEREXTPROC;
typedef GLuint   function(GLenum value) PFNGLBINDPARAMETEREXTPROC;
typedef GLboolean   function(GLuint id, GLenum cap) PFNGLISVARIANTENABLEDEXTPROC;
typedef void   function(GLuint id, GLenum value, GLboolean *data) PFNGLGETVARIANTBOOLEANVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLint *data) PFNGLGETVARIANTINTEGERVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLfloat *data) PFNGLGETVARIANTFLOATVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLvoid* *data) PFNGLGETVARIANTPOINTERVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLboolean *data) PFNGLGETINVARIANTBOOLEANVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLint *data) PFNGLGETINVARIANTINTEGERVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLfloat *data) PFNGLGETINVARIANTFLOATVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLboolean *data) PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLint *data) PFNGLGETLOCALCONSTANTINTEGERVEXTPROC;
typedef void   function(GLuint id, GLenum value, GLfloat *data) PFNGLGETLOCALCONSTANTFLOATVEXTPROC;
 extern   PFNGLBEGINVERTEXSHADEREXTPROC pglBeginVertexShaderEXT;
 extern   PFNGLENDVERTEXSHADEREXTPROC pglEndVertexShaderEXT;
 extern   PFNGLBINDVERTEXSHADEREXTPROC pglBindVertexShaderEXT;
 extern   PFNGLGENVERTEXSHADERSEXTPROC pglGenVertexShadersEXT;
 extern   PFNGLDELETEVERTEXSHADEREXTPROC pglDeleteVertexShaderEXT;
 extern   PFNGLSHADEROP1EXTPROC pglShaderOp1EXT;
 extern   PFNGLSHADEROP2EXTPROC pglShaderOp2EXT;
 extern   PFNGLSHADEROP3EXTPROC pglShaderOp3EXT;
 extern   PFNGLSWIZZLEEXTPROC pglSwizzleEXT;
 extern   PFNGLWRITEMASKEXTPROC pglWriteMaskEXT;
 extern   PFNGLINSERTCOMPONENTEXTPROC pglInsertComponentEXT;
 extern   PFNGLEXTRACTCOMPONENTEXTPROC pglExtractComponentEXT;
 extern   PFNGLGENSYMBOLSEXTPROC pglGenSymbolsEXT;
 extern   PFNGLSETINVARIANTEXTPROC pglSetInvariantEXT;
 extern   PFNGLSETLOCALCONSTANTEXTPROC pglSetLocalConstantEXT;
 extern   PFNGLVARIANTBVEXTPROC pglVariantbvEXT;
 extern   PFNGLVARIANTSVEXTPROC pglVariantsvEXT;
 extern   PFNGLVARIANTIVEXTPROC pglVariantivEXT;
 extern   PFNGLVARIANTFVEXTPROC pglVariantfvEXT;
 extern   PFNGLVARIANTDVEXTPROC pglVariantdvEXT;
 extern   PFNGLVARIANTUBVEXTPROC pglVariantubvEXT;
 extern   PFNGLVARIANTUSVEXTPROC pglVariantusvEXT;
 extern   PFNGLVARIANTUIVEXTPROC pglVariantuivEXT;
 extern   PFNGLVARIANTPOINTEREXTPROC pglVariantPointerEXT;
 extern   PFNGLENABLEVARIANTCLIENTSTATEEXTPROC pglEnableVariantClientStateEXT;
 extern   PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC pglDisableVariantClientStateEXT;
 extern   PFNGLBINDLIGHTPARAMETEREXTPROC pglBindLightParameterEXT;
 extern   PFNGLBINDMATERIALPARAMETEREXTPROC pglBindMaterialParameterEXT;
 extern   PFNGLBINDTEXGENPARAMETEREXTPROC pglBindTexGenParameterEXT;
 extern   PFNGLBINDTEXTUREUNITPARAMETEREXTPROC pglBindTextureUnitParameterEXT;
 extern   PFNGLBINDPARAMETEREXTPROC pglBindParameterEXT;
 extern   PFNGLISVARIANTENABLEDEXTPROC pglIsVariantEnabledEXT;
 extern   PFNGLGETVARIANTBOOLEANVEXTPROC pglGetVariantBooleanvEXT;
 extern   PFNGLGETVARIANTINTEGERVEXTPROC pglGetVariantIntegervEXT;
 extern   PFNGLGETVARIANTFLOATVEXTPROC pglGetVariantFloatvEXT;
 extern   PFNGLGETVARIANTPOINTERVEXTPROC pglGetVariantPointervEXT;
 extern   PFNGLGETINVARIANTBOOLEANVEXTPROC pglGetInvariantBooleanvEXT;
 extern   PFNGLGETINVARIANTINTEGERVEXTPROC pglGetInvariantIntegervEXT;
 extern   PFNGLGETINVARIANTFLOATVEXTPROC pglGetInvariantFloatvEXT;
 extern   PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC pglGetLocalConstantBooleanvEXT;
 extern   PFNGLGETLOCALCONSTANTINTEGERVEXTPROC pglGetLocalConstantIntegervEXT;
 extern   PFNGLGETLOCALCONSTANTFLOATVEXTPROC pglGetLocalConstantFloatvEXT;
alias pglBeginVertexShaderEXT glBeginVertexShaderEXT;
alias pglEndVertexShaderEXT glEndVertexShaderEXT;
alias pglBindVertexShaderEXT glBindVertexShaderEXT;
alias pglGenVertexShadersEXT glGenVertexShadersEXT;
alias pglDeleteVertexShaderEXT glDeleteVertexShaderEXT;
alias pglShaderOp1EXT glShaderOp1EXT;
alias pglShaderOp2EXT glShaderOp2EXT;
alias pglShaderOp3EXT glShaderOp3EXT;
alias pglSwizzleEXT glSwizzleEXT;
alias pglWriteMaskEXT glWriteMaskEXT;
alias pglInsertComponentEXT glInsertComponentEXT;
alias pglExtractComponentEXT glExtractComponentEXT;
alias pglGenSymbolsEXT glGenSymbolsEXT;
alias pglSetInvariantEXT glSetInvariantEXT;
alias pglSetLocalConstantEXT glSetLocalConstantEXT;
alias pglVariantbvEXT glVariantbvEXT;
alias pglVariantsvEXT glVariantsvEXT;
alias pglVariantivEXT glVariantivEXT;
alias pglVariantfvEXT glVariantfvEXT;
alias pglVariantdvEXT glVariantdvEXT;
alias pglVariantubvEXT glVariantubvEXT;
alias pglVariantusvEXT glVariantusvEXT;
alias pglVariantuivEXT glVariantuivEXT;
alias pglVariantPointerEXT glVariantPointerEXT;
alias pglEnableVariantClientStateEXT glEnableVariantClientStateEXT;
alias pglDisableVariantClientStateEXT glDisableVariantClientStateEXT;
alias pglBindLightParameterEXT glBindLightParameterEXT;
alias pglBindMaterialParameterEXT glBindMaterialParameterEXT;
alias pglBindTexGenParameterEXT glBindTexGenParameterEXT;
alias pglBindTextureUnitParameterEXT glBindTextureUnitParameterEXT;
alias pglBindParameterEXT glBindParameterEXT;
alias pglIsVariantEnabledEXT glIsVariantEnabledEXT;
alias pglGetVariantBooleanvEXT glGetVariantBooleanvEXT;
alias pglGetVariantIntegervEXT glGetVariantIntegervEXT;
alias pglGetVariantFloatvEXT glGetVariantFloatvEXT;
alias pglGetVariantPointervEXT glGetVariantPointervEXT;
alias pglGetInvariantBooleanvEXT glGetInvariantBooleanvEXT;
alias pglGetInvariantIntegervEXT glGetInvariantIntegervEXT;
alias pglGetInvariantFloatvEXT glGetInvariantFloatvEXT;
alias pglGetLocalConstantBooleanvEXT glGetLocalConstantBooleanvEXT;
alias pglGetLocalConstantIntegervEXT glGetLocalConstantIntegervEXT;
alias pglGetLocalConstantFloatvEXT glGetLocalConstantFloatvEXT;
//#endif ;

//GL_ATI_vertex_streams

//#ifndef GL_ATI_vertex_streams;
const uint GL_ATI_vertex_streams = 1;
const uint __GLEE_GL_ATI_vertex_streams = 1;
//constants
const uint GL_MAX_VERTEX_STREAMS_ATI                          = 0x876B;
const uint GL_VERTEX_STREAM0_ATI                              = 0x876C;
const uint GL_VERTEX_STREAM1_ATI                              = 0x876D;
const uint GL_VERTEX_STREAM2_ATI                              = 0x876E;
const uint GL_VERTEX_STREAM3_ATI                              = 0x876F;
const uint GL_VERTEX_STREAM4_ATI                              = 0x8770;
const uint GL_VERTEX_STREAM5_ATI                              = 0x8771;
const uint GL_VERTEX_STREAM6_ATI                              = 0x8772;
const uint GL_VERTEX_STREAM7_ATI                              = 0x8773;
const uint GL_VERTEX_SOURCE_ATI                               = 0x8774;
typedef void   function(GLenum stream, GLshort x) PFNGLVERTEXSTREAM1SATIPROC;
typedef void   function(GLenum stream, GLshort *coords) PFNGLVERTEXSTREAM1SVATIPROC;
typedef void   function(GLenum stream, GLint x) PFNGLVERTEXSTREAM1IATIPROC;
typedef void   function(GLenum stream, GLint *coords) PFNGLVERTEXSTREAM1IVATIPROC;
typedef void   function(GLenum stream, GLfloat x) PFNGLVERTEXSTREAM1FATIPROC;
typedef void   function(GLenum stream, GLfloat *coords) PFNGLVERTEXSTREAM1FVATIPROC;
typedef void   function(GLenum stream, GLdouble x) PFNGLVERTEXSTREAM1DATIPROC;
typedef void   function(GLenum stream, GLdouble *coords) PFNGLVERTEXSTREAM1DVATIPROC;
typedef void   function(GLenum stream, GLshort x, GLshort y) PFNGLVERTEXSTREAM2SATIPROC;
typedef void   function(GLenum stream, GLshort *coords) PFNGLVERTEXSTREAM2SVATIPROC;
typedef void   function(GLenum stream, GLint x, GLint y) PFNGLVERTEXSTREAM2IATIPROC;
typedef void   function(GLenum stream, GLint *coords) PFNGLVERTEXSTREAM2IVATIPROC;
typedef void   function(GLenum stream, GLfloat x, GLfloat y) PFNGLVERTEXSTREAM2FATIPROC;
typedef void   function(GLenum stream, GLfloat *coords) PFNGLVERTEXSTREAM2FVATIPROC;
typedef void   function(GLenum stream, GLdouble x, GLdouble y) PFNGLVERTEXSTREAM2DATIPROC;
typedef void   function(GLenum stream, GLdouble *coords) PFNGLVERTEXSTREAM2DVATIPROC;
typedef void   function(GLenum stream, GLshort x, GLshort y, GLshort z) PFNGLVERTEXSTREAM3SATIPROC;
typedef void   function(GLenum stream, GLshort *coords) PFNGLVERTEXSTREAM3SVATIPROC;
typedef void   function(GLenum stream, GLint x, GLint y, GLint z) PFNGLVERTEXSTREAM3IATIPROC;
typedef void   function(GLenum stream, GLint *coords) PFNGLVERTEXSTREAM3IVATIPROC;
typedef void   function(GLenum stream, GLfloat x, GLfloat y, GLfloat z) PFNGLVERTEXSTREAM3FATIPROC;
typedef void   function(GLenum stream, GLfloat *coords) PFNGLVERTEXSTREAM3FVATIPROC;
typedef void   function(GLenum stream, GLdouble x, GLdouble y, GLdouble z) PFNGLVERTEXSTREAM3DATIPROC;
typedef void   function(GLenum stream, GLdouble *coords) PFNGLVERTEXSTREAM3DVATIPROC;
typedef void   function(GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w) PFNGLVERTEXSTREAM4SATIPROC;
typedef void   function(GLenum stream, GLshort *coords) PFNGLVERTEXSTREAM4SVATIPROC;
typedef void   function(GLenum stream, GLint x, GLint y, GLint z, GLint w) PFNGLVERTEXSTREAM4IATIPROC;
typedef void   function(GLenum stream, GLint *coords) PFNGLVERTEXSTREAM4IVATIPROC;
typedef void   function(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLVERTEXSTREAM4FATIPROC;
typedef void   function(GLenum stream, GLfloat *coords) PFNGLVERTEXSTREAM4FVATIPROC;
typedef void   function(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLVERTEXSTREAM4DATIPROC;
typedef void   function(GLenum stream, GLdouble *coords) PFNGLVERTEXSTREAM4DVATIPROC;
typedef void   function(GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz) PFNGLNORMALSTREAM3BATIPROC;
typedef void   function(GLenum stream, GLbyte *coords) PFNGLNORMALSTREAM3BVATIPROC;
typedef void   function(GLenum stream, GLshort nx, GLshort ny, GLshort nz) PFNGLNORMALSTREAM3SATIPROC;
typedef void   function(GLenum stream, GLshort *coords) PFNGLNORMALSTREAM3SVATIPROC;
typedef void   function(GLenum stream, GLint nx, GLint ny, GLint nz) PFNGLNORMALSTREAM3IATIPROC;
typedef void   function(GLenum stream, GLint *coords) PFNGLNORMALSTREAM3IVATIPROC;
typedef void   function(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz) PFNGLNORMALSTREAM3FATIPROC;
typedef void   function(GLenum stream, GLfloat *coords) PFNGLNORMALSTREAM3FVATIPROC;
typedef void   function(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz) PFNGLNORMALSTREAM3DATIPROC;
typedef void   function(GLenum stream, GLdouble *coords) PFNGLNORMALSTREAM3DVATIPROC;
typedef void   function(GLenum stream) PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC;
typedef void   function(GLenum pname, GLint param) PFNGLVERTEXBLENDENVIATIPROC;
typedef void   function(GLenum pname, GLfloat param) PFNGLVERTEXBLENDENVFATIPROC;
 extern   PFNGLVERTEXSTREAM1SATIPROC pglVertexStream1sATI;
 extern   PFNGLVERTEXSTREAM1SVATIPROC pglVertexStream1svATI;
 extern   PFNGLVERTEXSTREAM1IATIPROC pglVertexStream1iATI;
 extern   PFNGLVERTEXSTREAM1IVATIPROC pglVertexStream1ivATI;
 extern   PFNGLVERTEXSTREAM1FATIPROC pglVertexStream1fATI;
 extern   PFNGLVERTEXSTREAM1FVATIPROC pglVertexStream1fvATI;
 extern   PFNGLVERTEXSTREAM1DATIPROC pglVertexStream1dATI;
 extern   PFNGLVERTEXSTREAM1DVATIPROC pglVertexStream1dvATI;
 extern   PFNGLVERTEXSTREAM2SATIPROC pglVertexStream2sATI;
 extern   PFNGLVERTEXSTREAM2SVATIPROC pglVertexStream2svATI;
 extern   PFNGLVERTEXSTREAM2IATIPROC pglVertexStream2iATI;
 extern   PFNGLVERTEXSTREAM2IVATIPROC pglVertexStream2ivATI;
 extern   PFNGLVERTEXSTREAM2FATIPROC pglVertexStream2fATI;
 extern   PFNGLVERTEXSTREAM2FVATIPROC pglVertexStream2fvATI;
 extern   PFNGLVERTEXSTREAM2DATIPROC pglVertexStream2dATI;
 extern   PFNGLVERTEXSTREAM2DVATIPROC pglVertexStream2dvATI;
 extern   PFNGLVERTEXSTREAM3SATIPROC pglVertexStream3sATI;
 extern   PFNGLVERTEXSTREAM3SVATIPROC pglVertexStream3svATI;
 extern   PFNGLVERTEXSTREAM3IATIPROC pglVertexStream3iATI;
 extern   PFNGLVERTEXSTREAM3IVATIPROC pglVertexStream3ivATI;
 extern   PFNGLVERTEXSTREAM3FATIPROC pglVertexStream3fATI;
 extern   PFNGLVERTEXSTREAM3FVATIPROC pglVertexStream3fvATI;
 extern   PFNGLVERTEXSTREAM3DATIPROC pglVertexStream3dATI;
 extern   PFNGLVERTEXSTREAM3DVATIPROC pglVertexStream3dvATI;
 extern   PFNGLVERTEXSTREAM4SATIPROC pglVertexStream4sATI;
 extern   PFNGLVERTEXSTREAM4SVATIPROC pglVertexStream4svATI;
 extern   PFNGLVERTEXSTREAM4IATIPROC pglVertexStream4iATI;
 extern   PFNGLVERTEXSTREAM4IVATIPROC pglVertexStream4ivATI;
 extern   PFNGLVERTEXSTREAM4FATIPROC pglVertexStream4fATI;
 extern   PFNGLVERTEXSTREAM4FVATIPROC pglVertexStream4fvATI;
 extern   PFNGLVERTEXSTREAM4DATIPROC pglVertexStream4dATI;
 extern   PFNGLVERTEXSTREAM4DVATIPROC pglVertexStream4dvATI;
 extern   PFNGLNORMALSTREAM3BATIPROC pglNormalStream3bATI;
 extern   PFNGLNORMALSTREAM3BVATIPROC pglNormalStream3bvATI;
 extern   PFNGLNORMALSTREAM3SATIPROC pglNormalStream3sATI;
 extern   PFNGLNORMALSTREAM3SVATIPROC pglNormalStream3svATI;
 extern   PFNGLNORMALSTREAM3IATIPROC pglNormalStream3iATI;
 extern   PFNGLNORMALSTREAM3IVATIPROC pglNormalStream3ivATI;
 extern   PFNGLNORMALSTREAM3FATIPROC pglNormalStream3fATI;
 extern   PFNGLNORMALSTREAM3FVATIPROC pglNormalStream3fvATI;
 extern   PFNGLNORMALSTREAM3DATIPROC pglNormalStream3dATI;
 extern   PFNGLNORMALSTREAM3DVATIPROC pglNormalStream3dvATI;
 extern   PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC pglClientActiveVertexStreamATI;
 extern   PFNGLVERTEXBLENDENVIATIPROC pglVertexBlendEnviATI;
 extern   PFNGLVERTEXBLENDENVFATIPROC pglVertexBlendEnvfATI;
alias pglVertexStream1sATI glVertexStream1sATI;
alias pglVertexStream1svATI glVertexStream1svATI;
alias pglVertexStream1iATI glVertexStream1iATI;
alias pglVertexStream1ivATI glVertexStream1ivATI;
alias pglVertexStream1fATI glVertexStream1fATI;
alias pglVertexStream1fvATI glVertexStream1fvATI;
alias pglVertexStream1dATI glVertexStream1dATI;
alias pglVertexStream1dvATI glVertexStream1dvATI;
alias pglVertexStream2sATI glVertexStream2sATI;
alias pglVertexStream2svATI glVertexStream2svATI;
alias pglVertexStream2iATI glVertexStream2iATI;
alias pglVertexStream2ivATI glVertexStream2ivATI;
alias pglVertexStream2fATI glVertexStream2fATI;
alias pglVertexStream2fvATI glVertexStream2fvATI;
alias pglVertexStream2dATI glVertexStream2dATI;
alias pglVertexStream2dvATI glVertexStream2dvATI;
alias pglVertexStream3sATI glVertexStream3sATI;
alias pglVertexStream3svATI glVertexStream3svATI;
alias pglVertexStream3iATI glVertexStream3iATI;
alias pglVertexStream3ivATI glVertexStream3ivATI;
alias pglVertexStream3fATI glVertexStream3fATI;
alias pglVertexStream3fvATI glVertexStream3fvATI;
alias pglVertexStream3dATI glVertexStream3dATI;
alias pglVertexStream3dvATI glVertexStream3dvATI;
alias pglVertexStream4sATI glVertexStream4sATI;
alias pglVertexStream4svATI glVertexStream4svATI;
alias pglVertexStream4iATI glVertexStream4iATI;
alias pglVertexStream4ivATI glVertexStream4ivATI;
alias pglVertexStream4fATI glVertexStream4fATI;
alias pglVertexStream4fvATI glVertexStream4fvATI;
alias pglVertexStream4dATI glVertexStream4dATI;
alias pglVertexStream4dvATI glVertexStream4dvATI;
alias pglNormalStream3bATI glNormalStream3bATI;
alias pglNormalStream3bvATI glNormalStream3bvATI;
alias pglNormalStream3sATI glNormalStream3sATI;
alias pglNormalStream3svATI glNormalStream3svATI;
alias pglNormalStream3iATI glNormalStream3iATI;
alias pglNormalStream3ivATI glNormalStream3ivATI;
alias pglNormalStream3fATI glNormalStream3fATI;
alias pglNormalStream3fvATI glNormalStream3fvATI;
alias pglNormalStream3dATI glNormalStream3dATI;
alias pglNormalStream3dvATI glNormalStream3dvATI;
alias pglClientActiveVertexStreamATI glClientActiveVertexStreamATI;
alias pglVertexBlendEnviATI glVertexBlendEnviATI;
alias pglVertexBlendEnvfATI glVertexBlendEnvfATI;
//#endif ;

//GL_ATI_element_array

//#ifndef GL_ATI_element_array;
const uint GL_ATI_element_array = 1;
const uint __GLEE_GL_ATI_element_array = 1;
//constants
const uint GL_ELEMENT_ARRAY_ATI                               = 0x8768;
const uint GL_ELEMENT_ARRAY_TYPE_ATI                          = 0x8769;
const uint GL_ELEMENT_ARRAY_POINTER_ATI                       = 0x876A;
typedef void   function(GLenum type, GLvoid *pointer) PFNGLELEMENTPOINTERATIPROC;
typedef void   function(GLenum mode, GLsizei count) PFNGLDRAWELEMENTARRAYATIPROC;
typedef void   function(GLenum mode, GLuint start, GLuint end, GLsizei count) PFNGLDRAWRANGEELEMENTARRAYATIPROC;
 extern   PFNGLELEMENTPOINTERATIPROC pglElementPointerATI;
 extern   PFNGLDRAWELEMENTARRAYATIPROC pglDrawElementArrayATI;
 extern   PFNGLDRAWRANGEELEMENTARRAYATIPROC pglDrawRangeElementArrayATI;
alias pglElementPointerATI glElementPointerATI;
alias pglDrawElementArrayATI glDrawElementArrayATI;
alias pglDrawRangeElementArrayATI glDrawRangeElementArrayATI;
//#endif ;

//GL_SUN_mesh_array

//#ifndef GL_SUN_mesh_array;
const uint GL_SUN_mesh_array = 1;
const uint __GLEE_GL_SUN_mesh_array = 1;
//constants
const uint GL_QUAD_MESH_SUN                                   = 0x8614;
const uint GL_TRIANGLE_MESH_SUN                               = 0x8615;
typedef void   function(GLenum mode, GLint first, GLsizei count, GLsizei width) PFNGLDRAWMESHARRAYSSUNPROC;
 extern   PFNGLDRAWMESHARRAYSSUNPROC pglDrawMeshArraysSUN;
alias pglDrawMeshArraysSUN glDrawMeshArraysSUN;
//#endif ;

//GL_SUN_slice_accum

//#ifndef GL_SUN_slice_accum;
const uint GL_SUN_slice_accum = 1;
const uint __GLEE_GL_SUN_slice_accum = 1;
//constants
const uint GL_SLICE_ACCUM_SUN                                 = 0x85CC;
//#endif ;

//GL_NV_multisample_filter_hint

//#ifndef GL_NV_multisample_filter_hint;
const uint GL_NV_multisample_filter_hint = 1;
const uint __GLEE_GL_NV_multisample_filter_hint = 1;
//constants
const uint GL_MULTISAMPLE_FILTER_HINT_NV                      = 0x8534;
//#endif ;

//GL_NV_depth_clamp

//#ifndef GL_NV_depth_clamp;
const uint GL_NV_depth_clamp = 1;
const uint __GLEE_GL_NV_depth_clamp = 1;
//constants
const uint GL_DEPTH_CLAMP_NV                                  = 0x864F;
//#endif ;

//GL_NV_occlusion_query

//#ifndef GL_NV_occlusion_query;
const uint GL_NV_occlusion_query = 1;
const uint __GLEE_GL_NV_occlusion_query = 1;
//constants
const uint GL_PIXEL_COUNTER_BITS_NV                           = 0x8864;
const uint GL_CURRENT_OCCLUSION_QUERY_ID_NV                   = 0x8865;
const uint GL_PIXEL_COUNT_NV                                  = 0x8866;
const uint GL_PIXEL_COUNT_AVAILABLE_NV                        = 0x8867;
typedef void   function(GLsizei n, GLuint *ids) PFNGLGENOCCLUSIONQUERIESNVPROC;
typedef void   function(GLsizei n, GLuint *ids) PFNGLDELETEOCCLUSIONQUERIESNVPROC;
typedef GLboolean   function(GLuint id) PFNGLISOCCLUSIONQUERYNVPROC;
typedef void   function(GLuint id) PFNGLBEGINOCCLUSIONQUERYNVPROC;
typedef void   function() PFNGLENDOCCLUSIONQUERYNVPROC;
typedef void   function(GLuint id, GLenum pname, GLint *params) PFNGLGETOCCLUSIONQUERYIVNVPROC;
typedef void   function(GLuint id, GLenum pname, GLuint *params) PFNGLGETOCCLUSIONQUERYUIVNVPROC;
 extern   PFNGLGENOCCLUSIONQUERIESNVPROC pglGenOcclusionQueriesNV;
 extern   PFNGLDELETEOCCLUSIONQUERIESNVPROC pglDeleteOcclusionQueriesNV;
 extern   PFNGLISOCCLUSIONQUERYNVPROC pglIsOcclusionQueryNV;
 extern   PFNGLBEGINOCCLUSIONQUERYNVPROC pglBeginOcclusionQueryNV;
 extern   PFNGLENDOCCLUSIONQUERYNVPROC pglEndOcclusionQueryNV;
 extern   PFNGLGETOCCLUSIONQUERYIVNVPROC pglGetOcclusionQueryivNV;
 extern   PFNGLGETOCCLUSIONQUERYUIVNVPROC pglGetOcclusionQueryuivNV;
alias pglGenOcclusionQueriesNV glGenOcclusionQueriesNV;
alias pglDeleteOcclusionQueriesNV glDeleteOcclusionQueriesNV;
alias pglIsOcclusionQueryNV glIsOcclusionQueryNV;
alias pglBeginOcclusionQueryNV glBeginOcclusionQueryNV;
alias pglEndOcclusionQueryNV glEndOcclusionQueryNV;
alias pglGetOcclusionQueryivNV glGetOcclusionQueryivNV;
alias pglGetOcclusionQueryuivNV glGetOcclusionQueryuivNV;
//#endif ;

//GL_NV_point_sprite

//#ifndef GL_NV_point_sprite;
const uint GL_NV_point_sprite = 1;
const uint __GLEE_GL_NV_point_sprite = 1;
//constants
const uint GL_POINT_SPRITE_NV                                 = 0x8861;
const uint GL_COORD_REPLACE_NV                                = 0x8862;
const uint GL_POINT_SPRITE_R_MODE_NV                          = 0x8863;
typedef void   function(GLenum pname, GLint param) PFNGLPOINTPARAMETERINVPROC;
typedef void   function(GLenum pname, GLint *params) PFNGLPOINTPARAMETERIVNVPROC;
 extern   PFNGLPOINTPARAMETERINVPROC pglPointParameteriNV;
 extern   PFNGLPOINTPARAMETERIVNVPROC pglPointParameterivNV;
alias pglPointParameteriNV glPointParameteriNV;
alias pglPointParameterivNV glPointParameterivNV;
//#endif ;

//GL_NV_texture_shader3

//#ifndef GL_NV_texture_shader3;
const uint GL_NV_texture_shader3 = 1;
const uint __GLEE_GL_NV_texture_shader3 = 1;
//constants
const uint GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV                 = 0x8850;
const uint GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV           = 0x8851;
const uint GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV          = 0x8852;
const uint GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV    = 0x8853;
const uint GL_OFFSET_HILO_TEXTURE_2D_NV                       = 0x8854;
const uint GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV                = 0x8855;
const uint GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV            = 0x8856;
const uint GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV     = 0x8857;
const uint GL_DEPENDENT_HILO_TEXTURE_2D_NV                    = 0x8858;
const uint GL_DEPENDENT_RGB_TEXTURE_3D_NV                     = 0x8859;
const uint GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV               = 0x885A;
const uint GL_DOT_PRODUCT_PASS_THROUGH_NV                     = 0x885B;
const uint GL_DOT_PRODUCT_TEXTURE_1D_NV                       = 0x885C;
const uint GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV             = 0x885D;
const uint GL_HILO8_NV                                        = 0x885E;
const uint GL_SIGNED_HILO8_NV                                 = 0x885F;
const uint GL_FORCE_BLUE_TO_ONE_NV                            = 0x8860;
//#endif ;

//GL_NV_vertex_program1_1

//#ifndef GL_NV_vertex_program1_1;
const uint GL_NV_vertex_program1_1 = 1;
const uint __GLEE_GL_NV_vertex_program1_1 = 1;
//constants
//#endif ;

//GL_EXT_shadow_funcs

//#ifndef GL_EXT_shadow_funcs;
const uint GL_EXT_shadow_funcs = 1;
const uint __GLEE_GL_EXT_shadow_funcs = 1;
//constants
//#endif ;

//GL_EXT_stencil_two_side

//#ifndef GL_EXT_stencil_two_side;
const uint GL_EXT_stencil_two_side = 1;
const uint __GLEE_GL_EXT_stencil_two_side = 1;
//constants
const uint GL_STENCIL_TEST_TWO_SIDE_EXT                       = 0x8910;
const uint GL_ACTIVE_STENCIL_FACE_EXT                         = 0x8911;
typedef void   function(GLenum face) PFNGLACTIVESTENCILFACEEXTPROC;
 extern   PFNGLACTIVESTENCILFACEEXTPROC pglActiveStencilFaceEXT;
alias pglActiveStencilFaceEXT glActiveStencilFaceEXT;
//#endif ;

//GL_ATI_text_fragment_shader

//#ifndef GL_ATI_text_fragment_shader;
const uint GL_ATI_text_fragment_shader = 1;
const uint __GLEE_GL_ATI_text_fragment_shader = 1;
//constants
const uint GL_TEXT_FRAGMENT_SHADER_ATI                        = 0x8200;
//#endif ;

//GL_APPLE_client_storage

//#ifndef GL_APPLE_client_storage;
const uint GL_APPLE_client_storage = 1;
const uint __GLEE_GL_APPLE_client_storage = 1;
//constants
const uint GL_UNPACK_CLIENT_STORAGE_APPLE                     = 0x85B2;
//#endif ;

//GL_APPLE_element_array

//#ifndef GL_APPLE_element_array;
const uint GL_APPLE_element_array = 1;
const uint __GLEE_GL_APPLE_element_array = 1;
//constants
const uint GL_ELEMENT_ARRAY_APPLE                             = 0x8768;
const uint GL_ELEMENT_ARRAY_TYPE_APPLE                        = 0x8769;
const uint GL_ELEMENT_ARRAY_POINTER_APPLE                     = 0x876A;
typedef void   function(GLenum type, GLvoid *pointer) PFNGLELEMENTPOINTERAPPLEPROC;
typedef void   function(GLenum mode, GLint first, GLsizei count) PFNGLDRAWELEMENTARRAYAPPLEPROC;
typedef void   function(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count) PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC;
typedef void   function(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount) PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC;
typedef void   function(GLenum mode, GLuint start, GLuint end, GLint *first, GLsizei *count, GLsizei primcount) PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC;
 extern   PFNGLELEMENTPOINTERAPPLEPROC pglElementPointerAPPLE;
 extern   PFNGLDRAWELEMENTARRAYAPPLEPROC pglDrawElementArrayAPPLE;
 extern   PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC pglDrawRangeElementArrayAPPLE;
 extern   PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC pglMultiDrawElementArrayAPPLE;
 extern   PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC pglMultiDrawRangeElementArrayAPPLE;
alias pglElementPointerAPPLE glElementPointerAPPLE;
alias pglDrawElementArrayAPPLE glDrawElementArrayAPPLE;
alias pglDrawRangeElementArrayAPPLE glDrawRangeElementArrayAPPLE;
alias pglMultiDrawElementArrayAPPLE glMultiDrawElementArrayAPPLE;
alias pglMultiDrawRangeElementArrayAPPLE glMultiDrawRangeElementArrayAPPLE;
//#endif ;

//GL_APPLE_fence

//#ifndef GL_APPLE_fence;
const uint GL_APPLE_fence = 1;
const uint __GLEE_GL_APPLE_fence = 1;
//constants
const uint GL_DRAW_PIXELS_APPLE                               = 0x8A0A;
const uint GL_FENCE_APPLE                                     = 0x8A0B;
typedef void   function(GLsizei n, GLuint *fences) PFNGLGENFENCESAPPLEPROC;
typedef void   function(GLsizei n, GLuint *fences) PFNGLDELETEFENCESAPPLEPROC;
typedef void   function(GLuint fence) PFNGLSETFENCEAPPLEPROC;
typedef GLboolean   function(GLuint fence) PFNGLISFENCEAPPLEPROC;
typedef GLboolean   function(GLuint fence) PFNGLTESTFENCEAPPLEPROC;
typedef void   function(GLuint fence) PFNGLFINISHFENCEAPPLEPROC;
typedef GLboolean   function(GLenum object, GLuint name) PFNGLTESTOBJECTAPPLEPROC;
typedef void   function(GLenum object, GLint name) PFNGLFINISHOBJECTAPPLEPROC;
 extern   PFNGLGENFENCESAPPLEPROC pglGenFencesAPPLE;
 extern   PFNGLDELETEFENCESAPPLEPROC pglDeleteFencesAPPLE;
 extern   PFNGLSETFENCEAPPLEPROC pglSetFenceAPPLE;
 extern   PFNGLISFENCEAPPLEPROC pglIsFenceAPPLE;
 extern   PFNGLTESTFENCEAPPLEPROC pglTestFenceAPPLE;
 extern   PFNGLFINISHFENCEAPPLEPROC pglFinishFenceAPPLE;
 extern   PFNGLTESTOBJECTAPPLEPROC pglTestObjectAPPLE;
 extern   PFNGLFINISHOBJECTAPPLEPROC pglFinishObjectAPPLE;
alias pglGenFencesAPPLE glGenFencesAPPLE;
alias pglDeleteFencesAPPLE glDeleteFencesAPPLE;
alias pglSetFenceAPPLE glSetFenceAPPLE;
alias pglIsFenceAPPLE glIsFenceAPPLE;
alias pglTestFenceAPPLE glTestFenceAPPLE;
alias pglFinishFenceAPPLE glFinishFenceAPPLE;
alias pglTestObjectAPPLE glTestObjectAPPLE;
alias pglFinishObjectAPPLE glFinishObjectAPPLE;
//#endif ;

//GL_APPLE_vertex_array_object

//#ifndef GL_APPLE_vertex_array_object;
const uint GL_APPLE_vertex_array_object = 1;
const uint __GLEE_GL_APPLE_vertex_array_object = 1;
//constants
const uint GL_VERTEX_ARRAY_BINDING_APPLE                      = 0x85B5;
typedef void   function(GLuint array) PFNGLBINDVERTEXARRAYAPPLEPROC;
typedef void   function(GLsizei n, GLuint *arrays) PFNGLDELETEVERTEXARRAYSAPPLEPROC;
typedef void   function(GLsizei n, GLuint *arrays) PFNGLGENVERTEXARRAYSAPPLEPROC;
typedef GLboolean   function(GLuint array) PFNGLISVERTEXARRAYAPPLEPROC;
 extern   PFNGLBINDVERTEXARRAYAPPLEPROC pglBindVertexArrayAPPLE;
 extern   PFNGLDELETEVERTEXARRAYSAPPLEPROC pglDeleteVertexArraysAPPLE;
 extern   PFNGLGENVERTEXARRAYSAPPLEPROC pglGenVertexArraysAPPLE;
 extern   PFNGLISVERTEXARRAYAPPLEPROC pglIsVertexArrayAPPLE;
alias pglBindVertexArrayAPPLE glBindVertexArrayAPPLE;
alias pglDeleteVertexArraysAPPLE glDeleteVertexArraysAPPLE;
alias pglGenVertexArraysAPPLE glGenVertexArraysAPPLE;
alias pglIsVertexArrayAPPLE glIsVertexArrayAPPLE;
//#endif ;

//GL_APPLE_vertex_array_range

//#ifndef GL_APPLE_vertex_array_range;
const uint GL_APPLE_vertex_array_range = 1;
const uint __GLEE_GL_APPLE_vertex_array_range = 1;
//constants
const uint GL_VERTEX_ARRAY_RANGE_APPLE                        = 0x851D;
const uint GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE                 = 0x851E;
const uint GL_VERTEX_ARRAY_STORAGE_HINT_APPLE                 = 0x851F;
const uint GL_VERTEX_ARRAY_RANGE_POINTER_APPLE                = 0x8521;
const uint GL_STORAGE_CACHED_APPLE                            = 0x85BE;
const uint GL_STORAGE_SHARED_APPLE                            = 0x85BF;
typedef void   function(GLsizei length, GLvoid *pointer) PFNGLVERTEXARRAYRANGEAPPLEPROC;
typedef void   function(GLsizei length, GLvoid *pointer) PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC;
typedef void   function(GLenum pname, GLint param) PFNGLVERTEXARRAYPARAMETERIAPPLEPROC;
 extern   PFNGLVERTEXARRAYRANGEAPPLEPROC pglVertexArrayRangeAPPLE;
 extern   PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC pglFlushVertexArrayRangeAPPLE;
 extern   PFNGLVERTEXARRAYPARAMETERIAPPLEPROC pglVertexArrayParameteriAPPLE;
alias pglVertexArrayRangeAPPLE glVertexArrayRangeAPPLE;
alias pglFlushVertexArrayRangeAPPLE glFlushVertexArrayRangeAPPLE;
alias pglVertexArrayParameteriAPPLE glVertexArrayParameteriAPPLE;
//#endif ;

//GL_APPLE_ycbcr_422

//#ifndef GL_APPLE_ycbcr_422;
const uint GL_APPLE_ycbcr_422 = 1;
const uint __GLEE_GL_APPLE_ycbcr_422 = 1;
//constants
const uint GL_YCBCR_422_APPLE                                 = 0x85B9;
const uint GL_UNSIGNED_SHORT_8_8_APPLE                        = 0x85BA;
const uint GL_UNSIGNED_SHORT_8_8_REV_APPLE                    = 0x85BB;
//#endif ;

//GL_S3_s3tc

//#ifndef GL_S3_s3tc;
const uint GL_S3_s3tc = 1;
const uint __GLEE_GL_S3_s3tc = 1;
//constants
const uint GL_RGB_S3TC                                        = 0x83A0;
const uint GL_RGB4_S3TC                                       = 0x83A1;
const uint GL_RGBA_S3TC                                       = 0x83A2;
const uint GL_RGBA4_S3TC                                      = 0x83A3;
//#endif ;

//GL_ATI_draw_buffers

//#ifndef GL_ATI_draw_buffers;
const uint GL_ATI_draw_buffers = 1;
const uint __GLEE_GL_ATI_draw_buffers = 1;
//constants
const uint GL_MAX_DRAW_BUFFERS_ATI                            = 0x8824;
const uint GL_DRAW_BUFFER0_ATI                                = 0x8825;
const uint GL_DRAW_BUFFER1_ATI                                = 0x8826;
const uint GL_DRAW_BUFFER2_ATI                                = 0x8827;
const uint GL_DRAW_BUFFER3_ATI                                = 0x8828;
const uint GL_DRAW_BUFFER4_ATI                                = 0x8829;
const uint GL_DRAW_BUFFER5_ATI                                = 0x882A;
const uint GL_DRAW_BUFFER6_ATI                                = 0x882B;
const uint GL_DRAW_BUFFER7_ATI                                = 0x882C;
const uint GL_DRAW_BUFFER8_ATI                                = 0x882D;
const uint GL_DRAW_BUFFER9_ATI                                = 0x882E;
const uint GL_DRAW_BUFFER10_ATI                               = 0x882F;
const uint GL_DRAW_BUFFER11_ATI                               = 0x8830;
const uint GL_DRAW_BUFFER12_ATI                               = 0x8831;
const uint GL_DRAW_BUFFER13_ATI                               = 0x8832;
const uint GL_DRAW_BUFFER14_ATI                               = 0x8833;
const uint GL_DRAW_BUFFER15_ATI                               = 0x8834;
typedef void   function(GLsizei n, GLenum *bufs) PFNGLDRAWBUFFERSATIPROC;
 extern   PFNGLDRAWBUFFERSATIPROC pglDrawBuffersATI;
alias pglDrawBuffersATI glDrawBuffersATI;
//#endif ;

//GL_ATI_texture_env_combine3

//#ifndef GL_ATI_texture_env_combine3;
const uint GL_ATI_texture_env_combine3 = 1;
const uint __GLEE_GL_ATI_texture_env_combine3 = 1;
//constants
const uint GL_MODULATE_ADD_ATI                                = 0x8744;
const uint GL_MODULATE_SIGNED_ADD_ATI                         = 0x8745;
const uint GL_MODULATE_SUBTRACT_ATI                           = 0x8746;
//#endif ;

//GL_ATI_texture_float

//#ifndef GL_ATI_texture_float;
const uint GL_ATI_texture_float = 1;
const uint __GLEE_GL_ATI_texture_float = 1;
//constants
const uint GL_RGBA_FLOAT32_ATI                                = 0x8814;
const uint GL_RGB_FLOAT32_ATI                                 = 0x8815;
const uint GL_ALPHA_FLOAT32_ATI                               = 0x8816;
const uint GL_INTENSITY_FLOAT32_ATI                           = 0x8817;
const uint GL_LUMINANCE_FLOAT32_ATI                           = 0x8818;
const uint GL_LUMINANCE_ALPHA_FLOAT32_ATI                     = 0x8819;
const uint GL_RGBA_FLOAT16_ATI                                = 0x881A;
const uint GL_RGB_FLOAT16_ATI                                 = 0x881B;
const uint GL_ALPHA_FLOAT16_ATI                               = 0x881C;
const uint GL_INTENSITY_FLOAT16_ATI                           = 0x881D;
const uint GL_LUMINANCE_FLOAT16_ATI                           = 0x881E;
const uint GL_LUMINANCE_ALPHA_FLOAT16_ATI                     = 0x881F;
//#endif ;

//GL_NV_float_buffer

//#ifndef GL_NV_float_buffer;
const uint GL_NV_float_buffer = 1;
const uint __GLEE_GL_NV_float_buffer = 1;
//constants
const uint GL_FLOAT_R_NV                                      = 0x8880;
const uint GL_FLOAT_RG_NV                                     = 0x8881;
const uint GL_FLOAT_RGB_NV                                    = 0x8882;
const uint GL_FLOAT_RGBA_NV                                   = 0x8883;
const uint GL_FLOAT_R16_NV                                    = 0x8884;
const uint GL_FLOAT_R32_NV                                    = 0x8885;
const uint GL_FLOAT_RG16_NV                                   = 0x8886;
const uint GL_FLOAT_RG32_NV                                   = 0x8887;
const uint GL_FLOAT_RGB16_NV                                  = 0x8888;
const uint GL_FLOAT_RGB32_NV                                  = 0x8889;
const uint GL_FLOAT_RGBA16_NV                                 = 0x888A;
const uint GL_FLOAT_RGBA32_NV                                 = 0x888B;
const uint GL_TEXTURE_FLOAT_COMPONENTS_NV                     = 0x888C;
const uint GL_FLOAT_CLEAR_COLOR_VALUE_NV                      = 0x888D;
const uint GL_FLOAT_RGBA_MODE_NV                              = 0x888E;
//#endif ;

//GL_NV_fragment_program

//#ifndef GL_NV_fragment_program;
const uint GL_NV_fragment_program = 1;
const uint __GLEE_GL_NV_fragment_program = 1;
//constants
const uint GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV        = 0x8868;
const uint GL_FRAGMENT_PROGRAM_NV                             = 0x8870;
const uint GL_MAX_TEXTURE_COORDS_NV                           = 0x8871;
const uint GL_MAX_TEXTURE_IMAGE_UNITS_NV                      = 0x8872;
const uint GL_FRAGMENT_PROGRAM_BINDING_NV                     = 0x8873;
const uint GL_PROGRAM_ERROR_STRING_NV                         = 0x8874;
typedef void   function(GLuint id, GLsizei len, GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w) PFNGLPROGRAMNAMEDPARAMETER4FNVPROC;
typedef void   function(GLuint id, GLsizei len, GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w) PFNGLPROGRAMNAMEDPARAMETER4DNVPROC;
typedef void   function(GLuint id, GLsizei len, GLubyte *name, GLfloat *v) PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC;
typedef void   function(GLuint id, GLsizei len, GLubyte *name, GLdouble *v) PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC;
typedef void   function(GLuint id, GLsizei len, GLubyte *name, GLfloat *params) PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC;
typedef void   function(GLuint id, GLsizei len, GLubyte *name, GLdouble *params) PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC;
 extern   PFNGLPROGRAMNAMEDPARAMETER4FNVPROC pglProgramNamedParameter4fNV;
 extern   PFNGLPROGRAMNAMEDPARAMETER4DNVPROC pglProgramNamedParameter4dNV;
 extern   PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC pglProgramNamedParameter4fvNV;
 extern   PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC pglProgramNamedParameter4dvNV;
 extern   PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC pglGetProgramNamedParameterfvNV;
 extern   PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC pglGetProgramNamedParameterdvNV;
alias pglProgramNamedParameter4fNV glProgramNamedParameter4fNV;
alias pglProgramNamedParameter4dNV glProgramNamedParameter4dNV;
alias pglProgramNamedParameter4fvNV glProgramNamedParameter4fvNV;
alias pglProgramNamedParameter4dvNV glProgramNamedParameter4dvNV;
alias pglGetProgramNamedParameterfvNV glGetProgramNamedParameterfvNV;
alias pglGetProgramNamedParameterdvNV glGetProgramNamedParameterdvNV;
//#endif ;

//GL_NV_half_float

//#ifndef GL_NV_half_float;
const uint GL_NV_half_float = 1;
const uint __GLEE_GL_NV_half_float = 1;
//constants
const uint GL_HALF_FLOAT_NV                                   = 0x140B;
typedef void   function(GLhalfNV x, GLhalfNV y) PFNGLVERTEX2HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLVERTEX2HVNVPROC;
typedef void   function(GLhalfNV x, GLhalfNV y, GLhalfNV z) PFNGLVERTEX3HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLVERTEX3HVNVPROC;
typedef void   function(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w) PFNGLVERTEX4HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLVERTEX4HVNVPROC;
typedef void   function(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz) PFNGLNORMAL3HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLNORMAL3HVNVPROC;
typedef void   function(GLhalfNV red, GLhalfNV green, GLhalfNV blue) PFNGLCOLOR3HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLCOLOR3HVNVPROC;
typedef void   function(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha) PFNGLCOLOR4HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLCOLOR4HVNVPROC;
typedef void   function(GLhalfNV s) PFNGLTEXCOORD1HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLTEXCOORD1HVNVPROC;
typedef void   function(GLhalfNV s, GLhalfNV t) PFNGLTEXCOORD2HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLTEXCOORD2HVNVPROC;
typedef void   function(GLhalfNV s, GLhalfNV t, GLhalfNV r) PFNGLTEXCOORD3HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLTEXCOORD3HVNVPROC;
typedef void   function(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q) PFNGLTEXCOORD4HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLTEXCOORD4HVNVPROC;
typedef void   function(GLenum target, GLhalfNV s) PFNGLMULTITEXCOORD1HNVPROC;
typedef void   function(GLenum target, GLhalfNV *v) PFNGLMULTITEXCOORD1HVNVPROC;
typedef void   function(GLenum target, GLhalfNV s, GLhalfNV t) PFNGLMULTITEXCOORD2HNVPROC;
typedef void   function(GLenum target, GLhalfNV *v) PFNGLMULTITEXCOORD2HVNVPROC;
typedef void   function(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r) PFNGLMULTITEXCOORD3HNVPROC;
typedef void   function(GLenum target, GLhalfNV *v) PFNGLMULTITEXCOORD3HVNVPROC;
typedef void   function(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q) PFNGLMULTITEXCOORD4HNVPROC;
typedef void   function(GLenum target, GLhalfNV *v) PFNGLMULTITEXCOORD4HVNVPROC;
typedef void   function(GLhalfNV fog) PFNGLFOGCOORDHNVPROC;
typedef void   function(GLhalfNV *fog) PFNGLFOGCOORDHVNVPROC;
typedef void   function(GLhalfNV red, GLhalfNV green, GLhalfNV blue) PFNGLSECONDARYCOLOR3HNVPROC;
typedef void   function(GLhalfNV *v) PFNGLSECONDARYCOLOR3HVNVPROC;
typedef void   function(GLhalfNV weight) PFNGLVERTEXWEIGHTHNVPROC;
typedef void   function(GLhalfNV *weight) PFNGLVERTEXWEIGHTHVNVPROC;
typedef void   function(GLuint index, GLhalfNV x) PFNGLVERTEXATTRIB1HNVPROC;
typedef void   function(GLuint index, GLhalfNV *v) PFNGLVERTEXATTRIB1HVNVPROC;
typedef void   function(GLuint index, GLhalfNV x, GLhalfNV y) PFNGLVERTEXATTRIB2HNVPROC;
typedef void   function(GLuint index, GLhalfNV *v) PFNGLVERTEXATTRIB2HVNVPROC;
typedef void   function(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z) PFNGLVERTEXATTRIB3HNVPROC;
typedef void   function(GLuint index, GLhalfNV *v) PFNGLVERTEXATTRIB3HVNVPROC;
typedef void   function(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w) PFNGLVERTEXATTRIB4HNVPROC;
typedef void   function(GLuint index, GLhalfNV *v) PFNGLVERTEXATTRIB4HVNVPROC;
typedef void   function(GLuint index, GLsizei n, GLhalfNV *v) PFNGLVERTEXATTRIBS1HVNVPROC;
typedef void   function(GLuint index, GLsizei n, GLhalfNV *v) PFNGLVERTEXATTRIBS2HVNVPROC;
typedef void   function(GLuint index, GLsizei n, GLhalfNV *v) PFNGLVERTEXATTRIBS3HVNVPROC;
typedef void   function(GLuint index, GLsizei n, GLhalfNV *v) PFNGLVERTEXATTRIBS4HVNVPROC;
 extern   PFNGLVERTEX2HNVPROC pglVertex2hNV;
 extern   PFNGLVERTEX2HVNVPROC pglVertex2hvNV;
 extern   PFNGLVERTEX3HNVPROC pglVertex3hNV;
 extern   PFNGLVERTEX3HVNVPROC pglVertex3hvNV;
 extern   PFNGLVERTEX4HNVPROC pglVertex4hNV;
 extern   PFNGLVERTEX4HVNVPROC pglVertex4hvNV;
 extern   PFNGLNORMAL3HNVPROC pglNormal3hNV;
 extern   PFNGLNORMAL3HVNVPROC pglNormal3hvNV;
 extern   PFNGLCOLOR3HNVPROC pglColor3hNV;
 extern   PFNGLCOLOR3HVNVPROC pglColor3hvNV;
 extern   PFNGLCOLOR4HNVPROC pglColor4hNV;
 extern   PFNGLCOLOR4HVNVPROC pglColor4hvNV;
 extern   PFNGLTEXCOORD1HNVPROC pglTexCoord1hNV;
 extern   PFNGLTEXCOORD1HVNVPROC pglTexCoord1hvNV;
 extern   PFNGLTEXCOORD2HNVPROC pglTexCoord2hNV;
 extern   PFNGLTEXCOORD2HVNVPROC pglTexCoord2hvNV;
 extern   PFNGLTEXCOORD3HNVPROC pglTexCoord3hNV;
 extern   PFNGLTEXCOORD3HVNVPROC pglTexCoord3hvNV;
 extern   PFNGLTEXCOORD4HNVPROC pglTexCoord4hNV;
 extern   PFNGLTEXCOORD4HVNVPROC pglTexCoord4hvNV;
 extern   PFNGLMULTITEXCOORD1HNVPROC pglMultiTexCoord1hNV;
 extern   PFNGLMULTITEXCOORD1HVNVPROC pglMultiTexCoord1hvNV;
 extern   PFNGLMULTITEXCOORD2HNVPROC pglMultiTexCoord2hNV;
 extern   PFNGLMULTITEXCOORD2HVNVPROC pglMultiTexCoord2hvNV;
 extern   PFNGLMULTITEXCOORD3HNVPROC pglMultiTexCoord3hNV;
 extern   PFNGLMULTITEXCOORD3HVNVPROC pglMultiTexCoord3hvNV;
 extern   PFNGLMULTITEXCOORD4HNVPROC pglMultiTexCoord4hNV;
 extern   PFNGLMULTITEXCOORD4HVNVPROC pglMultiTexCoord4hvNV;
 extern   PFNGLFOGCOORDHNVPROC pglFogCoordhNV;
 extern   PFNGLFOGCOORDHVNVPROC pglFogCoordhvNV;
 extern   PFNGLSECONDARYCOLOR3HNVPROC pglSecondaryColor3hNV;
 extern   PFNGLSECONDARYCOLOR3HVNVPROC pglSecondaryColor3hvNV;
 extern   PFNGLVERTEXWEIGHTHNVPROC pglVertexWeighthNV;
 extern   PFNGLVERTEXWEIGHTHVNVPROC pglVertexWeighthvNV;
 extern   PFNGLVERTEXATTRIB1HNVPROC pglVertexAttrib1hNV;
 extern   PFNGLVERTEXATTRIB1HVNVPROC pglVertexAttrib1hvNV;
 extern   PFNGLVERTEXATTRIB2HNVPROC pglVertexAttrib2hNV;
 extern   PFNGLVERTEXATTRIB2HVNVPROC pglVertexAttrib2hvNV;
 extern   PFNGLVERTEXATTRIB3HNVPROC pglVertexAttrib3hNV;
 extern   PFNGLVERTEXATTRIB3HVNVPROC pglVertexAttrib3hvNV;
 extern   PFNGLVERTEXATTRIB4HNVPROC pglVertexAttrib4hNV;
 extern   PFNGLVERTEXATTRIB4HVNVPROC pglVertexAttrib4hvNV;
 extern   PFNGLVERTEXATTRIBS1HVNVPROC pglVertexAttribs1hvNV;
 extern   PFNGLVERTEXATTRIBS2HVNVPROC pglVertexAttribs2hvNV;
 extern   PFNGLVERTEXATTRIBS3HVNVPROC pglVertexAttribs3hvNV;
 extern   PFNGLVERTEXATTRIBS4HVNVPROC pglVertexAttribs4hvNV;
alias pglVertex2hNV glVertex2hNV;
alias pglVertex2hvNV glVertex2hvNV;
alias pglVertex3hNV glVertex3hNV;
alias pglVertex3hvNV glVertex3hvNV;
alias pglVertex4hNV glVertex4hNV;
alias pglVertex4hvNV glVertex4hvNV;
alias pglNormal3hNV glNormal3hNV;
alias pglNormal3hvNV glNormal3hvNV;
alias pglColor3hNV glColor3hNV;
alias pglColor3hvNV glColor3hvNV;
alias pglColor4hNV glColor4hNV;
alias pglColor4hvNV glColor4hvNV;
alias pglTexCoord1hNV glTexCoord1hNV;
alias pglTexCoord1hvNV glTexCoord1hvNV;
alias pglTexCoord2hNV glTexCoord2hNV;
alias pglTexCoord2hvNV glTexCoord2hvNV;
alias pglTexCoord3hNV glTexCoord3hNV;
alias pglTexCoord3hvNV glTexCoord3hvNV;
alias pglTexCoord4hNV glTexCoord4hNV;
alias pglTexCoord4hvNV glTexCoord4hvNV;
alias pglMultiTexCoord1hNV glMultiTexCoord1hNV;
alias pglMultiTexCoord1hvNV glMultiTexCoord1hvNV;
alias pglMultiTexCoord2hNV glMultiTexCoord2hNV;
alias pglMultiTexCoord2hvNV glMultiTexCoord2hvNV;
alias pglMultiTexCoord3hNV glMultiTexCoord3hNV;
alias pglMultiTexCoord3hvNV glMultiTexCoord3hvNV;
alias pglMultiTexCoord4hNV glMultiTexCoord4hNV;
alias pglMultiTexCoord4hvNV glMultiTexCoord4hvNV;
alias pglFogCoordhNV glFogCoordhNV;
alias pglFogCoordhvNV glFogCoordhvNV;
alias pglSecondaryColor3hNV glSecondaryColor3hNV;
alias pglSecondaryColor3hvNV glSecondaryColor3hvNV;
alias pglVertexWeighthNV glVertexWeighthNV;
alias pglVertexWeighthvNV glVertexWeighthvNV;
alias pglVertexAttrib1hNV glVertexAttrib1hNV;
alias pglVertexAttrib1hvNV glVertexAttrib1hvNV;
alias pglVertexAttrib2hNV glVertexAttrib2hNV;
alias pglVertexAttrib2hvNV glVertexAttrib2hvNV;
alias pglVertexAttrib3hNV glVertexAttrib3hNV;
alias pglVertexAttrib3hvNV glVertexAttrib3hvNV;
alias pglVertexAttrib4hNV glVertexAttrib4hNV;
alias pglVertexAttrib4hvNV glVertexAttrib4hvNV;
alias pglVertexAttribs1hvNV glVertexAttribs1hvNV;
alias pglVertexAttribs2hvNV glVertexAttribs2hvNV;
alias pglVertexAttribs3hvNV glVertexAttribs3hvNV;
alias pglVertexAttribs4hvNV glVertexAttribs4hvNV;
//#endif ;

//GL_NV_pixel_data_range

//#ifndef GL_NV_pixel_data_range;
const uint GL_NV_pixel_data_range = 1;
const uint __GLEE_GL_NV_pixel_data_range = 1;
//constants
const uint GL_WRITE_PIXEL_DATA_RANGE_NV                       = 0x8878;
const uint GL_READ_PIXEL_DATA_RANGE_NV                        = 0x8879;
const uint GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV                = 0x887A;
const uint GL_READ_PIXEL_DATA_RANGE_LENGTH_NV                 = 0x887B;
const uint GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV               = 0x887C;
const uint GL_READ_PIXEL_DATA_RANGE_POINTER_NV                = 0x887D;
typedef void   function(GLenum target, GLsizei length, GLvoid *pointer) PFNGLPIXELDATARANGENVPROC;
typedef void   function(GLenum target) PFNGLFLUSHPIXELDATARANGENVPROC;
 extern   PFNGLPIXELDATARANGENVPROC pglPixelDataRangeNV;
 extern   PFNGLFLUSHPIXELDATARANGENVPROC pglFlushPixelDataRangeNV;
alias pglPixelDataRangeNV glPixelDataRangeNV;
alias pglFlushPixelDataRangeNV glFlushPixelDataRangeNV;
//#endif ;

//GL_NV_primitive_restart

//#ifndef GL_NV_primitive_restart;
const uint GL_NV_primitive_restart = 1;
const uint __GLEE_GL_NV_primitive_restart = 1;
//constants
const uint GL_PRIMITIVE_RESTART_NV                            = 0x8558;
const uint GL_PRIMITIVE_RESTART_INDEX_NV                      = 0x8559;
typedef void   function() PFNGLPRIMITIVERESTARTNVPROC;
typedef void   function(GLuint index) PFNGLPRIMITIVERESTARTINDEXNVPROC;
 extern   PFNGLPRIMITIVERESTARTNVPROC pglPrimitiveRestartNV;
 extern   PFNGLPRIMITIVERESTARTINDEXNVPROC pglPrimitiveRestartIndexNV;
alias pglPrimitiveRestartNV glPrimitiveRestartNV;
alias pglPrimitiveRestartIndexNV glPrimitiveRestartIndexNV;
//#endif ;

//GL_NV_texture_expand_normal

//#ifndef GL_NV_texture_expand_normal;
const uint GL_NV_texture_expand_normal = 1;
const uint __GLEE_GL_NV_texture_expand_normal = 1;
//constants
const uint GL_TEXTURE_UNSIGNED_REMAP_MODE_NV                  = 0x888F;
//#endif ;

//GL_NV_vertex_program2

//#ifndef GL_NV_vertex_program2;
const uint GL_NV_vertex_program2 = 1;
const uint __GLEE_GL_NV_vertex_program2 = 1;
//constants
//#endif ;

//GL_ATI_map_object_buffer

//#ifndef GL_ATI_map_object_buffer;
const uint GL_ATI_map_object_buffer = 1;
const uint __GLEE_GL_ATI_map_object_buffer = 1;
//constants
typedef GLvoid*   function(GLuint buffer) PFNGLMAPOBJECTBUFFERATIPROC;
typedef void   function(GLuint buffer) PFNGLUNMAPOBJECTBUFFERATIPROC;
 extern   PFNGLMAPOBJECTBUFFERATIPROC pglMapObjectBufferATI;
 extern   PFNGLUNMAPOBJECTBUFFERATIPROC pglUnmapObjectBufferATI;
alias pglMapObjectBufferATI glMapObjectBufferATI;
alias pglUnmapObjectBufferATI glUnmapObjectBufferATI;
//#endif ;

//GL_ATI_separate_stencil

//#ifndef GL_ATI_separate_stencil;
const uint GL_ATI_separate_stencil = 1;
const uint __GLEE_GL_ATI_separate_stencil = 1;
//constants
const uint GL_STENCIL_BACK_FUNC_ATI                           = 0x8800;
const uint GL_STENCIL_BACK_FAIL_ATI                           = 0x8801;
const uint GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI                = 0x8802;
const uint GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI                = 0x8803;
typedef void   function(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) PFNGLSTENCILOPSEPARATEATIPROC;
typedef void   function(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask) PFNGLSTENCILFUNCSEPARATEATIPROC;
 extern   PFNGLSTENCILOPSEPARATEATIPROC pglStencilOpSeparateATI;
 extern   PFNGLSTENCILFUNCSEPARATEATIPROC pglStencilFuncSeparateATI;
alias pglStencilOpSeparateATI glStencilOpSeparateATI;
alias pglStencilFuncSeparateATI glStencilFuncSeparateATI;
//#endif ;

//GL_ATI_vertex_attrib_array_object

//#ifndef GL_ATI_vertex_attrib_array_object;
const uint GL_ATI_vertex_attrib_array_object = 1;
const uint __GLEE_GL_ATI_vertex_attrib_array_object = 1;
//constants
typedef void   function(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset) PFNGLVERTEXATTRIBARRAYOBJECTATIPROC;
typedef void   function(GLuint index, GLenum pname, GLfloat *params) PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC;
typedef void   function(GLuint index, GLenum pname, GLint *params) PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC;
 extern   PFNGLVERTEXATTRIBARRAYOBJECTATIPROC pglVertexAttribArrayObjectATI;
 extern   PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC pglGetVertexAttribArrayObjectfvATI;
 extern   PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC pglGetVertexAttribArrayObjectivATI;
alias pglVertexAttribArrayObjectATI glVertexAttribArrayObjectATI;
alias pglGetVertexAttribArrayObjectfvATI glGetVertexAttribArrayObjectfvATI;
alias pglGetVertexAttribArrayObjectivATI glGetVertexAttribArrayObjectivATI;
//#endif ;

//GL_EXT_depth_bounds_test

//#ifndef GL_EXT_depth_bounds_test;
const uint GL_EXT_depth_bounds_test = 1;
const uint __GLEE_GL_EXT_depth_bounds_test = 1;
//constants
const uint GL_DEPTH_BOUNDS_TEST_EXT                           = 0x8890;
const uint GL_DEPTH_BOUNDS_EXT                                = 0x8891;
typedef void   function(GLclampd zmin, GLclampd zmax) PFNGLDEPTHBOUNDSEXTPROC;
 extern   PFNGLDEPTHBOUNDSEXTPROC pglDepthBoundsEXT;
alias pglDepthBoundsEXT glDepthBoundsEXT;
//#endif ;

//GL_EXT_texture_mirror_clamp

//#ifndef GL_EXT_texture_mirror_clamp;
const uint GL_EXT_texture_mirror_clamp = 1;
const uint __GLEE_GL_EXT_texture_mirror_clamp = 1;
//constants
const uint GL_MIRROR_CLAMP_EXT                                = 0x8742;
const uint GL_MIRROR_CLAMP_TO_EDGE_EXT                        = 0x8743;
const uint GL_MIRROR_CLAMP_TO_BORDER_EXT                      = 0x8912;
//#endif ;

//GL_EXT_blend_equation_separate

//#ifndef GL_EXT_blend_equation_separate;
const uint GL_EXT_blend_equation_separate = 1;
const uint __GLEE_GL_EXT_blend_equation_separate = 1;
//constants
const uint GL_BLEND_EQUATION_RGB_EXT                          = GL_BLEND_EQUATION;
const uint GL_BLEND_EQUATION_ALPHA_EXT                        = 0x883D;
typedef void   function(GLenum modeRGB, GLenum modeAlpha) PFNGLBLENDEQUATIONSEPARATEEXTPROC;
 extern   PFNGLBLENDEQUATIONSEPARATEEXTPROC pglBlendEquationSeparateEXT;
alias pglBlendEquationSeparateEXT glBlendEquationSeparateEXT;
//#endif ;

//GL_MESA_pack_invert

//#ifndef GL_MESA_pack_invert;
const uint GL_MESA_pack_invert = 1;
const uint __GLEE_GL_MESA_pack_invert = 1;
//constants
const uint GL_PACK_INVERT_MESA                                = 0x8758;
//#endif ;

//GL_MESA_ycbcr_texture

//#ifndef GL_MESA_ycbcr_texture;
const uint GL_MESA_ycbcr_texture = 1;
const uint __GLEE_GL_MESA_ycbcr_texture = 1;
//constants
const uint GL_UNSIGNED_SHORT_8_8_MESA                         = 0x85BA;
const uint GL_UNSIGNED_SHORT_8_8_REV_MESA                     = 0x85BB;
const uint GL_YCBCR_MESA                                      = 0x8757;
//#endif ;

//GL_EXT_color_matrix

//#ifndef GL_EXT_color_matrix;
const uint GL_EXT_color_matrix = 1;
const uint __GLEE_GL_EXT_color_matrix = 1;
//constants
//#endif ;

//GL_SGIS_texture_border_clamp

//#ifndef GL_SGIS_texture_border_clamp;
const uint GL_SGIS_texture_border_clamp = 1;
const uint __GLEE_GL_SGIS_texture_border_clamp = 1;
//constants
//#endif ;

//GL_SGIX_texture_select

//#ifndef GL_SGIX_texture_select;
const uint GL_SGIX_texture_select = 1;
const uint __GLEE_GL_SGIX_texture_select = 1;
//constants
//#endif ;

//GL_INGR_blend_func_separate

//#ifndef GL_INGR_blend_func_separate;
const uint GL_INGR_blend_func_separate = 1;
const uint __GLEE_GL_INGR_blend_func_separate = 1;
//constants
typedef void   function(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) PFNGLBLENDFUNCSEPARATEINGRPROC;
 extern   PFNGLBLENDFUNCSEPARATEINGRPROC pglBlendFuncSeparateINGR;
alias pglBlendFuncSeparateINGR glBlendFuncSeparateINGR;
//#endif ;

//GL_SGIX_depth_pass_instrument

//#ifndef GL_SGIX_depth_pass_instrument;
const uint GL_SGIX_depth_pass_instrument = 1;
const uint __GLEE_GL_SGIX_depth_pass_instrument = 1;
//constants
//#endif ;

//GL_SGIX_igloo_interface

//#ifndef GL_SGIX_igloo_interface;
const uint GL_SGIX_igloo_interface = 1;
const uint __GLEE_GL_SGIX_igloo_interface = 1;
//constants
typedef void   function(GLenum pname, GLvoid *params) PFNGLIGLOOINTERFACESGIXPROC;
 extern   PFNGLIGLOOINTERFACESGIXPROC pglIglooInterfaceSGIX;
alias pglIglooInterfaceSGIX glIglooInterfaceSGIX;
//#endif ;

//WIN32 SPECIFIC

//#ifdef WIN32;
// Extension querying variables

 extern   GLboolean GLEE_WGL_ARB_buffer_region;
 extern   GLboolean GLEE_WGL_ARB_multisample;
 extern   GLboolean GLEE_WGL_ARB_extensions_string;
 extern   GLboolean GLEE_WGL_ARB_pixel_format;
 extern   GLboolean GLEE_WGL_ARB_make_current_read;
 extern   GLboolean GLEE_WGL_ARB_pbuffer;
 extern   GLboolean GLEE_WGL_ARB_render_texture;
 extern   GLboolean GLEE_WGL_EXT_make_current_read;
 extern   GLboolean GLEE_WGL_EXT_pixel_format;
 extern   GLboolean GLEE_WGL_EXT_pbuffer;
 extern   GLboolean GLEE_WGL_EXT_depth_float;
 extern   GLboolean GLEE_WGL_3DFX_multisample;
 extern   GLboolean GLEE_WGL_EXT_multisample;
 extern   GLboolean GLEE_WGL_I3D_digital_video_control;
 extern   GLboolean GLEE_WGL_I3D_gamma;
 extern   GLboolean GLEE_WGL_I3D_genlock;
 extern   GLboolean GLEE_WGL_I3D_image_buffer;
 extern   GLboolean GLEE_WGL_I3D_swap_frame_lock;
 extern   GLboolean GLEE_WGL_NV_render_depth_texture;
 extern   GLboolean GLEE_WGL_NV_render_texture_rectangle;
 extern   GLboolean GLEE_WGL_NV_float_buffer;
 extern   GLboolean GLEE_WGL_EXT_display_color_table;
 extern   GLboolean GLEE_WGL_EXT_extensions_string;
 extern   GLboolean GLEE_WGL_EXT_swap_control;
 extern   GLboolean GLEE_WGL_NV_vertex_array_range;
 extern   GLboolean GLEE_WGL_OML_sync_control;
 extern   GLboolean GLEE_WGL_I3D_swap_frame_usage;

//WGL_ARB_buffer_region

//#ifndef WGL_ARB_buffer_region;
const uint WGL_ARB_buffer_region = 1;
const uint __GLEE_WGL_ARB_buffer_region = 1;
//constants
const uint WGL_FRONT_COLOR_BUFFER_BIT_ARB                     = 0x00000001;
const uint WGL_BACK_COLOR_BUFFER_BIT_ARB                      = 0x00000002;
const uint WGL_DEPTH_BUFFER_BIT_ARB                           = 0x00000004;
const uint WGL_STENCIL_BUFFER_BIT_ARB                         = 0x00000008;
typedef HANDLE function(HDC hDC, int iLayerPlane, UINT uType) PFNWGLCREATEBUFFERREGIONARBPROC;
typedef  void  function(HANDLE hRegion) PFNWGLDELETEBUFFERREGIONARBPROC;
typedef BOOLEAN  function(HANDLE hRegion, int x, int y, int width, int height) PFNWGLSAVEBUFFERREGIONARBPROC;
typedef BOOLEAN function(HANDLE hRegion, int x, int y, int width, int height, int xSrc, int ySrc) PFNWGLRESTOREBUFFERREGIONARBPROC;
 extern   PFNWGLCREATEBUFFERREGIONARBPROC pwglCreateBufferRegionARB;
 extern   PFNWGLDELETEBUFFERREGIONARBPROC pwglDeleteBufferRegionARB;
 extern   PFNWGLSAVEBUFFERREGIONARBPROC pwglSaveBufferRegionARB;
 extern   PFNWGLRESTOREBUFFERREGIONARBPROC pwglRestoreBufferRegionARB;
alias  pwglCreateBufferRegionARB wglCreateBufferRegionARB;
alias  pwglDeleteBufferRegionARB wglDeleteBufferRegionARB;
alias  pwglSaveBufferRegionARB wglSaveBufferRegionARB;
alias  pwglRestoreBufferRegionARB wglRestoreBufferRegionARB;
//#endif ;

//WGL_ARB_multisample

//#ifndef WGL_ARB_multisample;
const uint WGL_ARB_multisample = 1;
const uint __GLEE_WGL_ARB_multisample = 1;
//constants
const uint WGL_SAMPLE_BUFFERS_ARB                             = 0x2041;
const uint WGL_SAMPLES_ARB                                    = 0x2042;
//#endif ;

//WGL_ARB_extensions_string

//#ifndef WGL_ARB_extensions_string;
const uint WGL_ARB_extensions_string = 1;
const uint __GLEE_WGL_ARB_extensions_string = 1;
//constants
typedef char * function(HDC hdc) PFNWGLGETEXTENSIONSSTRINGARBPROC;
 extern   PFNWGLGETEXTENSIONSSTRINGARBPROC pwglGetExtensionsStringARB;
alias pwglGetExtensionsStringARB wglGetExtensionsStringARB;
//#endif ;

//WGL_ARB_pixel_format

//#ifndef WGL_ARB_pixel_format;
const uint WGL_ARB_pixel_format = 1;
const uint __GLEE_WGL_ARB_pixel_format = 1;
//constants
const uint WGL_NUMBER_PIXEL_FORMATS_ARB                       = 0x2000;
const uint WGL_DRAW_TO_WINDOW_ARB                             = 0x2001;
const uint WGL_DRAW_TO_BITMAP_ARB                             = 0x2002;
const uint WGL_ACCELERATION_ARB                               = 0x2003;
const uint WGL_NEED_PALETTE_ARB                               = 0x2004;
const uint WGL_NEED_SYSTEM_PALETTE_ARB                        = 0x2005;
const uint WGL_SWAP_LAYER_BUFFERS_ARB                         = 0x2006;
const uint WGL_SWAP_METHOD_ARB                                = 0x2007;
const uint WGL_NUMBER_OVERLAYS_ARB                            = 0x2008;
const uint WGL_NUMBER_UNDERLAYS_ARB                           = 0x2009;
const uint WGL_TRANSPARENT_ARB                                = 0x200A;
const uint WGL_TRANSPARENT_RED_VALUE_ARB                      = 0x2037;
const uint WGL_TRANSPARENT_GREEN_VALUE_ARB                    = 0x2038;
const uint WGL_TRANSPARENT_BLUE_VALUE_ARB                     = 0x2039;
const uint WGL_TRANSPARENT_ALPHA_VALUE_ARB                    = 0x203A;
const uint WGL_TRANSPARENT_INDEX_VALUE_ARB                    = 0x203B;
const uint WGL_SHARE_DEPTH_ARB                                = 0x200C;
const uint WGL_SHARE_STENCIL_ARB                              = 0x200D;
const uint WGL_SHARE_ACCUM_ARB                                = 0x200E;
const uint WGL_SUPPORT_GDI_ARB                                = 0x200F;
const uint WGL_SUPPORT_OPENGL_ARB                             = 0x2010;
const uint WGL_DOUBLE_BUFFER_ARB                              = 0x2011;
const uint WGL_STEREO_ARB                                     = 0x2012;
const uint WGL_PIXEL_TYPE_ARB                                 = 0x2013;
const uint WGL_COLOR_BITS_ARB                                 = 0x2014;
const uint WGL_RED_BITS_ARB                                   = 0x2015;
const uint WGL_RED_SHIFT_ARB                                  = 0x2016;
const uint WGL_GREEN_BITS_ARB                                 = 0x2017;
const uint WGL_GREEN_SHIFT_ARB                                = 0x2018;
const uint WGL_BLUE_BITS_ARB                                  = 0x2019;
const uint WGL_BLUE_SHIFT_ARB                                 = 0x201A;
const uint WGL_ALPHA_BITS_ARB                                 = 0x201B;
const uint WGL_ALPHA_SHIFT_ARB                                = 0x201C;
const uint WGL_ACCUM_BITS_ARB                                 = 0x201D;
const uint WGL_ACCUM_RED_BITS_ARB                             = 0x201E;
const uint WGL_ACCUM_GREEN_BITS_ARB                           = 0x201F;
const uint WGL_ACCUM_BLUE_BITS_ARB                            = 0x2020;
const uint WGL_ACCUM_ALPHA_BITS_ARB                           = 0x2021;
const uint WGL_DEPTH_BITS_ARB                                 = 0x2022;
const uint WGL_STENCIL_BITS_ARB                               = 0x2023;
const uint WGL_AUX_BUFFERS_ARB                                = 0x2024;
const uint WGL_NO_ACCELERATION_ARB                            = 0x2025;
const uint WGL_GENERIC_ACCELERATION_ARB                       = 0x2026;
const uint WGL_FULL_ACCELERATION_ARB                          = 0x2027;
const uint WGL_SWAP_EXCHANGE_ARB                              = 0x2028;
const uint WGL_SWAP_COPY_ARB                                  = 0x2029;
const uint WGL_SWAP_UNDEFINED_ARB                             = 0x202A;
const uint WGL_TYPE_RGBA_ARB                                  = 0x202B;
const uint WGL_TYPE_COLORINDEX_ARB                            = 0x202C;
typedef BOOLEAN   function(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, int *piValues) PFNWGLGETPIXELFORMATATTRIBIVARBPROC;
typedef BOOLEAN   function(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, FLOAT *pfValues) PFNWGLGETPIXELFORMATATTRIBFVARBPROC;
typedef BOOLEAN   function(HDC hdc, int *piAttribIList, FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats) PFNWGLCHOOSEPIXELFORMATARBPROC;
 extern   PFNWGLGETPIXELFORMATATTRIBIVARBPROC pwglGetPixelFormatAttribivARB;
 extern   PFNWGLGETPIXELFORMATATTRIBFVARBPROC pwglGetPixelFormatAttribfvARB;
 extern   PFNWGLCHOOSEPIXELFORMATARBPROC pwglChoosePixelFormatARB;
alias pwglGetPixelFormatAttribivARB wglGetPixelFormatAttribivARB;
alias pwglGetPixelFormatAttribfvARB wglGetPixelFormatAttribfvARB;
alias pwglChoosePixelFormatARB wglChoosePixelFormatARB;
//#endif ;

//WGL_ARB_make_current_read

//#ifndef WGL_ARB_make_current_read;
const uint WGL_ARB_make_current_read = 1;
const uint __GLEE_WGL_ARB_make_current_read = 1;
//constants
const uint ERROR_INVALID_PIXEL_TYPE_ARB                       = 0x2043;
const uint ERROR_INCOMPATIBLE_DEVICE_CONTEXTS_ARB             = 0x2054;
typedef BOOLEAN   function(HDC hDrawDC, HDC hReadDC, HGLRC hglrc) PFNWGLMAKECONTEXTCURRENTARBPROC;
typedef HDC   function() PFNWGLGETCURRENTREADDCARBPROC;
 extern   PFNWGLMAKECONTEXTCURRENTARBPROC pwglMakeContextCurrentARB;
 extern   PFNWGLGETCURRENTREADDCARBPROC pwglGetCurrentReadDCARB;
alias  pwglMakeContextCurrentARB wglMakeContextCurrentARB;
alias  pwglGetCurrentReadDCARB wglGetCurrentReadDCARB;
//#endif ;

//WGL_ARB_pbuffer

//#ifndef WGL_ARB_pbuffer;
const uint WGL_ARB_pbuffer = 1;
const uint __GLEE_WGL_ARB_pbuffer = 1;
//constants
const uint WGL_DRAW_TO_PBUFFER_ARB                            = 0x202D;
const uint WGL_MAX_PBUFFER_PIXELS_ARB                         = 0x202E;
const uint WGL_MAX_PBUFFER_WIDTH_ARB                          = 0x202F;
const uint WGL_MAX_PBUFFER_HEIGHT_ARB                         = 0x2030;
const uint WGL_PBUFFER_LARGEST_ARB                            = 0x2033;
const uint WGL_PBUFFER_WIDTH_ARB                              = 0x2034;
const uint WGL_PBUFFER_HEIGHT_ARB                             = 0x2035;
const uint WGL_PBUFFER_LOST_ARB                               = 0x2036;
typedef HPBUFFERARB  function(HDC hDC, int iPixelFormat, int iWidth, int iHeight, int *piAttribList) PFNWGLCREATEPBUFFERARBPROC;
typedef HDC   function(HPBUFFERARB hPbuffer) PFNWGLGETPBUFFERDCARBPROC;
typedef int  function(HPBUFFERARB hPbuffer, HDC hDC) PFNWGLRELEASEPBUFFERDCARBPROC;
typedef BOOLEAN   function(HPBUFFERARB hPbuffer) PFNWGLDESTROYPBUFFERARBPROC;
typedef BOOLEAN   function(HPBUFFERARB hPbuffer, int iAttribute, int *piValue) PFNWGLQUERYPBUFFERARBPROC;
 extern   PFNWGLCREATEPBUFFERARBPROC pwglCreatePbufferARB;
 extern   PFNWGLGETPBUFFERDCARBPROC pwglGetPbufferDCARB;
 extern   PFNWGLRELEASEPBUFFERDCARBPROC pwglReleasePbufferDCARB;
 extern   PFNWGLDESTROYPBUFFERARBPROC pwglDestroyPbufferARB;
 extern   PFNWGLQUERYPBUFFERARBPROC pwglQueryPbufferARB;
alias pwglCreatePbufferARB wglCreatePbufferARB;
alias pwglGetPbufferDCARB wglGetPbufferDCARB;
alias pwglReleasePbufferDCARB wglReleasePbufferDCARB;
alias pwglDestroyPbufferARB wglDestroyPbufferARB;
alias pwglQueryPbufferARB wglQueryPbufferARB;
//#endif ;

//WGL_ARB_render_texture

//#ifndef WGL_ARB_render_texture;
const uint WGL_ARB_render_texture = 1;
const uint __GLEE_WGL_ARB_render_texture = 1;
//constants
const uint WGL_BIND_TO_TEXTURE_RGB_ARB                        = 0x2070;
const uint WGL_BIND_TO_TEXTURE_RGBA_ARB                       = 0x2071;
const uint WGL_TEXTURE_FORMAT_ARB                             = 0x2072;
const uint WGL_TEXTURE_TARGET_ARB                             = 0x2073;
const uint WGL_MIPMAP_TEXTURE_ARB                             = 0x2074;
const uint WGL_TEXTURE_RGB_ARB                                = 0x2075;
const uint WGL_TEXTURE_RGBA_ARB                               = 0x2076;
const uint WGL_NO_TEXTURE_ARB                                 = 0x2077;
const uint WGL_TEXTURE_CUBE_MAP_ARB                           = 0x2078;
const uint WGL_TEXTURE_1D_ARB                                 = 0x2079;
const uint WGL_TEXTURE_2D_ARB                                 = 0x207A;
const uint WGL_MIPMAP_LEVEL_ARB                               = 0x207B;
const uint WGL_CUBE_MAP_FACE_ARB                              = 0x207C;
const uint WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB                = 0x207D;
const uint WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB                = 0x207E;
const uint WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB                = 0x207F;
const uint WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB                = 0x2080;
const uint WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB                = 0x2081;
const uint WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB                = 0x2082;
const uint WGL_FRONT_LEFT_ARB                                 = 0x2083;
const uint WGL_FRONT_RIGHT_ARB                                = 0x2084;
const uint WGL_BACK_LEFT_ARB                                  = 0x2085;
const uint WGL_BACK_RIGHT_ARB                                 = 0x2086;
const uint WGL_AUX0_ARB                                       = 0x2087;
const uint WGL_AUX1_ARB                                       = 0x2088;
const uint WGL_AUX2_ARB                                       = 0x2089;
const uint WGL_AUX3_ARB                                       = 0x208A;
const uint WGL_AUX4_ARB                                       = 0x208B;
const uint WGL_AUX5_ARB                                       = 0x208C;
const uint WGL_AUX6_ARB                                       = 0x208D;
const uint WGL_AUX7_ARB                                       = 0x208E;
const uint WGL_AUX8_ARB                                       = 0x208F;
const uint WGL_AUX9_ARB                                       = 0x2090;
typedef BOOLEAN   function(HPBUFFERARB hPbuffer, int iBuffer) PFNWGLBINDTEXIMAGEARBPROC;
typedef BOOLEAN   function(HPBUFFERARB hPbuffer, int iBuffer) PFNWGLRELEASETEXIMAGEARBPROC;
typedef BOOLEAN   function(HPBUFFERARB hPbuffer, int *piAttribList) PFNWGLSETPBUFFERATTRIBARBPROC;
 extern   PFNWGLBINDTEXIMAGEARBPROC pwglBindTexImageARB;
 extern   PFNWGLRELEASETEXIMAGEARBPROC pwglReleaseTexImageARB;
 extern   PFNWGLSETPBUFFERATTRIBARBPROC pwglSetPbufferAttribARB;
alias pwglBindTexImageARB wglBindTexImageARB;
alias pwglReleaseTexImageARB wglReleaseTexImageARB;
alias pwglSetPbufferAttribARB wglSetPbufferAttribARB;
//#endif ;

//WGL_EXT_make_current_read

//#ifndef WGL_EXT_make_current_read;
const uint WGL_EXT_make_current_read = 1;
const uint __GLEE_WGL_EXT_make_current_read = 1;
//constants
const uint ERROR_INVALID_PIXEL_TYPE_EXT                       = 0x2043;
typedef BOOLEAN   function(HDC hDrawDC, HDC hReadDC, HGLRC hglrc) PFNWGLMAKECONTEXTCURRENTEXTPROC;
typedef HDC   function() PFNWGLGETCURRENTREADDCEXTPROC;
 extern   PFNWGLMAKECONTEXTCURRENTEXTPROC pwglMakeContextCurrentEXT;
 extern   PFNWGLGETCURRENTREADDCEXTPROC pwglGetCurrentReadDCEXT;
alias  pwglMakeContextCurrentEXT wglMakeContextCurrentEXT;
alias  pwglGetCurrentReadDCEXT wglGetCurrentReadDCEXT;
//#endif ;

//WGL_EXT_pixel_format

//#ifndef WGL_EXT_pixel_format;
const uint WGL_EXT_pixel_format = 1;
const uint __GLEE_WGL_EXT_pixel_format = 1;
//constants
const uint WGL_NUMBER_PIXEL_FORMATS_EXT                       = 0x2000;
const uint WGL_DRAW_TO_WINDOW_EXT                             = 0x2001;
const uint WGL_DRAW_TO_BITMAP_EXT                             = 0x2002;
const uint WGL_ACCELERATION_EXT                               = 0x2003;
const uint WGL_NEED_PALETTE_EXT                               = 0x2004;
const uint WGL_NEED_SYSTEM_PALETTE_EXT                        = 0x2005;
const uint WGL_SWAP_LAYER_BUFFERS_EXT                         = 0x2006;
const uint WGL_SWAP_METHOD_EXT                                = 0x2007;
const uint WGL_NUMBER_OVERLAYS_EXT                            = 0x2008;
const uint WGL_NUMBER_UNDERLAYS_EXT                           = 0x2009;
const uint WGL_TRANSPARENT_EXT                                = 0x200A;
const uint WGL_TRANSPARENT_VALUE_EXT                          = 0x200B;
const uint WGL_SHARE_DEPTH_EXT                                = 0x200C;
const uint WGL_SHARE_STENCIL_EXT                              = 0x200D;
const uint WGL_SHARE_ACCUM_EXT                                = 0x200E;
const uint WGL_SUPPORT_GDI_EXT                                = 0x200F;
const uint WGL_SUPPORT_OPENGL_EXT                             = 0x2010;
const uint WGL_DOUBLE_BUFFER_EXT                              = 0x2011;
const uint WGL_STEREO_EXT                                     = 0x2012;
const uint WGL_PIXEL_TYPE_EXT                                 = 0x2013;
const uint WGL_COLOR_BITS_EXT                                 = 0x2014;
const uint WGL_RED_BITS_EXT                                   = 0x2015;
const uint WGL_RED_SHIFT_EXT                                  = 0x2016;
const uint WGL_GREEN_BITS_EXT                                 = 0x2017;
const uint WGL_GREEN_SHIFT_EXT                                = 0x2018;
const uint WGL_BLUE_BITS_EXT                                  = 0x2019;
const uint WGL_BLUE_SHIFT_EXT                                 = 0x201A;
const uint WGL_ALPHA_BITS_EXT                                 = 0x201B;
const uint WGL_ALPHA_SHIFT_EXT                                = 0x201C;
const uint WGL_ACCUM_BITS_EXT                                 = 0x201D;
const uint WGL_ACCUM_RED_BITS_EXT                             = 0x201E;
const uint WGL_ACCUM_GREEN_BITS_EXT                           = 0x201F;
const uint WGL_ACCUM_BLUE_BITS_EXT                            = 0x2020;
const uint WGL_ACCUM_ALPHA_BITS_EXT                           = 0x2021;
const uint WGL_DEPTH_BITS_EXT                                 = 0x2022;
const uint WGL_STENCIL_BITS_EXT                               = 0x2023;
const uint WGL_AUX_BUFFERS_EXT                                = 0x2024;
const uint WGL_NO_ACCELERATION_EXT                            = 0x2025;
const uint WGL_GENERIC_ACCELERATION_EXT                       = 0x2026;
const uint WGL_FULL_ACCELERATION_EXT                          = 0x2027;
const uint WGL_SWAP_EXCHANGE_EXT                              = 0x2028;
const uint WGL_SWAP_COPY_EXT                                  = 0x2029;
const uint WGL_SWAP_UNDEFINED_EXT                             = 0x202A;
const uint WGL_TYPE_RGBA_EXT                                  = 0x202B;
const uint WGL_TYPE_COLORINDEX_EXT                            = 0x202C;
typedef BOOLEAN   function(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, int *piValues) PFNWGLGETPIXELFORMATATTRIBIVEXTPROC;
typedef BOOLEAN   function(HDC hdc, int iPixelFormat, int iLayerPlane, UINT nAttributes, int *piAttributes, FLOAT *pfValues) PFNWGLGETPIXELFORMATATTRIBFVEXTPROC;
typedef BOOLEAN   function(HDC hdc, int *piAttribIList, FLOAT *pfAttribFList, UINT nMaxFormats, int *piFormats, UINT *nNumFormats) PFNWGLCHOOSEPIXELFORMATEXTPROC;
 extern   PFNWGLGETPIXELFORMATATTRIBIVEXTPROC pwglGetPixelFormatAttribivEXT;
 extern   PFNWGLGETPIXELFORMATATTRIBFVEXTPROC pwglGetPixelFormatAttribfvEXT;
 extern   PFNWGLCHOOSEPIXELFORMATEXTPROC pwglChoosePixelFormatEXT;
alias pwglGetPixelFormatAttribivEXT wglGetPixelFormatAttribivEXT;
alias pwglGetPixelFormatAttribfvEXT wglGetPixelFormatAttribfvEXT;
alias pwglChoosePixelFormatEXT wglChoosePixelFormatEXT;
//#endif ;

//WGL_EXT_pbuffer

//#ifndef WGL_EXT_pbuffer;
const uint WGL_EXT_pbuffer = 1;
const uint __GLEE_WGL_EXT_pbuffer = 1;
//constants
const uint WGL_DRAW_TO_PBUFFER_EXT                            = 0x202D;
const uint WGL_MAX_PBUFFER_PIXELS_EXT                         = 0x202E;
const uint WGL_MAX_PBUFFER_WIDTH_EXT                          = 0x202F;
const uint WGL_MAX_PBUFFER_HEIGHT_EXT                         = 0x2030;
const uint WGL_OPTIMAL_PBUFFER_WIDTH_EXT                      = 0x2031;
const uint WGL_OPTIMAL_PBUFFER_HEIGHT_EXT                     = 0x2032;
const uint WGL_PBUFFER_LARGEST_EXT                            = 0x2033;
const uint WGL_PBUFFER_WIDTH_EXT                              = 0x2034;
const uint WGL_PBUFFER_HEIGHT_EXT                             = 0x2035;
typedef HPBUFFEREXT function(HDC hDC, int iPixelFormat, int iWidth, int iHeight, int *piAttribList) PFNWGLCREATEPBUFFEREXTPROC;
typedef HDC   function(HPBUFFEREXT hPbuffer) PFNWGLGETPBUFFERDCEXTPROC;
typedef int   function(HPBUFFEREXT hPbuffer, HDC hDC) PFNWGLRELEASEPBUFFERDCEXTPROC;
typedef BOOLEAN   function(HPBUFFEREXT hPbuffer) PFNWGLDESTROYPBUFFEREXTPROC;
typedef BOOLEAN   function(HPBUFFEREXT hPbuffer, int iAttribute, int *piValue) PFNWGLQUERYPBUFFEREXTPROC;
 extern   PFNWGLCREATEPBUFFEREXTPROC pwglCreatePbufferEXT;
 extern   PFNWGLGETPBUFFERDCEXTPROC pwglGetPbufferDCEXT;
 extern   PFNWGLRELEASEPBUFFERDCEXTPROC pwglReleasePbufferDCEXT;
 extern   PFNWGLDESTROYPBUFFEREXTPROC pwglDestroyPbufferEXT;
 extern   PFNWGLQUERYPBUFFEREXTPROC pwglQueryPbufferEXT;
alias pwglCreatePbufferEXT wglCreatePbufferEXT;
alias pwglGetPbufferDCEXT wglGetPbufferDCEXT;
alias pwglReleasePbufferDCEXT wglReleasePbufferDCEXT;
alias pwglDestroyPbufferEXT wglDestroyPbufferEXT;
alias pwglQueryPbufferEXT wglQueryPbufferEXT;
//#endif ;

//WGL_EXT_depth_float

//#ifndef WGL_EXT_depth_float;
const uint WGL_EXT_depth_float = 1;
const uint __GLEE_WGL_EXT_depth_float = 1;
//constants
const uint WGL_DEPTH_FLOAT_EXT                                = 0x2040;
//#endif ;

//WGL_3DFX_multisample

//#ifndef WGL_3DFX_multisample;
const uint WGL_3DFX_multisample = 1;
const uint __GLEE_WGL_3DFX_multisample = 1;
//constants
const uint WGL_SAMPLE_BUFFERS_3DFX                            = 0x2060;
const uint WGL_SAMPLES_3DFX                                   = 0x2061;
//#endif ;

//WGL_EXT_multisample

//#ifndef WGL_EXT_multisample;
const uint WGL_EXT_multisample = 1;
const uint __GLEE_WGL_EXT_multisample = 1;
//constants
const uint WGL_SAMPLE_BUFFERS_EXT                             = 0x2041;
const uint WGL_SAMPLES_EXT                                    = 0x2042;
//#endif ;

//WGL_I3D_digital_video_control

//#ifndef WGL_I3D_digital_video_control;
const uint WGL_I3D_digital_video_control = 1;
const uint __GLEE_WGL_I3D_digital_video_control = 1;
//constants
const uint WGL_DIGITAL_VIDEO_CURSOR_ALPHA_FRAMEBUFFER_I3D     = 0x2050;
const uint WGL_DIGITAL_VIDEO_CURSOR_ALPHA_VALUE_I3D           = 0x2051;
const uint WGL_DIGITAL_VIDEO_CURSOR_INCLUDED_I3D              = 0x2052;
const uint WGL_DIGITAL_VIDEO_GAMMA_CORRECTED_I3D              = 0x2053;
typedef BOOLEAN   function(HDC hDC, int iAttribute, int *piValue) PFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC;
typedef BOOLEAN   function(HDC hDC, int iAttribute, int *piValue) PFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC;
 extern   PFNWGLGETDIGITALVIDEOPARAMETERSI3DPROC pwglGetDigitalVideoParametersI3D;
 extern   PFNWGLSETDIGITALVIDEOPARAMETERSI3DPROC pwglSetDigitalVideoParametersI3D;
alias  pwglGetDigitalVideoParametersI3D wglGetDigitalVideoParametersI3D;
alias  pwglSetDigitalVideoParametersI3D wglSetDigitalVideoParametersI3D;
//#endif ;

//WGL_I3D_gamma

//#ifndef WGL_I3D_gamma;
const uint WGL_I3D_gamma = 1;
const uint __GLEE_WGL_I3D_gamma = 1;
//constants
const uint WGL_GAMMA_TABLE_SIZE_I3D                           = 0x204E;
const uint WGL_GAMMA_EXCLUDE_DESKTOP_I3D                      = 0x204F;
typedef BOOLEAN   function(HDC hDC, int iAttribute, int *piValue) PFNWGLGETGAMMATABLEPARAMETERSI3DPROC;
typedef BOOLEAN   function(HDC hDC, int iAttribute, int *piValue) PFNWGLSETGAMMATABLEPARAMETERSI3DPROC;
typedef BOOLEAN   function(HDC hDC, int iEntries, USHORT *puRed, USHORT *puGreen, USHORT *puBlue) PFNWGLGETGAMMATABLEI3DPROC;
typedef BOOLEAN   function(HDC hDC, int iEntries, USHORT *puRed, USHORT *puGreen, USHORT *puBlue) PFNWGLSETGAMMATABLEI3DPROC;
 extern   PFNWGLGETGAMMATABLEPARAMETERSI3DPROC pwglGetGammaTableParametersI3D;
 extern   PFNWGLSETGAMMATABLEPARAMETERSI3DPROC pwglSetGammaTableParametersI3D;
 extern   PFNWGLGETGAMMATABLEI3DPROC pwglGetGammaTableI3D;
 extern   PFNWGLSETGAMMATABLEI3DPROC pwglSetGammaTableI3D;
alias pwglGetGammaTableParametersI3D wglGetGammaTableParametersI3D;
alias pwglSetGammaTableParametersI3D wglSetGammaTableParametersI3D;
alias pwglGetGammaTableI3D wglGetGammaTableI3D;
alias pwglSetGammaTableI3D wglSetGammaTableI3D;
//#endif ;

//WGL_I3D_genlock

//#ifndef WGL_I3D_genlock;
const uint WGL_I3D_genlock = 1;
const uint __GLEE_WGL_I3D_genlock = 1;
//constants
const uint WGL_GENLOCK_SOURCE_MULTIVIEW_I3D                   = 0x2044;
const uint WGL_GENLOCK_SOURCE_EXTENAL_SYNC_I3D                = 0x2045;
const uint WGL_GENLOCK_SOURCE_EXTENAL_FIELD_I3D               = 0x2046;
const uint WGL_GENLOCK_SOURCE_EXTENAL_TTL_I3D                 = 0x2047;
const uint WGL_GENLOCK_SOURCE_DIGITAL_SYNC_I3D                = 0x2048;
const uint WGL_GENLOCK_SOURCE_DIGITAL_FIELD_I3D               = 0x2049;
const uint WGL_GENLOCK_SOURCE_EDGE_FALLING_I3D                = 0x204A;
const uint WGL_GENLOCK_SOURCE_EDGE_RISING_I3D                 = 0x204B;
const uint WGL_GENLOCK_SOURCE_EDGE_BOTH_I3D                   = 0x204C;
typedef BOOLEAN   function(HDC hDC) PFNWGLENABLEGENLOCKI3DPROC;
typedef BOOLEAN   function(HDC hDC) PFNWGLDISABLEGENLOCKI3DPROC;
typedef BOOLEAN   function(HDC hDC, BOOLEAN *pFlag) PFNWGLISENABLEDGENLOCKI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT uSource) PFNWGLGENLOCKSOURCEI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT *uSource) PFNWGLGETGENLOCKSOURCEI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT uEdge) PFNWGLGENLOCKSOURCEEDGEI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT *uEdge) PFNWGLGETGENLOCKSOURCEEDGEI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT uRate) PFNWGLGENLOCKSAMPLERATEI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT *uRate) PFNWGLGETGENLOCKSAMPLERATEI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT uDelay) PFNWGLGENLOCKSOURCEDELAYI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT *uDelay) PFNWGLGETGENLOCKSOURCEDELAYI3DPROC;
typedef BOOLEAN   function(HDC hDC, UINT *uMaxLineDelay, UINT *uMaxPixelDelay) PFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC;
 extern   PFNWGLENABLEGENLOCKI3DPROC pwglEnableGenlockI3D;
 extern   PFNWGLDISABLEGENLOCKI3DPROC pwglDisableGenlockI3D;
 extern   PFNWGLISENABLEDGENLOCKI3DPROC pwglIsEnabledGenlockI3D;
 extern   PFNWGLGENLOCKSOURCEI3DPROC pwglGenlockSourceI3D;
 extern   PFNWGLGETGENLOCKSOURCEI3DPROC pwglGetGenlockSourceI3D;
 extern   PFNWGLGENLOCKSOURCEEDGEI3DPROC pwglGenlockSourceEdgeI3D;
 extern   PFNWGLGETGENLOCKSOURCEEDGEI3DPROC pwglGetGenlockSourceEdgeI3D;
 extern   PFNWGLGENLOCKSAMPLERATEI3DPROC pwglGenlockSampleRateI3D;
 extern   PFNWGLGETGENLOCKSAMPLERATEI3DPROC pwglGetGenlockSampleRateI3D;
 extern   PFNWGLGENLOCKSOURCEDELAYI3DPROC pwglGenlockSourceDelayI3D;
 extern   PFNWGLGETGENLOCKSOURCEDELAYI3DPROC pwglGetGenlockSourceDelayI3D;
 extern   PFNWGLQUERYGENLOCKMAXSOURCEDELAYI3DPROC pwglQueryGenlockMaxSourceDelayI3D;
alias pwglEnableGenlockI3D wglEnableGenlockI3D;
alias pwglDisableGenlockI3D wglDisableGenlockI3D;
alias pwglIsEnabledGenlockI3D wglIsEnabledGenlockI3D;
alias pwglGenlockSourceI3D wglGenlockSourceI3D;
alias pwglGetGenlockSourceI3D wglGetGenlockSourceI3D;
alias pwglGenlockSourceEdgeI3D wglGenlockSourceEdgeI3D;
alias pwglGetGenlockSourceEdgeI3D wglGetGenlockSourceEdgeI3D;
alias pwglGenlockSampleRateI3D wglGenlockSampleRateI3D;
alias pwglGetGenlockSampleRateI3D wglGetGenlockSampleRateI3D;
alias pwglGenlockSourceDelayI3D wglGenlockSourceDelayI3D;
alias pwglGetGenlockSourceDelayI3D wglGetGenlockSourceDelayI3D;
alias pwglQueryGenlockMaxSourceDelayI3D wglQueryGenlockMaxSourceDelayI3D;
//#endif ;

//WGL_I3D_image_buffer

//#ifndef WGL_I3D_image_buffer;
const uint WGL_I3D_image_buffer = 1;
const uint __GLEE_WGL_I3D_image_buffer = 1;
//constants
const uint WGL_IMAGE_BUFFER_MIN_ACCESS_I3D                    = 0x00000001;
const uint WGL_IMAGE_BUFFER_LOCK_I3D                          = 0x00000002;
typedef LPVOID function(HDC hDC, DWORD dwSize, UINT uFlags) PFNWGLCREATEIMAGEBUFFERI3DPROC;
typedef BOOLEAN   function(HDC hDC, LPVOID pAddress) PFNWGLDESTROYIMAGEBUFFERI3DPROC;
typedef BOOLEAN   function(HDC hDC, HANDLE *pEvent, LPVOID *pAddress, DWORD *pSize, UINT count) PFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC;
typedef BOOLEAN   function(HDC hDC, LPVOID *pAddress, UINT count) PFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC;
 extern   PFNWGLCREATEIMAGEBUFFERI3DPROC pwglCreateImageBufferI3D;
 extern   PFNWGLDESTROYIMAGEBUFFERI3DPROC pwglDestroyImageBufferI3D;
 extern   PFNWGLASSOCIATEIMAGEBUFFEREVENTSI3DPROC pwglAssociateImageBufferEventsI3D;
 extern   PFNWGLRELEASEIMAGEBUFFEREVENTSI3DPROC pwglReleaseImageBufferEventsI3D;
alias pwglCreateImageBufferI3D wglCreateImageBufferI3D;
alias pwglDestroyImageBufferI3D wglDestroyImageBufferI3D;
alias pwglAssociateImageBufferEventsI3D wglAssociateImageBufferEventsI3D;
alias pwglReleaseImageBufferEventsI3D wglReleaseImageBufferEventsI3D;
//#endif ;

//WGL_I3D_swap_frame_lock

//#ifndef WGL_I3D_swap_frame_lock;
const uint WGL_I3D_swap_frame_lock = 1;
const uint __GLEE_WGL_I3D_swap_frame_lock = 1;
//constants
typedef BOOLEAN   function() PFNWGLENABLEFRAMELOCKI3DPROC;
typedef BOOLEAN   function() PFNWGLDISABLEFRAMELOCKI3DPROC;
typedef BOOLEAN   function(BOOLEAN *pFlag) PFNWGLISENABLEDFRAMELOCKI3DPROC;
typedef BOOLEAN   function(BOOLEAN *pFlag) PFNWGLQUERYFRAMELOCKMASTERI3DPROC;
 extern   PFNWGLENABLEFRAMELOCKI3DPROC pwglEnableFrameLockI3D;
 extern   PFNWGLDISABLEFRAMELOCKI3DPROC pwglDisableFrameLockI3D;
 extern   PFNWGLISENABLEDFRAMELOCKI3DPROC pwglIsEnabledFrameLockI3D;
 extern   PFNWGLQUERYFRAMELOCKMASTERI3DPROC pwglQueryFrameLockMasterI3D;
alias pwglEnableFrameLockI3D wglEnableFrameLockI3D;
alias pwglDisableFrameLockI3D wglDisableFrameLockI3D;
alias pwglIsEnabledFrameLockI3D wglIsEnabledFrameLockI3D;
alias pwglQueryFrameLockMasterI3D wglQueryFrameLockMasterI3D;
//#endif ;

//WGL_NV_render_depth_texture

//#ifndef WGL_NV_render_depth_texture;
const uint WGL_NV_render_depth_texture = 1;
const uint __GLEE_WGL_NV_render_depth_texture = 1;
//constants
const uint WGL_BIND_TO_TEXTURE_DEPTH_NV                       = 0x20A3;
const uint WGL_BIND_TO_TEXTURE_RECTANGLE_DEPTH_NV             = 0x20A4;
const uint WGL_DEPTH_TEXTURE_FORMAT_NV                        = 0x20A5;
const uint WGL_TEXTURE_DEPTH_COMPONENT_NV                     = 0x20A6;
const uint WGL_DEPTH_COMPONENT_NV                             = 0x20A7;
//#endif ;

//WGL_NV_render_texture_rectangle

//#ifndef WGL_NV_render_texture_rectangle;
const uint WGL_NV_render_texture_rectangle = 1;
const uint __GLEE_WGL_NV_render_texture_rectangle = 1;
//constants
const uint WGL_BIND_TO_TEXTURE_RECTANGLE_RGB_NV               = 0x20A0;
const uint WGL_BIND_TO_TEXTURE_RECTANGLE_RGBA_NV              = 0x20A1;
const uint WGL_TEXTURE_RECTANGLE_NV                           = 0x20A2;
//#endif ;

//WGL_NV_float_buffer

//#ifndef WGL_NV_float_buffer;
const uint WGL_NV_float_buffer = 1;
const uint __GLEE_WGL_NV_float_buffer = 1;
//constants
const uint WGL_FLOAT_COMPONENTS_NV                            = 0x20B0;
const uint WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV           = 0x20B1;
const uint WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV          = 0x20B2;
const uint WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV         = 0x20B3;
const uint WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV        = 0x20B4;
const uint WGL_TEXTURE_FLOAT_R_NV                             = 0x20B5;
const uint WGL_TEXTURE_FLOAT_RG_NV                            = 0x20B6;
const uint WGL_TEXTURE_FLOAT_RGB_NV                           = 0x20B7;
const uint WGL_TEXTURE_FLOAT_RGBA_NV                          = 0x20B8;
//#endif ;

//WGL_EXT_display_color_table

//#ifndef WGL_EXT_display_color_table;
const uint WGL_EXT_display_color_table = 1;
const uint __GLEE_WGL_EXT_display_color_table = 1;
//constants
typedef GLboolean   function(GLushort id) PFNWGLCREATEDISPLAYCOLORTABLEEXTPROC;
typedef GLboolean   function(GLushort *table, GLuint length) PFNWGLLOADDISPLAYCOLORTABLEEXTPROC;
typedef GLboolean   function(GLushort id) PFNWGLBINDDISPLAYCOLORTABLEEXTPROC;
typedef  void function(GLushort id) PFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC;
 extern   PFNWGLCREATEDISPLAYCOLORTABLEEXTPROC pwglCreateDisplayColorTableEXT;
 extern   PFNWGLLOADDISPLAYCOLORTABLEEXTPROC pwglLoadDisplayColorTableEXT;
 extern   PFNWGLBINDDISPLAYCOLORTABLEEXTPROC pwglBindDisplayColorTableEXT;
 extern   PFNWGLDESTROYDISPLAYCOLORTABLEEXTPROC pwglDestroyDisplayColorTableEXT;
alias pwglCreateDisplayColorTableEXT wglCreateDisplayColorTableEXT;
alias pwglLoadDisplayColorTableEXT wglLoadDisplayColorTableEXT;
alias pwglBindDisplayColorTableEXT wglBindDisplayColorTableEXT;
alias pwglDestroyDisplayColorTableEXT wglDestroyDisplayColorTableEXT;
//#endif ;

//WGL_EXT_extensions_string

//#ifndef WGL_EXT_extensions_string;
const uint WGL_EXT_extensions_string = 1;
const uint __GLEE_WGL_EXT_extensions_string = 1;
//constants
typedef char * function() PFNWGLGETEXTENSIONSSTRINGEXTPROC;
 extern   PFNWGLGETEXTENSIONSSTRINGEXTPROC pwglGetExtensionsStringEXT;
alias pwglGetExtensionsStringEXT wglGetExtensionsStringEXT;
//#endif ;

//WGL_EXT_swap_control

//#ifndef WGL_EXT_swap_control;
const uint WGL_EXT_swap_control = 1;
const uint __GLEE_WGL_EXT_swap_control = 1;
//constants
typedef BOOLEAN   function(int interval) PFNWGLSWAPINTERVALEXTPROC;
typedef int   function() PFNWGLGETSWAPINTERVALEXTPROC;
 extern   PFNWGLSWAPINTERVALEXTPROC pwglSwapIntervalEXT;
 extern   PFNWGLGETSWAPINTERVALEXTPROC pwglGetSwapIntervalEXT;
alias pwglSwapIntervalEXT wglSwapIntervalEXT;
alias pwglGetSwapIntervalEXT wglGetSwapIntervalEXT;
//#endif ;

//WGL_NV_vertex_array_range

//#ifndef WGL_NV_vertex_array_range;
const uint WGL_NV_vertex_array_range = 1;
const uint __GLEE_WGL_NV_vertex_array_range = 1;
//constants
typedef void*  function(GLsizei size, GLfloat readfreq, GLfloat writefreq, GLfloat priority) PFNWGLALLOCATEMEMORYNVPROC;
typedef void   function(void *pointer) PFNWGLFREEMEMORYNVPROC;
 extern   PFNWGLALLOCATEMEMORYNVPROC pwglAllocateMemoryNV;
 extern   PFNWGLFREEMEMORYNVPROC pwglFreeMemoryNV;
alias pwglAllocateMemoryNV wglAllocateMemoryNV;
alias pwglFreeMemoryNV wglFreeMemoryNV;
//#endif ;

//WGL_OML_sync_control

//#ifndef WGL_OML_sync_control;
const uint WGL_OML_sync_control = 1;
const uint __GLEE_WGL_OML_sync_control = 1;
//constants
typedef BOOLEAN   function(HDC hdc, INT64 *ust, INT64 *msc, INT64 *sbc) PFNWGLGETSYNCVALUESOMLPROC;
typedef BOOLEAN   function(HDC hdc, INT32 *numerator, INT32 *denominator) PFNWGLGETMSCRATEOMLPROC;
typedef INT64  function(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder) PFNWGLSWAPBUFFERSMSCOMLPROC;
typedef INT64  function(HDC hdc, int fuPlanes, INT64 target_msc, INT64 divisor, INT64 remainder) PFNWGLSWAPLAYERBUFFERSMSCOMLPROC;
typedef BOOLEAN   function(HDC hdc, INT64 target_msc, INT64 divisor, INT64 remainder, INT64 *ust, INT64 *msc, INT64 *sbc) PFNWGLWAITFORMSCOMLPROC;
typedef BOOLEAN   function(HDC hdc, INT64 target_sbc, INT64 *ust, INT64 *msc, INT64 *sbc) PFNWGLWAITFORSBCOMLPROC;
 extern   PFNWGLGETSYNCVALUESOMLPROC pwglGetSyncValuesOML;
 extern   PFNWGLGETMSCRATEOMLPROC pwglGetMscRateOML;
 extern   PFNWGLSWAPBUFFERSMSCOMLPROC pwglSwapBuffersMscOML;
 extern   PFNWGLSWAPLAYERBUFFERSMSCOMLPROC pwglSwapLayerBuffersMscOML;
 extern   PFNWGLWAITFORMSCOMLPROC pwglWaitForMscOML;
 extern   PFNWGLWAITFORSBCOMLPROC pwglWaitForSbcOML;
alias pwglGetSyncValuesOML wglGetSyncValuesOML;
alias pwglGetMscRateOML wglGetMscRateOML;
alias pwglSwapBuffersMscOML wglSwapBuffersMscOML;
alias pwglSwapLayerBuffersMscOML wglSwapLayerBuffersMscOML;
alias pwglWaitForMscOML wglWaitForMscOML;
alias pwglWaitForSbcOML wglWaitForSbcOML;
//#endif ;

//WGL_I3D_swap_frame_usage

//#ifndef WGL_I3D_swap_frame_usage;
const uint WGL_I3D_swap_frame_usage = 1;
const uint __GLEE_WGL_I3D_swap_frame_usage = 1;
//constants
typedef BOOLEAN   function(float *pUsage) PFNWGLGETFRAMEUSAGEI3DPROC;
typedef BOOLEAN   function() PFNWGLBEGINFRAMETRACKINGI3DPROC;
typedef BOOLEAN   function() PFNWGLENDFRAMETRACKINGI3DPROC;
typedef BOOLEAN   function(DWORD *pFrameCount, DWORD *pMissedFrames, float *pLastMissedUsage) PFNWGLQUERYFRAMETRACKINGI3DPROC;
 extern   PFNWGLGETFRAMEUSAGEI3DPROC pwglGetFrameUsageI3D;
 extern   PFNWGLBEGINFRAMETRACKINGI3DPROC pwglBeginFrameTrackingI3D;
 extern   PFNWGLENDFRAMETRACKINGI3DPROC pwglEndFrameTrackingI3D;
 extern   PFNWGLQUERYFRAMETRACKINGI3DPROC pwglQueryFrameTrackingI3D;
alias pwglGetFrameUsageI3D wglGetFrameUsageI3D;
alias pwglBeginFrameTrackingI3D wglBeginFrameTrackingI3D;
alias pwglEndFrameTrackingI3D wglEndFrameTrackingI3D;
alias pwglQueryFrameTrackingI3D wglQueryFrameTrackingI3D;
//#endif ;
//#else //WIN32 defined
//#endif //end linux

//GLEE FUNCTIONS

 extern   GLboolean GLeeInit();
 extern   char * GLeeGetErrorString();
 extern   char * GLeeGetExtStrGL();

//#ifdef WIN32;
 extern   char * GLeeGetExtStrWGL();
//#else ;
//#endif ;

//#ifdef __cplusplus;
//#endif ;

//#endif //__glee_h_ defined

};